/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.core.JdbcTemplate;

public class SequenceUtil {
    private static final String QUERY_CURRENT_VALUE = "select current_value, step from ohaotian_order_sequence where name = ? for update";
    private static final String UPDATE_CURRENT_VALUE = "update ohaotian_order_sequence set current_value = current_value + step  where name = ?";
    private static final String UPDATE_BATCH_CURRENT_VALUE = "update ohaotian_order_sequence set current_value = current_value + (step * ?)  where name = ?";
    private JdbcTemplate jdbcTemplate;
    private String sequenceName;

    public SequenceUtil(JdbcTemplate jdbcTemplate, String sequenceName) {
        this.jdbcTemplate = jdbcTemplate;
        this.sequenceName = sequenceName;
    }

    public synchronized long nextId() throws SQLException {
        Long aLong = null;
        try {
            this.jdbcTemplate.update(UPDATE_CURRENT_VALUE, new Object[]{this.sequenceName});
            aLong = (Long)this.jdbcTemplate.queryForObject("select current_value from ohaotian_order_sequence where name = ? ", Long.class, new Object[]{this.sequenceName});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aLong;
    }

    private PreparedStatement createUpdatePreparedStatement(Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(UPDATE_CURRENT_VALUE);
        ps.setString(1, this.sequenceName);
        return ps;
    }

    private PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(QUERY_CURRENT_VALUE);
        ps.setString(1, this.sequenceName);
        return ps;
    }

    public synchronized long[] nextIds(int idNum) throws SQLException {
        long[] ids;
        try (Connection conn = this.jdbcTemplate.getDataSource().getConnection();
             PreparedStatement psUpdate = this.createUpdateBatchPreparedStatement(conn, idNum);
             PreparedStatement psQuery = this.createPreparedStatement(conn);){
            conn.setAutoCommit(false);
            psUpdate.execute();
            try (ResultSet rs = psQuery.executeQuery();){
                if (!rs.next()) {
                    throw new IllegalArgumentException("Can't find " + this.sequenceName + " from table ohaotian_order_sequence, please create sequence. ");
                }
                long id = rs.getLong("current_value");
                int step = rs.getInt("step");
                ids = SequenceUtil.batchIds(idNum, id, step);
                conn.commit();
            }
        }
        return ids;
    }

    private static long[] batchIds(int idNum, long id, int step) {
        long[] ids = new long[idNum];
        for (int i = idNum; i > 0; --i) {
            ids[i - 1] = id - (long)(step * (idNum - i));
        }
        return ids;
    }

    private PreparedStatement createUpdateBatchPreparedStatement(Connection conn, int idNum) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(UPDATE_BATCH_CURRENT_VALUE);
        ps.setInt(1, idNum);
        ps.setString(2, this.sequenceName);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getSeqNext() {
        Long l = 0L;
        try {
            JdbcTemplate jdbcTemplate = this.jdbcTemplate;
            synchronized (jdbcTemplate) {
                l = this.nextId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return l;
    }
}

