/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.constant;

import com.ohaotian.plugin.file.FileClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";

    public static void getExcelDate(String path, List<List<String>> data, Integer readLine, Integer sheetAt, FileClient fileClient) throws Exception {
        int count = 2;
        log.info("\u8bf7\u6c42\u8bfb {}", (Object)path);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String s = URLDecoder.decode(path, "utf-8");
        log.info("\u66ff\u6362\u540e\u7684\u8def\u5f84 {} ", (Object)s);
        InputStream inputStream = fileClient.downLoadToInputStream(s);
        ExcelUtils.checkExcelVaild(path);
        Object workbook = path.endsWith(".xls") ? new HSSFWorkbook(inputStream) : new XSSFWorkbook(inputStream);
        Sheet sheet = workbook.getSheetAt(sheetAt.intValue());
        for (int rowNum = 2; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            ArrayList<String> c = new ArrayList<String>();
            if (sheet.getRow(rowNum).getCell(0) == null || "".equals(sheet.getRow(rowNum).getCell(0).toString())) continue;
            int end = sheet.getRow(rowNum).getLastCellNum();
            for (int i = 1; i < end; ++i) {
                Cell cell = sheet.getRow(rowNum).getCell(i);
                if (cell == null) {
                    c.add("");
                    continue;
                }
                Object obj = ExcelUtils.getValue(cell);
                if (count < readLine) continue;
                c.add(String.valueOf(obj).trim());
            }
            ++count;
            if (c.size() <= 0) continue;
            data.add(c);
        }
    }

    private static void checkExcelVaild(String filePath) throws Exception {
        if (filePath == null) {
            return;
        }
        String extString = filePath.substring(filePath.lastIndexOf(".") + 1);
        if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }

    private static Workbook getWorkbok(File file, InputStream inputStream) throws IOException {
        HSSFWorkbook wb = null;
        if (file.getName().endsWith(EXCEL_XLS)) {
            wb = new HSSFWorkbook(inputStream);
        } else if (file.getName().endsWith(EXCEL_XLSX)) {
            wb = new XSSFWorkbook(inputStream);
        }
        return wb;
    }

    private static Object getValue(Cell cell) {
        Object obj = null;
        cell.setCellType(CellType.STRING);
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }
}

