/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.enumType.Brand;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.base.utils.DateUtils;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.busi.api.UccBrandAddBusiService;
import com.tydic.commodity.busibase.busi.bo.UccBrandAddReqBO;
import com.tydic.commodity.busibase.busi.bo.UccBrandAddRspBO;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccBrandAddBusiServiceImpl
implements UccBrandAddBusiService {
    @Autowired
    private UccBrandDealMapper mapper;
    private Sequence uccBrandSequence = Sequence.getInstance();
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccBrandAddBusiServiceImpl.class);
    UccBrandAddRspBO rspBO = new UccBrandAddRspBO();

    @Override
    public UccBrandAddRspBO addBrand(UccBrandAddReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        UccBrandDealPO brandDealPO = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPO);
        UccBrandAddBusiServiceImpl.transStringToDate(reqBO, brandDealPO);
        try {
            int result;
            Long brandId = this.uccBrandSequence.nextId();
            brandDealPO.setBrandId(brandId);
            brandDealPO.setBrandType(1);
            if (StringUtils.isEmpty((Object)brandDealPO.getBrandCode())) {
                brandDealPO.setBrandCode(brandDealPO.getBrandId().toString());
            }
            if ((result = this.mapper.addBrand(brandDealPO)) > 0) {
                this.rspBO.setRespCode("0000");
                this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u6210\u529f");
                this.rspBO.setBrandId(brandId);
            } else {
                this.rspBO.setRespCode("8888");
                this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        return this.rspBO;
    }

    public boolean judge(UccBrandAddReqBO reqBO) {
        Map<String, String> map = null;
        if (reqBO.getBrandName() == null || reqBO.getBrandName().equals("")) {
            this.rspBO.setRespDesc("\u63d2\u5165\u54c1\u724c\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getBrandStatus() != null) {
            map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString());
            if (!map.containsKey(reqBO.getBrandStatus().toString())) {
                this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u72b6\u6001");
                return false;
            }
        } else {
            this.rspBO.setRespDesc("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getExpTime()) && !StringUtils.isEmpty((Object)reqBO.getEffTime())) {
            SimpleDateFormat str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date expTime = str.parse(reqBO.getExpTime());
                Date effTime = str.parse(reqBO.getEffTime());
                long result = effTime.getTime() - expTime.getTime();
                if (result > 0L) {
                    this.rspBO.setRespDesc("\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65f6\u95f4");
                    return false;
                }
            }
            catch (ParseException e) {
                throw new BusinessException("8888", "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
            }
        }
        return true;
    }

    public static void transStringToDate(UccBrandAddReqBO reqBO, UccBrandDealPO brandDealPO) {
        String effTime = reqBO.getEffTime();
        String expTime = reqBO.getExpTime();
        try {
            Date effTime1 = DateUtils.strToDate((String)effTime);
            Date expTime1 = DateUtils.strToDate((String)expTime);
            brandDealPO.setEffTime(effTime1);
            brandDealPO.setExpTime(expTime1);
        }
        catch (Exception e) {
            LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            throw new ZTBusinessException(e.getMessage());
        }
    }
}

