/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsRspBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.SkuPoolRelTypeConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.bo.CommodityCategoryForEsBO;
import com.tydic.commodity.busibase.atom.bo.CommodityForEsBO;
import com.tydic.commodity.busibase.atom.bo.CommoditySpecForEsBO;
import com.tydic.commodity.busibase.atom.bo.EsStorageSpuAttrInfoBO;
import com.tydic.commodity.busibase.atom.bo.EsStorageSpuInfoBO;
import com.tydic.commodity.busibase.atom.bo.SkuForEsBO;
import com.tydic.commodity.busibase.atom.bo.UccPoolsLableBo;
import com.tydic.commodity.busibase.comb.api.SearchCommodityService;
import com.tydic.commodity.busibase.comb.bo.CommodityRspBo;
import com.tydic.commodity.busibase.comb.bo.SearchEsReqBO;
import com.tydic.commodity.busibase.comb.bo.SearchEsRspBo;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccChannelDealMapper;
import com.tydic.commodity.dao.UccCommodityLabelMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccRelChannelPoolMapper;
import com.tydic.commodity.dao.UccRelCommodityLabelPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.dao.UocApprovalObjMapper;
import com.tydic.commodity.po.CommodityForEsPO;
import com.tydic.commodity.po.CommoditySpecForEsPO;
import com.tydic.commodity.po.SkuForEsPO;
import com.tydic.commodity.po.UccCatalogDealPO;
import com.tydic.commodity.po.UccCatalogLevelPo;
import com.tydic.commodity.po.UccChannelDealPO;
import com.tydic.commodity.po.UccCommodityLabelPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccMallBrandRelPO;
import com.tydic.commodity.po.UccRelChannelPoolPo;
import com.tydic.commodity.po.UccRelCommodityLabelPoolPo;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UocSpuApproverPO;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="syncSceneCommodityToEsAtomService")
public class SyncSceneCommodityToEsAtomServiceImpl
implements SyncSceneCommodityToEsAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncSceneCommodityToEsAtomServiceImpl.class);
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private SearchCommodityService searchCommodityService;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccChannelDealMapper uccChannelDealMapper;
    @Autowired
    private UccRelChannelPoolMapper uccRelChannelPoolMapper;
    @Autowired
    private UccCommodityLabelMapper cnncCommodityLabelMapper;
    @Autowired
    private UccRelCommodityLabelPoolMapper cnncRelCommodityLaberPoolMapper;
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;

    @Override
    public SyncSceneCommodityToEsRspBO syncSceneCommodityToEs(SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO) {
        SyncSceneCommodityToEsRspBO rspBO = new SyncSceneCommodityToEsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u6210\u529f!");
        if (syncSceneCommodityToEsReqBO.getSupplierId() == null && syncSceneCommodityToEsReqBO.getRootOrgIdIn() != null) {
            syncSceneCommodityToEsReqBO.setSupplierId(syncSceneCommodityToEsReqBO.getRootOrgIdIn());
        }
        this.validateReqParams(syncSceneCommodityToEsReqBO);
        if (ModelRuleConstant.OPER_ES_ADD_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.syncCommodityToEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_DELETE_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.deleteCommodityInfoFromEs(syncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_UPDATE_TYPE.equals(syncSceneCommodityToEsReqBO.getOperType())) {
            this.updateCommodityToEs(syncSceneCommodityToEsReqBO);
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b[" + syncSceneCommodityToEsReqBO.getOperType() + "]\u6682\u4e0d\u652f\u6301!");
        }
        return rspBO;
    }

    private void syncCommodityToEs(SyncSceneCommodityToEsReqBO reqBO) {
        List<CommodityForEsBO> commodityForEsBOS = this.qryCommodityList(reqBO);
        if (commodityForEsBOS == null || commodityForEsBOS.isEmpty()) {
            LOGGER.error("ES \u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a \u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f->{}" + JSONObject.toJSONString((Object)reqBO));
            return;
        }
        List<Long> commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
        ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
        this.assemblyEsSkuInfo(reqBO, commodityIds, esStorageSpuInfoBOS);
        this.assemblyEsCommodityAndCategoryInfo(reqBO, commodityIds, esStorageSpuInfoBOS, commodityForEsBOS);
        this.syncSkuPoolToES(reqBO, commodityIds, esStorageSpuInfoBOS);
        this.dealChannel(esStorageSpuInfoBOS);
        this.dealLable(esStorageSpuInfoBOS);
        this.applrovalCommodityToEs(esStorageSpuInfoBOS);
        this.syncCommodityInfoToEs(esStorageSpuInfoBOS);
    }

    private void deleteCommodityInfoFromEs(SyncSceneCommodityToEsReqBO reqBO) {
        this.deleteSpuInfoFromEs(reqBO);
    }

    private void updateCommodityToEs(SyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getSingleType() == 0) {
            List<CommodityForEsBO> commodityForEsBOS = this.qryCommodityList(reqBO);
            if (commodityForEsBOS == null || commodityForEsBOS.isEmpty()) {
                LOGGER.error("\u66f4\u65b0ES\u4e0b\u7684\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u573a\u666f[" + reqBO.getSceneId() + "]\u4e0b\u5173\u8054\u7684\u5546\u54c1\u6570\u636e!");
                return;
            }
            List<Long> commodityIds = commodityForEsBOS.stream().map(CommodityForEsBO::getCommodityId).collect(Collectors.toList());
            SearchEsReqBO searchEsReqBO = new SearchEsReqBO();
            searchEsReqBO.setCommdIds(commodityIds);
            searchEsReqBO.setSceneId(reqBO.getSceneId());
            SearchEsRspBo searchEsRspBo = this.searchCommodityService.queryByMatch(searchEsReqBO);
            List<Long> esExistCommodityIds = null;
            if (searchEsRspBo != null && searchEsRspBo.getCommodityRspBos() != null && !searchEsRspBo.getCommodityRspBos().isEmpty()) {
                List<CommodityRspBo> commodityRspBos = searchEsRspBo.getCommodityRspBos();
                esExistCommodityIds = commodityRspBos.stream().map(CommodityRspBo::getCommodity_id).collect(Collectors.toList());
            }
            if (esExistCommodityIds == null || esExistCommodityIds.isEmpty()) {
                return;
            }
            ArrayList<CommodityForEsBO> newCommodityForEsBOS = new ArrayList<CommodityForEsBO>();
            for (CommodityForEsBO commodityForEsBO : commodityForEsBOS) {
                if (!esExistCommodityIds.contains(commodityForEsBO.getCommodityId())) continue;
                newCommodityForEsBOS.add(commodityForEsBO);
            }
            ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
            this.assemblyEsSkuInfo(reqBO, esExistCommodityIds, esStorageSpuInfoBOS);
            this.assemblyEsCommodityAndCategoryInfo(reqBO, esExistCommodityIds, esStorageSpuInfoBOS, newCommodityForEsBOS);
            this.syncSkuPoolToES(reqBO, commodityIds, esStorageSpuInfoBOS);
            this.dealChannel(esStorageSpuInfoBOS);
            this.applrovalCommodityToEs(esStorageSpuInfoBOS);
            this.syncCommodityInfoToEs(esStorageSpuInfoBOS);
        } else {
            this.searchSku(reqBO);
            if (reqBO.getSingleType() != 1) {
                if (reqBO.getSingleType() == 2) {
                    List<UccSkuPo> poList = this.uccSkuMapper.queryBatchSkusLessCloum(reqBO.getSkuIds(), reqBO.getSupplierId());
                    ArrayList<EsStorageSpuInfoBO> esStorageSpuInfoBOS = new ArrayList<EsStorageSpuInfoBO>();
                    EsStorageSpuInfoBO bo = null;
                    ArrayList<Long> commds = new ArrayList<Long>();
                    for (UccSkuPo each : poList) {
                        bo = new EsStorageSpuInfoBO();
                        bo.setSku_id(each.getSkuId());
                        bo.setSku_status(each.getSkuStatus());
                        bo.setCommodity_id(each.getCommodityId());
                        bo.setCreate_time(each.getCreateTime().getTime());
                        bo.setSku_approval_status(each.getApprovalStatus());
                        commds.add(each.getCommodityId());
                        esStorageSpuInfoBOS.add(bo);
                    }
                    List<UccCommodityPo> commodityPoList = this.uccCommodityMapper.queryByCommodityIdLists(commds);
                    if (!CollectionUtils.isEmpty(commodityPoList)) {
                        Map<Long, List<UccCommodityPo>> mapSpu = commodityPoList.stream().collect(Collectors.groupingBy(UccCommodityPo::getCommodityId));
                        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
                            if (!mapSpu.containsKey(esStorageSpuInfoBO.getCommodity_id())) continue;
                            esStorageSpuInfoBO.setCommodity_status(((UccCommodityPo)((List)mapSpu.get(esStorageSpuInfoBO.getCommodity_id())).get(0)).getCommodityStatus());
                            esStorageSpuInfoBO.setSpu_approval_status(((UccCommodityPo)((List)mapSpu.get(esStorageSpuInfoBO.getCommodity_id())).get(0)).getApprovalStatus());
                        }
                    }
                    this.applrovalCommodityToEs(esStorageSpuInfoBOS);
                    if (!CollectionUtils.isEmpty(poList)) {
                        for (EsStorageSpuInfoBO each : esStorageSpuInfoBOS) {
                            JSONObject object = new JSONObject();
                            object.put("sku_status", (Object)each.getSku_status());
                            object.put("audit_time", (Object)each.getAudit_time());
                            object.put("on_shelve_time", (Object)each.getOn_shelve_time());
                            object.put("operIds", each.getOperIds());
                            object.put("create_time", (Object)each.getCreate_time());
                            object.put("sku_approval_status", (Object)each.getSku_approval_status());
                            object.put("spu_approval_status", (Object)each.getSpu_approval_status());
                            object.put("commodity_status", (Object)each.getCommodity_status());
                            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), reqBO.getSceneId() == null ? each.getSku_id().toString() : reqBO.getSceneId() + "" + each.getSku_id(), object);
                        }
                    }
                } else if (reqBO.getSingleType() == 3) {
                    List<UccSkuPricePo> pricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBO.getSkuIds(), reqBO.getSupplierId());
                    List<UccLadderPricePO> ladderPricePOS = this.uccLadderPriceMapper.selectBySkuIds(reqBO.getSkuIds(), reqBO.getSupplierId());
                    Map<Object, Object> skuLadderMap = new HashMap();
                    if (CollectionUtils.isEmpty(ladderPricePOS)) {
                        skuLadderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
                    }
                    if (!CollectionUtils.isEmpty(pricePos)) {
                        for (UccSkuPricePo each : pricePos) {
                            JSONObject object = new JSONObject();
                            object.put("sale_price", (Object)each.getSalePrice());
                            object.put("agreement_price", (Object)each.getAgreementPrice());
                            object.put("market_price", (Object)each.getMarketPrice());
                            object.put("member_price1", (Object)each.getMemberPrice1());
                            object.put("member_price2", (Object)each.getMemberPrice2());
                            object.put("member_price3", (Object)each.getMemberPrice3());
                            object.put("member_price4", (Object)each.getMemberPrice4());
                            object.put("member_price5", (Object)each.getMemberPrice5());
                            object.put("discounts", (Object)(each.getSalePrice() / each.getAgreementPrice()));
                            if (skuLadderMap.containsKey(each.getSkuId())) {
                                List ladderPrice = ((List)skuLadderMap.get(each.getSkuId())).stream().map(UccLadderPricePO::getPrice).collect(Collectors.toList());
                                object.put("ladderPrice", ladderPrice);
                            }
                            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), reqBO.getSceneId() == null ? each.getSkuId().toString() : reqBO.getSceneId() + "" + each.getSkuId(), object);
                        }
                    }
                } else {
                    LOGGER.error("\u672a\u77e5\u540c\u6b65\u7c7b\u578b");
                }
            }
        }
    }

    private List<CommodityForEsBO> qryCommodityList(SyncSceneCommodityToEsReqBO reqBO) {
        List<Long> commodityTypeIds;
        List<CommodityForEsBO> commodityForEsBOS = new ArrayList<CommodityForEsBO>();
        List<CommodityForEsPO> forEsPOList = null;
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType())) {
            commodityTypeIds = this.uccCommodityTypeMapper.qryCommodityTypeIdsByCategorys(reqBO.getCategoryIds());
            if (commodityTypeIds == null || commodityTypeIds.isEmpty()) {
                throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u7c7b\u76ee\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u6570\u636e!");
            }
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBO.getRootOrgIdIn(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID.equals(reqBO.getSyncType())) {
            commodityTypeIds = this.uccCatRCommdTypeMapper.queryTypeByGuideCatalogIds(reqBO.getGuiCategoryIds());
            if (commodityTypeIds == null || commodityTypeIds.isEmpty()) {
                throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u7c7b\u76ee\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u6570\u636e!");
            }
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBO.getSupplierId(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType())) {
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, reqBO.getCommodityIds(), reqBO.getSupplierId(), reqBO.getSceneId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_SKU_ID.equals(reqBO.getSyncType())) {
            List<UccSkuPo> skuPoList = this.uccSkuMapper.queryBatchSkusLessCloum(reqBO.getSkuIds(), reqBO.getSupplierId());
            if (CollectionUtils.isEmpty(skuPoList)) {
                return commodityForEsBOS;
            }
            ArrayList<Long> commodityIds = new ArrayList<Long>();
            for (UccSkuPo uccSkuPo : skuPoList) {
                if (commodityIds.contains(uccSkuPo.getCommodityId())) continue;
                commodityIds.add(uccSkuPo.getCommodityId());
            }
            forEsPOList = this.uccCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, commodityIds, reqBO.getSupplierId(), reqBO.getSceneId());
        }
        if (!CollectionUtils.isEmpty(forEsPOList)) {
            commodityForEsBOS = JSONObject.parseArray((String)JSONObject.toJSONString(forEsPOList), CommodityForEsBO.class);
        }
        if (!CollectionUtils.isEmpty(commodityForEsBOS)) {
            ArrayList mergeSameB0s = new ArrayList();
            HashedMap mergeSameMap = new HashedMap();
            for (CommodityForEsBO commodityForEsBO : commodityForEsBOS) {
                CommodityForEsBO bo;
                if (commodityForEsBO.getGuideCataLogId() == null) {
                    bo = new CommodityForEsBO();
                    BeanUtils.copyProperties((Object)commodityForEsBO, (Object)bo);
                    mergeSameMap.put(commodityForEsBO.getCommodityId(), bo);
                    continue;
                }
                if (mergeSameMap.containsKey(commodityForEsBO.getCommodityId())) {
                    ((CommodityForEsBO)mergeSameMap.get(commodityForEsBO.getCommodityId())).getGuideCataLogIds().add(commodityForEsBO.getGuideCataLogId());
                    continue;
                }
                bo = new CommodityForEsBO();
                BeanUtils.copyProperties((Object)commodityForEsBO, (Object)bo);
                bo.setGuideCataLogIds(new ArrayList<Long>(Arrays.asList(commodityForEsBO.getGuideCataLogId())));
                mergeSameMap.put(commodityForEsBO.getCommodityId(), bo);
            }
            commodityForEsBOS = new ArrayList();
            for (Map.Entry entry : mergeSameMap.entrySet()) {
                commodityForEsBOS.add((CommodityForEsBO)entry.getValue());
            }
            commodityForEsBOS.addAll(mergeSameB0s);
        }
        return commodityForEsBOS;
    }

    private void assemblyEsSkuInfo(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        List<UccLadderPricePO> ladderPricePOS;
        List<UccMallBrandRelPO> mallBrandRelList;
        List skuForEsBOS = null;
        List<SkuForEsPO> skuForEsPOList = this.uccSkuMapper.qrySkuAndLowPriceList(reqBO.getSupplierId(), commodityIds);
        if (CollectionUtils.isEmpty(skuForEsPOList)) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4e0b\u5173\u8054\u7684\u5355\u54c1\u6570\u636e!");
        }
        skuForEsBOS = JSONObject.parseArray((String)JSONObject.toJSONString(skuForEsPOList), SkuForEsBO.class);
        skuForEsBOS.forEach(sku -> {
            sku.setOriginBrandId(sku.getBrandId());
            sku.setOriginBrandName(sku.getBrandName());
        });
        List<Long> brandList = skuForEsBOS.stream().filter(a -> a.getBrandId() != null).map(SkuForEsBO::getBrandId).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(brandList) && !CollectionUtils.isEmpty(mallBrandRelList = this.uccMallBrandRelMapper.getRelByBrandList(brandList))) {
            block0: for (SkuForEsBO sku2 : skuForEsBOS) {
                for (UccMallBrandRelPO rel : mallBrandRelList) {
                    if (sku2.getBrandId() == null || !sku2.getBrandId().equals(rel.getBrandId())) continue;
                    sku2.setBrandId(rel.getMallBrandId());
                    sku2.setBrandName(rel.getMallBrandName());
                    continue block0;
                }
            }
        }
        List ladderEsBo = skuForEsBOS.stream().filter(a -> a.getSwitchOn() == 1).collect(Collectors.toList());
        List laderSku = null;
        if (!CollectionUtils.isEmpty(ladderEsBo)) {
            laderSku = ladderEsBo.stream().map(SkuForEsBO::getSkuId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(laderSku) && !CollectionUtils.isEmpty(ladderPricePOS = this.uccLadderPriceMapper.selectBySkuIds(reqBO.getSkuIds(), reqBO.getSupplierId()))) {
            Map<Long, List<UccLadderPricePO>> skuLadderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
            skuForEsBOS.forEach(sku -> {
                if (skuLadderMap.containsKey(sku.getSkuId())) {
                    sku.setLadderPrice(((List)skuLadderMap.get(sku.getSkuId())).stream().map(UccLadderPricePO::getPrice).collect(Collectors.toList()));
                }
            });
        }
        List<Long> skuIds = skuForEsBOS.stream().map(SkuForEsBO::getSkuId).collect(Collectors.toList());
        Map<Long, Long> skuStockPoMap = new HashMap<Long, Long>();
        List<UccSaleNumPo> saleNumPos = this.uccSaleNumMapper.qryBySkuIds(skuIds);
        Map<Long, UccSaleNumPo> saleNumPoMap = saleNumPos.stream().collect(Collectors.toMap(UccSaleNumPo::getSkuId, uccSaleNumPo -> uccSaleNumPo));
        List<UccSkuPicPo> skuPicPos = this.uccSkuPicMapper.qeurySkuPicBySkuId(skuIds, 1);
        Map<Long, UccSkuPicPo> skuPicPoMap = skuPicPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, UccSkuPicPo2 -> UccSkuPicPo2));
        if (!CollectionUtils.isEmpty(skuIds = this.uccSkuMapper.checkInventoryManagement(skuIds, reqBO.getSupplierId()))) {
            SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
            smcsdkQryStockNumReqBO.setSkuIds(skuIds);
            SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
            if ("0000".equals(smcsdkQryStockNumRspBO.getRespCode()) && smcsdkQryStockNumRspBO.getSkuStockNumMap() != null && !smcsdkQryStockNumRspBO.getSkuStockNumMap().isEmpty()) {
                skuStockPoMap = smcsdkQryStockNumRspBO.getSkuStockNumMap();
            }
        }
        this.buildEsSku(esStorageSpuInfoBOS, skuForEsBOS, skuStockPoMap, saleNumPoMap, skuPicPoMap);
    }

    private void buildEsSku(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS, List<SkuForEsBO> skuForEsBOS, Map<Long, Long> skuStockPoMap, Map<Long, UccSaleNumPo> saleNumPoMap, Map<Long, UccSkuPicPo> skuPicPoMap) {
        for (SkuForEsBO skuForEsBO : skuForEsBOS) {
            UccSaleNumPo uccSaleNumPo;
            Long stockNum;
            EsStorageSpuInfoBO esStorageSpuInfoBO = new EsStorageSpuInfoBO();
            esStorageSpuInfoBO.setCommodity_id(skuForEsBO.getCommodityId());
            esStorageSpuInfoBO.setSku_id(skuForEsBO.getSkuId());
            esStorageSpuInfoBO.setSku_name(skuForEsBO.getSkuName());
            esStorageSpuInfoBO.setSearch_name(skuForEsBO.getSkuName());
            esStorageSpuInfoBO.setExt_sku_id(skuForEsBO.getExtSkuId());
            esStorageSpuInfoBO.setBrand_id(skuForEsBO.getBrandId());
            esStorageSpuInfoBO.setBrand_name(skuForEsBO.getBrandName());
            esStorageSpuInfoBO.setSku_status(skuForEsBO.getSkuStatus());
            esStorageSpuInfoBO.setSku_source(skuForEsBO.getSkuSource());
            esStorageSpuInfoBO.setMfgsku(skuForEsBO.getMfgsku());
            esStorageSpuInfoBO.setUpc(skuForEsBO.getUpcCode());
            esStorageSpuInfoBO.setType_id(skuForEsBO.getCommodityTypeId());
            esStorageSpuInfoBO.setType_name(skuForEsBO.getCommodityTypeName());
            if (skuForEsBO.getOnShelveTime() != null) {
                esStorageSpuInfoBO.setOn_shelve_time(DateUtils.strToDateLong((String)skuForEsBO.getOnShelveTime()).getTime());
            }
            esStorageSpuInfoBO.setAgreement_id(skuForEsBO.getAgreementId());
            esStorageSpuInfoBO.setAgreement_details_id(skuForEsBO.getAgreementDetailsId());
            esStorageSpuInfoBO.setSale_price(skuForEsBO.getSalePrice() == null ? 0.0 : (double)skuForEsBO.getSalePrice().longValue());
            esStorageSpuInfoBO.setAgreement_price(skuForEsBO.getAgreementPrice() == null ? 0.0 : (double)skuForEsBO.getAgreementPrice().longValue());
            esStorageSpuInfoBO.setMarket_price(skuForEsBO.getMarketPrice() == null ? 0.0 : (double)skuForEsBO.getMarketPrice().longValue());
            esStorageSpuInfoBO.setMember_price1(skuForEsBO.getMemberPrice1() == null ? 0.0 : (double)skuForEsBO.getMemberPrice1().longValue());
            esStorageSpuInfoBO.setMember_price2(skuForEsBO.getMemberPrice2() == null ? 0.0 : (double)skuForEsBO.getMemberPrice2().longValue());
            esStorageSpuInfoBO.setMember_price3(skuForEsBO.getMemberPrice3() == null ? 0.0 : (double)skuForEsBO.getMemberPrice3().longValue());
            esStorageSpuInfoBO.setMember_price4(skuForEsBO.getMemberPrice4() == null ? 0.0 : (double)skuForEsBO.getMemberPrice4().longValue());
            esStorageSpuInfoBO.setMember_price5(skuForEsBO.getMemberPrice5() == null ? 0.0 : (double)skuForEsBO.getMemberPrice5().longValue());
            esStorageSpuInfoBO.setSupplier_id(skuForEsBO.getSupplierId());
            esStorageSpuInfoBO.setSupplier_shop_id(skuForEsBO.getSupplierShopId());
            esStorageSpuInfoBO.setShop_name(skuForEsBO.getShopName());
            esStorageSpuInfoBO.setSupplier_name(skuForEsBO.getSupplierName());
            String discount = "0";
            if (skuForEsBO.getSalePrice() != null && skuForEsBO.getMarketPrice() != null && skuForEsBO.getMarketPrice() != 0L) {
                discount = String.format("%.2f", (double)skuForEsBO.getSalePrice().longValue() / (double)skuForEsBO.getMarketPrice().longValue());
            }
            esStorageSpuInfoBO.setDiscounts(Double.valueOf(discount));
            esStorageSpuInfoBO.setComment_number(null);
            if (skuStockPoMap.size() > 0 && (stockNum = skuStockPoMap.get(skuForEsBO.getSkuId())) != null) {
                esStorageSpuInfoBO.setComment_number(stockNum);
            }
            esStorageSpuInfoBO.setSold_number(null);
            esStorageSpuInfoBO.setEcommerce_sale(null);
            if (saleNumPoMap.size() > 0 && (uccSaleNumPo = saleNumPoMap.get(skuForEsBO.getSkuId())) != null) {
                if (uccSaleNumPo.getSoldNumber() != null) {
                    esStorageSpuInfoBO.setSold_number(uccSaleNumPo.getSoldNumber().longValue());
                }
                if (uccSaleNumPo.getEcommerceSale() != null) {
                    esStorageSpuInfoBO.setEcommerce_sale(uccSaleNumPo.getEcommerceSale().longValue());
                }
            }
            if (skuPicPoMap.size() > 0) {
                UccSkuPicPo uccSkuPicPo = skuPicPoMap.get(skuForEsBO.getSkuId());
                if (uccSkuPicPo != null) {
                    esStorageSpuInfoBO.setPicture_url(uccSkuPicPo.getSkuPicUrl());
                } else {
                    esStorageSpuInfoBO.setPicture_url(null);
                }
            } else {
                esStorageSpuInfoBO.setPicture_url(null);
            }
            esStorageSpuInfoBO.setChannel_id(null);
            esStorageSpuInfoBO.setBrand_id_name(null);
            esStorageSpuInfoBO.setDescription(null);
            esStorageSpuInfoBO.setSupplier_id_name(null);
            esStorageSpuInfoBO.setProperties(null);
            esStorageSpuInfoBO.setL4mg_category_id(skuForEsBO.getMgCatalogId());
            esStorageSpuInfoBO.setL4mg_category_name(skuForEsBO.getMgCatalogName());
            esStorageSpuInfoBO.setMaterial_id(skuForEsBO.getMaterialId());
            if (!StringUtils.isEmpty((CharSequence)skuForEsBO.getMaterialName())) {
                esStorageSpuInfoBO.setMaterial_name(skuForEsBO.getMaterialName());
            } else {
                esStorageSpuInfoBO.setMaterial_name(skuForEsBO.getOrgMaterialName());
            }
            esStorageSpuInfoBO.setMaterial_code(skuForEsBO.getMaterialCode());
            esStorageSpuInfoBO.setModel(skuForEsBO.getModel());
            esStorageSpuInfoBO.setSpec(skuForEsBO.getSpec());
            esStorageSpuInfoBO.setMeasure_name(skuForEsBO.getMeasure());
            esStorageSpuInfoBO.setMeasure_id(skuForEsBO.getMeasureId());
            esStorageSpuInfoBO.setOrigin_brand_id(skuForEsBO.getOriginBrandId());
            esStorageSpuInfoBO.setOrigin_brand_name(skuForEsBO.getOriginBrandName());
            esStorageSpuInfoBO.setInsert_time(System.currentTimeMillis());
            esStorageSpuInfoBO.setSku_code(skuForEsBO.getSkuCode());
            esStorageSpuInfoBO.setSku_approval_status(skuForEsBO.getApprovalStatus());
            esStorageSpuInfoBO.setSupplier_org_id(skuForEsBO.getSupplierOrgId());
            esStorageSpuInfoBO.setSupplier_org_name(skuForEsBO.getSupplierOrgName());
            esStorageSpuInfoBO.setCreate_oper_id(skuForEsBO.getCreateOperId());
            esStorageSpuInfoBO.setCreate_oper_name(skuForEsBO.getCreateOperName());
            esStorageSpuInfoBO.setUpdate_oper_id(skuForEsBO.getUpdateOperId());
            esStorageSpuInfoBO.setUpdate_oper_name(skuForEsBO.getUpdateOperName());
            esStorageSpuInfoBO.setSwitch_on(skuForEsBO.getSwitchOn());
            esStorageSpuInfoBO.setLadderPrice(skuForEsBO.getLadderPrice());
            if (skuForEsBO.getCreateTime() != null) {
                esStorageSpuInfoBO.setCreate_time(skuForEsBO.getCreateTime().getTime());
            }
            if (skuForEsBO.getUpdateTime() != null) {
                esStorageSpuInfoBO.setUpdate_time(skuForEsBO.getUpdateTime().getTime());
            }
            esStorageSpuInfoBO.setMoq(skuForEsBO.getMoq());
            esStorageSpuInfoBO.setSales_unit_id(skuForEsBO.getSalesUnitId());
            esStorageSpuInfoBO.setSales_unit_name(skuForEsBO.getSalesUnitName());
            if (skuForEsBO.getPreDeliverDay() != null) {
                esStorageSpuInfoBO.setPre_deliver_day(new BigDecimal(skuForEsBO.getPreDeliverDay()));
            }
            esStorageSpuInfoBO.setSettlement_unit(skuForEsBO.getSettlementUnit());
            esStorageSpuInfoBOS.add(esStorageSpuInfoBO);
        }
    }

    private void assemblyEsCommodityAndCategoryInfo(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS, List<CommodityForEsBO> commodityForEsBOS) {
        Map<Long, CommodityForEsBO> commodityEsBOMap = commodityForEsBOS.stream().collect(Collectors.toMap(CommodityForEsBO::getCommodityId, commodityForEsBO -> commodityForEsBO));
        ArrayList<Long> guiCataLog = new ArrayList<Long>();
        for (CommodityForEsBO each : commodityForEsBOS) {
            if (CollectionUtils.isEmpty(each.getGuideCataLogIds())) continue;
            guiCataLog.addAll(each.getGuideCataLogIds());
        }
        if (!CollectionUtils.isEmpty(guiCataLog)) {
            LinkedHashSet hashSet = new LinkedHashSet(guiCataLog);
            guiCataLog = new ArrayList(hashSet);
        }
        List<Object> catalogLevelPos = new ArrayList();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(guiCataLog)) {
            catalogLevelPos = this.uccCatalogDealMapper.quryCatalogLevel(reqBO.getSceneId(), null, guiCataLog);
        }
        List commoditySpecForEsBOS = new ArrayList();
        List<CommoditySpecForEsPO> specForEsPOS = this.uccSpuSpecMapper.qrySpuSpecList(commodityIds, reqBO.getSupplierId());
        if (!CollectionUtils.isEmpty(specForEsPOS)) {
            commoditySpecForEsBOS = JSONObject.parseArray((String)JSONObject.toJSONString(specForEsPOS), CommoditySpecForEsBO.class);
        }
        Map<Long, CommoditySpecForEsBO> commoditySpecForEsBOMap = commoditySpecForEsBOS.stream().collect(Collectors.toMap(CommoditySpecForEsBO::getCommodityId, commoditySpecForEsBO -> commoditySpecForEsBO));
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            CommoditySpecForEsBO commoditySpecForEsBO2;
            CommodityForEsBO commodityForEsBO2 = commodityEsBOMap.get(esStorageSpuInfoBO.getCommodity_id());
            esStorageSpuInfoBO.setScene_id(reqBO.getSceneId());
            esStorageSpuInfoBO.setCommodity_name(commodityForEsBO2.getCommodityName());
            esStorageSpuInfoBO.setCommodity_status(commodityForEsBO2.getCommodityStatus());
            esStorageSpuInfoBO.setCommd_pic_url(commodityForEsBO2.getCommodityPicUrl());
            if (!CollectionUtils.isEmpty(commodityForEsBO2.getGuideCataLogIds())) {
                esStorageSpuInfoBO.setL3_category_id(commodityForEsBO2.getGuideCataLogIds().stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
            }
            esStorageSpuInfoBO.setVendor_id(commodityForEsBO2.getVendorId());
            esStorageSpuInfoBO.setVendor_name(commodityForEsBO2.getVendorName());
            if (StringUtils.isEmpty((CharSequence)esStorageSpuInfoBO.getPicture_url())) {
                esStorageSpuInfoBO.setPicture_url(commodityForEsBO2.getCommodityPicUrl());
            }
            esStorageSpuInfoBO.setView_order(commodityForEsBO2.getViewOrder());
            esStorageSpuInfoBO.setOther_source_name(commodityForEsBO2.getOtherSourceName());
            esStorageSpuInfoBO.setOther_source_id(commodityForEsBO2.getOtherSourceId());
            esStorageSpuInfoBO.setOther_source_code(commodityForEsBO2.getOtherSourceCode());
            esStorageSpuInfoBO.setTaxRate(commodityForEsBO2.getTaxRate());
            esStorageSpuInfoBO.setTaxCode(commodityForEsBO2.getTaxCatCode());
            esStorageSpuInfoBO.setSpu_approval_status(commodityForEsBO2.getApprovalStatus());
            esStorageSpuInfoBO.setCommodity_code(commodityForEsBO2.getCommodityCode());
            esStorageSpuInfoBO.setExt_spu_id(commodityForEsBO2.getExtSpuId());
            esStorageSpuInfoBO.setCommodity_expand1(commodityForEsBO2.getCommodityExpand1());
            esStorageSpuInfoBO.setShow_prop_json(null);
            if (!CollectionUtils.isEmpty(catalogLevelPos) && !CollectionUtils.isEmpty(esStorageSpuInfoBO.getL3_category_id())) {
                for (UccCatalogLevelPo uccCatalogLevelPo : catalogLevelPos) {
                    for (String l3_category_id : esStorageSpuInfoBO.getL3_category_id()) {
                        if (!uccCatalogLevelPo.getL3GuideCatalogId().equals(Long.valueOf(l3_category_id))) continue;
                        if (uccCatalogLevelPo.getL1GuideCatalogId() != null) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL1_category_id())) {
                                esStorageSpuInfoBO.setL1_category_id(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL1GuideCatalogId().toString()}));
                            } else if (!esStorageSpuInfoBO.getL1_category_id().contains(String.valueOf(uccCatalogLevelPo.getL1GuideCatalogId()))) {
                                esStorageSpuInfoBO.getL1_category_id().add(String.valueOf(uccCatalogLevelPo.getL1GuideCatalogId()));
                            }
                        }
                        if (uccCatalogLevelPo.getL2GuideCatalogId() != null) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL2_category_id())) {
                                esStorageSpuInfoBO.setL2_category_id(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL2GuideCatalogId().toString()}));
                            } else if (!esStorageSpuInfoBO.getL2_category_id().contains(String.valueOf(uccCatalogLevelPo.getL2GuideCatalogId()))) {
                                esStorageSpuInfoBO.getL2_category_id().add(uccCatalogLevelPo.getL2GuideCatalogId().toString());
                            }
                        }
                        if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL1CatalogName())) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL1_category_name())) {
                                esStorageSpuInfoBO.setL1_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL1CatalogName()}));
                            } else if (!esStorageSpuInfoBO.getL1_category_name().contains(uccCatalogLevelPo.getL1CatalogName())) {
                                esStorageSpuInfoBO.getL1_category_name().add(uccCatalogLevelPo.getL1CatalogName());
                            }
                        }
                        if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL2CatalogName())) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL2_category_name())) {
                                esStorageSpuInfoBO.setL2_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL2CatalogName()}));
                            } else if (!esStorageSpuInfoBO.getL2_category_name().contains(uccCatalogLevelPo.getL2CatalogName())) {
                                esStorageSpuInfoBO.getL2_category_name().add(uccCatalogLevelPo.getL2CatalogName());
                            }
                        }
                        if (!StringUtils.isEmpty((CharSequence)uccCatalogLevelPo.getL3CatalogName())) {
                            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getL3_category_name())) {
                                esStorageSpuInfoBO.setL3_category_name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getL3CatalogName()}));
                            } else if (!esStorageSpuInfoBO.getL3_category_name().contains(uccCatalogLevelPo.getL3CatalogName())) {
                                esStorageSpuInfoBO.getL3_category_name().add(uccCatalogLevelPo.getL3CatalogName());
                            }
                        }
                        if (uccCatalogLevelPo.getChannelId() == null) continue;
                        if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getChannel_id())) {
                            esStorageSpuInfoBO.setChannel_id(Lists.newArrayList((Object[])new Long[]{uccCatalogLevelPo.getChannelId()}));
                            esStorageSpuInfoBO.setChannel_Name(Lists.newArrayList((Object[])new String[]{uccCatalogLevelPo.getChannelName()}));
                            continue;
                        }
                        if (!esStorageSpuInfoBO.getChannel_id().contains(uccCatalogLevelPo.getChannelId())) {
                            esStorageSpuInfoBO.getChannel_id().add(uccCatalogLevelPo.getChannelId());
                        }
                        if (esStorageSpuInfoBO.getChannel_Name().contains(uccCatalogLevelPo.getChannelName())) continue;
                        esStorageSpuInfoBO.getChannel_Name().add(uccCatalogLevelPo.getChannelName());
                    }
                }
            }
            if (commoditySpecForEsBOMap.size() > 0 && (commoditySpecForEsBO2 = commoditySpecForEsBOMap.get(esStorageSpuInfoBO.getCommodity_id())) != null) {
                esStorageSpuInfoBO.setShow_prop_json(commoditySpecForEsBO2.getPropJson());
            }
            String properties = this.uccSpuSpecMapper.getSpuSpecProperties(esStorageSpuInfoBO.getSku_id());
            esStorageSpuInfoBO.setProperties(properties);
            esStorageSpuInfoBO.setUnuse_suppliershop_list(null);
        }
    }

    private CommodityCategoryForEsBO assemblyCategoryInfo(CommodityCategoryForEsBO categoryForEsBO, Map<Long, UccCatalogDealPO> upperCatalogDealPOMap) {
        CommodityCategoryForEsBO finalSpuCategoryForEsBO = new CommodityCategoryForEsBO();
        for (int i = 0; i < upperCatalogDealPOMap.size(); ++i) {
            UccCatalogDealPO uccCatalogDealPO;
            if (i == 0 && categoryForEsBO.getUpperGatalogId() == 0L) {
                return categoryForEsBO;
            }
            if (i == 0 && categoryForEsBO.getUpperGatalogId() != 0L) {
                uccCatalogDealPO = upperCatalogDealPOMap.get(categoryForEsBO.getUpperGatalogId());
                finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(categoryForEsBO, uccCatalogDealPO);
                continue;
            }
            if (finalSpuCategoryForEsBO.getUpperGatalogId() == 0L) {
                return finalSpuCategoryForEsBO;
            }
            uccCatalogDealPO = upperCatalogDealPOMap.get(finalSpuCategoryForEsBO.getUpperGatalogId());
            finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(finalSpuCategoryForEsBO, uccCatalogDealPO);
        }
        return finalSpuCategoryForEsBO;
    }

    private CommodityCategoryForEsBO mergeChildAndParentCategory(CommodityCategoryForEsBO childCategory, UccCatalogDealPO parentCategory) {
        CommodityCategoryForEsBO finalCategory = new CommodityCategoryForEsBO();
        finalCategory.setGuideCatalogId(parentCategory.getGuideCatalogId());
        finalCategory.setUpperGatalogId(parentCategory.getUpperCatalogId());
        finalCategory.setCatalogName(parentCategory.getCatalogName());
        finalCategory.setChildCatalog(childCategory);
        return finalCategory;
    }

    private void syncCommodityInfoToEs(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            String jsonStr = JSONObject.toJSONString((Object)esStorageSpuInfoBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = "";
            esId = esStorageSpuInfoBO.getScene_id() == null ? String.valueOf(esStorageSpuInfoBO.getSku_id()) : esStorageSpuInfoBO.getScene_id() + String.valueOf(esStorageSpuInfoBO.getSku_id());
            String id = this.elasticsearchUtil.addData(this.esConfig.getIndexName(), this.esConfig.getEsType(), esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            LOGGER.error("\u5546\u54c1\u4fe1\u606f[" + esStorageSpuInfoBO.getScene_id() == null ? "" : esStorageSpuInfoBO.getScene_id() + "|" + esStorageSpuInfoBO.getCommodity_id() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }

    private void syncCommodityAttrToEs(List<EsStorageSpuAttrInfoBO> attrInfoBOS) {
        if (CollectionUtils.isEmpty(attrInfoBOS)) {
            return;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (EsStorageSpuAttrInfoBO each : attrInfoBOS) {
            JSONObject map = JSONObject.parseObject((String)JSON.toJSONString((Object)each));
            list.add((Map<String, Object>)map);
        }
        this.elasticsearchUtil.bulkPutIndex(this.esConfig.getPropIndexName(), this.esConfig.getPropIndexType(), list, "spec_id");
    }

    private void deleteSpuInfoFromEs(SyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getSyncType() == ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
                LOGGER.error("\u5220\u9664\u6570\u636e\u7c7b\u5bb9\u4e3a\u7a7a" + JSONObject.toJSONString((Object)reqBO));
                return;
            }
            for (Long each : reqBO.getCommodityIds()) {
                JSONObject delConditionOrderJson = new JSONObject();
                delConditionOrderJson.put("commodity_id", (Object)String.valueOf(each));
                JSONObject termOrderJson = new JSONObject();
                termOrderJson.put("term", (Object)delConditionOrderJson);
                JSONObject termAfsJson = new JSONObject();
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)termOrderJson);
                JSONObject mustJson = new JSONObject();
                mustJson.put("must", (Object)jsonArray);
                JSONObject boolJson = new JSONObject();
                boolJson.put("bool", (Object)mustJson);
                JSONObject qryJson = new JSONObject();
                qryJson.put("query", (Object)boolJson);
                String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_delete_by_query";
                Boolean deleteResult = this.elasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
                if (deleteResult.booleanValue()) continue;
                LOGGER.error("\u5546\u54c1\u4fe1\u606f[" + each + "]\u5220\u9664\u5931\u8d25!");
            }
        } else if (reqBO.getSyncType() == ModelRuleConstant.SYNC_ES_BY_SKU_ID) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                LOGGER.error("\u5220\u9664\u6570\u636e\u7c7b\u5bb9\u4e3a\u7a7a" + JSONObject.toJSONString((Object)reqBO));
                return;
            }
            for (Long each : reqBO.getSkuIds()) {
                JSONObject delConditionOrderJson = new JSONObject();
                delConditionOrderJson.put("sku_id", (Object)String.valueOf(each));
                JSONObject termOrderJson = new JSONObject();
                termOrderJson.put("term", (Object)delConditionOrderJson);
                JSONObject termAfsJson = new JSONObject();
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)termOrderJson);
                JSONObject mustJson = new JSONObject();
                mustJson.put("must", (Object)jsonArray);
                JSONObject boolJson = new JSONObject();
                boolJson.put("bool", (Object)mustJson);
                JSONObject qryJson = new JSONObject();
                qryJson.put("query", (Object)boolJson);
                String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_delete_by_query";
                Boolean deleteResult = this.elasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
                if (deleteResult.booleanValue()) continue;
                LOGGER.error("\u5355\u54c1\u4fe1\u606f[" + each + "]\u5220\u9664\u5931\u8d25!");
            }
        } else {
            LOGGER.error("\u5220\u9664ES \u6570\u636e\u672a\u77e5\u7684\u5904\u7406\u7c7b\u578b" + JSONObject.toJSONString((Object)reqBO));
        }
    }

    public void searchSku(SyncSceneCommodityToEsReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            return;
        }
        List<Object> skuPoList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getGuiCategoryIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByGuiCataLogs(reqBO.getGuiCategoryIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCategoryIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByCataLogs(reqBO.getCategoryIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
            skuPoList = this.uccSkuMapper.qrySkuByCommoditys(reqBO.getCommodityIds(), reqBO.getSupplierId());
        }
        if (!CollectionUtils.isEmpty(skuPoList)) {
            reqBO.setSkuIds(skuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
        }
    }

    private List<EsStorageSpuAttrInfoBO> assemblyCommodityAttrInfo(List<Long> commodityIds) {
        if (CollectionUtils.isEmpty(commodityIds)) {
            return new ArrayList<EsStorageSpuAttrInfoBO>();
        }
        return JSONObject.parseArray((String)JSONObject.toJSONString(this.uccSpuSpecMapper.qryEsAttrList(commodityIds)), EsStorageSpuAttrInfoBO.class);
    }

    private void validateReqParams(SyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getOperType() == null) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getSyncType() == null) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u540c\u6b65\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType()) && (reqBO.getCategoryIds() == null || reqBO.getCategoryIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5173\u8054\u7c7b\u76ee\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID.equals(reqBO.getSyncType()) && (reqBO.getGuiCategoryIds() == null || reqBO.getGuiCategoryIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5173\u8054\u7c7b\u76ee\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType()) && (reqBO.getCommodityIds() == null || reqBO.getCommodityIds().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5546\u54c1ID\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_ACTIVITY_CONTENT.equals(reqBO.getSyncType()) && (reqBO.getSpuEsForActivityBOS() == null || reqBO.getSpuEsForActivityBOS().isEmpty())) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u6d3b\u52a8\u4fe1\u606f\u5230ES\u5931\u8d25\uff1a\u6d3b\u52a8\u76f8\u5173\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private void syncSkuPoolToES(SyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS) || CollectionUtils.isEmpty(commodityIds)) {
            return;
        }
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.batchQrySkuForPool(reqBO.getSupplierId(), commodityIds);
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            throw new BusinessException("8888", "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u6c60\u4fe1\u606f\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4e0b\u5173\u8054\u7684\u5355\u54c1\u6570\u636e!");
        }
        ArrayList<Long> skuIds = new ArrayList<Long>();
        ArrayList<Long> agrIds = new ArrayList<Long>();
        ArrayList<Long> vendorIds = new ArrayList<Long>();
        ArrayList<Long> typeIds = new ArrayList<Long>();
        ArrayList<Long> spuIds = new ArrayList<Long>();
        uccSkuPos.forEach(each -> {
            if (!skuIds.contains(each.getSkuId())) {
                skuIds.add(each.getSkuId());
            }
            if (!agrIds.contains(each.getAgreementId())) {
                agrIds.add(each.getAgreementId());
            }
            if (!vendorIds.contains(each.getVendorId())) {
                vendorIds.add(each.getVendorId());
            }
            if (!typeIds.contains(each.getCommodityTypeId())) {
                typeIds.add(each.getCommodityTypeId());
            }
            if (!spuIds.contains(each.getCommodityId())) {
                spuIds.add(each.getCommodityId());
            }
        });
        List<Object> uccRelPoolCommodityPosBySku = new ArrayList();
        if (!CollectionUtils.isEmpty(skuIds)) {
            uccRelPoolCommodityPosBySku = this.uccRelPoolCommodityMapper.queryPools(skuIds, SkuPoolRelTypeConstant.REL_BY_SKU);
        }
        List<Object> uccRelPoolCommodityPosByType = new ArrayList();
        if (!CollectionUtils.isEmpty(typeIds)) {
            uccRelPoolCommodityPosByType = this.uccRelPoolCommodityMapper.queryPools(typeIds, SkuPoolRelTypeConstant.REL_BY_COMMODITY_TYPE);
        }
        ArrayList uccRelPoolCommodityPosByVendor = new ArrayList();
        if (!CollectionUtils.isEmpty(vendorIds)) {
            this.uccRelPoolCommodityMapper.queryPools(vendorIds, SkuPoolRelTypeConstant.REL_BY_VENDOR);
        }
        List<Object> uccRelPoolCommodityPosByAgr = new ArrayList();
        if (!CollectionUtils.isEmpty(agrIds)) {
            uccRelPoolCommodityPosByAgr = this.uccRelPoolCommodityMapper.queryPools(agrIds, SkuPoolRelTypeConstant.REL_BY_AGR);
        }
        List<Object> uccRelPoolCommodityPosBySpu = new ArrayList();
        if (!CollectionUtils.isEmpty(spuIds)) {
            uccRelPoolCommodityPosBySpu = this.uccRelPoolCommodityMapper.queryPools(spuIds, SkuPoolRelTypeConstant.REL_BY_SPU);
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosBySku)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosBySku) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getSku_id())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                }
            }
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosByType)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosByType) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getType_id())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                }
            }
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosByVendor)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosByVendor) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getVendor_id())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                }
            }
            if (!CollectionUtils.isEmpty(uccRelPoolCommodityPosByAgr)) {
                for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosByAgr) {
                    if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getAgreement_id())) continue;
                    if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                        esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                        continue;
                    }
                    esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
                }
            }
            if (CollectionUtils.isEmpty(uccRelPoolCommodityPosBySpu)) continue;
            for (UccRelPoolCommodityPo uccRelPoolCommodityPo : uccRelPoolCommodityPosBySpu) {
                if (!uccRelPoolCommodityPo.getSource().equals(esStorageSpuInfoBO.getCommodity_id())) continue;
                if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                    esStorageSpuInfoBO.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{uccRelPoolCommodityPo.getPoolId()}));
                    continue;
                }
                esStorageSpuInfoBO.getSkuPoolIds().add(uccRelPoolCommodityPo.getPoolId());
            }
        }
    }

    private void applrovalCommodityToEs(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        Map<Long, List<UocSpuApproverPO>> approvar;
        List<UocSpuApproverPO> approvers;
        ArrayList<Long> skus = new ArrayList<Long>();
        HashSet spus = new HashSet();
        esStorageSpuInfoBOS.forEach(bo -> {
            if (bo.getSku_approval_status() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_GO || bo.getSku_approval_status() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO || bo.getSku_approval_status() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO || bo.getSku_approval_status() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO) {
                skus.add(bo.getSku_id());
            } else if (bo.getSku_approval_status() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO) {
                spus.add(bo.getCommodity_id());
            }
        });
        if (!skus.isEmpty() && !CollectionUtils.isEmpty(approvers = this.uocApprovalObjMapper.querySpuApprover(skus, esStorageSpuInfoBOS.get(0).getSupplier_shop_id()))) {
            approvar = approvers.stream().collect(Collectors.groupingBy(UocSpuApproverPO::getObjId));
            esStorageSpuInfoBOS.forEach(bo -> {
                if (approvar.containsKey(bo.getSku_id())) {
                    bo.setOperIds(((List)approvar.get(bo.getSku_id())).stream().map(UocSpuApproverPO::getOperId).collect(Collectors.toList()));
                    bo.setAudit_time(((UocSpuApproverPO)((List)approvar.get(bo.getSku_id())).get(0)).getCreateTime().getTime());
                }
            });
        }
        if (skus.isEmpty()) {
            esStorageSpuInfoBOS.forEach(bo -> {
                bo.setOperIds(null);
                bo.setAudit_time(null);
            });
        }
        if (!spus.isEmpty() && !CollectionUtils.isEmpty(approvers = this.uocApprovalObjMapper.querySpuApprover(new ArrayList<Long>(spus), esStorageSpuInfoBOS.get(0).getSupplier_shop_id()))) {
            approvar = approvers.stream().collect(Collectors.groupingBy(UocSpuApproverPO::getObjId));
            esStorageSpuInfoBOS.forEach(bo -> {
                if (approvar.containsKey(bo.getCommodity_id())) {
                    bo.setOperIds(((List)approvar.get(bo.getCommodity_id())).stream().map(UocSpuApproverPO::getOperId).collect(Collectors.toList()));
                    bo.setAudit_time(((UocSpuApproverPO)((List)approvar.get(bo.getCommodity_id())).get(0)).getCreateTime().getTime());
                }
            });
        }
    }

    private void dealLable(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS)) {
            return;
        }
        ArrayList<Long> skuPoos = new ArrayList<Long>();
        esStorageSpuInfoBOS.stream().filter(s -> !CollectionUtils.isEmpty(s.getSkuPoolIds())).forEach(item -> skuPoos.addAll(item.getSkuPoolIds()));
        if (CollectionUtils.isEmpty(skuPoos)) {
            return;
        }
        List<UccRelCommodityLabelPoolPo> cnncRelCommodityLabelPoolPos = this.cnncRelCommodityLaberPoolMapper.queryAllInfoByPoolList(skuPoos);
        if (CollectionUtils.isEmpty(cnncRelCommodityLabelPoolPos)) {
            return;
        }
        HashSet lableList = new HashSet();
        cnncRelCommodityLabelPoolPos.stream().forEach(item -> lableList.add(item.getLabelId()));
        List<UccCommodityLabelPo> labelPos = this.cnncCommodityLabelMapper.selectLabel(null, new ArrayList<Long>(skuPoos));
        if (CollectionUtils.isEmpty(labelPos)) {
            LOGGER.error("\u5546\u54c1\u540c\u6b65es \uff0c\u6807\u7b7e\u4e0d\u5b58\u5728" + lableList);
            return;
        }
        Map<Long, UccCommodityLabelPo> labelMap = labelPos.stream().collect(Collectors.toMap(UccCommodityLabelPo::getLabelId, CnncCommodityLabelPo -> CnncCommodityLabelPo, (a, b) -> a));
        Map<Long, List<UccRelCommodityLabelPoolPo>> groupByPools = cnncRelCommodityLabelPoolPos.stream().collect(Collectors.groupingBy(UccRelCommodityLabelPoolPo::getPoolId));
        HashMap<Long, UccPoolsLableBo> poolsLableDetailMap = new HashMap<Long, UccPoolsLableBo>();
        for (Map.Entry<Long, List<UccRelCommodityLabelPoolPo>> entry : groupByPools.entrySet()) {
            HashSet<Long> labelIds = new HashSet<Long>();
            HashSet<Long> showLabelIds = new HashSet<Long>();
            HashSet<String> labelNames = new HashSet<String>();
            HashSet<String> showLabelNames = new HashSet<String>();
            UccPoolsLableBo uccPoolsLableBo = new UccPoolsLableBo();
            uccPoolsLableBo.setPoolId(entry.getKey());
            for (UccRelCommodityLabelPoolPo relCommodityLabelPoolPo : entry.getValue()) {
                if (!labelMap.containsKey(relCommodityLabelPoolPo.getLabelId())) continue;
                labelIds.add(relCommodityLabelPoolPo.getLabelId());
                labelNames.add(labelMap.get(relCommodityLabelPoolPo.getLabelId()).getLabelName());
                if (relCommodityLabelPoolPo.getIsShow() != 1) continue;
                showLabelIds.add(relCommodityLabelPoolPo.getLabelId());
                showLabelNames.add(labelMap.get(relCommodityLabelPoolPo.getLabelId()).getLabelName());
            }
            uccPoolsLableBo.setLabelIds(new ArrayList<Long>(labelIds));
            uccPoolsLableBo.setLabelNames(new ArrayList<String>(labelNames));
            uccPoolsLableBo.setShowLabelIds(new ArrayList<Long>(showLabelIds));
            uccPoolsLableBo.setShowLabelNames(new ArrayList<String>(showLabelNames));
            poolsLableDetailMap.put(entry.getKey(), uccPoolsLableBo);
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) continue;
            HashSet<Long> labelIds = new HashSet<Long>();
            HashSet<Long> showLabelIds = new HashSet<Long>();
            HashSet<String> labelNames = new HashSet<String>();
            HashSet<String> showLabelNames = new HashSet<String>();
            for (Long pool : esStorageSpuInfoBO.getSkuPoolIds()) {
                if (poolsLableDetailMap.containsKey(pool)) {
                    labelIds.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getLabelIds());
                    showLabelIds.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getShowLabelIds());
                    labelNames.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getLabelNames());
                    showLabelNames.addAll(((UccPoolsLableBo)poolsLableDetailMap.get(pool)).getShowLabelNames());
                    continue;
                }
                LOGGER.error("\u672a\u5339\u914d\u5230\u5546\u54c1\u6c60\u8be6\u60c5\u6570\u636e\uff1a" + pool);
            }
            esStorageSpuInfoBO.setLabelIds(new ArrayList<Long>(labelIds));
            esStorageSpuInfoBO.setLabelNames(new ArrayList<String>(labelNames));
            esStorageSpuInfoBO.setShowLabelIds(new ArrayList<Long>(showLabelIds));
            esStorageSpuInfoBO.setShowLabelNames(new ArrayList<String>(showLabelNames));
        }
    }

    private void dealChannel(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        if (CollectionUtils.isEmpty(esStorageSpuInfoBOS)) {
            return;
        }
        for (EsStorageSpuInfoBO esStorageSpuInfoBO : esStorageSpuInfoBOS) {
            List<UccRelChannelPoolPo> uccRelChannelPoolPos;
            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getChannel_id())) {
                List<UccRelChannelPoolPo> uccRelChannelPoolPos2;
                if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds()) || CollectionUtils.isEmpty(uccRelChannelPoolPos2 = this.uccRelChannelPoolMapper.getRelListByPools(esStorageSpuInfoBO.getSkuPoolIds()))) continue;
                List channelIdList = uccRelChannelPoolPos2.stream().map(a -> a.getChannelId()).collect(Collectors.toList());
                esStorageSpuInfoBO.setChannel_id(channelIdList);
                List<String> channelNameList = uccRelChannelPoolPos2.stream().map(a -> a.getChannelName()).collect(Collectors.toList());
                esStorageSpuInfoBO.setChannel_Name(channelNameList);
                continue;
            }
            ArrayList<Long> channelIdLists = new ArrayList<Long>();
            channelIdLists.addAll(esStorageSpuInfoBO.getChannel_id());
            for (Long each : esStorageSpuInfoBO.getChannel_id()) {
                UccChannelDealPO uccChannelDealPO = new UccChannelDealPO();
                uccChannelDealPO.setChannelId(each);
                uccChannelDealPO.setRelatedType(1);
                List<UccChannelDealPO> uccChannelDealPOList = this.uccChannelDealMapper.selectByChannelCode(uccChannelDealPO);
                if (CollectionUtils.isEmpty(uccChannelDealPOList)) continue;
                if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds())) {
                    channelIdLists.remove(each);
                    esStorageSpuInfoBO.getChannel_Name().remove(uccChannelDealPOList.get(0).getChannelName());
                    continue;
                }
                List<UccRelChannelPoolPo> uccRelChannelPoolPos3 = this.uccRelChannelPoolMapper.getRelListByChannelIds(Lists.newArrayList((Object[])new Long[]{uccChannelDealPOList.get(0).getChannelId()}));
                if (CollectionUtils.isEmpty(uccRelChannelPoolPos3)) {
                    esStorageSpuInfoBO.getChannel_Name().remove(uccChannelDealPOList.get(0).getChannelName());
                    channelIdLists.remove(each);
                    continue;
                }
                boolean contain = false;
                for (UccRelChannelPoolPo uccRelChannelPoolPo : uccRelChannelPoolPos3) {
                    if (!esStorageSpuInfoBO.getSkuPoolIds().contains(uccRelChannelPoolPo.getPoolId())) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                channelIdLists.remove(each);
                esStorageSpuInfoBO.getChannel_Name().remove(uccChannelDealPOList.get(0).getChannelName());
            }
            esStorageSpuInfoBO.setChannel_id(channelIdLists);
            if (CollectionUtils.isEmpty(esStorageSpuInfoBO.getSkuPoolIds()) || CollectionUtils.isEmpty(uccRelChannelPoolPos = this.uccRelChannelPoolMapper.getRelListByPools(esStorageSpuInfoBO.getSkuPoolIds()))) continue;
            List channelIdList = uccRelChannelPoolPos.stream().map(a -> a.getChannelId()).collect(Collectors.toList());
            Map<Long, String> channelMap = uccRelChannelPoolPos.stream().collect(Collectors.toMap(a -> a.getChannelId(), b -> b.getChannelName(), (oldValue, newValue) -> newValue));
            for (Long each : channelIdList) {
                if (esStorageSpuInfoBO.getChannel_id().contains(each)) continue;
                esStorageSpuInfoBO.getChannel_id().add(each);
                esStorageSpuInfoBO.getChannel_Name().add(channelMap.get(each));
            }
        }
    }
}

