/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.commodity.base.bo.QueryParam;
import com.tydic.commodity.base.bo.SearchBarEsReqBO;
import com.tydic.commodity.base.bo.SearchBarEsRspBO;
import com.tydic.commodity.base.bo.SearchBarEsRspInfo;
import com.tydic.commodity.base.bo.UccSourceCatalogBo;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.utils.MoneyUtils;
import com.tydic.commodity.busibase.atom.api.UccFieldsSearchCacheAtomService;
import com.tydic.commodity.busibase.comb.api.SearchBarEsCombService;
import com.tydic.commodity.busibase.comb.api.SearchCommodityService;
import com.tydic.commodity.busibase.comb.bo.CommodityRspBo;
import com.tydic.commodity.busibase.comb.bo.SearchEsReqBO;
import com.tydic.commodity.busibase.comb.bo.SearchEsRspBo;
import com.tydic.commodity.busibase.comb.bo.SourceCatalogBo;
import com.tydic.commodity.busibase.comb.bo.SourceTypeBo;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.po.UccSpuSpecPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SearchBarEsCombServiceImpl
implements SearchBarEsCombService {
    private static final Logger LOGGER = LogManager.getLogger(SearchBarEsCombServiceImpl.class);
    @Autowired
    private SearchCommodityService searchCommodityService;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccFieldsSearchCacheAtomService uccFieldsSearchCacheAtomService;
    @Value(value="${analyzer_tokens}")
    private Boolean analyzerTokens;
    private static Integer esSeaarchSize = 10000;

    @Override
    public SearchBarEsRspBO qryBySearchBar(SearchBarEsReqBO reqBO) {
        SearchEsRspBo searchEsRspBo;
        SourceCatalogBo sourceCatalogBo;
        ArrayList<SourceCatalogBo> searchSourceList;
        SearchBarEsRspBO searchBarEsRspBO = new SearchBarEsRspBO();
        String jsonStr1 = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        SearchEsReqBO searchEsReqBO = (SearchEsReqBO)((Object)JSON.parseObject((String)jsonStr1, SearchEsReqBO.class));
        if (reqBO.getSkuStatus() == null || reqBO.getSkuStatus().size() == 0) {
            ArrayList<Integer> skuStatus = new ArrayList<Integer>();
            skuStatus.add(ModelRuleConstant.SKU_STATUS_ON_SHELF);
            reqBO.setSkuStatus(skuStatus);
        }
        if (reqBO.getSupplierShopId() != null) {
            ArrayList<Long> supplierShopIds = new ArrayList<Long>();
            supplierShopIds.add(reqBO.getSupplierShopId());
            searchEsReqBO.setSupplierShopIds(supplierShopIds);
        }
        if (CollectionUtils.isEmpty(searchEsReqBO.getCategoryIds())) {
            if (reqBO.getCategoryId() != null) {
                if (!CollectionUtils.isEmpty((Collection)reqBO.getCategoryIds())) {
                    if (!reqBO.getCategoryIds().contains(reqBO.getCategoryId())) {
                        reqBO.getCategoryIds().add(reqBO.getCategoryId());
                        searchEsReqBO.setCategoryIds(reqBO.getCategoryIds());
                    } else {
                        searchEsReqBO.setCategoryIds(reqBO.getCategoryIds());
                    }
                } else {
                    ArrayList<Long> categoryIds = new ArrayList<Long>();
                    categoryIds.add(reqBO.getCategoryId());
                    searchEsReqBO.setCategoryIds(categoryIds);
                }
            } else {
                searchEsReqBO.setCategoryIds(reqBO.getCategoryIds());
            }
        }
        if (reqBO.getBrandId() != null) {
            ArrayList<Long> brandIds = new ArrayList<Long>();
            brandIds.add(reqBO.getBrandId());
            searchEsReqBO.setBrandIds(brandIds);
        }
        if (reqBO.getTypeId() != null) {
            searchEsReqBO.setTypeId(reqBO.getTypeId());
        }
        if (reqBO.getTypeName() != null) {
            searchEsReqBO.setTypeName(reqBO.getTypeName());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSearchSourceList())) {
            searchSourceList = new ArrayList<SourceCatalogBo>();
            for (UccSourceCatalogBo each : reqBO.getSearchSourceList()) {
                sourceCatalogBo = new SourceCatalogBo();
                BeanUtils.copyProperties((Object)each, (Object)sourceCatalogBo);
                searchSourceList.add(sourceCatalogBo);
            }
            searchEsReqBO.setSearchSourceList(searchSourceList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSearchLevelList())) {
            searchSourceList = new ArrayList();
            for (UccSourceCatalogBo each : reqBO.getSearchLevelList()) {
                sourceCatalogBo = new SourceCatalogBo();
                BeanUtils.copyProperties((Object)each, (Object)sourceCatalogBo);
                searchSourceList.add(sourceCatalogBo);
            }
            searchEsReqBO.setSearchLevelList(searchSourceList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSearchTypeList())) {
            ArrayList<SourceTypeBo> searchTypeList = new ArrayList<SourceTypeBo>();
            for (UccSourceCatalogBo each : reqBO.getSearchTypeList()) {
                SourceTypeBo sourceTypeBo = new SourceTypeBo();
                BeanUtils.copyProperties((Object)each, (Object)sourceTypeBo);
                searchTypeList.add(sourceTypeBo);
            }
            searchEsReqBO.setSearchTypeList(searchTypeList);
        }
        if ((searchEsRspBo = this.searchCommodityService.queryByMatch(searchEsReqBO)) == null) {
            LOGGER.info("\u67e5\u8be2ES\u6570\u636e\u670d\u52a1\u5f02\u5e38!!");
            searchBarEsRspBO.setRespCode("0000");
            searchBarEsRspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
            searchBarEsRspBO.setPageNo(1);
            searchBarEsRspBO.setTotal(0);
            searchBarEsRspBO.setRecordsTotal(0);
            return searchBarEsRspBO;
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)searchBarEsRspBO);
        List<CommodityRspBo> commodityRspBos = searchEsRspBo.getCommodityRspBos();
        List<SearchBarEsRspInfo> result = this.convertRspBo(commodityRspBos);
        searchBarEsRspBO.setResult(result);
        int size = reqBO.getPageSize();
        int no = reqBO.getPageNo();
        int totalPage = 0;
        int add = 0;
        Integer total = 0;
        if (esSeaarchSize.compareTo(searchEsRspBo.getTotal()) > 0 || reqBO.isQryCount()) {
            totalPage = searchEsRspBo.getTotal() / size;
            add = searchEsRspBo.getTotal() % size == 0 ? 0 : 1;
            total = searchEsRspBo.getTotal();
        } else {
            totalPage = esSeaarchSize / size;
            total = size * (totalPage + (add = esSeaarchSize % size == 0 ? 0 : 1));
            if (total.compareTo(searchEsRspBo.getTotal()) > 0) {
                total = searchEsRspBo.getTotal();
            }
        }
        searchBarEsRspBO.setTotal(totalPage + add);
        searchBarEsRspBO.setPageNo(no);
        if (searchEsRspBo.getQueryParams() != null && searchEsRspBo.getPropParams() != null) {
            searchEsRspBo.getQueryParams().addAll(searchEsRspBo.getPropParams());
        }
        searchBarEsRspBO.setQueryParams(JSONObject.parseArray((String)JSONObject.toJSONString(searchEsRspBo.getQueryParams()), QueryParam.class));
        searchBarEsRspBO.setRecordsTotal(total.intValue());
        searchBarEsRspBO.setRespCode("0000");
        searchBarEsRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return searchBarEsRspBO;
    }

    private List<SearchBarEsRspInfo> convertRspBo(List<CommodityRspBo> commodityRspBos) {
        ArrayList<SearchBarEsRspInfo> searchBarEsRspInfos = new ArrayList<SearchBarEsRspInfo>();
        if (commodityRspBos != null && commodityRspBos.size() > 0) {
            for (CommodityRspBo commodityRspBo : commodityRspBos) {
                SearchBarEsRspInfo searchBarEsRspInfo = new SearchBarEsRspInfo();
                searchBarEsRspInfo.setCommodityId(Long.valueOf(commodityRspBo.getCommodity_id()));
                searchBarEsRspInfo.setSkuId(Long.valueOf(commodityRspBo.getSku_id()));
                searchBarEsRspInfo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchBarEsRspInfo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getAgreement_price())));
                searchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMarket_price())));
                searchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getSale_price())));
                searchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price1())));
                searchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price2())));
                searchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price3())));
                searchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price4())));
                searchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price5())));
                searchBarEsRspInfo.setCommentNumber(commodityRspBo.getComment_number());
                searchBarEsRspInfo.setSkuName(commodityRspBo.getSku_name());
                searchBarEsRspInfo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchBarEsRspInfo.setSupplierShopName(commodityRspBo.getShop_name());
                searchBarEsRspInfo.setSupplierId(String.valueOf(commodityRspBo.getSupplier_id()));
                searchBarEsRspInfo.setSupplierName(commodityRspBo.getSupplier_name());
                searchBarEsRspInfo.setSkuSource(Integer.valueOf(commodityRspBo.getSku_source()));
                searchBarEsRspInfo.setCommodityName(commodityRspBo.getCommodity_name());
                searchBarEsRspInfo.setCommdPicUrl(commodityRspBo.getCommd_pic_url());
                if (commodityRspBo.getEcommerce_sale() != null) {
                    searchBarEsRspInfo.setEcommerceSale(Long.valueOf(commodityRspBo.getEcommerce_sale().longValue()));
                }
                searchBarEsRspInfo.setExtendProperties(commodityRspBo.getExtendProperties());
                searchBarEsRspInfo.setVendorName(commodityRspBo.getVendor_name());
                searchBarEsRspInfo.setAgreementId(Long.valueOf(commodityRspBo.getAgreement_id()));
                searchBarEsRspInfo.setHighLightSkuName(commodityRspBo.getHighLightSkuName());
                searchBarEsRspInfo.setHighLightCommodityName(commodityRspBo.getHighLightCommodityName());
                searchBarEsRspInfo.setChannelIds(commodityRspBo.getChannel_id());
                searchBarEsRspInfo.setChannelNames(commodityRspBo.getChannel_Name());
                searchBarEsRspInfo.setTypeId(commodityRspBo.getType_id());
                searchBarEsRspInfo.setVendorId(commodityRspBo.getVendor_id());
                searchBarEsRspInfo.setL1CategoryName(commodityRspBo.getL1_category_name());
                searchBarEsRspInfo.setL2CategoryName(commodityRspBo.getL2_category_name());
                searchBarEsRspInfo.setL3CategoryName(commodityRspBo.getL3_category_name());
                searchBarEsRspInfo.setL1CategoryId(commodityRspBo.getL1_category_id());
                searchBarEsRspInfo.setL2CategoryId(commodityRspBo.getL2_category_id());
                searchBarEsRspInfo.setL3CategoryId(commodityRspBo.getL3_category_id());
                searchBarEsRspInfo.setBrandName(commodityRspBo.getBrand_name());
                searchBarEsRspInfo.setLabelIds(commodityRspBo.getLabelIds());
                searchBarEsRspInfo.setLabelNames(commodityRspBo.getLabelNames());
                searchBarEsRspInfo.setShowLabelIds(commodityRspBo.getShowLabelIds());
                searchBarEsRspInfo.setShowLabelNames(commodityRspBo.getShowLabelNames());
                if (!(CollectionUtils.isEmpty(commodityRspBo.getL1_category_name()) || CollectionUtils.isEmpty(commodityRspBo.getL2_category_name()) || CollectionUtils.isEmpty(commodityRspBo.getL3_category_name()))) {
                    StringBuffer catalogAllName = new StringBuffer(commodityRspBo.getL1_category_name().get(0));
                    catalogAllName.append("/").append(commodityRspBo.getL2_category_name().get(0)).append("/").append(commodityRspBo.getL3_category_name().get(0));
                    searchBarEsRspInfo.setCatalogAllName(catalogAllName.toString());
                }
                searchBarEsRspInfo.setShipWay(commodityRspBo.getShip_way());
                searchBarEsRspInfo.setDealWay(commodityRspBo.getDeal_way());
                searchBarEsRspInfo.setSourceAssort(commodityRspBo.getSourceAssort());
                searchBarEsRspInfos.add(searchBarEsRspInfo);
            }
        }
        commodityRspBos = null;
        return searchBarEsRspInfos;
    }

    private void queryOtherProp(List<SearchBarEsRspInfo> rspInfos) {
        if (rspInfos == null || rspInfos.size() == 0) {
            return;
        }
        HashedMap shopCommd = new HashedMap();
        for (SearchBarEsRspInfo each : rspInfos) {
            if (shopCommd.containsKey(each.getSupplierShopId())) {
                ((List)shopCommd.get(each.getSupplierShopId())).add(each.getCommodityId());
                continue;
            }
            ArrayList<Long> commoditys = new ArrayList<Long>();
            commoditys.add(each.getCommodityId());
            shopCommd.put(each.getSupplierShopId(), commoditys);
        }
        Iterator iterator = shopCommd.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            System.out.println(++i);
            Map.Entry data = iterator.next();
            List<UccSpuSpecPo> uccSpuSpecPoList = this.uccSpuSpecMapper.batchQueryLessSpecs((List)data.getValue(), ModelRuleConstant.PROP_GRP_TYPE_OTHER, (Long)data.getKey());
            if (uccSpuSpecPoList == null || uccSpuSpecPoList.size() == 0) continue;
            HashedMap specMap = new HashedMap();
            for (UccSpuSpecPo uccSpuSpecPo : uccSpuSpecPoList) {
                if (specMap.containsKey(uccSpuSpecPo.getCommodityId())) {
                    ((JSONObject)specMap.get(uccSpuSpecPo.getCommodityId())).put(uccSpuSpecPo.getPropShowName(), (Object)uccSpuSpecPo.getPropValue());
                    continue;
                }
                JSONObject specData = new JSONObject();
                specData.put(uccSpuSpecPo.getPropShowName(), (Object)uccSpuSpecPo.getPropValue());
                specMap.put(uccSpuSpecPo.getCommodityId(), specData);
            }
            for (SearchBarEsRspInfo searchBarEsRspInfo : rspInfos) {
                searchBarEsRspInfo.setExtendProperties(JSONObject.toJSONString(specMap.get(searchBarEsRspInfo.getCommodityId())));
            }
        }
        shopCommd = null;
    }
}

