/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccCommodityPoolOperateAtomService;
import com.tydic.commodity.busibase.atom.bo.UccCommodityPoolOperateAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccCommodityPoolOperateAtomRspBO;
import com.tydic.commodity.dao.UccCommodityPoolHisMapper;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.po.UccCommodityPoolHisPO;
import com.tydic.commodity.po.UccCommodityPoolPO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccCommodityPoolOperateAtomServiceImpl
implements UccCommodityPoolOperateAtomService {
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;
    @Autowired
    private UccCommodityPoolHisMapper uccCommodityPoolHisMapper;

    @Override
    public UccCommodityPoolOperateAtomRspBO operateCommodityPool(UccCommodityPoolOperateAtomReqBO atomReqBO) {
        this.validParam(atomReqBO);
        switch (atomReqBO.getOperType()) {
            case 1: {
                this.addCommodityPool(atomReqBO);
                break;
            }
            case 0: {
                this.updateCommodityPool(atomReqBO);
                break;
            }
            case -1: {
                this.deleteCommodityPool(atomReqBO);
                break;
            }
            default: {
                throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[operType]\u4e0d\u5408\u6cd5");
            }
        }
        UccCommodityPoolOperateAtomRspBO rspBO = new UccCommodityPoolOperateAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateCommodityPool(UccCommodityPoolOperateAtomReqBO atomReqBO) {
        UccCommodityPoolPO uccCommodityPoolPO = (UccCommodityPoolPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)atomReqBO)), UccCommodityPoolPO.class);
        this.uccCommodityPoolMapper.updateByPrimaryKeySelective(uccCommodityPoolPO);
        UccCommodityPoolHisPO uccCommodityPoolHisPO = (UccCommodityPoolHisPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)atomReqBO)), UccCommodityPoolHisPO.class);
        uccCommodityPoolHisPO.setPoolHisId(Sequence.getInstance().nextId());
        uccCommodityPoolHisPO.setOperType(UccConstants.CommodityPoolOperType.UPDATE);
        uccCommodityPoolHisPO.setHisCreateTime(atomReqBO.getUpdateTime());
        this.uccCommodityPoolHisMapper.insert(uccCommodityPoolHisPO);
    }

    private void deleteCommodityPool(UccCommodityPoolOperateAtomReqBO atomReqBO) {
        UccCommodityPoolPO uccCommodityPoolPO = new UccCommodityPoolPO();
        uccCommodityPoolPO.setPoolId(atomReqBO.getPoolId());
        uccCommodityPoolPO.setPoolIds(atomReqBO.getPoolIds());
        List<UccCommodityPoolPO> poolPOS = this.uccCommodityPoolMapper.getList(uccCommodityPoolPO);
        if (poolPOS == null || poolPOS.size() == 0) {
            throw new BusinessException("8888", "\u5546\u54c1\u6c60\u4e0d\u5b58\u5728");
        }
        ArrayList<UccCommodityPoolHisPO> list = new ArrayList<UccCommodityPoolHisPO>();
        ArrayList<Long> poolIds = new ArrayList<Long>();
        for (UccCommodityPoolPO po : poolPOS) {
            UccCommodityPoolHisPO uccCommodityPoolHisPO = (UccCommodityPoolHisPO)JSON.parseObject((String)JSON.toJSONString((Object)po), UccCommodityPoolHisPO.class);
            uccCommodityPoolHisPO.setPoolHisId(Sequence.getInstance().nextId());
            uccCommodityPoolHisPO.setOperType(UccConstants.CommodityPoolOperType.DELETE);
            uccCommodityPoolHisPO.setHisCreateTime(atomReqBO.getUpdateTime());
            list.add(uccCommodityPoolHisPO);
            poolIds.add(po.getPoolId());
        }
        this.uccCommodityPoolHisMapper.insertBatch(list);
        this.uccCommodityPoolMapper.batchDelete(poolIds);
    }

    private void addCommodityPool(UccCommodityPoolOperateAtomReqBO atomReqBO) {
        UccCommodityPoolPO uccCommodityPoolPO = (UccCommodityPoolPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)atomReqBO)), UccCommodityPoolPO.class);
        this.uccCommodityPoolMapper.insert(uccCommodityPoolPO);
        UccCommodityPoolHisPO uccCommodityPoolHisPO = (UccCommodityPoolHisPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)atomReqBO)), UccCommodityPoolHisPO.class);
        uccCommodityPoolHisPO.setPoolHisId(Sequence.getInstance().nextId());
        uccCommodityPoolHisPO.setOperType(UccConstants.CommodityPoolOperType.ADD);
        uccCommodityPoolHisPO.setHisCreateTime(atomReqBO.getUpdateTime());
        this.uccCommodityPoolHisMapper.insert(uccCommodityPoolHisPO);
    }

    private void validParam(UccCommodityPoolOperateAtomReqBO atomReqBO) {
        if (atomReqBO == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (atomReqBO.getOperType() == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[operType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (atomReqBO.getPoolId() == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[poolId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

