/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccLadderPriceInfo;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccItemcreationAtomService;
import com.tydic.commodity.busibase.atom.bo.UccItemcreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccItemcreationAtomRspBO;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuDetailPO;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.po.UccSkuSpecPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccItemcreationAtomServiceImpl
implements UccItemcreationAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccItemcreationAtomServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    @Resource(name="uccSkuIdSequence")
    private OrderSequence orderSequence;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccItemcreationAtomRspBO dealCreateSku(UccItemcreationAtomReqBO reqBO) {
        UccItemcreationAtomRspBO rspBO = new UccItemcreationAtomRspBO();
        UccSkuPo uccSkuPo = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuPo);
        if (reqBO.getMaterialId() != null) {
            uccSkuPo.setMaterialId(reqBO.getMaterialId().toString());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSalesUnitRate())) {
            try {
                uccSkuPo.setSalesUnitRate(new BigDecimal(reqBO.getSalesUnitRate()));
            }
            catch (Exception e) {
                log.error("\u5355\u54c1\u521b\u5efa\u5f02\u5e38\uff1a" + e.getMessage());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSalesUnitId())) {
            try {
                uccSkuPo.setSalesUnitId(Long.valueOf(reqBO.getSalesUnitId()));
            }
            catch (Exception e) {
                log.error("\u5355\u54c1\u521b\u5efa\u5f02\u5e38\uff1a" + e.getMessage());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
        }
        if (reqBO.getSkuInfoPrice() != null && reqBO.getSkuInfoPrice().getSalePrice() != null) {
            uccSkuPo.setSkuPrice(MoneyUtils.yuanToHaoToLong(reqBO.getSkuInfoPrice().getSalePrice()));
        }
        try {
            uccSkuPo.setSkuId(this.orderSequence.nextId());
        }
        catch (SQLException e) {
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), "\u5e8f\u5217\u751f\u6210\u5931\u8d25\uff01");
        }
        try {
            this.uccSkuMapper.addsku(uccSkuPo);
        }
        catch (Exception e) {
            throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u65b0\u589e\u5931\u8d25" + e.getMessage());
        }
        if (!(StringUtils.isEmpty((Object)reqBO.getSkuPcDetailChar()) && StringUtils.isEmpty((Object)reqBO.getSkuPcDetailUrl()) && StringUtils.isEmpty((Object)reqBO.getSkuPhoneDetailChar()) && StringUtils.isEmpty((Object)reqBO.getSkuPhoneDetailUrl()))) {
            UccSkuDetailPO uccSkuDetailPO = new UccSkuDetailPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuDetailPO);
            uccSkuDetailPO.setSkuId(uccSkuPo.getSkuId());
            this.uccSkuDetailMapper.addSkuDetail(uccSkuDetailPO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getSkuImages())) {
            List uccSkuPicPoList = JSONObject.parseArray((String)JSONObject.toJSONString(reqBO.getSkuImages()), UccSkuPicPo.class);
            uccSkuPicPoList.stream().forEach(each -> {
                each.setSkuId(uccSkuPo.getSkuId());
                each.setSupplierShopId(reqBO.getSupplierShopId());
                each.setCreateOperId(reqBO.getCreateOperId());
                each.setSkuPicId(this.sequence.nextId());
                if (each.getPicOrder() == null) {
                    each.setPicOrder(1);
                }
            });
            try {
                this.uccSkuPicMapper.addskuPicList(uccSkuPicPoList);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u4ef7\u683c\u65b0\u589e\u5931\u8d25" + e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getSkuSpec())) {
            List uccSkuSpecPos = JSONObject.parseArray((String)JSONObject.toJSONString(reqBO.getSkuSpec()), UccSkuSpecPo.class);
            uccSkuSpecPos.stream().forEach(each -> {
                each.setSkuId(uccSkuPo.getSkuId());
                each.setCommodityId(uccSkuPo.getCommodityId());
                each.setSupplierShopId(reqBO.getSupplierShopId());
                each.setCreateOperId(reqBO.getCreateOperId());
                each.setSkuSpecId(this.sequence.nextId());
            });
            try {
                this.uccSkuSpecMapper.addSkuSpecs(uccSkuSpecPos);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u5c5e\u6027\u65b0\u589e\u5931\u8d25" + e.getMessage());
            }
        }
        if (reqBO.getSkuInfoPrice() != null) {
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            BeanUtils.copyProperties((Object)reqBO.getSkuInfoPrice(), (Object)uccSkuPricePo);
            uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
            uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPricePo.setCreateOperId(reqBO.getCreateOperId());
            uccSkuPricePo.setSkuPriceId(this.sequence.nextId());
            if (reqBO.getSkuInfoPrice().getMarketPrice() != null) {
                uccSkuPricePo.setMarketPrice(MoneyUtils.yuanToHaoToLong(reqBO.getSkuInfoPrice().getMarketPrice()));
            }
            if (reqBO.getSkuInfoPrice().getAgreementPrice() != null) {
                uccSkuPricePo.setAgreementPrice(MoneyUtils.yuanToHaoToLong(reqBO.getSkuInfoPrice().getAgreementPrice()));
            }
            if (reqBO.getSkuInfoPrice().getSalePrice() != null) {
                uccSkuPricePo.setSalePrice(MoneyUtils.yuanToHaoToLong(reqBO.getSkuInfoPrice().getSalePrice()));
            }
            this.uccSkuPriceMapper.addskuPrice(uccSkuPricePo);
            if (uccSkuPricePo.getSwitchOn() == 1) {
                ArrayList<UccLadderPricePO> uccLadderPricePOList = new ArrayList<UccLadderPricePO>();
                UccLadderPricePO uccLadderPricePO = null;
                for (UccLadderPriceInfo each2 : reqBO.getSkuInfoPrice().getLadderPriceInfo()) {
                    uccLadderPricePO = new UccLadderPricePO();
                    uccLadderPricePO.setStart(MoneyUtils.yuanToHaoToLong(each2.getStart()));
                    if (each2.getStop() != null) {
                        uccLadderPricePO.setStop(MoneyUtils.yuanToHaoToLong(each2.getStop()));
                    }
                    uccLadderPricePO.setPrice(MoneyUtils.yuanToHaoToLong(each2.getPrice()));
                    uccLadderPricePO.setSkuId(uccSkuPo.getSkuId());
                    uccLadderPricePO.setSupplierShopId(reqBO.getSupplierShopId());
                    uccLadderPricePO.setSkuPriceId(uccSkuPricePo.getSkuPriceId());
                    uccLadderPricePO.setId(this.sequence.nextId());
                    uccLadderPricePOList.add(uccLadderPricePO);
                }
                try {
                    this.uccLadderPriceMapper.batchInsert(uccLadderPricePOList);
                }
                catch (Exception e) {
                    throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u9636\u68af\u4ef7\u683c\u65b0\u589e\u5931\u8d25" + e.getMessage());
                }
            }
        }
        UccSaleNumPo saleNumPo = new UccSaleNumPo();
        saleNumPo.setSkuId(uccSkuPo.getSkuId());
        saleNumPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
        saleNumPo.setSoldNumber(new BigDecimal(0));
        saleNumPo.setSaleId(this.sequence.nextId());
        try {
            this.uccSaleNumMapper.insertSaleNum(saleNumPo);
        }
        catch (Exception e) {
            throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u9500\u91cf\u65b0\u589e\u5931\u8d25" + e.getMessage());
        }
        if (reqBO.getOnShelveWay() != null) {
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setSkuId(uccSkuPo.getSkuId());
            uccSkuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPutCirPo.setId(this.sequence.nextId());
            uccSkuPutCirPo.setState(1);
            if (0 == reqBO.getOnShelveWay()) {
                uccSkuPutCirPo.setUpType(1);
                uccSkuPutCirPo.setDownType(1);
            } else {
                uccSkuPutCirPo.setUpType(2);
                uccSkuPutCirPo.setDownType(2);
            }
            try {
                if (!StringUtils.isEmpty((Object)reqBO.getPreUpTime())) {
                    uccSkuPutCirPo.setPreUpTime(DateUtils.strToDate(reqBO.getPreUpTime()));
                }
                if (!StringUtils.isEmpty((Object)reqBO.getPreDownTime())) {
                    uccSkuPutCirPo.setPreDownTime(DateUtils.strToDate(reqBO.getPreDownTime()));
                }
            }
            catch (IllegalArgumentException e) {
                throw new ZTBusinessException(RspConstantEnums.TYPE_CONVERSION_FAILED.code() + e.getMessage());
            }
            try {
                this.uccSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u4e0a\u4e0b\u67b6\u5468\u671f\u5f02\u5e38");
            }
        }
        try {
            SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
            smcsdkOperateStockNumReqBO.setOperateType("10");
            smcsdkOperateStockNumReqBO.setOperateNo(reqBO.getCreateOperId());
            ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
            SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
            if (reqBO.getTotalNum() != null) {
                smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(MoneyUtils.yuanToHaoToLong(reqBO.getTotalNum())));
            } else {
                smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(0L));
            }
            smcsdkStockNumInfoBO.setSkuId(String.valueOf(uccSkuPo.getSkuId()));
            smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
            smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
            smcsdkOperateStockNumReqBO.setObjectId(String.valueOf(reqBO.getCommodityId()));
            smcsdkOperateStockNumReqBO.setObjectType("10");
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
            SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
            if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                throw new ZTBusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_ADD_FAIL.code() + smcsdkOperateStockNumRspBO.getRespDesc());
            }
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
        }
        catch (Exception e) {
            throw new ZTBusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_ADD_FAIL.code() + e.getMessage());
        }
        if (reqBO.getSkuExpand() != null || !StringUtils.isEmpty((Object)reqBO.getOrgPath())) {
            UccSkuExpandPo uccSkuExpandPo = new UccSkuExpandPo();
            if (reqBO.getSkuExpand() != null) {
                BeanUtils.copyProperties((Object)reqBO.getSkuExpand(), (Object)uccSkuExpandPo);
                uccSkuExpandPo.setExpand20(reqBO.getSkuExpand().getExpand20());
            }
            uccSkuExpandPo.setSkuId(uccSkuPo.getSkuId());
            uccSkuExpandPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
            uccSkuExpandPo.setCommodityId(uccSkuPo.getCommodityId());
            uccSkuExpandPo.setExpand13(reqBO.getOrgPath());
            try {
                this.uccSkuExpandMapper.insertSkuExpand(uccSkuExpandPo);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u6269\u5c55\u4fe1\u606f\u65b0\u589e\u5931\u8d25" + e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setSku(uccSkuPo.getSkuId());
        return rspBO;
    }
}

