/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.SkuPoolSyncESThreadBo;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomReqBo;
import com.tydic.commodity.busibase.atom.api.UccDealPoolSyncESAtomService;
import com.tydic.commodity.dao.UccGuideCatalogExtMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SkuPoolSyncESThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SkuPoolSyncESThread.class);
    private SkuPoolSyncESThreadBo skuPoolSyncESThreadBo;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccGuideCatalogExtMapper uccGuideCatalogExtMapper;
    @Autowired
    private UccDealPoolSyncESAtomService uccDealPoolSyncESAtomService;

    @Override
    public void run() {
        System.out.println(Thread.currentThread() + "\u7ebf\u7a0bes\u66f4\u65b0\u5f00\u59cb \uff01\u5206\u7247\uff1a" + this.skuPoolSyncESThreadBo.getStart());
        switch (this.skuPoolSyncESThreadBo.getSyncType()) {
            case 0: {
                List skuIds = this.skuPoolSyncESThreadBo.getSkuIds();
                this.dealSkuIds(skuIds);
                break;
            }
            case 1: {
                this.dealList(this.skuPoolSyncESThreadBo.getVendorIds(), null, null, null);
                break;
            }
            case 2: {
                this.dealList(null, null, this.skuPoolSyncESThreadBo.getTypeIds(), null);
                break;
            }
            case 3: {
                this.dealList(null, this.skuPoolSyncESThreadBo.getAgrIds(), null, null);
                break;
            }
            case 4: {
                this.dealByPoolIds(this.skuPoolSyncESThreadBo.getPoolIds());
                break;
            }
            case 5: {
                List<Long> typeIds = this.uccGuideCatalogExtMapper.getTypeIdByCat(this.skuPoolSyncESThreadBo.getGuideCatalogIds());
                this.dealList(null, null, typeIds, null);
                break;
            }
            case 6: {
                List spuIds = this.skuPoolSyncESThreadBo.getSpuIds();
                this.dealSpus(spuIds);
            }
        }
    }

    private void dealList(List<Long> vendorIds, List<Long> argIds, List<Long> typeIds, List<Long> spus) {
        int num = 1;
        int total = 0;
        do {
            Page page = new Page(num, this.skuPoolSyncESThreadBo.getSize());
            List<Long> skuList = this.uccSkuMapper.batchQrySkuList(vendorIds, argIds, typeIds, spus, this.skuPoolSyncESThreadBo.getShard(), this.skuPoolSyncESThreadBo.getStart(), page);
            if (total == 0) {
                total = page.getTotalPages();
                System.out.println("\u7b2c" + this.skuPoolSyncESThreadBo.getStart() + "\u7247\uff0c\u603b\u9875\u6570\u4e3a" + total);
            }
            if (CollectionUtils.isEmpty(skuList)) continue;
            this.dealSkuIds(skuList);
        } while (++num <= total);
    }

    private void dealByPoolIds(List<Long> poolIds) {
        for (Long poolId : poolIds) {
            List<UccRelPoolCommodityPo> uccRelPoolCommodityPOS = this.uccRelPoolCommodityMapper.qryNotSkuListByPoolId(poolId);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPOS)) {
                Map<Integer, List<UccRelPoolCommodityPo>> map = uccRelPoolCommodityPOS.stream().collect(Collectors.groupingBy(a -> a.getPoolRelated()));
                for (Map.Entry<Integer, List<UccRelPoolCommodityPo>> each : map.entrySet()) {
                    List<Long> dealIds = each.getValue().stream().map(a -> a.getSource()).collect(Collectors.toList());
                    switch (each.getKey()) {
                        case 1: {
                            this.dealList(null, null, dealIds, null);
                            break;
                        }
                        case 2: {
                            this.dealList(null, dealIds, null, null);
                            break;
                        }
                        case 3: {
                            this.dealList(dealIds, null, null, null);
                            break;
                        }
                        case 4: {
                            System.err.println("\u5546\u54c1\u6c60\u5546\u54c1\u9057\u6f0f\uff01");
                            break;
                        }
                        case 5: {
                            this.dealList(null, null, null, dealIds);
                        }
                    }
                }
            }
            int num = 1;
            int total = 0;
            do {
                Page page = new Page(num, this.skuPoolSyncESThreadBo.getSize());
                List<UccRelPoolCommodityPo> uccRelPoolCommodityPOList = this.uccRelPoolCommodityMapper.qrySkuListShard(poolId, this.skuPoolSyncESThreadBo.getShard(), this.skuPoolSyncESThreadBo.getStart(), page);
                if (total == 0) {
                    total = page.getTotalPages();
                    System.out.println("\u7b2c" + this.skuPoolSyncESThreadBo.getStart() + "\u7247\uff0c\u603b\u9875\u6570\u4e3a" + total);
                }
                if (CollectionUtils.isEmpty(uccRelPoolCommodityPOList)) continue;
                List<Long> skuIds = uccRelPoolCommodityPOS.stream().map(a -> a.getSource()).collect(Collectors.toList());
                this.dealSkuIds(skuIds);
            } while (++num <= total);
        }
    }

    private void dealSkuIds(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        UccDealPoolSyncESAtomReqBo uccDealPoolSyncESAtomReqBo = new UccDealPoolSyncESAtomReqBo();
        uccDealPoolSyncESAtomReqBo.setSkuIds(skuIds);
        uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(0));
        System.out.println("\u7b2c" + this.skuPoolSyncESThreadBo.getStart() + "\u7247\uff0c\u66f4\u65b0\u5546\u54c1\u6570\u91cf\u4e3a" + skuIds.size());
        this.uccDealPoolSyncESAtomService.dealPoolSyncES(uccDealPoolSyncESAtomReqBo);
    }

    private void dealSpus(List<Long> spuIds) {
        if (CollectionUtils.isEmpty(spuIds)) {
            return;
        }
        UccDealPoolSyncESAtomReqBo uccDealPoolSyncESAtomReqBo = new UccDealPoolSyncESAtomReqBo();
        uccDealPoolSyncESAtomReqBo.setSpuIds(spuIds);
        uccDealPoolSyncESAtomReqBo.setSyncType(Integer.valueOf(6));
        System.out.println("\u7b2c" + this.skuPoolSyncESThreadBo.getStart() + "\u7247\uff0c\u66f4\u65b0\u5546\u54c1\u6570\u91cf\u4e3a" + spuIds.size());
        this.uccDealPoolSyncESAtomService.dealPoolSyncES(uccDealPoolSyncESAtomReqBo);
    }

    public void setSkuPoolSyncESThreadBo(SkuPoolSyncESThreadBo skuPoolSyncESThreadBo) {
        this.skuPoolSyncESThreadBo = skuPoolSyncESThreadBo;
    }

    public void setUccExtSkuMapper(UccSkuMapper uccSkuMapper) {
        this.uccSkuMapper = uccSkuMapper;
    }

    public void setUccRelPoolCommodityMapper(UccRelPoolCommodityMapper uccRelPoolCommodityMapper) {
        this.uccRelPoolCommodityMapper = uccRelPoolCommodityMapper;
    }

    public void setUccGuideCatalogExtMapper(UccGuideCatalogExtMapper uccGuideCatalogExtMapper) {
        this.uccGuideCatalogExtMapper = uccGuideCatalogExtMapper;
    }

    public void setUccDealPoolSyncESAtomService(UccDealPoolSyncESAtomService uccDealPoolSyncESAtomService) {
        this.uccDealPoolSyncESAtomService = uccDealPoolSyncESAtomService;
    }
}

