/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccCommodityPoolRelOperateAtomService;
import com.tydic.commodity.busibase.atom.bo.UccCommodityPoolRelOperateAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccCommodityPoolRelOperateAtomRspBO;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityHisMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.po.UccCommodityPoolPO;
import com.tydic.commodity.po.UccRelPoolCommodityHisPO;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCommodityPoolRelOperateAtomServiceImpl
implements UccCommodityPoolRelOperateAtomService {
    @Autowired
    private UccRelPoolCommodityHisMapper uccRelPoolCommodityHisMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;

    @Override
    public UccCommodityPoolRelOperateAtomRspBO operateCommodityPoolRel(UccCommodityPoolRelOperateAtomReqBO atomReqBO) {
        this.validateParam(atomReqBO);
        switch (atomReqBO.getOperType()) {
            case 1: {
                this.addCommodityPoolRel(atomReqBO);
                break;
            }
            case -1: {
                this.deleteCommodityPoolRel(atomReqBO);
                break;
            }
            default: {
                throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[operType]\u4e0d\u5408\u6cd5");
            }
        }
        UccCommodityPoolRelOperateAtomRspBO rspBO = new UccCommodityPoolRelOperateAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void deleteCommodityPoolRel(UccCommodityPoolRelOperateAtomReqBO atomReqBO) {
        ArrayList<UccRelPoolCommodityHisPO> UccRelPoolCommodityHisPOs = new ArrayList<UccRelPoolCommodityHisPO>();
        UccRelPoolCommodityPo uccRelPoolCommodityPo = new UccRelPoolCommodityPo();
        uccRelPoolCommodityPo.setPoolIds(atomReqBO.getPools());
        uccRelPoolCommodityPo.setSources(atomReqBO.getSourceList());
        uccRelPoolCommodityPo.setPoolRelated(atomReqBO.getPoolRelated());
        List<UccRelPoolCommodityPo> poolCommodityPos = this.uccRelPoolCommodityMapper.queryAll(uccRelPoolCommodityPo);
        if (!CollectionUtils.isEmpty(poolCommodityPos)) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (UccRelPoolCommodityPo uccRelPoolCommodityPo1 : poolCommodityPos) {
                ids.add(uccRelPoolCommodityPo1.getId());
                UccRelPoolCommodityHisPO cnncRelPoolCommodityHisPO = (UccRelPoolCommodityHisPO)JSON.parseObject((String)JSON.toJSONString((Object)uccRelPoolCommodityPo1), UccRelPoolCommodityHisPO.class);
                cnncRelPoolCommodityHisPO.setHisId(Sequence.getInstance().nextId());
                cnncRelPoolCommodityHisPO.setHisCreateTime(atomReqBO.getUpdateTime());
                cnncRelPoolCommodityHisPO.setOperType(UccConstants.CommodityPoolOperType.DELETE);
                UccRelPoolCommodityHisPOs.add(cnncRelPoolCommodityHisPO);
            }
            this.uccRelPoolCommodityMapper.batchDeleteByIdList(ids);
            this.uccRelPoolCommodityHisMapper.insertBatch(UccRelPoolCommodityHisPOs);
        }
    }

    private void addCommodityPoolRel(UccCommodityPoolRelOperateAtomReqBO atomReqBO) {
        ArrayList<UccRelPoolCommodityPo> UccRelPoolCommodityPoS = new ArrayList<UccRelPoolCommodityPo>();
        ArrayList<UccRelPoolCommodityHisPO> UccRelPoolCommodityHisPOs = new ArrayList<UccRelPoolCommodityHisPO>();
        atomReqBO.getPools().forEach(poolId -> {
            UccCommodityPoolPO uccCommodityPoolPO = this.uccCommodityPoolMapper.selectByPrimaryKey((Long)poolId);
            if (uccCommodityPoolPO == null) {
                throw new BusinessException("8888", "\u5546\u54c1\u6c60\u4e0d\u5b58\u5728");
            }
            atomReqBO.getSourceList().forEach(source -> {
                UccRelPoolCommodityPo cnncRelPoolCommodityPo = new UccRelPoolCommodityPo();
                cnncRelPoolCommodityPo.setSource((Long)source);
                cnncRelPoolCommodityPo.setPoolId((Long)poolId);
                cnncRelPoolCommodityPo.setPoolRelated(uccCommodityPoolPO.getPoolRelated());
                cnncRelPoolCommodityPo.setCreateTime(atomReqBO.getUpdateTime());
                if (atomReqBO.getUserId() != null) {
                    cnncRelPoolCommodityPo.setCreateOper(atomReqBO.getUsername());
                }
                cnncRelPoolCommodityPo.setId(Sequence.getInstance().nextId());
                UccRelPoolCommodityPoS.add(cnncRelPoolCommodityPo);
                UccRelPoolCommodityHisPO cnncRelPoolCommodityHisPO = (UccRelPoolCommodityHisPO)JSON.parseObject((String)JSON.toJSONString((Object)cnncRelPoolCommodityPo), UccRelPoolCommodityHisPO.class);
                cnncRelPoolCommodityHisPO.setHisId(Sequence.getInstance().nextId());
                cnncRelPoolCommodityHisPO.setHisCreateTime(atomReqBO.getUpdateTime());
                cnncRelPoolCommodityHisPO.setOperType(UccConstants.CommodityPoolOperType.ADD);
                UccRelPoolCommodityHisPOs.add(cnncRelPoolCommodityHisPO);
            });
        });
        this.uccRelPoolCommodityMapper.batchInsert(UccRelPoolCommodityPoS);
        this.uccRelPoolCommodityHisMapper.insertBatch(UccRelPoolCommodityHisPOs);
    }

    private void validateParam(UccCommodityPoolRelOperateAtomReqBO atomReqBO) {
        if (atomReqBO == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (atomReqBO.getOperType() == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[operType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(atomReqBO.getPools())) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pools]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(atomReqBO.getSourceList())) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[sourceList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

