/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccDealTaskAtomService;
import com.tydic.commodity.busibase.atom.bo.UccDealTaskAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccDealTaskAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccSendMessageAndNoteAtomService;
import com.tydic.commodity.busibase.busi.bo.ApproveTaskSyncBO;
import com.tydic.commodity.busibase.busi.bo.UccSendMessageAndNoteAtomBO;
import com.tydic.commodity.busibase.busi.bo.UccSendMessageAndNoteAtomReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSendMessageAndNoteAtomRspBO;
import com.tydic.commodity.dao.ComBatchDealOrderMapper;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ComBatchDealOrderPO;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService;
import com.tydic.dyc.umc.service.todo.UmcSendTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoBo;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccDealTaskAtomServiceImpl
implements UccDealTaskAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccDealTaskAtomServiceImpl.class);
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UmcSendHaveDoneService umcSendHaveDoneService;
    @Autowired
    private UmcSendTodoService umcSendTodoService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;
    @Value(value="${ucc.approve.todoUrlSuffix:{todoPrefix}?isShowApprovalBtn=true&orderCode={orderCode}&orderId={orderId}&isArg=true&tabKey=1&taskId={taskId}&currentStatus={currentStatus}&f={f}}")
    private String todoUrlSuffix;
    @Value(value="${ucc.approve.todoDoneUrlSuffix:{todoPrefix}?orderCode={orderCode}&orderId={orderId}&isArg=false&tabKey=2&taskId={taskId}&currentStatus={currentStatus}&f={f}&auditTime={nowDate}}")
    private String todoDoneUrlSuffix;
    @Value(value="${ucc.approve.todoUrlPrefix:http://192.168.10.17/index/}")
    private String todoUrlPrefix;
    @Autowired
    private UccSendMessageAndNoteAtomService uccSendMessageAndNoteAtomService;

    @Override
    public UccDealTaskAtomRspBO dealTask(UccDealTaskAtomReqBO reqBO) {
        if (!CollectionUtils.isEmpty(reqBO.getNextTaskInfos())) {
            this.dealToDo(reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getCompleteTaskInfos())) {
            this.dealDone(reqBO);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getPreTaskId())) {
            this.dealPreTask(reqBO.getPreTaskId());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getReturnTaskId())) {
            this.dealReturnTask(reqBO.getPreTaskId());
        }
        if (reqBO.getUpdateTaskCandidate() != null && reqBO.getUpdateTaskCandidate().getApproveTaskId() != null) {
            this.dealTaskDealUpdate(reqBO.getUpdateTaskCandidate());
        }
        if (!CollectionUtils.isEmpty(reqBO.getBackTaskInfos())) {
            this.dealTaskDealBack(reqBO);
        }
        UccDealTaskAtomRspBO atomRspBO = new UccDealTaskAtomRspBO();
        atomRspBO.setRespCode("0000");
        return atomRspBO;
    }

    private void dealTaskDealBack(UccDealTaskAtomReqBO reqBO) {
        List<Long> taskIds = reqBO.getBackTaskInfos().stream().map(ApproveTaskSyncBO::getApproveTaskId).filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(taskIds)) {
            EacRuTaskPO set = new EacRuTaskPO();
            set.setStatus("BACK");
            EacRuTaskPO where = new EacRuTaskPO();
            where.setTaskIds(taskIds);
            this.eacRuTaskMapper.updateBy(set, where);
            if (!CollectionUtils.isEmpty(reqBO.getNextTaskInfos())) {
                String tacheCode = reqBO.getNextTaskInfos().get(0).getStepId();
                EacRuTaskPO set1 = new EacRuTaskPO();
                set1.setStatus("BACK");
                EacRuTaskPO where1 = new EacRuTaskPO();
                where1.setTacheCode(tacheCode);
                where1.setApproveInstId(reqBO.getNextTaskInfos().get(0).getApproveInstId());
                where1.setStatus("COMPLETE");
                this.eacRuTaskMapper.updateBy(set1, where1);
            }
        }
    }

    private void dealReturnTask(String taskId) {
        EacRuTaskPO eacRuTaskPO = this.checkTaskIsToDo(taskId);
        this.dealStepFinish(eacRuTaskPO);
    }

    private void dealPreTask(String taskId) {
        this.checkTaskIsToDo(taskId);
        this.deleteTask(taskId);
    }

    private void dealTaskDealUpdate(ApproveTaskSyncBO updateTaskCandidate) {
        this.checkTaskIsToDo(updateTaskCandidate.getApproveTaskId().toString());
        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
        eacRuTaskPO.setTaskId(updateTaskCandidate.getApproveTaskId());
        this.eacRuTaskMapper.clearUserInfo(eacRuTaskPO);
        EacRuTaskPO set = new EacRuTaskPO();
        set.setUserId(updateTaskCandidate.getUserId());
        set.setUserName(updateTaskCandidate.getUserName());
        set.setOrgId(updateTaskCandidate.getOrgId());
        set.setOrgName(updateTaskCandidate.getOrgName());
        set.setRoleId(updateTaskCandidate.getRoleId());
        set.setRoleName(updateTaskCandidate.getRoleName());
        set.setStationCode(updateTaskCandidate.getStationCode());
        set.setStationName(updateTaskCandidate.getStationName());
        set.setUpdateTime(new Date(System.currentTimeMillis()));
        EacRuTaskPO where = new EacRuTaskPO();
        where.setTaskId(updateTaskCandidate.getApproveTaskId());
        this.eacRuTaskMapper.updateBy(set, where);
    }

    private EacRuTaskPO checkTaskIsToDo(String taskId) {
        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
        eacRuTaskPO.setTaskId(Long.parseLong(taskId));
        EacRuTaskPO eacRuTaskPO1 = this.eacRuTaskMapper.getModelBy(eacRuTaskPO);
        if (eacRuTaskPO1 == null) {
            throw new BaseBusinessException("8888", "\u4efb\u52a1\u5b9e\u4f8bid(" + taskId + ")\u4e0d\u5b58\u5728");
        }
        if (!"ACTIVE".equals(eacRuTaskPO1.getStatus())) {
            throw new BaseBusinessException("8888", "\u4efb\u52a1\u5b9e\u4f8bid(" + taskId + ")\u5df2\u5b8c\u7ed3");
        }
        return eacRuTaskPO1;
    }

    private void dealDone(UccDealTaskAtomReqBO reqBO) {
        reqBO.getCompleteTaskInfos().forEach(approveTaskSyncBO -> {
            EacRuTaskPO exitTaskInfo = this.checkTaskIsToDo(approveTaskSyncBO.getApproveTaskId().toString());
            EacRuTaskPO set = new EacRuTaskPO();
            set.setColumn2(approveTaskSyncBO.getAuditResult().toString());
            set.setStatus("COMPLETE");
            set.setDueTime(new Date(System.currentTimeMillis()));
            set.setUpdateTime(new Date(System.currentTimeMillis()));
            EacRuTaskPO where = new EacRuTaskPO();
            where.setTaskId(approveTaskSyncBO.getApproveTaskId());
            this.eacRuTaskMapper.updateBy(set, where);
            this.sendHaveDone(exitTaskInfo);
            if (approveTaskSyncBO.getAuditStepFinish() != null && approveTaskSyncBO.getAuditStepFinish().booleanValue()) {
                this.dealStepFinish(exitTaskInfo);
            }
        });
    }

    private void sendTodo(EacRuTaskPO exitTaskInfo) {
        ComBatchDealOrderPO comBatchDealOrderPO = new ComBatchDealOrderPO();
        comBatchDealOrderPO.setProcInstId(exitTaskInfo.getApproveInstId());
        ComBatchDealOrderPO comBatchDealOrderPO1 = this.comBatchDealOrderMapper.getModelBy(comBatchDealOrderPO);
        UmcSendTodoReqBo umcSendTodoReqBo = new UmcSendTodoReqBo();
        umcSendTodoReqBo.setTodoList(new ArrayList());
        UmcTodoBo umcTodoBo = new UmcTodoBo();
        umcTodoBo.setBusiId(exitTaskInfo.getApproveInstId() + "-" + exitTaskInfo.getTaskId());
        umcTodoBo.setTodoName(comBatchDealOrderPO1.getOrderName());
        umcTodoBo.setTodoItemCode(UccConstants.ApprovalTodoCodeEnum.find((String)(comBatchDealOrderPO1.getSource() + "_" + comBatchDealOrderPO1.getBusiType())).getValue());
        if (UccConstants.Source.AGR.equals(comBatchDealOrderPO1.getSource()) && UccConstants.AgrType.QUOTE.equals(Convert.toInt((Object)comBatchDealOrderPO1.getSourceType(), null))) {
            umcTodoBo.setTodoItemCode("QUOTE_" + umcTodoBo.getTodoItemCode());
        }
        String todoUrl = this.getTodoUrl(this.todoUrlSuffix, exitTaskInfo, comBatchDealOrderPO1);
        umcTodoBo.setUrlSuffix(todoUrl);
        umcTodoBo.setCreateOperId(comBatchDealOrderPO1.getCreateUserId().toString());
        umcTodoBo.setCreateOperName(comBatchDealOrderPO1.getCreateUserName());
        umcTodoBo.setCandidateOperId(exitTaskInfo.getUserId());
        umcTodoBo.setCandidateOperName(exitTaskInfo.getUserName());
        umcTodoBo.setProcInstId(exitTaskInfo.getApproveInstId());
        umcTodoBo.setProcInstKey(exitTaskInfo.getProcDefKey());
        umcSendTodoReqBo.getTodoList().add(umcTodoBo);
        try {
            log.info("\u53d1\u9001\u5f85\u529e\u5165\u53c2umcSendTodoAbilityReqBO:{}", (Object)JSON.toJSONString((Object)umcSendTodoReqBo));
            UmcSendTodoRspBo umcSendTodoRspBo = this.umcSendTodoService.sendTodo(umcSendTodoReqBo);
            log.info("\u53d1\u9001\u5f85\u529e\u51fa\u53c2umcSendTodoAbilityRspBO:{}", (Object)JSON.toJSONString((Object)umcSendTodoRspBo));
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u53d1\u9001\u5f85\u529e\u62a5\u9519:" + e.getMessage());
        }
        this.sendMessage(exitTaskInfo, todoUrl, comBatchDealOrderPO1);
    }

    private String getTodoUrl(String template, EacRuTaskPO exitTaskInfo, ComBatchDealOrderPO comBatchDealOrderPO1) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)comBatchDealOrderPO1));
        jsonObject.put("taskId", (Object)exitTaskInfo.getTaskId());
        jsonObject.put("nowDate", (Object)URLEncoder.encode(DateUtil.now(), "UTF-8"));
        if (UccConstants.Source.AGR.equals(comBatchDealOrderPO1.getSource())) {
            jsonObject.put("todoPrefix", (Object)"agrSkuApprDetail");
            if (UccConstants.AgrType.QUOTE.equals(Convert.toInt((Object)comBatchDealOrderPO1.getSourceType(), null))) {
                jsonObject.put("f", (Object)"yyAgrApprChangeList");
            } else {
                jsonObject.put("f", (Object)"agrApprovalList");
            }
        } else if (UccConstants.Source.ECOM.equals(comBatchDealOrderPO1.getSource())) {
            jsonObject.put("f", (Object)"ecCommodityApprovalList");
            jsonObject.put("todoPrefix", (Object)"ecCommodityApprovalDetail");
        } else {
            jsonObject.put("f", (Object)"unagrApprovalList");
            jsonObject.put("todoPrefix", (Object)"unagrSkuApprDetail");
        }
        return StrUtil.format((CharSequence)template, (Map)jsonObject);
    }

    private void sendHaveDone(EacRuTaskPO exitTaskInfo) {
        ComBatchDealOrderPO comBatchDealOrderPO = new ComBatchDealOrderPO();
        comBatchDealOrderPO.setProcInstId(exitTaskInfo.getApproveInstId());
        ComBatchDealOrderPO comBatchDealOrderPO1 = this.comBatchDealOrderMapper.getModelBy(comBatchDealOrderPO);
        UmcSendHaveDoneReqBo umcSendHaveDoneAbilityReqBO = new UmcSendHaveDoneReqBo();
        umcSendHaveDoneAbilityReqBO.setBusiId(exitTaskInfo.getApproveInstId() + "-" + exitTaskInfo.getTaskId());
        umcSendHaveDoneAbilityReqBO.setOperUserId(exitTaskInfo.getUserId());
        umcSendHaveDoneAbilityReqBO.setOperUserName(exitTaskInfo.getUserName());
        String todoDoneUrl = this.getTodoUrl(this.todoDoneUrlSuffix, exitTaskInfo, comBatchDealOrderPO1);
        umcSendHaveDoneAbilityReqBO.setDoneUrl(todoDoneUrl);
        try {
            log.info("\u53d1\u9001\u5df2\u529e\u5165\u53c2umcSendHaveDoneAbilityReqBO:{}", (Object)JSON.toJSONString((Object)umcSendHaveDoneAbilityReqBO));
            UmcSendHaveDoneRspBo umcSendHaveDoneAbilityRspBO = this.umcSendHaveDoneService.sendHaveDone(umcSendHaveDoneAbilityReqBO);
            log.info("\u53d1\u9001\u5df2\u529e\u51fa\u53c2umcSendHaveDoneAbilityRspBO:{}", (Object)JSON.toJSONString((Object)umcSendHaveDoneAbilityRspBO));
        }
        catch (Exception e) {
            log.info("\u53d1\u9001\u5df2\u529e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void dealStepFinish(EacRuTaskPO exitTaskInfo) {
        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
        eacRuTaskPO.setApproveInstId(exitTaskInfo.getApproveInstId());
        eacRuTaskPO.setTacheCode(exitTaskInfo.getTacheCode());
        eacRuTaskPO.setStatus("ACTIVE");
        List<EacRuTaskPO> pos = this.eacRuTaskMapper.getList(eacRuTaskPO);
        if (!CollectionUtils.isEmpty(pos)) {
            pos.forEach(eacRuTaskPO1 -> this.deleteTask(eacRuTaskPO1.getTaskId().toString()));
        }
    }

    private void deleteTask(String taskId) {
        EacRuTaskPO eacRuTaskPO1 = new EacRuTaskPO();
        eacRuTaskPO1.setTaskId(Long.parseLong(taskId));
        EacRuTaskPO eacRuTaskPO2 = this.eacRuTaskMapper.getModelBy(eacRuTaskPO1);
        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
        eacRuTaskPO.setTaskId(Long.parseLong(taskId));
        this.eacRuTaskMapper.deleteBy(eacRuTaskPO);
        this.sendHaveDone(eacRuTaskPO2);
    }

    private void dealToDo(UccDealTaskAtomReqBO reqBO) {
        ArrayList<EacRuTaskPO> eacRuTaskPOS = new ArrayList<EacRuTaskPO>();
        reqBO.getNextTaskInfos().forEach(approveTaskSyncBO -> {
            EacRuTaskPO po = (EacRuTaskPO)JSON.parseObject((String)JSON.toJSONString((Object)approveTaskSyncBO), EacRuTaskPO.class);
            po.setTaskId(approveTaskSyncBO.getApproveTaskId());
            if (null != approveTaskSyncBO.getBusiness()) {
                po.setBusinessId(approveTaskSyncBO.getBusiness().getBusinessId());
            } else {
                po.setBusinessId(approveTaskSyncBO.getBusinessId());
            }
            po.setTacheCode(approveTaskSyncBO.getStepId());
            po.setTacheName(approveTaskSyncBO.getStepName());
            po.setIsJoinTransfer(2);
            if (!StringUtils.isEmpty((Object)approveTaskSyncBO.getJoinSignType())) {
                po.setIsJoinTransfer(1);
            }
            po.setCreateTime(new Date());
            eacRuTaskPOS.add(po);
            this.sendTodo(po);
        });
        this.eacRuTaskMapper.insertBatch(eacRuTaskPOS);
    }

    private void sendMessage(EacRuTaskPO exitTaskInfo, String todoUrl, ComBatchDealOrderPO comBatchDealOrderPO1) {
        UccSendMessageAndNoteAtomReqBO uccSendMessageAndNoteAtomReqBO = new UccSendMessageAndNoteAtomReqBO();
        ArrayList<UccSendMessageAndNoteAtomBO> noteList = new ArrayList<UccSendMessageAndNoteAtomBO>();
        UccSendMessageAndNoteAtomBO noteAtomBO = new UccSendMessageAndNoteAtomBO();
        noteAtomBO.setBusinessCode(comBatchDealOrderPO1.getOrderCode());
        noteAtomBO.setBusinessId(exitTaskInfo.getApproveInstId() + "-" + exitTaskInfo.getTaskId());
        noteAtomBO.setBusinessType(comBatchDealOrderPO1.getBusiType().toString());
        noteAtomBO.setCreateUserId(comBatchDealOrderPO1.getCreateUserId());
        noteAtomBO.setCreateUserName(comBatchDealOrderPO1.getCreateUserName());
        noteAtomBO.setUserId(exitTaskInfo.getUserId());
        noteAtomBO.setUserName(exitTaskInfo.getUserName());
        noteAtomBO.setApproveInstId(exitTaskInfo.getApproveInstId());
        noteAtomBO.setLinkUrl(this.todoUrlPrefix + todoUrl);
        noteList.add(noteAtomBO);
        Map<String, List<UccSendMessageAndNoteAtomBO>> collect = noteList.stream().collect(Collectors.groupingBy(UccSendMessageAndNoteAtomBO::getApproveInstId));
        uccSendMessageAndNoteAtomReqBO.setTaskList(collect);
        try {
            log.info("\u53d1\u9001\u901a\u77e5\u5165\u53c2uccSendMessageAndNoteAtomReqBO:{}", (Object)JSON.toJSONString((Object)uccSendMessageAndNoteAtomReqBO));
            UccSendMessageAndNoteAtomRspBO uccSendMessageAndNoteAtomRspBO = this.uccSendMessageAndNoteAtomService.sendMessageAndNote(uccSendMessageAndNoteAtomReqBO);
            log.info("\u53d1\u9001\u901a\u77e5\u51fa\u53c2uccSendMessageAndNoteAtomRspBO:{}", (Object)JSON.toJSONString((Object)((Object)uccSendMessageAndNoteAtomRspBO)));
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u53d1\u9001\u901a\u77e5\u62a5\u9519:" + e.getMessage());
        }
    }
}

