/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.busibase.busi.api.UccGeneralBusiRuleExecService;
import com.tydic.commodity.busibase.busi.bo.UccGeneralBusiRuleExecReqBO;
import com.tydic.commodity.busibase.busi.bo.UccGeneralBusiRuleExecRspBO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccGeneralBusiRuleExecServiceImpl
implements UccGeneralBusiRuleExecService {
    private static final Logger log = LoggerFactory.getLogger(UccGeneralBusiRuleExecServiceImpl.class);
    @Value(value="${qry.rule.url}")
    private String qryRuleUrl;
    @Value(value="${call.rule.url}")
    private String callRuleUrl;
    @Value(value="${newVirgo.enable:false}")
    private boolean newVirgoEnable;

    @Override
    public UccGeneralBusiRuleExecRspBO generalBusiRuleExec(UccGeneralBusiRuleExecReqBO reqBO) {
        UccGeneralBusiRuleExecRspBO rspBO = new UccGeneralBusiRuleExecRspBO();
        if (!StringUtils.isBlank((CharSequence)reqBO.getApproveBusiType()) && this.newVirgoEnable) {
            this.newVirgo(reqBO, rspBO);
        } else {
            JSONObject qryRuleReqJsonObj = new JSONObject();
            qryRuleReqJsonObj.put("serviceCode", (Object)reqBO.getServiceCode());
            qryRuleReqJsonObj.put("dealType", (Object)"RULE_TYPE_BUSINESS");
            String qryRuleRspJsonObjStr = HttpUtil.post((String)this.qryRuleUrl, (String)qryRuleReqJsonObj.toJSONString(), (int)4000);
            JSONObject qryRuleRspJsonObj = JSON.parseObject((String)qryRuleRspJsonObjStr);
            JSONArray ruleInfos = qryRuleRspJsonObj.getJSONArray("ruleInfos");
            if (!ruleInfos.isEmpty()) {
                for (int i = 0; i < ruleInfos.size(); ++i) {
                    JSONObject ruleInfo = JSON.parseObject((String)JSON.toJSONString((Object)ruleInfos.get(i)));
                    List fields = ruleInfo.getJSONArray("fields").toJavaList(String.class);
                    Long ruleId = ruleInfo.getLong("ruleId");
                    JSONObject callRuleReqJsonObj = new JSONObject();
                    callRuleReqJsonObj.put("ruleId", (Object)ruleId);
                    if (!CollectionUtils.isEmpty((Collection)fields)) {
                        Map<String, Object> ruleParams = reqBO.getParamMap();
                        JSONObject callRuleReqParamsJsonObj = new JSONObject();
                        for (String field : fields) {
                            if (!ruleParams.containsKey(field)) continue;
                            callRuleReqParamsJsonObj.put(field, ruleParams.get(field));
                        }
                        callRuleReqJsonObj.put("params", (Object)callRuleReqParamsJsonObj.toJSONString());
                    }
                    log.info("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u5165\u53c2\u4e3a\uff1a" + callRuleReqJsonObj.toJSONString());
                    String callRuleRspJsonObjStr = HttpUtil.post((String)this.callRuleUrl, (String)callRuleReqJsonObj.toJSONString(), (int)4000);
                    log.info("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u51fa\u53c2\u4e3a\uff1a" + callRuleRspJsonObjStr);
                    JSONObject callRuleRspJsonObj = JSON.parseObject((String)callRuleRspJsonObjStr);
                    JSONObject resultJson = callRuleRspJsonObj.getJSONObject("result");
                    if (resultJson == null) {
                        throw new ZTBusinessException("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5931\u8d25\uff01");
                    }
                    rspBO.setBusiRuleExecResult(JSON.toJSONString((Object)resultJson));
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void newVirgo(UccGeneralBusiRuleExecReqBO reqBO, UccGeneralBusiRuleExecRspBO rspBO) {
        JSONObject callRuleReqJsonObj = new JSONObject();
        if ("1".equals(reqBO.getApproveBusiType())) {
            callRuleReqJsonObj.put("busiSceneCode", (Object)"UCC_EDIT_APPROVE");
        } else if ("2".equals(reqBO.getApproveBusiType())) {
            callRuleReqJsonObj.put("busiSceneCode", (Object)"UCC_ON_SHELF_APPROVE");
        } else if ("3".equals(reqBO.getApproveBusiType())) {
            callRuleReqJsonObj.put("busiSceneCode", (Object)"UCC_OFF_SHELF_APPROVE");
        } else {
            callRuleReqJsonObj.put("busiSceneCode", (Object)"UCC_RE_ON_SHELF_APPROVE");
        }
        JSONObject jsonObject = new JSONObject();
        reqBO.getParamMap().forEach((key, value) -> jsonObject.put(key, (Object)Convert.toStr((Object)value)));
        callRuleReqJsonObj.put("params", (Object)JSON.toJSONString((Object)jsonObject));
        log.debug("\u89e6\u53d1\u89c4\u5219\u5f15\u64ce\u5165\u53c2\u4e3a\uff1a" + callRuleReqJsonObj.toJSONString());
        String callRuleRspJsonObjStr = HttpUtil.post((String)this.callRuleUrl, (String)callRuleReqJsonObj.toJSONString(), (int)4000);
        log.debug("\u89e6\u53d1\u89c4\u5219\u5f15\u64ce\u51fa\u53c2\u4e3a\uff1a" + callRuleRspJsonObjStr);
        JSONObject callRuleRspJsonObj = JSON.parseObject((String)callRuleRspJsonObjStr);
        JSONObject resultJson = callRuleRspJsonObj.getJSONObject("result");
        if (resultJson == null) {
            throw new ZTBusinessException("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5931\u8d25\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u89c4\u5219\u8fd0\u7b97\u6210\u529f\uff01");
        rspBO.setBusiRuleExecResult(JSON.toJSONString((Object)resultJson));
    }
}

