/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.config;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.springframework.stereotype.Component;

@Component
public class UccIdGenerator {
    private static volatile Snowflake instance = null;

    public Long nextId() {
        return UccIdGenerator.getInstance().nextId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Snowflake getInstance() {
        if (instance != null) return instance;
        Class<UccIdGenerator> clazz = UccIdGenerator.class;
        synchronized (UccIdGenerator.class) {
            if (instance != null) return instance;
            instance = IdUtil.getSnowflake((long)UccIdGenerator.getWorkId(), (long)UccIdGenerator.getDataCenterId());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static Long getWorkId() {
        try {
            String hostAddress = Inet4Address.getLocalHost().getHostAddress();
            int[] ints = StringUtils.toCodePoints((CharSequence)hostAddress);
            int sums = 0;
            for (int b : ints) {
                sums += b;
            }
            return sums % 32;
        }
        catch (UnknownHostException e) {
            return RandomUtil.randomLong((long)31L);
        }
    }

    private static Long getDataCenterId() {
        try {
            String hostName = SystemUtils.getHostName();
            int[] ints = StringUtils.toCodePoints((CharSequence)hostName);
            int sums = 0;
            for (int i : ints) {
                sums += i;
            }
            return sums % 32;
        }
        catch (Exception e) {
            return RandomUtil.randomLong((long)31L);
        }
    }
}

