/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.base.bo.OrderColumBo;
import com.tydic.commodity.base.bo.UccSourceTypeBo;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.SearchEsManageService;
import com.tydic.commodity.busibase.busi.bo.SearchEsManageReqBo;
import com.tydic.commodity.busibase.busi.bo.SearchEsManageRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class SearchEsManageServiceImpl
implements SearchEsManageService {
    private static final Logger log = LoggerFactory.getLogger(SearchEsManageServiceImpl.class);

    @Override
    public SearchEsManageRspBo buildEsQuerySql(SearchEsManageReqBo reqBo) {
        RangeQueryBuilder qb;
        BoolQueryBuilder authorityinBoolQueryBuilder;
        BoolQueryBuilder authorityextBoolQueryBuilder;
        WildcardQueryBuilder queryBuilder1;
        SearchEsManageRspBo rspBo = new SearchEsManageRspBo();
        BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
        if (!ObjectUtils.isEmpty((Object)reqBo.getIsAddCoefficient())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"is_add_coefficient", (Object)reqBo.getIsAddCoefficient()));
        }
        if (reqBo.getSkuStatus() != null && reqBo.getSkuStatus().size() > 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", reqBo.getSkuStatus()));
        }
        if (reqBo.getChannelId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"channel_id", (Object)reqBo.getChannelId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (reqBo.getSupplierId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)reqBo.getSupplierId()));
        }
        if (reqBo.getBrandId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getAgreementId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getTypeId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getTypeId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperIds())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", reqBo.getOperIds()));
        }
        if (reqBo.getCatalogId() != null && reqBo.getLevel() != null) {
            if (reqBo.getLevel() == 1) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id", (Object)reqBo.getCatalogId()));
            } else if (reqBo.getLevel() == 2) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l2_category_id", (Object)reqBo.getCatalogId()));
            } else if (reqBo.getLevel() == 3) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l1_category_id", (Object)reqBo.getCatalogId()));
            } else {
                log.error("\u4f20\u5165\u4e86\u9519\u8bef\u7684\u7c7b\u76ee\u7b49\u7ea7");
            }
        }
        if (reqBo.getMaterialCatalogId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_id", (Object)reqBo.getMaterialCatalogId()));
        }
        if (reqBo.getSkuSource() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getVendorId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuList())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getSkuList()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getAgreementIds())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"agreement_id", reqBo.getAgreementIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getPoolIds())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"skuPoolIds", reqBo.getPoolIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getIgnoreList())) {
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getIgnoreList()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getIgnorSpuList())) {
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", reqBo.getIgnorSpuList()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommdIds())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", reqBo.getCommdIds()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getTypeName())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_name", (String)reqBo.getTypeName()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpcCode())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"upc", (String)reqBo.getUpcCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_code.keyword", (String)reqBo.getMaterialCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuExpand2())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuExpand.expand2.keyword", (String)reqBo.getSkuExpand2()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            if (reqBo.getFuzzyFields().contains("skuCode")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_code.keyword", (String)reqBo.getSkuCode()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            if (reqBo.getFuzzyFields().contains("commodityCode")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_code.keyword", (String)reqBo.getCommodityCode()));
            }
        }
        if (reqBo.isMustHavCode()) {
            ExistsQueryBuilder sexQueryBuilder = QueryBuilders.existsQuery((String)"material_code");
            extBoolQueryBuilder.must((QueryBuilder)sexQueryBuilder);
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"material_code", (String)""));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"spec.keyword", (String)reqBo.getSpec()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"model", (String)reqBo.getModel()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSearchIgnoreTypeList())) {
            authorityextBoolQueryBuilder = QueryBuilders.boolQuery();
            for (UccSourceTypeBo each : reqBo.getSearchIgnoreTypeList()) {
                authorityinBoolQueryBuilder = QueryBuilders.boolQuery();
                if (each.getSkuSource() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)each.getSkuSource()));
                }
                if (!CollectionUtils.isEmpty((Collection)each.getType())) {
                    authorityinBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"type_id", (Collection)each.getType()));
                }
                authorityextBoolQueryBuilder.should((QueryBuilder)authorityinBoolQueryBuilder);
            }
            extBoolQueryBuilder.must((QueryBuilder)authorityextBoolQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(reqBo.getSearchTypeList())) {
            authorityextBoolQueryBuilder = QueryBuilders.boolQuery();
            for (UccSourceTypeBo each : reqBo.getSearchTypeList()) {
                authorityinBoolQueryBuilder = QueryBuilders.boolQuery();
                if (each.getSkuSource() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)each.getSkuSource()));
                }
                if (!CollectionUtils.isEmpty((Collection)each.getType())) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"type_id", (Collection)each.getType()));
                }
                authorityextBoolQueryBuilder.should((QueryBuilder)authorityinBoolQueryBuilder);
            }
            extBoolQueryBuilder.must((QueryBuilder)authorityextBoolQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(reqBo.getIgnoreVendorIds())) {
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"vendor_id", reqBo.getIgnoreVendorIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getIgnoreAgrIds())) {
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"agreement_id", reqBo.getIgnoreAgrIds()));
        }
        if (StringUtils.isEmpty(reqBo.getFuzzyFields())) {
            reqBo.setFuzzyFields(Lists.newArrayList((Object[])new String[]{"1"}));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCatalogName())) {
            if (reqBo.getFuzzyFields().contains("catalogName")) {
                if (reqBo.getLevel() == null) {
                    queryBuilder1 = QueryBuilders.wildcardQuery((String)"l1_category_name", (String)("*" + reqBo.getCatalogName() + "*"));
                    WildcardQueryBuilder queryBuilder2 = QueryBuilders.wildcardQuery((String)"l2_category_name.keyword", (String)("*" + reqBo.getCatalogName() + "*"));
                    WildcardQueryBuilder queryBuilder3 = QueryBuilders.wildcardQuery((String)"l3_category_name.keyword", (String)("*" + reqBo.getCatalogName() + "*"));
                    extBoolQueryBuilder.should((QueryBuilder)queryBuilder1).should((QueryBuilder)queryBuilder2).should((QueryBuilder)queryBuilder3);
                } else if (reqBo.getLevel() == 1) {
                    queryBuilder1 = QueryBuilders.wildcardQuery((String)"l1_category_name", (String)("*" + reqBo.getCatalogName() + "*"));
                    extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
                } else if (reqBo.getLevel() == 2) {
                    WildcardQueryBuilder queryBuilder2 = QueryBuilders.wildcardQuery((String)"l2_category_name.keyword", (String)("*" + reqBo.getCatalogName() + "*"));
                    extBoolQueryBuilder.must((QueryBuilder)queryBuilder2);
                } else if (reqBo.getLevel() == 3) {
                    WildcardQueryBuilder queryBuilder3 = QueryBuilders.wildcardQuery((String)"l3_category_name.keyword", (String)("*" + reqBo.getCatalogName() + "*"));
                    extBoolQueryBuilder.must((QueryBuilder)queryBuilder3);
                }
            } else if (reqBo.getLevel() == null) {
                BoolQueryBuilder innerQueryBuilder1 = QueryBuilders.boolQuery();
                BoolQueryBuilder innerQueryBuilder2 = QueryBuilders.boolQuery();
                BoolQueryBuilder innerQueryBuilder3 = QueryBuilders.boolQuery();
                innerQueryBuilder1.must((QueryBuilder)QueryBuilders.termsQuery((String)"l1_category_name", (String[])new String[]{reqBo.getCatalogName()}));
                innerQueryBuilder2.must((QueryBuilder)QueryBuilders.termsQuery((String)"l2_category_name.keyword", (String[])new String[]{reqBo.getCatalogName()}));
                innerQueryBuilder3.must((QueryBuilder)QueryBuilders.termsQuery((String)"l3_category_name.keyword", (String[])new String[]{reqBo.getCatalogName()}));
                extBoolQueryBuilder.should((QueryBuilder)innerQueryBuilder1).should((QueryBuilder)innerQueryBuilder2).should((QueryBuilder)innerQueryBuilder3);
            } else if (reqBo.getLevel() == 1) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l1_category_name", (String[])new String[]{reqBo.getCatalogName()}));
            } else if (reqBo.getLevel() == 2) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l2_category_name.keyword", (String[])new String[]{reqBo.getCatalogName()}));
            } else if (reqBo.getLevel() == 3) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l3_category_name.keyword", (String[])new String[]{reqBo.getCatalogName()}));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            if (reqBo.getFuzzyFields().contains("extSkuId")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"ext_sku_id.keyword", (String)("*" + reqBo.getExtSkuId() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_sku_id.keyword", (String)reqBo.getExtSkuId()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            if (reqBo.getFuzzyFields().contains("extSpuId")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"ext_spu_id.keyword", (String)("*" + reqBo.getExtSpuId() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_spu_id.keyword", (String)reqBo.getExtSpuId()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            if (reqBo.getFuzzyFields().contains("skuName")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_name.keyword", (String)reqBo.getSkuName()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            if (reqBo.getFuzzyFields().contains("commodityName")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_name.keyword", (String)reqBo.getCommodityName()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierName())) {
            if (reqBo.getFuzzyFields().contains("supplierName")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"supplier_name.keyword", (String)("*" + reqBo.getSupplierName() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_name.keyword", (String)reqBo.getSupplierName()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCatalogName())) {
            if (reqBo.getFuzzyFields().contains("materialCatalogName")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"l4mg_category_name.keyword", (String)("*" + reqBo.getMaterialCatalogName() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_name.keyword", (String)reqBo.getMaterialCatalogName()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            if (reqBo.getFuzzyFields().contains("vendorName")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_name.keyword", (String)reqBo.getVendorName()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            if (reqBo.getFuzzyFields().contains("brandName")) {
                queryBuilder1 = QueryBuilders.wildcardQuery((String)"brand_name", (String)("*" + reqBo.getBrandName() + "*"));
                extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
            } else {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_name.keyword", (String)reqBo.getBrandName()));
            }
        }
        try {
            qb = null;
            if (null != reqBo.getMinMarketPrice()) {
                qb = reqBo.getMinMarketPrice().compareTo(BigDecimal.ZERO) != 0 ? QueryBuilders.rangeQuery((String)"market_price").gte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)reqBo.getMinMarketPrice())) : QueryBuilders.rangeQuery((String)"market_price").gte((Object)0);
            }
            if (null != reqBo.getMaxMarketPrice() && reqBo.getMaxMarketPrice().compareTo(BigDecimal.ZERO) != 0 && null != qb) {
                qb.lte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)reqBo.getMaxMarketPrice()));
            }
            if (qb != null) {
                extBoolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u5e02\u573a\u4ef7\u683c\u6216\u6700\u9ad8\u5e02\u573a\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        try {
            qb = null;
            if (null != reqBo.getMinSalesPrice()) {
                qb = reqBo.getMinSalesPrice().compareTo(BigDecimal.ZERO) != 0 ? QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)reqBo.getMinSalesPrice())) : QueryBuilders.rangeQuery((String)"sale_price").gte((Object)0);
            }
            if (null != reqBo.getMaxSalesPrice() && reqBo.getMaxSalesPrice().compareTo(BigDecimal.ZERO) != 0 && null != qb) {
                qb.lte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)reqBo.getMaxSalesPrice()));
            }
            if (qb != null) {
                extBoolQueryBuilder.must((QueryBuilder)qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u9500\u552e\u4ef7\u683c\u6216\u6700\u9ad8\u9500\u552e\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        try {
            qb = null;
            if (null != reqBo.getMinDiscounts()) {
                qb = reqBo.getMinDiscounts().compareTo(BigDecimal.ZERO) != 0 ? QueryBuilders.rangeQuery((String)"discounts").gte((Object)reqBo.getMinDiscounts()) : QueryBuilders.rangeQuery((String)"discounts").gte((Object)0);
            }
            if (null != reqBo.getMaxDiscounts() && reqBo.getMaxDiscounts().compareTo(BigDecimal.ZERO) != 0 && null != qb) {
                qb.lte((Object)reqBo.getMaxDiscounts());
            }
            if (qb != null) {
                extBoolQueryBuilder.must((QueryBuilder)qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u6298\u6263\u7387\u6216\u6700\u9ad8\u6298\u6263\u7387\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "sold_number";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "sku_id";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 3) {
                sortField = "sale_price";
            }
        }
        if (!sortField.isEmpty()) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            fieldSortBuilders.add(sortQuery);
        }
        if (!CollectionUtils.isEmpty(reqBo.getOrderColum())) {
            fieldSortBuilders = new ArrayList();
            for (OrderColumBo each : reqBo.getOrderColum()) {
                orderType = SortOrder.DESC;
                if (each.getOrderType() != null && each.getOrderType() == 1) {
                    orderType = SortOrder.ASC;
                }
                fieldSortBuilders.add((FieldSortBuilder)SortBuilders.fieldSort((String)each.getOrderByColumn()).order(orderType));
            }
        }
        rspBo.setBoolQueryBuilder(extBoolQueryBuilder);
        rspBo.setSortQuery(fieldSortBuilders);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setPageSize(reqBo.getPageSize());
        return rspBo;
    }
}

