/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.busi.api.UccCodegenerationBusiService;
import com.tydic.commodity.busibase.busi.bo.UccCodegenerationBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccCodegenerationBusiRspBO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccCodegenerationBusiServiceImpl
implements UccCodegenerationBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCodegenerationBusiServiceImpl.class);
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private CfcEncodedSerialGetService CfcEncodedSerialGetService;
    @Autowired
    private CfcRedisSerialService CfcRedisSerialService;

    @Override
    public UccCodegenerationBusiRspBO dealUccCodegeneration(UccCodegenerationBusiReqBO reqBO) {
        UccCodegenerationBusiRspBO rspBO = new UccCodegenerationBusiRspBO();
        String codeTypeTranslate = null;
        Map<String, String> codeTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("CODE_GENERATION");
        if (reqBO.getCodeType() != null && codeTypeMap != null && codeTypeMap.containsKey(reqBO.getCodeType().trim())) {
            codeTypeTranslate = codeTypeMap.get(reqBO.getCodeType().trim());
        }
        CfcEncodedSerialGetServiceReqBO CfcEncodedSerialGetServiceReqBO2 = new CfcEncodedSerialGetServiceReqBO();
        CfcEncodedSerialGetServiceReqBO2.setEncodedRuleCode(codeTypeTranslate);
        CfcEncodedSerialGetServiceReqBO2.setCenter("UCC");
        CfcEncodedSerialGetServiceReqBO2.setOrgType("-1");
        CfcEncodedSerialGetServiceReqBO2.setNum(reqBO.getCount());
        if (reqBO.getUpperCode() != null && !"".equals(reqBO.getUpperCode())) {
            ArrayList<String> replaceValue = new ArrayList<String>();
            replaceValue.add(reqBO.getUpperCode());
            CfcEncodedSerialGetServiceReqBO2.setReplaceValue(replaceValue);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u7f16\u7801\u751f\u6210\u4e2d\u5fc3\u5165\u53c2{}" + JSONObject.toJSONString((Object)CfcEncodedSerialGetServiceReqBO2));
        }
        CfcEncodedSerialGetServiceRspBO encodedSerial = new CfcEncodedSerialGetServiceRspBO();
        try {
            encodedSerial = this.CfcEncodedSerialGetService.getEncodedSerial(CfcEncodedSerialGetServiceReqBO2);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8c03\u7528\u7f16\u7801\u751f\u6210\u4e2d\u5fc3\u5931\u8d25:" + e.getMessage());
        }
        ArrayList<String> codeList = new ArrayList<String>(encodedSerial.getSerialNoList());
        rspBO.setCodeList(codeList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

