/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.commodity.base.bo.UccSkuCreateNewInfoBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccGoodssubjecttocreateAtomService;
import com.tydic.commodity.busibase.atom.api.UccItemcreationAtomService;
import com.tydic.commodity.busibase.atom.bo.EsStorageSpuInfoBO;
import com.tydic.commodity.busibase.atom.bo.UccGoodssubjecttocreateAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccGoodssubjecttocreateAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccItemcreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccItemcreationAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccSpuCacheCreateNewBusiService;
import com.tydic.commodity.busibase.busi.bo.UccSpuCreateaNewBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSpuCreateaNewBusiRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.SupplierShopPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSpuCacheCreateNewBusiServiceImpl
implements UccSpuCacheCreateNewBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuCacheCreateNewBusiServiceImpl.class);
    @Autowired
    private UccGoodssubjecttocreateAtomService uccGoodssubjecttocreateAtomService;
    @Autowired
    private UccItemcreationAtomService uccItemcreationAtomService;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;

    @Override
    public UccSpuCreateaNewBusiRspBO dealAgrSpuCreate(UccSpuCreateaNewBusiReqBO reqBO) {
        List<String> skuCode;
        List<UccSkuPo> checkSkuCode;
        UccSpuCreateaNewBusiRspBO rspBO = new UccSpuCreateaNewBusiRspBO();
        reqBO.setCommodityStatus(ModelRuleConstant.COMMD_STATUS_TEMP);
        if (StringUtils.hasText((String)reqBO.getCommodityCode())) {
            UccCommodityPo commodityPo = new UccCommodityPo();
            commodityPo.setCommodityCode(reqBO.getCommodityCode());
            List<UccCommodityPo> commodityPos = this.uccCommodityMapper.qryCommodity(commodityPo);
            if (!CollectionUtils.isEmpty(commodityPos)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5546\u54c1\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
                return rspBO;
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getSkuCreateInfo()) && !CollectionUtils.isEmpty(checkSkuCode = this.uccSkuMapper.querySkuByCode(skuCode = reqBO.getSkuCreateInfo().stream().map(UccSkuCreateNewInfoBO::getSkuCode).collect(Collectors.toList())))) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5355\u54c1\u7f16\u7801\u5df2\u7ecf\u5b58\u5728:" + checkSkuCode.get(0).getSkuCode());
            return rspBO;
        }
        if (reqBO.getSupplierShopId() != null) {
            SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId());
            if (supplierShopPo == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5e97\u94fa\u4fe1\u606f");
                return rspBO;
            }
        } else {
            reqBO.setSupplierShopId(reqBO.getOrgIdIn());
            reqBO.setShopName(reqBO.getOrgName());
        }
        UccGoodssubjecttocreateAtomReqBO uccGoodssubjecttocreateAtomReqBO = new UccGoodssubjecttocreateAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)uccGoodssubjecttocreateAtomReqBO));
        uccGoodssubjecttocreateAtomReqBO.setStoreGetType("1");
        UccGoodssubjecttocreateAtomRspBO uccGoodssubjecttocreateAtomRspBO = null;
        try {
            uccGoodssubjecttocreateAtomRspBO = this.uccGoodssubjecttocreateAtomService.dealGoodssubjecttocreate(uccGoodssubjecttocreateAtomReqBO);
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.GOODS_SUBJECTTOC_CREATE_FAIL.code(), e.getMessage());
        }
        if (!"0000".equals(uccGoodssubjecttocreateAtomRspBO.getRespCode())) {
            throw new BusinessException(uccGoodssubjecttocreateAtomRspBO.getRespCode(), rspBO.getRespDesc());
        }
        rspBO.setCommodityId(uccGoodssubjecttocreateAtomRspBO.getCommodityId());
        rspBO.setSupplierShopId(reqBO.getSupplierShopId());
        if (!CollectionUtils.isEmpty(reqBO.getSkuCreateInfo())) {
            for (UccSkuCreateNewInfoBO each : reqBO.getSkuCreateInfo()) {
                UccItemcreationAtomReqBO uccItemcreationAtomReqBO = new UccItemcreationAtomReqBO();
                BeanUtils.copyProperties((Object)each, (Object)uccItemcreationAtomReqBO);
                uccItemcreationAtomReqBO.setCommodityId(uccGoodssubjecttocreateAtomRspBO.getCommodityId());
                uccItemcreationAtomReqBO.setSupplierShopId(reqBO.getSupplierShopId());
                uccItemcreationAtomReqBO.setShopName(reqBO.getShopName());
                uccItemcreationAtomReqBO.setBrandName(reqBO.getBrandName());
                if (!StringUtils.isEmpty((Object)reqBO.getCreateOperId())) {
                    uccItemcreationAtomReqBO.setCreateOperId(reqBO.getCreateOperId());
                } else {
                    uccItemcreationAtomReqBO.setCreateOperId(reqBO.getUserId().toString());
                }
                if (!StringUtils.isEmpty((Object)reqBO.getCreateOperName())) {
                    uccItemcreationAtomReqBO.setCreateOperName(reqBO.getCreateOperName());
                } else {
                    uccItemcreationAtomReqBO.setCreateOperName(reqBO.getUsername());
                }
                uccItemcreationAtomReqBO.setOrgId(reqBO.getOrgId());
                uccItemcreationAtomReqBO.setOrgName(reqBO.getOrgName());
                uccItemcreationAtomReqBO.setOrgPath(reqBO.getOrgPath());
                UccItemcreationAtomRspBO uccItemcreationAtomRspBO = null;
                try {
                    uccItemcreationAtomRspBO = this.uccItemcreationAtomService.dealCreateSku(uccItemcreationAtomReqBO);
                }
                catch (Exception e) {
                    throw new BusinessException(RspConstantEnums.ITEM_CREATE_FAIL.code(), e.getMessage());
                }
                if (!"0000".equals(uccItemcreationAtomRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.ITEM_CREATE_FAIL.code(), uccItemcreationAtomRspBO.getRespDesc());
                }
                if (CollectionUtils.isEmpty(rspBO.getSkuList())) {
                    ArrayList<Long> skus = new ArrayList<Long>();
                    skus.add(uccItemcreationAtomRspBO.getSku());
                    rspBO.setSkuList(skus);
                    continue;
                }
                rspBO.getSkuList().add(uccItemcreationAtomRspBO.getSku());
            }
        }
        this.syncCommodityInfoToEs(reqBO, rspBO.getCommodityId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncCommodityInfoToEs(UccSpuCreateaNewBusiReqBO reqBO, Long commodityId) {
        EsStorageSpuInfoBO esStorageSpuInfoBO = new EsStorageSpuInfoBO();
        esStorageSpuInfoBO.setCommodity_id(commodityId);
        esStorageSpuInfoBO.setCommodity_code(reqBO.getCommodityCode());
        esStorageSpuInfoBO.setCommodity_name(reqBO.getCommodityName());
        esStorageSpuInfoBO.setSpu_approval_status(null);
        esStorageSpuInfoBO.setCommodity_status(reqBO.getCommodityStatus());
        esStorageSpuInfoBO.setVendor_id(reqBO.getVendorId());
        esStorageSpuInfoBO.setVendor_name(reqBO.getVendorName());
        esStorageSpuInfoBO.setOther_source_name(reqBO.getOtherSourceName());
        esStorageSpuInfoBO.setOther_source_id(reqBO.getOtherSourceId());
        esStorageSpuInfoBO.setOther_source_code(reqBO.getOtherSourceCode());
        if (!ObjectUtils.isEmpty((Object)reqBO.getSpuExpand())) {
            esStorageSpuInfoBO.setCommodity_expand1(reqBO.getSpuExpand().getCommodityExpand1());
        }
        esStorageSpuInfoBO.setBrand_id(reqBO.getBrandId());
        esStorageSpuInfoBO.setBrand_name(reqBO.getBrandName());
        if (reqBO.getCommodityTypeId() != null) {
            esStorageSpuInfoBO.setType_id(reqBO.getCommodityTypeId());
            UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId());
            if (uccCommodityTypePo != null) {
                esStorageSpuInfoBO.setType_name(uccCommodityTypePo.getCommodityTypeName());
            }
        }
        esStorageSpuInfoBO.setSku_source(reqBO.getCommoditySource());
        esStorageSpuInfoBO.setSupplier_shop_id(reqBO.getSupplierShopId());
        esStorageSpuInfoBO.setShop_name(reqBO.getShopName());
        esStorageSpuInfoBO.setSupplier_org_id(reqBO.getOrgIdIn().toString());
        esStorageSpuInfoBO.setSupplier_org_name(reqBO.getOrgName());
        esStorageSpuInfoBO.setSupplier_org_path(reqBO.getOrgPath());
        esStorageSpuInfoBO.setCreate_oper_id(reqBO.getUserId().toString());
        esStorageSpuInfoBO.setCreate_oper_name(reqBO.getUsername());
        esStorageSpuInfoBO.setCreate_time(new Date().getTime());
        String jsonStr = JSONObject.toJSONString((Object)esStorageSpuInfoBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        log.info("\u5546\u54c1\u6682\u5b58\u540c\u6b65ES\u6570\u636e" + jsonStr);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String esId = esStorageSpuInfoBO.getCommodity_id().toString();
        String id = this.elasticsearchUtil.addData(this.esConfig.getIndexName(), this.esConfig.getEsType(), esId, jsonObject);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
            log.error("\u5546\u54c1\u4fe1\u606f[" + esStorageSpuInfoBO.getScene_id() == null ? "" : esStorageSpuInfoBO.getScene_id() + "|" + esStorageSpuInfoBO.getCommodity_id() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }
}

