/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.common.ability.api.QueryFtpFoldersService;
import com.tydic.commodity.common.ability.bo.QueryFtpFoldersReqBO;
import com.tydic.commodity.common.ability.bo.QueryFtpFoldersRspBO;
import com.tydic.commodity.utils.FtpCollectionUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=QueryFtpFoldersService.class)
public class QueryFtpFoldersServiceImpl
implements QueryFtpFoldersService {
    private static final Logger log = LoggerFactory.getLogger(QueryFtpFoldersServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(QueryFtpFoldersServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Value(value="${ftp.fileHost}")
    private String hostname;
    @Value(value="${ftp.filePort}")
    private Integer port;
    @Value(value="${ftp.fileUser}")
    private String username;
    @Value(value="${ftp.filePwd}")
    private String password;

    public QueryFtpFoldersRspBO queryFtpFolders(QueryFtpFoldersReqBO queryFtpFoldersReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2 ftp \u6587\u4ef6\u5939\u5217\u8868\u670d\u52a1\u5165\u53c2\uff1a" + queryFtpFoldersReqBO.toString());
        }
        QueryFtpFoldersRspBO rspBO = new QueryFtpFoldersRspBO();
        FtpCollectionUtil ftpUtil = new FtpCollectionUtil(this.username, this.password, this.hostname, this.port.intValue());
        ArrayList folderList = new ArrayList();
        try {
            ftpUtil.listFolders(queryFtpFoldersReqBO.getPath(), folderList);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u5217\u8868\u67e5\u8be2\u5931\u8d25 \uff1a" + e.getMessage());
        }
        rspBO.setFolderList(folderList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

