/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.busibase.comb.api.CompareCommodityService;
import com.tydic.commodity.busibase.comb.bo.CommodityRspBo;
import com.tydic.commodity.busibase.comb.bo.CompareEsReqBo;
import com.tydic.commodity.busibase.comb.bo.CompareEsRspBo;
import com.tydic.commodity.common.ability.api.UccComparePriceAbilityService;
import com.tydic.commodity.common.ability.bo.ComparePriceReqBo;
import com.tydic.commodity.common.ability.bo.ComparePriceRspBo;
import com.tydic.commodity.common.ability.bo.SearchBarEsRspInfo;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccComparePriceAbilityService.class)
public class UccComparePriceAbilityServiceImpl
implements UccComparePriceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccComparePriceAbilityServiceImpl.class);
    @Autowired
    private CompareCommodityService compareCommodityService;

    public ComparePriceRspBo compare(ComparePriceReqBo reqBo) {
        ComparePriceRspBo rspBo = new ComparePriceRspBo();
        if (StringUtils.isEmpty((CharSequence)reqBo.getUpc()) && StringUtils.isEmpty((CharSequence)reqBo.getMfgsku())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u65e0\u6bd4\u4ef7\u5173\u952e\u4fe1\u606f");
            rspBo.setResult(new ArrayList());
            return rspBo;
        }
        CompareEsReqBo compareEsReqBo = new CompareEsReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)compareEsReqBo);
        CompareEsRspBo compareEsRspBo = this.compareCommodityService.compare(compareEsReqBo);
        if (!"0000".equals(compareEsRspBo.getRespCode())) {
            BeanUtils.copyProperties((Object)compareEsRspBo, (Object)reqBo);
            return rspBo;
        }
        List commodityRspBos = compareEsRspBo.getCommodityRspBos();
        List<SearchBarEsRspInfo> result = this.convertRspBo(commodityRspBos);
        HashMap<Long, Integer> filter = new HashMap<Long, Integer>();
        int i = 0;
        if (!result.isEmpty()) {
            for (SearchBarEsRspInfo each : result) {
                if (filter.containsKey(each.getSupplierShopId())) {
                    if (result.get((Integer)filter.get(each.getSupplierShopId())).getSalePrice().compareTo(each.getSalePrice()) > 0) {
                        filter.put(each.getSupplierShopId(), i);
                    }
                } else {
                    filter.put(each.getSupplierShopId(), i);
                }
                ++i;
            }
            ArrayList<SearchBarEsRspInfo> supplierShopPrice = new ArrayList<SearchBarEsRspInfo>();
            for (Long each : filter.keySet()) {
                supplierShopPrice.add(result.get((Integer)filter.get(each)));
            }
            result.clear();
            result.addAll(supplierShopPrice);
        }
        rspBo.setResult(result);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<SearchBarEsRspInfo> convertRspBo(List<CommodityRspBo> commodityRspBos) {
        ArrayList<SearchBarEsRspInfo> searchBarEsRspInfos = new ArrayList<SearchBarEsRspInfo>();
        if (commodityRspBos != null && commodityRspBos.size() > 0) {
            for (CommodityRspBo commodityRspBo : commodityRspBos) {
                SearchBarEsRspInfo searchBarEsRspInfo = new SearchBarEsRspInfo();
                searchBarEsRspInfo.setCommodityId(Long.valueOf(commodityRspBo.getCommodity_id()));
                searchBarEsRspInfo.setSkuId(Long.valueOf(commodityRspBo.getSku_id()));
                searchBarEsRspInfo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchBarEsRspInfo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMarket_price())));
                searchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getSale_price())));
                searchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price1())));
                searchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price2())));
                searchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price3())));
                searchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price4())));
                searchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price5())));
                searchBarEsRspInfo.setSkuName(commodityRspBo.getSku_name());
                searchBarEsRspInfo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchBarEsRspInfo.setSupplierShopName(commodityRspBo.getShop_name());
                searchBarEsRspInfo.setSupplierId(String.valueOf(commodityRspBo.getSupplier_id()));
                searchBarEsRspInfo.setSupplierName(commodityRspBo.getSupplier_name());
                searchBarEsRspInfo.setSkuSource(Integer.valueOf(commodityRspBo.getSku_source()));
                searchBarEsRspInfos.add(searchBarEsRspInfo);
            }
        }
        return searchBarEsRspInfos;
    }
}

