/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.busibase.busi.api.UccReplacementPriceBusiService;
import com.tydic.commodity.busibase.busi.bo.ReplacePriceInfoBO;
import com.tydic.commodity.busibase.busi.bo.UccReplacementPriceBusiReqBo;
import com.tydic.commodity.busibase.busi.bo.UccReplacementPriceBusiRspBo;
import com.tydic.commodity.busibase.comb.api.CompareCommodityService;
import com.tydic.commodity.busibase.comb.bo.CommodityRspBo;
import com.tydic.commodity.busibase.comb.bo.CompareEsReqBo;
import com.tydic.commodity.busibase.comb.bo.CompareEsRspBo;
import com.tydic.commodity.common.ability.api.UccPriceCompareAbilityService;
import com.tydic.commodity.common.ability.bo.SearchBarEsRspInfo;
import com.tydic.commodity.common.ability.bo.UccComparePriceAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccComparePriceAbilityRspBO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccPriceCompareAbilityService.class)
public class UccPriceCompareAbilityServiceImpl
implements UccPriceCompareAbilityService {
    @Autowired
    private CompareCommodityService compareCommodityService;
    @Autowired
    private UccReplacementPriceBusiService uccReplacementPriceBusiService;

    public UccComparePriceAbilityRspBO compare(UccComparePriceAbilityReqBO reqBo) {
        UccComparePriceAbilityRspBO rspBo = new UccComparePriceAbilityRspBO();
        if (StringUtils.isEmpty((CharSequence)reqBo.getUpc()) && StringUtils.isEmpty((CharSequence)reqBo.getMfgsku())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u65e0\u6bd4\u4ef7\u5173\u952e\u4fe1\u606f");
            rspBo.setResult(new ArrayList());
            return rspBo;
        }
        CompareEsReqBo compareEsReqBo = new CompareEsReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)compareEsReqBo);
        CompareEsRspBo compareEsRspBo = this.compareCommodityService.compare(compareEsReqBo);
        if (!"0000".equals(compareEsRspBo.getRespCode())) {
            BeanUtils.copyProperties((Object)compareEsRspBo, (Object)reqBo);
            return rspBo;
        }
        List commodityRspBos = compareEsRspBo.getCommodityRspBos();
        List<SearchBarEsRspInfo> result = this.convertRspBo(commodityRspBos);
        HashMap<Long, Integer> filter = new HashMap<Long, Integer>();
        int i = 0;
        if (!result.isEmpty()) {
            for (SearchBarEsRspInfo searchBarEsRspInfo : result) {
                if (filter.containsKey(searchBarEsRspInfo.getSupplierShopId())) {
                    if (result.get((Integer)filter.get(searchBarEsRspInfo.getSupplierShopId())).getSalePrice().compareTo(searchBarEsRspInfo.getSalePrice()) > 0) {
                        filter.put(searchBarEsRspInfo.getSupplierShopId(), i);
                    }
                } else {
                    filter.put(searchBarEsRspInfo.getSupplierShopId(), i);
                }
                ++i;
            }
            ArrayList<SearchBarEsRspInfo> supplierShopPrice = new ArrayList<SearchBarEsRspInfo>();
            for (Long each : filter.keySet()) {
                supplierShopPrice.add(result.get((Integer)filter.get(each)));
            }
            result.clear();
            result.addAll(supplierShopPrice);
        }
        if ("1".equals(reqBo.getIsprofess()) && !"".equals(reqBo.getCompanyId())) {
            UccReplacementPriceBusiReqBo uccReplacementPriceBusiReqBo = new UccReplacementPriceBusiReqBo();
            Object var10_12 = null;
            ArrayList<ReplacePriceInfoBO> replacePriceInfoBOList = new ArrayList<ReplacePriceInfoBO>();
            for (SearchBarEsRspInfo each : result) {
                ReplacePriceInfoBO replacePriceInfoBO = new ReplacePriceInfoBO();
                replacePriceInfoBO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)each.getAgreementPrice())));
                replacePriceInfoBO.setAgreementId(each.getAgreementId());
                replacePriceInfoBO.setCommodityTypeId(each.getTypeId());
                replacePriceInfoBO.setSkuSource(each.getSkuSource());
                replacePriceInfoBO.setSupplierShopId(each.getSupplierShopId());
                replacePriceInfoBO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)each.getSalePrice())));
                replacePriceInfoBO.setSkuId(each.getSkuId());
                replacePriceInfoBO.setCommodityId(each.getCommodityId());
                replacePriceInfoBO.setVendorId(each.getVendorId());
                replacePriceInfoBOList.add(replacePriceInfoBO);
            }
            uccReplacementPriceBusiReqBo.setIsprofess(reqBo.getIsprofess());
            uccReplacementPriceBusiReqBo.setCompanyId(reqBo.getCompanyId());
            uccReplacementPriceBusiReqBo.setReplacePriceInfo(replacePriceInfoBOList);
            uccReplacementPriceBusiReqBo.setPsDiscountRate(reqBo.getPsDiscountRate());
            UccReplacementPriceBusiRspBo uccReplacementPriceBusiRspBo = this.uccReplacementPriceBusiService.replacePrice(uccReplacementPriceBusiReqBo);
            if ("0000".equals(uccReplacementPriceBusiRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)uccReplacementPriceBusiRspBo.getRows())) {
                Map<Long, Long> replacePriceMap = uccReplacementPriceBusiRspBo.getRows().stream().collect(Collectors.toMap(ReplacePriceInfoBO::getSkuId, ReplacePriceInfoBO::getSalePrice));
                for (SearchBarEsRspInfo each : result) {
                    if (!replacePriceMap.containsKey(each.getSkuId())) continue;
                    each.setSalePrice(MoneyUtils.haoToYuan((Long)replacePriceMap.get(each.getSkuId())));
                }
            }
        } else {
            for (SearchBarEsRspInfo searchBarEsRspInfo : result) {
                if (!"2".equals(reqBo.getIsprofess()) || searchBarEsRspInfo.getSourceAssort() == null || searchBarEsRspInfo.getSourceAssort() != 0 && searchBarEsRspInfo.getSourceAssort() != 3 || searchBarEsRspInfo.getAgreementPrice() == null) continue;
                searchBarEsRspInfo.setSalePrice(searchBarEsRspInfo.getAgreementPrice());
            }
            if (reqBo.getPsDiscountRate() != null && reqBo.getPsDiscountRate().compareTo(BigDecimal.ZERO) != 0) {
                for (SearchBarEsRspInfo searchBarEsRspInfo : result) {
                    BigDecimal agreementPrice;
                    BigDecimal salePrice = searchBarEsRspInfo.getSalePrice();
                    if (salePrice.compareTo(agreementPrice = searchBarEsRspInfo.getAgreementPrice()) == 0) continue;
                    BigDecimal difValue = salePrice.subtract(agreementPrice);
                    BigDecimal salePirce = difValue.multiply(reqBo.getPsDiscountRate().divide(BigDecimal.valueOf(100L), 4, 0)).add(agreementPrice);
                    searchBarEsRspInfo.setSalePrice(salePirce);
                }
            }
        }
        rspBo.setResult(result);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<SearchBarEsRspInfo> convertRspBo(List<CommodityRspBo> commodityRspBos) {
        ArrayList<SearchBarEsRspInfo> searchBarEsRspInfos = new ArrayList<SearchBarEsRspInfo>();
        if (commodityRspBos != null && commodityRspBos.size() > 0) {
            for (CommodityRspBo commodityRspBo : commodityRspBos) {
                SearchBarEsRspInfo searchBarEsRspInfo = new SearchBarEsRspInfo();
                searchBarEsRspInfo.setCommodityId(Long.valueOf(commodityRspBo.getCommodity_id()));
                searchBarEsRspInfo.setSkuId(Long.valueOf(commodityRspBo.getSku_id()));
                searchBarEsRspInfo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchBarEsRspInfo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getAgreement_price())));
                searchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMarket_price())));
                searchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getSale_price())));
                searchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price1())));
                searchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price2())));
                searchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price3())));
                searchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price4())));
                searchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan((BigDecimal)new BigDecimal(commodityRspBo.getMember_price5())));
                searchBarEsRspInfo.setSkuName(commodityRspBo.getSku_name());
                searchBarEsRspInfo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchBarEsRspInfo.setSupplierShopName(commodityRspBo.getShop_name());
                searchBarEsRspInfo.setSupplierId(String.valueOf(commodityRspBo.getSupplier_id()));
                searchBarEsRspInfo.setSupplierName(commodityRspBo.getSupplier_name());
                searchBarEsRspInfo.setSkuSource(Integer.valueOf(commodityRspBo.getSku_source()));
                searchBarEsRspInfos.add(searchBarEsRspInfo);
            }
        }
        return searchBarEsRspInfos;
    }
}

