/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.CommdPropDefBO;
import com.tydic.commodity.base.enumType.CommodityPropDefEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.common.ability.api.UccPropGroupListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccPropGroupListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccPropGroupListQryAbilityRspBO;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccRelPropGrpPropMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccCommdPropDefPo;
import com.tydic.commodity.po.UccRelPropGrpPropPo;
import com.tydic.commodity.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccPropGroupListQryAbilityService.class)
public class UccPropGroupListQryAbilityServiceImpl
implements UccPropGroupListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccPropGroupListQryAbilityServiceImpl.class);
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccRelPropGrpPropMapper uccRelPropGrpPropMapper;

    public UccPropGroupListQryAbilityRspBO qryPropGroupList(UccPropGroupListQryAbilityReqBO reqBO) {
        UccPropGroupListQryAbilityRspBO rspBO = new UccPropGroupListQryAbilityRspBO();
        Page pagePo = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccCommdPropDefPo po = new UccCommdPropDefPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        List<UccCommdPropDefPo> polist = this.uccCommodityPropDefMapper.queryRelPoToPage(pagePo, po);
        if (polist == null || polist.size() == 0) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setTotal(0);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        if (reqBO.getIgnorPropGroupId() != null) {
            polist = this.cleanPropDef(polist, reqBO.getIgnorPropGroupId());
        }
        ArrayList<CommdPropDefBO> boList = new ArrayList<CommdPropDefBO>();
        CommdPropDefBO bo = null;
        DicDictionaryPo dicDictionaryPo = null;
        for (UccCommdPropDefPo each : polist) {
            bo = new CommdPropDefBO();
            BeanUtils.copyProperties((Object)each, (Object)bo);
            bo.setCreateName(each.getCreateOperId());
            bo.setUpdateName(each.getUpdateOperName());
            if (each.getCreateTime() != null) {
                bo.setCreateTime(DateUtils.dateToStr((Date)each.getCreateTime()));
            }
            if (each.getUpdateTime() != null) {
                bo.setUpdateTime(DateUtils.dateToStr((Date)each.getUpdateTime()));
            }
            if (each.getPropTag() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getPropTag().toString(), CommodityPropDefEnum.COMMODITY_PROP_DEF_PROP_TAG.toString())) != null) {
                bo.setPropTagTranslation(dicDictionaryPo.getTitle());
            }
            if (each.getPropType() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getPropType()), CommodityPropDefEnum.COMMODITY_PROP_DEF_PROP_TYPE.toString())) != null) {
                bo.setPropTypeTranslation(dicDictionaryPo.getTitle());
            }
            if (each.getInputType() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getInputType()), CommodityPropDefEnum.COMMODITY_PROP_DEF_INPUT_TYPE.toString())) != null) {
                bo.setInputTypeTranslation(dicDictionaryPo.getTitle());
            }
            if (each.getFilterFlag() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getFilterFlag().toString(), CommodityPropDefEnum.COMMODITY_PROP_DEF_FILTER_FLAG.toString())) != null) {
                bo.setFilterFlagTranslation(dicDictionaryPo.getTitle());
            }
            if (each.getRequiredFlag() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getRequiredFlag()), CommodityPropDefEnum.COMMODITY_PROP_DEF_REQUIRED_FLAG.toString())) != null) {
                bo.setRequiredFlagTranslation(dicDictionaryPo.getTitle());
            }
            if (each.getMultiFlag() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getMultiFlag()), CommodityPropDefEnum.COMMODITY_PROP_DEF_MULTI_FLAG.toString())) != null) {
                bo.setMultiFlagTranslation(dicDictionaryPo.getTitle());
            }
            if (each.getPropertyLink() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getPropertyLink()), CommodityPropDefEnum.COMMODITY_PROP_DEF_PROPERTY_LINK.toString())) != null) {
                bo.setPropertyLinkTranslation(dicDictionaryPo.getTitle());
            }
            boList.add(bo);
        }
        rspBO.setRows(boList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(pagePo.getPageNo());
        rspBO.setRecordsTotal(pagePo.getTotalCount());
        rspBO.setTotal(pagePo.getTotalPages());
        return rspBO;
    }

    private List<UccCommdPropDefPo> cleanPropDef(List<UccCommdPropDefPo> polist, Long ignorPropGroupId) {
        ArrayList<UccCommdPropDefPo> newPoList = new ArrayList<UccCommdPropDefPo>();
        List uccRelPropGrpPropPos = this.uccRelPropGrpPropMapper.selectByDefIdAndGrpId(null, ignorPropGroupId);
        if (uccRelPropGrpPropPos != null && !uccRelPropGrpPropPos.isEmpty()) {
            ArrayList<Long> commodityPropDefIdList = new ArrayList<Long>();
            for (UccRelPropGrpPropPo uccRelPropGrpPropPo : uccRelPropGrpPropPos) {
                commodityPropDefIdList.add(uccRelPropGrpPropPo.getCommodityPropDefId());
            }
            for (UccCommdPropDefPo uccCommdPropDefPo : polist) {
                if (commodityPropDefIdList.contains(uccCommdPropDefPo.getCommodityPropDefId())) continue;
                newPoList.add(uccCommdPropDefPo);
            }
        }
        return newPoList;
    }
}

