/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.common.ability.api.UccQryChannelLableAbilityService;
import com.tydic.commodity.common.ability.bo.UccQryChannelLableAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccQryChannelLableAbilityRspBO;
import com.tydic.commodity.dao.UccChannelMapper;
import com.tydic.commodity.dao.UccCommodityLabelMapper;
import com.tydic.commodity.dao.UccRelChannelPoolMapper;
import com.tydic.commodity.dao.UccRelCommodityLabelPoolMapper;
import com.tydic.commodity.po.UccChannelPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccQryChannelLableAbilityService.class)
public class UccQryChannelLableAbilityServiceImpl
implements UccQryChannelLableAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccQryChannelLableAbilityServiceImpl.class);
    @Autowired
    private UccChannelMapper uccChannelMapper;
    @Autowired
    private UccRelChannelPoolMapper cnncUccRelChannelPoolMapper;
    @Autowired
    private UccRelCommodityLabelPoolMapper cnncRelCommodityLabelPoolMapper;
    @Autowired
    private UccCommodityLabelMapper cnncCommodityLabelMapper;

    public UccQryChannelLableAbilityRspBO queryChannelLable(UccQryChannelLableAbilityReqBO reqBO) {
        UccQryChannelLableAbilityRspBO rspBO = new UccQryChannelLableAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getChannelId() == null) {
            rspBO.setHideLable(new ArrayList());
            rspBO.setShowLable(new ArrayList());
            return rspBO;
        }
        UccChannelPO uccChannelPO = this.uccChannelMapper.selectByPrimaryKey(reqBO.getChannelId());
        if (uccChannelPO == null) {
            rspBO.setHideLable(new ArrayList());
            rspBO.setShowLable(new ArrayList());
            return rspBO;
        }
        List channelPoolJoinPOS = this.cnncUccRelChannelPoolMapper.queryRelList(Arrays.asList(reqBO.getChannelId()), null);
        if (CollectionUtils.isEmpty((Collection)channelPoolJoinPOS)) {
            rspBO.setHideLable(new ArrayList());
            rspBO.setShowLable(new ArrayList());
            return rspBO;
        }
        HashSet pools = new HashSet();
        channelPoolJoinPOS.stream().filter(s -> s.getPoolState() != 0).forEach(s -> pools.add(s.getPoolId()));
        if (!CollectionUtils.isEmpty(pools)) {
            List show = this.cnncCommodityLabelMapper.selectLabel(Integer.valueOf(1), new ArrayList(pools));
            List hide = this.cnncCommodityLabelMapper.selectLabel(Integer.valueOf(0), new ArrayList(pools));
            if (!CollectionUtils.isEmpty((Collection)show)) {
                HashSet showLabel = new HashSet();
                show.stream().forEach(s -> showLabel.add(s.getLabelName()));
                rspBO.setShowLable(new ArrayList(showLabel));
            }
            if (!CollectionUtils.isEmpty((Collection)hide)) {
                HashSet hideLabel = new HashSet();
                hide.stream().forEach(s -> hideLabel.add(s.getLabelName()));
                rspBO.setHideLable(new ArrayList(hideLabel));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

