/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.commodity.common.ability.api.UccQueryMaterialClassifyService;
import com.tydic.commodity.common.ability.bo.UccQueryMaterialClassifyReqBO;
import com.tydic.commodity.common.ability.bo.UccQueryMaterialClassifyRspBO;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.po.CnncUccMaterialClassifyPO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccQueryMaterialClassifyService.class)
public class UccQueryMaterialClassifyServiceImpl
implements UccQueryMaterialClassifyService {
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;

    public UccQueryMaterialClassifyRspBO queryMaterialClassify(UccQueryMaterialClassifyReqBO reqBO) {
        UccQueryMaterialClassifyRspBO rspBO = new UccQueryMaterialClassifyRspBO();
        if (reqBO.getCommodityTypeId() == null || reqBO.getCommodityTypeId() == 0L) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1\u7c7b\u578bid\u4e3a\u7a7a");
            return rspBO;
        }
        CnncUccMaterialClassifyPO cnncUccMaterialClassifyPO = this.uccEMdmCatalogMapper.queryCatalogByCommodityType(reqBO.getCommodityTypeId());
        if (cnncUccMaterialClassifyPO != null && cnncUccMaterialClassifyPO.getCatalogId() != null) {
            List<UccEMdmCatalogPO> poList = this.findParent(cnncUccMaterialClassifyPO.getCatalogId());
            if (!CollectionUtils.isEmpty(poList)) {
                Collections.sort(poList, new Comparator<UccEMdmCatalogPO>(){

                    @Override
                    public int compare(UccEMdmCatalogPO o1, UccEMdmCatalogPO o2) {
                        return o1.getCatalogLevel() - o2.getCatalogLevel();
                    }
                });
                StringBuilder sb = new StringBuilder("");
                poList.stream().forEach(a -> {
                    if (!"".equals(sb.toString())) {
                        sb.append("-");
                    }
                    sb.append(a.getCatalogName());
                });
                rspBO.setCatalogName(sb.toString());
            }
            rspBO.setCatalogId(cnncUccMaterialClassifyPO.getCatalogId());
            rspBO.setCommodityTypeName(cnncUccMaterialClassifyPO.getCommodityTypeName());
            rspBO.setTaxCatCode(cnncUccMaterialClassifyPO.getTaxCatCode());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5931\u8d25");
        return rspBO;
    }

    List<UccEMdmCatalogPO> findParent(Long catalogId) {
        ArrayList<UccEMdmCatalogPO> poList = new ArrayList<UccEMdmCatalogPO>();
        UccEMdmCatalogPO po = this.uccEMdmCatalogMapper.queryById(catalogId);
        if (po == null) {
            return poList;
        }
        poList.add(po);
        if (po.getCatalogLevel() == 1) {
            return poList;
        }
        List<UccEMdmCatalogPO> parent = this.findParent(po.getParentCatalogId());
        poList.addAll(parent);
        return poList;
    }
}

