/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.ExcelUtils;
import com.tydic.commodity.common.ability.api.UccIteminstockEditAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuImportBatchEditStockAbilityService;
import com.tydic.commodity.common.ability.bo.UccImportInfo;
import com.tydic.commodity.common.ability.bo.UccIteminstockEditAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccIteminstockEditAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccIteminstockEditBO;
import com.tydic.commodity.common.ability.bo.UccSkuImportBatchEditStockAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuImportBatchEditStockAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UCC_GROUP_DEV", serviceInterface=UccSkuImportBatchEditStockAbilityService.class)
public class UccSkuImportBatchEditStockAbilityServiceImpl
implements UccSkuImportBatchEditStockAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuImportBatchEditStockAbilityServiceImpl.class);
    private static final int startReadLine = 2;
    @Autowired
    private UccIteminstockEditAbilityService uccIteminstockEditAbilityService;

    public UccSkuImportBatchEditStockAbilityRspBO dealbatchEdit(UccSkuImportBatchEditStockAbilityReqBO reqBO) {
        UccSkuImportBatchEditStockAbilityRspBO rspBO = new UccSkuImportBatchEditStockAbilityRspBO();
        List<UccImportInfo> data = this.getData(reqBO.getImportUrl());
        UccIteminstockEditAbilityReqBO uccIteminstockEditAbilityReqBO = new UccIteminstockEditAbilityReqBO();
        ArrayList<UccIteminstockEditBO> batchStock = new ArrayList<UccIteminstockEditBO>();
        for (UccImportInfo uccImportInfo : data) {
            UccIteminstockEditBO uccIteminstockEditBO = new UccIteminstockEditBO();
            uccIteminstockEditBO.setSkuId(uccImportInfo.getSkuId());
            uccIteminstockEditBO.setOperTupe(Integer.valueOf(1));
            uccIteminstockEditBO.setNum(Long.valueOf(uccImportInfo.getTotalNum().longValue()));
            batchStock.add(uccIteminstockEditBO);
        }
        uccIteminstockEditAbilityReqBO.setBatchStock(batchStock);
        UccIteminstockEditAbilityRspBO uccIteminstockEditAbilityRspBO = this.uccIteminstockEditAbilityService.dealUccIteminstockEdit(uccIteminstockEditAbilityReqBO);
        BeanUtils.copyProperties((Object)uccIteminstockEditAbilityRspBO, (Object)rspBO);
        return rspBO;
    }

    private List<UccImportInfo> getData(String url) {
        if (StringUtils.isEmpty((Object)url)) {
            throw new ZTBusinessException("\u8bf7\u4f20\u5165\u8def\u5f84\u4fe1\u606f");
        }
        List<Object> data = new ArrayList();
        try {
            data = this.dealEcxel(url);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        ArrayList<UccImportInfo> uccImportInfos = new ArrayList<UccImportInfo>();
        int rowNum = 1;
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    if (list.size() < 6) continue;
                    int i = 1;
                    UccImportInfo uccImportInfo = new UccImportInfo();
                    uccImportInfo.setSkuName((String)list.get(i++));
                    uccImportInfo.setSkuId(Long.valueOf((String)list.get(i++)));
                    if (!StringUtils.isEmpty(list.get(i))) {
                        uccImportInfo.setTotalNum(BigDecimal.valueOf(Long.parseLong((String)list.get(i++))));
                    } else {
                        ++i;
                    }
                    if (!StringUtils.isEmpty(list.get(i))) {
                        uccImportInfo.setSaledNum(BigDecimal.valueOf(Long.parseLong((String)list.get(i++))));
                    } else {
                        ++i;
                    }
                    if (!StringUtils.isEmpty(list.get(i))) {
                        uccImportInfo.setCancelStock(BigDecimal.valueOf(Long.parseLong((String)list.get(i++))));
                    } else {
                        ++i;
                    }
                    uccImportInfos.add(uccImportInfo);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        log.info("\u8bfb\u53d6excel\u5230\u5b9e\u4f53\u7c7b\uff1a" + JSONObject.toJSONString(uccImportInfos));
        return uccImportInfos;
    }

    private List<List<String>> dealEcxel(String url) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelUtils.getExcelDate((String)url, lines, (Integer)2);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }
}

