/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.atom.api.UccCatalogCommdNumQryAtomService;
import com.tydic.commodity.common.atom.bo.CatalogCommdNumBO;
import com.tydic.commodity.common.atom.bo.UccCatalogCommdNumQryReqBO;
import com.tydic.commodity.common.atom.bo.UccCatalogCommdNumQryRspBO;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.po.SupplierShopPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uccCatalogCommdNumQryAtomService")
public class UccCatalogCommdNumQryAtomServiceImpl
implements UccCatalogCommdNumQryAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogCommdNumQryAtomServiceImpl.class);
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    @Override
    public UccCatalogCommdNumQryRspBO qryCommdNum(UccCatalogCommdNumQryReqBO reqBO) {
        this.checkReq(reqBO);
        UccCatalogCommdNumQryRspBO rspBO = new UccCatalogCommdNumQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        ArrayList<CatalogCommdNumBO> catalogCommdNumBOList = new ArrayList<CatalogCommdNumBO>();
        rspBO.setResult(catalogCommdNumBOList);
        List supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isEmpty((Collection)supplierShopPos)) {
            rspBO.setRespDesc("\u5546\u6237\u4e0b\u65e0\u5e97\u94fa\u4fe1\u606f");
            return rspBO;
        }
        List supplierShopIds = supplierShopPos.stream().map(SupplierShopPo::getSupplierShopId).collect(Collectors.toList());
        Map<Long, List<Long>> commodityTypeIdsMap = this.queryCommdTypeIds(reqBO.getCatalogIds());
        for (Map.Entry<Long, List<Long>> each : commodityTypeIdsMap.entrySet()) {
            Long catalogId = each.getKey();
            List<Long> commodityTypeIds = each.getValue();
            CatalogCommdNumBO catalogCommdNumBO = new CatalogCommdNumBO();
            catalogCommdNumBO.setCatalogId(catalogId);
            catalogCommdNumBO.setCommodityNum(0L);
            catalogCommdNumBO.setSaleItemNum(0L);
            catalogCommdNumBO.setDepotItemNum(0L);
            catalogCommdNumBO.setNotStockCount(0L);
            catalogCommdNumBOList.add(catalogCommdNumBO);
            if (CollectionUtils.isEmpty(commodityTypeIds)) continue;
            Long count = this.uccSkuMapper.qryNumsByStatus(null, supplierShopIds, commodityTypeIds);
            catalogCommdNumBO.setCommodityNum(count);
            ArrayList<Integer> status = new ArrayList<Integer>();
            status.add(0);
            status.add(1);
            status.add(2);
            status.add(5);
            status.add(7);
            status.add(10);
            Long depotItemNum = this.uccSkuMapper.qryNumsByStatus(status, supplierShopIds, commodityTypeIds);
            catalogCommdNumBO.setDepotItemNum(depotItemNum);
            status = new ArrayList();
            status.add(3);
            Long saleNums = this.uccSkuMapper.qryNumsByStatus(status, supplierShopIds, commodityTypeIds);
            catalogCommdNumBO.setSaleItemNum(saleNums);
            Long understockNum = this.uccCommodityMapper.qryRemark(reqBO.getSupplierId(), catalogId);
            catalogCommdNumBO.setNotStockCount(understockNum);
        }
        return rspBO;
    }

    public Map<Long, List<Long>> queryCommdTypeIds(List<Long> catalogIds) {
        if (CollectionUtils.isEmpty(catalogIds)) {
            return null;
        }
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        for (int i = 0; i < catalogIds.size(); ++i) {
            try {
                List commodityTypeIds = this.uccCatRCommdTypeMapper.qryCommodityTypeIds(catalogIds.get(i));
                map.put(catalogIds.get(i), commodityTypeIds);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u5931\u8d25");
            }
        }
        return map;
    }

    public void checkReq(UccCatalogCommdNumQryReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getCatalogIds())) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u7c7b\u76eeID");
        }
        if (reqBO.getSupplierId() == null) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u5546\u6237ID");
        }
    }
}

