/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.atom.api.UccCatalogSoldNumQryAtomService;
import com.tydic.commodity.common.atom.api.UccQryCommodityTypeIdsAtomService;
import com.tydic.commodity.common.atom.bo.CommdSoldNum;
import com.tydic.commodity.common.atom.bo.UccCatalogSoldNumQryReqBO;
import com.tydic.commodity.common.atom.bo.UccCatalogSoldNumQryRspBO;
import com.tydic.commodity.common.atom.bo.UccQryCommodityTypeIdsReqBO;
import com.tydic.commodity.common.atom.bo.UccQryCommodityTypeIdsRspBO;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uccCatalogSoldNumQryAtomService")
public class UccCatalogSoldNumQryAtomServiceImpl
implements UccCatalogSoldNumQryAtomService {
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccQryCommodityTypeIdsAtomService uccQryCommodityTypeIdsAtomService;

    @Override
    public UccCatalogSoldNumQryRspBO qrySoldNum(UccCatalogSoldNumQryReqBO reqBO) {
        UccCatalogSoldNumQryRspBO rspBO = new UccCatalogSoldNumQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        if (CollectionUtils.isEmpty(reqBO.getCatalogIds())) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u7c7b\u76eeID");
        }
        UccQryCommodityTypeIdsReqBO uccQryCommodityTypeIdsReqBO = new UccQryCommodityTypeIdsReqBO();
        uccQryCommodityTypeIdsReqBO.setCatalogIds(reqBO.getCatalogIds());
        UccQryCommodityTypeIdsRspBO uccQryCommodityTypeIdsRspBO = this.uccQryCommodityTypeIdsAtomService.qryCommodityTypeIds(uccQryCommodityTypeIdsReqBO);
        Map<Long, List<Long>> commodityTypeIdMap = uccQryCommodityTypeIdsRspBO.getCommodityIds();
        Iterator<Map.Entry<Long, List<Long>>> iterator = commodityTypeIdMap.entrySet().iterator();
        ArrayList<CommdSoldNum> commdSoldNums = new ArrayList<CommdSoldNum>();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<Long>> each = iterator.next();
            Long catalogId = each.getKey();
            List<Long> commodityTypeIds = each.getValue();
            CommdSoldNum commdSoldNum = new CommdSoldNum();
            commdSoldNum.setCatalogId(catalogId);
            commdSoldNum.setSoldNum(0L);
            commdSoldNums.add(commdSoldNum);
            List uccSkuPoList = this.uccSkuMapper.querySkuByCommTypeIds(commodityTypeIds);
            if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) continue;
            ArrayList<Long> skuIds = new ArrayList<Long>();
            for (UccSkuPo uccSkuPo : uccSkuPoList) {
                skuIds.add(uccSkuPo.getSkuId());
            }
            List uccSaleNumPos = this.uccSaleNumMapper.qryBySkuIds(skuIds);
            if (CollectionUtils.isEmpty((Collection)uccSaleNumPos)) continue;
            BigDecimal soldNum = new BigDecimal(0);
            for (UccSaleNumPo uccSaleNumPo : uccSaleNumPos) {
                soldNum = soldNum.add(uccSaleNumPo.getSoldNumber());
            }
            commdSoldNum.setSoldNum(soldNum.longValue());
        }
        rspBO.setResult(commdSoldNums);
        return rspBO;
    }
}

