/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.EstoreSkuInfoImageBo;
import com.tydic.commodity.base.bo.SkuInfoSpecBo;
import com.tydic.commodity.base.bo.UccLadderPriceInfo;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccIteminstockEditAbilityService;
import com.tydic.commodity.common.ability.bo.UccIteminstockEditAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccIteminstockEditAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccIteminstockEditBO;
import com.tydic.commodity.common.ability.bo.UccSkuEditDetailInfoBo;
import com.tydic.commodity.common.atom.api.UccItemEditAtomService;
import com.tydic.commodity.common.atom.bo.UccItemEditAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccItemEditAtomRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccLadderPriceEditMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSaleNumEditMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuDetailEditMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuEditMapper;
import com.tydic.commodity.dao.UccSkuExpandEditMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicEditMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceEditMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirEditMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSkuSpecEditMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccLadderPriceEditPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSaleNumEditPO;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuDetailEditPO;
import com.tydic.commodity.po.UccSkuDetailPO;
import com.tydic.commodity.po.UccSkuEditPO;
import com.tydic.commodity.po.UccSkuExpandEditPO;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPicEditPO;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPriceEditPO;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuPutCirEditPO;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.po.UccSkuSpecEditPO;
import com.tydic.commodity.po.UccSkuSpecPo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccItemEditAtomServiceImpl
implements UccItemEditAtomService {
    private static final Logger log = LogManager.getLogger(UccItemEditAtomServiceImpl.class);
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuEditMapper uccSkuEditMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccSkuDetailEditMapper uccSkuDetailEditMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSkuSpecEditMapper uccSkuSpecEditMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPicEditMapper uccSkuPicEditMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSkuExpandEditMapper uccSkuExpandEditMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuPriceEditMapper uccSkuPriceEditMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccLadderPriceEditMapper uccLadderPriceEditMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSkuPutCirEditMapper uccSkuPutCirEditMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSaleNumEditMapper uccSaleNumEditMapper;
    @Autowired
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    @Autowired
    private UccIteminstockEditAbilityService uccIteminstockEditAbilityService;
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;
    private Sequence sequenceUtil = Sequence.getInstance();

    @Override
    public UccItemEditAtomRspBO dealUccItemEdit(UccItemEditAtomReqBO reqBO) {
        Timestamp time = new Timestamp(System.currentTimeMillis());
        for (UccSkuEditDetailInfoBo uccSkuEditDetailInfoBo : reqBO.getSkuEditInfo()) {
            if (!(StringUtils.isEmpty((Object)uccSkuEditDetailInfoBo.getSalesUnitName()) && uccSkuEditDetailInfoBo.getSalesUnitRate() == null || uccSkuEditDetailInfoBo.getSalesUnitId() != null)) {
                throw new ZTBusinessException("\u5305\u88c5\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.qryCommdByCommdId(uccSkuEditDetailInfoBo.getCommodityId(), uccSkuEditDetailInfoBo.getSupplierShopId());
            uccSkuEditDetailInfoBo.setBrandId(uccCommodityPo.getBrandId());
            uccSkuEditDetailInfoBo.setBrandName(uccCommodityPo.getBrandName());
            if (uccCommodityPo.getCommodityStatus() == 0) {
                this.updateNormal(uccSkuEditDetailInfoBo, time, reqBO.getUserId().toString(), reqBO.getUsername(), reqBO.getOrgId(), reqBO.getOrgName());
                continue;
            }
            this.updateEdit(uccSkuEditDetailInfoBo, time, reqBO.getUserId().toString(), reqBO.getUsername(), reqBO.getOrgId(), reqBO.getOrgName());
        }
        UccItemEditAtomRspBO rspBO = new UccItemEditAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateNormal(UccSkuEditDetailInfoBo uccSkuEditDetailInfoBo, Timestamp time, String userId, String userName, Long orgId, String orgName) {
        UccSkuDetailPO uccSkuDetailPO;
        UccSkuPo uccSkuPo;
        UccLadderPricePO uccLadderPricePO;
        UccSkuPricePo uccSkuPricePo;
        Object uccSkuExpandPo;
        UccSkuPicPo uccSkuPicPo;
        if (uccSkuEditDetailInfoBo.getOperType() == 1) {
            Long skuId = this.sequence.nextId();
            UccSkuPo uccSkuPo2 = new UccSkuPo();
            BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo, (Object)uccSkuPo2);
            uccSkuPo2.setSkuId(skuId);
            uccSkuPo2.setCreateOperName(userName);
            uccSkuPo2.setCreateOperId(userId);
            uccSkuPo2.setCreateTime((Date)time);
            uccSkuPo2.setOrgId(orgId);
            uccSkuPo2.setOrgName(orgName);
            uccSkuPo2.setSkuStatus(Integer.valueOf(0));
            uccSkuPo2.setSalesUnitId(uccSkuEditDetailInfoBo.getSalesUnitId());
            if (uccSkuEditDetailInfoBo.getSkuPrice() != null) {
                uccSkuPo2.setSkuPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuPrice()).longValue()));
            }
            this.uccSkuMapper.addsku(uccSkuPo2);
            UccSkuDetailPO uccSkuDetailPO2 = new UccSkuDetailPO();
            BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo, (Object)uccSkuDetailPO2);
            this.uccSkuDetailMapper.insert(uccSkuDetailPO2);
            for (SkuInfoSpecBo skuInfoSpecBo : uccSkuEditDetailInfoBo.getSkuSpec()) {
                UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
                BeanUtils.copyProperties((Object)skuInfoSpecBo, (Object)uccSkuSpecPo);
                uccSkuSpecPo.setSkuSpecId(Long.valueOf(this.sequence.nextId()));
                uccSkuSpecPo.setSkuId(skuId);
                uccSkuSpecPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                uccSkuSpecPo.setCreateOperId(userId);
                uccSkuSpecPo.setCreateTime((Date)time);
                this.uccSkuSpecMapper.addskuSpec(uccSkuSpecPo);
            }
            for (EstoreSkuInfoImageBo estoreSkuInfoImageBo : uccSkuEditDetailInfoBo.getSkuImages()) {
                uccSkuPicPo = new UccSkuPicPo();
                BeanUtils.copyProperties((Object)estoreSkuInfoImageBo, (Object)uccSkuPicPo);
                uccSkuPicPo.setSkuPicId(Long.valueOf(this.sequence.nextId()));
                uccSkuPicPo.setSkuId(skuId);
                uccSkuPicPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                uccSkuPicPo.setCreateOperId(userId);
                uccSkuPicPo.setCreateTime((Date)time);
                this.uccSkuPicMapper.addskuPic(uccSkuPicPo);
            }
            if (uccSkuEditDetailInfoBo.getSkuExpand() != null) {
                uccSkuExpandPo = new UccSkuExpandPo();
                BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuExpand(), (Object)uccSkuExpandPo);
                uccSkuExpandPo.setSkuId(skuId);
                uccSkuExpandPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                this.uccSkuExpandMapper.insertSkuExpand((UccSkuExpandPo)uccSkuExpandPo);
            }
            uccSkuPricePo = new UccSkuPricePo();
            BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuInfoPrice(), (Object)uccSkuPricePo);
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMarketPrice() != null) {
                uccSkuPricePo.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMarketPrice()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getAgreementPrice() != null) {
                uccSkuPricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getAgreementPrice()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getSalePrice() != null) {
                uccSkuPricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getSalePrice()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice1() != null) {
                uccSkuPricePo.setMemberPrice1(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice1()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice2() != null) {
                uccSkuPricePo.setMemberPrice2(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice2()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice3() != null) {
                uccSkuPricePo.setMemberPrice3(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice3()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice4() != null) {
                uccSkuPricePo.setMemberPrice4(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice4()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice5() != null) {
                uccSkuPricePo.setMemberPrice5(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice5()).longValue()));
            }
            uccSkuPricePo.setSkuId(skuId);
            uccSkuPricePo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            Long skuPriceId = this.sequence.nextId();
            uccSkuPricePo.setSkuPriceId(skuPriceId);
            uccSkuPricePo.setCreateOperId(userId);
            uccSkuPricePo.setCreateTime((Date)time);
            this.uccSkuPriceMapper.addskuPrice(uccSkuPricePo);
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getSwitchOn() == 1 && uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo() != null && !uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo().isEmpty()) {
                ArrayList<UccLadderPricePO> uccCommodityPicPos = new ArrayList<UccLadderPricePO>();
                for (UccLadderPriceInfo uccLadderPriceInfo : uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo()) {
                    uccLadderPricePO = new UccLadderPricePO();
                    BeanUtils.copyProperties((Object)uccLadderPriceInfo, (Object)uccLadderPricePO);
                    if (uccLadderPriceInfo.getPrice() != null) {
                        uccLadderPricePO.setPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getPrice()).longValue()));
                    }
                    if (uccLadderPriceInfo.getStart() != null) {
                        uccLadderPricePO.setStart(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getStart()).longValue()));
                    }
                    if (uccLadderPriceInfo.getStop() != null) {
                        uccLadderPricePO.setStop(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getStop()).longValue()));
                    }
                    uccLadderPricePO.setSkuId(skuId);
                    uccLadderPricePO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    uccLadderPricePO.setId(Long.valueOf(this.sequence.nextId()));
                    uccLadderPricePO.setSkuPriceId(skuPriceId);
                    uccCommodityPicPos.add(uccLadderPricePO);
                }
                this.uccLadderPriceMapper.batchInsert(uccCommodityPicPos);
            }
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setId(Long.valueOf(this.sequence.nextId()));
            uccSkuPutCirPo.setSkuId(skuId);
            uccSkuPutCirPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            uccSkuPutCirPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            if (uccSkuEditDetailInfoBo.getOnShelveWay() != null) {
                if (uccSkuEditDetailInfoBo.getOnShelveWay() == 0) {
                    uccSkuPutCirPo.setUpType(Integer.valueOf(1));
                } else {
                    uccSkuPutCirPo.setUpType(Integer.valueOf(2));
                    uccSkuPutCirPo.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                    if (uccSkuEditDetailInfoBo.getPreDownTime() != null) {
                        uccSkuPutCirPo.setPreDownTime(uccSkuEditDetailInfoBo.getPreDownTime());
                        uccSkuPutCirPo.setDownType(Integer.valueOf(2));
                    }
                }
            } else {
                throw new BusinessException("8888", "\u65b0\u589e\u65f6\u4e0a\u67b6\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            uccSkuPutCirPo.setState(Integer.valueOf(1));
            uccSkuPutCirPo.setCreateOperId(userId);
            uccSkuPutCirPo.setCreateTime((Date)time);
            this.uccSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
            UccSaleNumPo uccSaleNumPo = new UccSaleNumPo();
            uccSaleNumPo.setSaleId(Long.valueOf(this.sequence.nextId()));
            uccSaleNumPo.setSkuId(skuId);
            uccSaleNumPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            uccSaleNumPo.setCreateOperId(userId);
            uccSaleNumPo.setCreateTime((Date)time);
            uccSaleNumPo.setSoldNumber(new BigDecimal(0));
            this.uccSaleNumMapper.insertSaleNum(uccSaleNumPo);
            if (uccSkuEditDetailInfoBo.getTotalNum() != null) {
                uccSkuEditDetailInfoBo.setSkuId(skuId);
                this.addStock(uccSkuEditDetailInfoBo, userName);
            } else {
                throw new ZTBusinessException("\u5355\u54c1\"" + uccSkuEditDetailInfoBo.getSkuId() + "\"\u7684\u5e93\u5b58\u4e3a\u7a7a");
            }
        }
        if (uccSkuEditDetailInfoBo.getOperType() == 2) {
            uccSkuPo = new UccSkuPo();
            BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo, (Object)uccSkuPo);
            uccSkuPo.setUpdateOperName(userName);
            uccSkuPo.setUpdateOperId(userId);
            uccSkuPo.setUpdateTime((Date)time);
            if (uccSkuEditDetailInfoBo.getSkuPrice() != null) {
                uccSkuPo.setSkuPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuPrice()).longValue()));
            }
            this.uccSkuMapper.updateSku(uccSkuPo);
            uccSkuDetailPO = new UccSkuDetailPO();
            BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo, (Object)uccSkuDetailPO);
            UccSkuDetailPO where = new UccSkuDetailPO();
            where.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            where.setCommodityId(uccSkuEditDetailInfoBo.getCommodityId());
            where.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            this.uccSkuDetailMapper.updateBy(uccSkuDetailPO, where);
            if (uccSkuEditDetailInfoBo.getOnShelveWay() != null || uccSkuEditDetailInfoBo.getPreUpTime() != null || uccSkuEditDetailInfoBo.getPreDownTime() != null) {
                Object uccSkuPutCirPo = new UccSkuPutCirPo();
                uccSkuPutCirPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                uccSkuPutCirPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                uccSkuPutCirPo.setState(Integer.valueOf(1));
                List uccSkuPutCirPoList = this.uccSkuPutCirMapper.querySkuPutCir((UccSkuPutCirPo)uccSkuPutCirPo);
                if (CollectionUtils.isNotEmpty((Collection)uccSkuPutCirPoList)) {
                    uccSkuPutCirPo = (UccSkuPutCirPo)uccSkuPutCirPoList.get(0);
                    if (uccSkuEditDetailInfoBo.getOnShelveWay() != null) {
                        if (uccSkuEditDetailInfoBo.getOnShelveWay() == 0) {
                            uccSkuPutCirPo.setUpType(Integer.valueOf(1));
                        } else {
                            uccSkuPutCirPo.setUpType(Integer.valueOf(2));
                        }
                    }
                    if (uccSkuEditDetailInfoBo.getPreUpTime() != null) {
                        uccSkuPutCirPo.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                    }
                    if (uccSkuEditDetailInfoBo.getPreUpTime() != null) {
                        uccSkuPutCirPo.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                    }
                    uccSkuPutCirPo.setId(Long.valueOf(this.sequence.nextId()));
                    uccSkuPutCirPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPutCirPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    uccSkuPutCirPo.setState(Integer.valueOf(1));
                    uccSkuPutCirPo.setCreateOperId(userId);
                    uccSkuPutCirPo.setCreateTime((Date)time);
                    UccSkuPutCirPo temp = new UccSkuPutCirPo();
                    temp.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    temp.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    temp.setState(Integer.valueOf(2));
                    this.uccSkuPutCirMapper.updateSkuPutCir(temp);
                    this.uccSkuPutCirMapper.addSkuPutCir((UccSkuPutCirPo)uccSkuPutCirPo);
                } else {
                    uccSkuPutCirPo = new UccSkuPutCirPo();
                    uccSkuPutCirPo.setId(Long.valueOf(this.sequence.nextId()));
                    uccSkuPutCirPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPutCirPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    if (uccSkuEditDetailInfoBo.getOnShelveWay() != null) {
                        if (uccSkuEditDetailInfoBo.getOnShelveWay() == 0) {
                            uccSkuPutCirPo.setUpType(Integer.valueOf(1));
                        } else {
                            uccSkuPutCirPo.setUpType(Integer.valueOf(2));
                            uccSkuPutCirPo.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                            if (uccSkuEditDetailInfoBo.getPreDownTime() != null) {
                                uccSkuPutCirPo.setPreDownTime(uccSkuEditDetailInfoBo.getPreDownTime());
                                uccSkuPutCirPo.setDownType(Integer.valueOf(2));
                            }
                        }
                    } else {
                        throw new BusinessException("8888", "\u65b0\u589e\u4e0a\u67b6\u5468\u671f\u65f6\u4e0a\u67b6\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    uccSkuPutCirPo.setState(Integer.valueOf(1));
                    uccSkuPutCirPo.setCreateOperId(userId);
                    uccSkuPutCirPo.setCreateTime((Date)time);
                    this.uccSkuPutCirMapper.addSkuPutCir((UccSkuPutCirPo)uccSkuPutCirPo);
                }
            }
            if (uccSkuEditDetailInfoBo.getSkuImages() != null && !uccSkuEditDetailInfoBo.getSkuImages().isEmpty()) {
                for (EstoreSkuInfoImageBo estoreSkuInfoImageBo : uccSkuEditDetailInfoBo.getSkuImages()) {
                    uccSkuPicPo = new UccSkuPicPo();
                    BeanUtils.copyProperties((Object)estoreSkuInfoImageBo, (Object)uccSkuPicPo);
                    uccSkuPicPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPicPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    uccSkuPicPo.setUpdateOperId(userId);
                    uccSkuPicPo.setUpdateTime((Date)time);
                    this.uccSkuPicMapper.updateSkuPic(uccSkuPicPo);
                }
            }
            if (uccSkuEditDetailInfoBo.getSkuExpand() != null) {
                UccSkuExpandPo skuExpandPo;
                uccSkuExpandPo = new UccSkuExpandPo();
                uccSkuExpandPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                uccSkuExpandPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                List uccSkuExpandPoList = this.uccSkuExpandMapper.querySkuExpand((UccSkuExpandPo)uccSkuExpandPo);
                if (uccSkuExpandPoList != null && !uccSkuExpandPoList.isEmpty()) {
                    skuExpandPo = new UccSkuExpandPo();
                    BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuExpand(), (Object)skuExpandPo);
                    skuExpandPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    skuExpandPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuExpandMapper.updateSkuExpand(skuExpandPo);
                } else {
                    skuExpandPo = new UccSkuExpandPo();
                    BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuExpand(), (Object)skuExpandPo);
                    skuExpandPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    skuExpandPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuExpandMapper.insertSkuExpand(skuExpandPo);
                }
            }
            if (uccSkuEditDetailInfoBo.getSkuSpec() != null && !uccSkuEditDetailInfoBo.getSkuSpec().isEmpty()) {
                for (SkuInfoSpecBo skuInfoSpecBo : uccSkuEditDetailInfoBo.getSkuSpec()) {
                    UccSkuSpecPo skuSpecPo;
                    if (skuInfoSpecBo.getOperType() == 1) {
                        skuSpecPo = new UccSkuSpecPo();
                        BeanUtils.copyProperties((Object)skuInfoSpecBo, (Object)skuSpecPo);
                        skuSpecPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        skuSpecPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        skuSpecPo.setSkuSpecId(Long.valueOf(this.sequence.nextId()));
                        skuSpecPo.setCreateOperId(userId);
                        skuSpecPo.setCreateTime((Date)time);
                        this.uccSkuSpecMapper.addskuSpec(skuSpecPo);
                    }
                    if (skuInfoSpecBo.getOperType() == 2) {
                        skuSpecPo = new UccSkuSpecPo();
                        BeanUtils.copyProperties((Object)skuInfoSpecBo, (Object)skuSpecPo);
                        skuSpecPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        skuSpecPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        skuSpecPo.setUpdateOperId(userId);
                        skuSpecPo.setUpdateTime((Date)time);
                        this.uccSkuSpecMapper.updateSkuSpec(skuSpecPo);
                    }
                    if (skuInfoSpecBo.getOperType() != 3) continue;
                    skuSpecPo = new UccSkuSpecPo();
                    skuSpecPo.setSkuSpecId(skuInfoSpecBo.getSkuSpecId());
                    skuSpecPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    skuSpecPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuSpecMapper.deleteSkuSpec(skuSpecPo);
                }
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice() != null) {
                uccSkuPricePo = new UccSkuPricePo();
                BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuInfoPrice(), (Object)uccSkuPricePo);
                if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMarketPrice() != null) {
                    uccSkuPricePo.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMarketPrice()).longValue()));
                }
                if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getAgreementPrice() != null) {
                    uccSkuPricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getAgreementPrice()).longValue()));
                }
                if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getSalePrice() != null) {
                    uccSkuPricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getSalePrice()).longValue()));
                }
                if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice1() != null) {
                    uccSkuPricePo.setMemberPrice1(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice1()).longValue()));
                }
                if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice2() != null) {
                    uccSkuPricePo.setMemberPrice2(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice2()).longValue()));
                }
                if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice3() != null) {
                    uccSkuPricePo.setMemberPrice3(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice3()).longValue()));
                }
                if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice4() != null) {
                    uccSkuPricePo.setMemberPrice4(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice4()).longValue()));
                }
                if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice5() != null) {
                    uccSkuPricePo.setMemberPrice5(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice5()).longValue()));
                }
                uccSkuPricePo.setUpdateOperId(userId);
                uccSkuPricePo.setUpdateTime((Date)time);
                uccSkuPricePo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                uccSkuPricePo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                this.uccSkuPriceMapper.updateSkuPrice(uccSkuPricePo);
                if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getSwitchOn() != null && uccSkuEditDetailInfoBo.getSkuInfoPrice().getSwitchOn() == 1 && uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo() != null && !uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo().isEmpty()) {
                    UccLadderPricePO delete = new UccLadderPricePO();
                    delete.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    delete.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccLadderPriceMapper.deleteByExample(delete);
                    ArrayList<UccLadderPricePO> uccLadderPricePOList = new ArrayList<UccLadderPricePO>();
                    for (UccLadderPriceInfo uccLadderPriceInfo : uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo()) {
                        uccLadderPricePO = new UccLadderPricePO();
                        BeanUtils.copyProperties((Object)uccLadderPriceInfo, (Object)uccLadderPricePO);
                        if (uccLadderPriceInfo.getPrice() != null) {
                            uccLadderPricePO.setPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getPrice()).longValue()));
                        }
                        if (uccLadderPriceInfo.getStart() != null) {
                            uccLadderPricePO.setStart(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getStart()).longValue()));
                        }
                        if (uccLadderPriceInfo.getStop() != null) {
                            uccLadderPricePO.setStop(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getStop()).longValue()));
                        }
                        uccLadderPricePO.setId(Long.valueOf(this.sequence.nextId()));
                        uccLadderPricePO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        uccLadderPricePO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        uccLadderPricePOList.add(uccLadderPricePO);
                    }
                    this.uccLadderPriceMapper.batchInsert(uccLadderPricePOList);
                }
            }
            if (uccSkuEditDetailInfoBo.getTotalNum() != null) {
                this.updateStock(uccSkuEditDetailInfoBo, userName);
            }
        }
        if (uccSkuEditDetailInfoBo.getOperType() == 3) {
            uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            uccSkuPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            this.uccSkuMapper.deleteSkuBySkuId(uccSkuPo);
            uccSkuDetailPO = new UccSkuDetailPO();
            uccSkuDetailPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            uccSkuDetailPO.setCommodityId(uccSkuEditDetailInfoBo.getCommodityId());
            uccSkuDetailPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            this.uccSkuDetailMapper.deleteBy(uccSkuDetailPO);
            UccSkuPicPo uccSkuPicPo2 = new UccSkuPicPo();
            uccSkuPicPo2.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            uccSkuPicPo2.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            this.uccSkuPicMapper.deletePicBySkuId(uccSkuPicPo2);
            uccSkuExpandPo = new UccSkuExpandPo();
            uccSkuExpandPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            uccSkuExpandPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            this.uccSkuExpandMapper.deleteSkuExpand((UccSkuExpandPo)uccSkuExpandPo);
            UccSkuPricePo uccSkuPricePo2 = new UccSkuPricePo();
            uccSkuPricePo2.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            uccSkuPricePo2.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            this.uccSkuPriceMapper.deleteSkuPriceBySkuId(uccSkuPricePo2);
            UccLadderPricePO uccLadderPricePO2 = new UccLadderPricePO();
            uccLadderPricePO2.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            uccLadderPricePO2.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            this.uccLadderPriceMapper.deleteByExample(uccLadderPricePO2);
            UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
            uccSkuSpecPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            uccSkuSpecPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            this.uccSkuSpecMapper.deleteSkuSpec(uccSkuSpecPo);
            UccSaleNumPo uccSaleNumPo = new UccSaleNumPo();
            uccSaleNumPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            uccSaleNumPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            this.uccSaleNumMapper.delete(uccSaleNumPo);
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            uccSkuPutCirPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            this.uccSkuPutCirMapper.deleteSkuPutCirInfoBySkuId(uccSkuPutCirPo);
        }
    }

    private void updateEdit(UccSkuEditDetailInfoBo uccSkuEditDetailInfoBo, Timestamp time, String userId, String userName, Long orgId, String orgName) {
        UccSkuPicEditPO uccSkuPicEditPO;
        UccLadderPriceEditPO uccLadderPriceEditPO;
        UccSkuPicEditPO uccSkuPicEditPO2;
        Object uccSkuDetailEditPO;
        Long batchId = this.sequence.nextId();
        UccSkuEditPO skuEditPO1 = new UccSkuEditPO();
        UccSkuEditPO skuEditPO2 = null;
        if (uccSkuEditDetailInfoBo.getOperType() != 1) {
            skuEditPO1.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            skuEditPO1.setCommodityId(uccSkuEditDetailInfoBo.getCommodityId());
            skuEditPO1.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            skuEditPO2 = this.uccSkuEditMapper.getModelBy(skuEditPO1);
        }
        if (skuEditPO2 != null) {
            batchId = skuEditPO2.getBatchId();
        }
        if (uccSkuEditDetailInfoBo.getOperType() == 1) {
            Long skuId = this.sequence.nextId();
            UccSkuEditPO uccSkuEditPO = new UccSkuEditPO();
            BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo, (Object)uccSkuEditPO);
            uccSkuEditPO.setCreateOperName(userName);
            uccSkuEditPO.setCreateOperId(userId);
            uccSkuEditPO.setCreateTime((Date)time);
            uccSkuEditPO.setSkuId(skuId);
            uccSkuEditPO.setOrgId(orgId.toString());
            uccSkuEditPO.setOrgName(orgName);
            uccSkuEditPO.setCommodityId(uccSkuEditDetailInfoBo.getCommodityId());
            uccSkuEditPO.setSkuStatus(Integer.valueOf(0));
            uccSkuEditPO.setBatchId(batchId);
            if (uccSkuEditDetailInfoBo.getSkuPrice() != null) {
                uccSkuEditPO.setSkuPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuPrice()).longValue()));
            }
            this.uccSkuEditMapper.insert(uccSkuEditPO);
            uccSkuDetailEditPO = new UccSkuDetailEditPO();
            BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo, (Object)uccSkuDetailEditPO);
            uccSkuDetailEditPO.setSkuId(skuId);
            uccSkuDetailEditPO.setBatchId(batchId);
            this.uccSkuDetailEditMapper.insert((UccSkuDetailEditPO)uccSkuDetailEditPO);
            for (SkuInfoSpecBo skuInfoSpecBo : uccSkuEditDetailInfoBo.getSkuSpec()) {
                UccSkuSpecEditPO uccSkuSpecEditPO = new UccSkuSpecEditPO();
                BeanUtils.copyProperties((Object)skuInfoSpecBo, (Object)uccSkuSpecEditPO);
                uccSkuSpecEditPO.setOperType(Integer.valueOf(1));
                uccSkuSpecEditPO.setSkuSpecId(Long.valueOf(this.sequence.nextId()));
                uccSkuSpecEditPO.setSkuId(skuId);
                uccSkuSpecEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                uccSkuSpecEditPO.setCommodityId(uccSkuEditDetailInfoBo.getCommodityId());
                uccSkuSpecEditPO.setCreateOperId(userId);
                uccSkuSpecEditPO.setCreateTime((Date)time);
                uccSkuSpecEditPO.setBatchId(batchId);
                this.uccSkuSpecEditMapper.insert(uccSkuSpecEditPO);
            }
            for (EstoreSkuInfoImageBo estoreSkuInfoImageBo : uccSkuEditDetailInfoBo.getSkuImages()) {
                uccSkuPicEditPO2 = new UccSkuPicEditPO();
                BeanUtils.copyProperties((Object)estoreSkuInfoImageBo, (Object)uccSkuPicEditPO2);
                uccSkuPicEditPO2.setSkuPicId(Long.valueOf(this.sequence.nextId()));
                uccSkuPicEditPO2.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                uccSkuPicEditPO2.setSkuId(skuId);
                uccSkuPicEditPO2.setCreateOperId(userId);
                uccSkuPicEditPO2.setCreateTime((Date)time);
                uccSkuPicEditPO2.setBatchId(batchId);
                this.uccSkuPicEditMapper.insert(uccSkuPicEditPO2);
            }
            if (uccSkuEditDetailInfoBo.getSkuExpand() != null) {
                UccSkuExpandEditPO uccSkuExpandEditPO = new UccSkuExpandEditPO();
                BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuExpand(), (Object)uccSkuExpandEditPO);
                uccSkuExpandEditPO.setSkuId(skuId);
                uccSkuExpandEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                uccSkuExpandEditPO.setBatchId(batchId);
                this.uccSkuExpandEditMapper.insert(uccSkuExpandEditPO);
            }
            UccSkuPriceEditPO uccSkuPriceEditPO = new UccSkuPriceEditPO();
            BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuInfoPrice(), (Object)uccSkuPriceEditPO);
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMarketPrice() != null) {
                uccSkuPriceEditPO.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMarketPrice()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getAgreementPrice() != null) {
                uccSkuPriceEditPO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getAgreementPrice()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getSalePrice() != null) {
                uccSkuPriceEditPO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getSalePrice()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice1() != null) {
                uccSkuPriceEditPO.setMemberPrice1(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice1()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice2() != null) {
                uccSkuPriceEditPO.setMemberPrice2(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice2()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice3() != null) {
                uccSkuPriceEditPO.setMemberPrice3(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice3()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice4() != null) {
                uccSkuPriceEditPO.setMemberPrice4(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice4()).longValue()));
            }
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice5() != null) {
                uccSkuPriceEditPO.setMemberPrice5(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice5()).longValue()));
            }
            uccSkuPriceEditPO.setSkuId(skuId);
            uccSkuPriceEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            Long skuPriceId = this.sequence.nextId();
            uccSkuPriceEditPO.setSkuPriceId(skuPriceId);
            uccSkuPriceEditPO.setCreateOperId(userId);
            uccSkuPriceEditPO.setCreateTime((Date)time);
            uccSkuPriceEditPO.setBatchId(batchId);
            this.uccSkuPriceEditMapper.insert(uccSkuPriceEditPO);
            if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getSwitchOn() == 1 && uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo() != null && !uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo().isEmpty()) {
                ArrayList<UccLadderPriceEditPO> uccLadderPriceEditPOList = new ArrayList<UccLadderPriceEditPO>();
                for (UccLadderPriceInfo uccLadderPriceInfo : uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo()) {
                    uccLadderPriceEditPO = new UccLadderPriceEditPO();
                    BeanUtils.copyProperties((Object)uccLadderPriceInfo, (Object)uccLadderPriceEditPO);
                    if (uccLadderPriceInfo.getPrice() != null) {
                        uccLadderPriceEditPO.setPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getPrice()).longValue()));
                    }
                    if (uccLadderPriceInfo.getStart() != null) {
                        uccLadderPriceEditPO.setStart(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getStart()).longValue()));
                    }
                    if (uccLadderPriceInfo.getStop() != null) {
                        uccLadderPriceEditPO.setStop(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getStop()).longValue()));
                    }
                    uccLadderPriceEditPO.setSkuId(skuId);
                    uccLadderPriceEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    uccLadderPriceEditPO.setId(Long.valueOf(this.sequence.nextId()));
                    uccLadderPriceEditPO.setSkuPriceId(skuPriceId);
                    uccLadderPriceEditPO.setBatchId(batchId);
                    uccLadderPriceEditPOList.add(uccLadderPriceEditPO);
                }
                this.uccLadderPriceEditMapper.insertBatch(uccLadderPriceEditPOList);
            }
            UccSkuPutCirEditPO uccSkuPutCirEditPO = new UccSkuPutCirEditPO();
            uccSkuPutCirEditPO.setBatchId(batchId);
            uccSkuPutCirEditPO.setId(Long.valueOf(this.sequence.nextId()));
            uccSkuPutCirEditPO.setSkuId(skuId);
            uccSkuPutCirEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            if (uccSkuEditDetailInfoBo.getOnShelveWay() != null) {
                if (uccSkuEditDetailInfoBo.getOnShelveWay() == 0) {
                    uccSkuPutCirEditPO.setUpType(Integer.valueOf(1));
                } else {
                    uccSkuPutCirEditPO.setUpType(Integer.valueOf(2));
                    uccSkuPutCirEditPO.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                    if (uccSkuEditDetailInfoBo.getPreDownTime() != null) {
                        uccSkuPutCirEditPO.setPreDownTime(uccSkuEditDetailInfoBo.getPreDownTime());
                        uccSkuPutCirEditPO.setDownType(Integer.valueOf(2));
                    }
                }
            } else {
                throw new BusinessException("8888", "\u65b0\u589e\u65f6\u4e0a\u67b6\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            uccSkuPutCirEditPO.setState(Integer.valueOf(1));
            uccSkuPutCirEditPO.setCreateOperId(userId);
            uccSkuPutCirEditPO.setCreateTime((Date)time);
            this.uccSkuPutCirEditMapper.insert(uccSkuPutCirEditPO);
            UccSaleNumEditPO uccSaleNumEditPO = new UccSaleNumEditPO();
            uccSaleNumEditPO.setSaleId(Long.valueOf(this.sequence.nextId()));
            uccSaleNumEditPO.setSkuId(skuId);
            uccSaleNumEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            uccSaleNumEditPO.setCreateOperId(userId);
            uccSaleNumEditPO.setCreateTime((Date)time);
            uccSaleNumEditPO.setSoldNumber(new BigDecimal(0));
            uccSaleNumEditPO.setBatchId(batchId);
            this.uccSaleNumEditMapper.insert(uccSaleNumEditPO);
            if (uccSkuEditDetailInfoBo.getTotalNum() != null) {
                uccSkuEditDetailInfoBo.setSkuId(skuId);
                this.addStock(uccSkuEditDetailInfoBo, userName);
            } else {
                throw new ZTBusinessException("\u5355\u54c1\"" + uccSkuEditDetailInfoBo.getSkuId() + "\"\u7684\u5e93\u5b58\u4e3a\u7a7a");
            }
        }
        if (uccSkuEditDetailInfoBo.getOperType() == 2) {
            UccSkuExpandEditPO uccSkuExpandEditPO;
            if (skuEditPO2 != null) {
                UccSkuPriceEditPO where;
                UccSkuPicEditPO where2;
                uccSkuEditDetailInfoBo.setOperType(null);
                UccSkuEditPO skuEditPO = new UccSkuEditPO();
                BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo, (Object)skuEditPO);
                if (uccSkuEditDetailInfoBo.getSkuPrice() != null) {
                    skuEditPO.setSkuPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuPrice()).longValue()));
                }
                skuEditPO.setUpdateOperName(userName);
                skuEditPO.setUpdateOperId(userId);
                skuEditPO.setUpdateTime((Date)time);
                UccSkuEditPO temp = new UccSkuEditPO();
                temp.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                temp.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                temp.setCommodityId(uccSkuEditDetailInfoBo.getCommodityId());
                this.uccSkuEditMapper.updateBy(skuEditPO, temp);
                uccSkuDetailEditPO = new UccSkuDetailEditPO();
                BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo, (Object)uccSkuDetailEditPO);
                UccSkuDetailEditPO where1 = new UccSkuDetailEditPO();
                where1.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                where1.setCommodityId(uccSkuEditDetailInfoBo.getCommodityId());
                where1.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                this.uccSkuDetailEditMapper.updateBy((UccSkuDetailEditPO)uccSkuDetailEditPO, where1);
                if (uccSkuEditDetailInfoBo.getSkuImages() != null && !uccSkuEditDetailInfoBo.getSkuImages().isEmpty()) {
                    for (EstoreSkuInfoImageBo estoreSkuInfoImageBo : uccSkuEditDetailInfoBo.getSkuImages()) {
                        UccSkuPicEditPO uccSkuPicEditPO3 = new UccSkuPicEditPO();
                        BeanUtils.copyProperties((Object)estoreSkuInfoImageBo, (Object)uccSkuPicEditPO3);
                        uccSkuPicEditPO3.setUpdateOperId(userId);
                        uccSkuPicEditPO3.setUpdateTime((Date)time);
                        where2 = new UccSkuPicEditPO();
                        where2.setSkuPicId(estoreSkuInfoImageBo.getSkuPicId());
                        where2.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        this.uccSkuPicEditMapper.updateBy(uccSkuPicEditPO3, where2);
                    }
                }
                if (uccSkuEditDetailInfoBo.getSkuExpand() != null) {
                    UccSkuExpandEditPO skuExpandEditPO;
                    uccSkuExpandEditPO = new UccSkuExpandEditPO();
                    uccSkuExpandEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuExpandEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    UccSkuExpandEditPO temp2 = this.uccSkuExpandEditMapper.getModelBy(uccSkuExpandEditPO);
                    if (temp2 != null) {
                        skuExpandEditPO = new UccSkuExpandEditPO();
                        BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuExpand(), (Object)skuExpandEditPO);
                        where2 = new UccSkuExpandEditPO();
                        where2.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        where2.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        this.uccSkuExpandEditMapper.updateBy(skuExpandEditPO, (UccSkuExpandEditPO)where2);
                    } else {
                        skuExpandEditPO = new UccSkuExpandEditPO();
                        BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuExpand(), (Object)skuExpandEditPO);
                        skuExpandEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        skuExpandEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        skuExpandEditPO.setBatchId(batchId);
                        this.uccSkuExpandEditMapper.insert(skuExpandEditPO);
                    }
                }
                if (uccSkuEditDetailInfoBo.getSkuInfoPrice() != null) {
                    UccSkuPriceEditPO uccSkuPriceEditPO = new UccSkuPriceEditPO();
                    BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuInfoPrice(), (Object)uccSkuPriceEditPO);
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMarketPrice() != null) {
                        uccSkuPriceEditPO.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMarketPrice()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getAgreementPrice() != null) {
                        uccSkuPriceEditPO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getAgreementPrice()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getSalePrice() != null) {
                        uccSkuPriceEditPO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getSalePrice()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice1() != null) {
                        uccSkuPriceEditPO.setMemberPrice1(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice1()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice2() != null) {
                        uccSkuPriceEditPO.setMemberPrice2(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice2()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice3() != null) {
                        uccSkuPriceEditPO.setMemberPrice3(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice3()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice4() != null) {
                        uccSkuPriceEditPO.setMemberPrice4(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice4()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice5() != null) {
                        uccSkuPriceEditPO.setMemberPrice5(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice5()).longValue()));
                    }
                    UccSkuPriceEditPO temp1 = new UccSkuPriceEditPO();
                    temp1.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    temp1.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    UccSkuPriceEditPO uccSkuPriceEditPO1 = this.uccSkuPriceEditMapper.getModelBy(temp1);
                    Long priceId = uccSkuPriceEditPO1.getSkuPriceId();
                    uccSkuPriceEditPO.setUpdateOperId(userId);
                    uccSkuPriceEditPO.setUpdateTime((Date)time);
                    where = new UccSkuPriceEditPO();
                    where.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    where.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuPriceEditMapper.updateBy(uccSkuPriceEditPO, where);
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getSwitchOn() != null && uccSkuEditDetailInfoBo.getSkuInfoPrice().getSwitchOn() == 1 && uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo() != null && !uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo().isEmpty()) {
                        UccLadderPriceEditPO delete = new UccLadderPriceEditPO();
                        delete.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        delete.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        this.uccLadderPriceEditMapper.deleteBy(delete);
                        ArrayList<UccLadderPriceEditPO> uccLadderPriceEditPOList = new ArrayList<UccLadderPriceEditPO>();
                        for (UccLadderPriceInfo uccLadderPriceInfo : uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo()) {
                            UccLadderPriceEditPO uccLadderPriceEditPO2 = new UccLadderPriceEditPO();
                            BeanUtils.copyProperties((Object)uccLadderPriceInfo, (Object)uccLadderPriceEditPO2);
                            uccLadderPriceEditPO2.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                            uccLadderPriceEditPO2.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                            uccLadderPriceEditPO2.setSkuPriceId(priceId);
                            if (uccLadderPriceInfo.getPrice() != null) {
                                uccLadderPriceEditPO2.setPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getPrice()).longValue()));
                            }
                            if (uccLadderPriceInfo.getStart() != null) {
                                uccLadderPriceEditPO2.setStart(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getStart()).longValue()));
                            }
                            if (uccLadderPriceInfo.getStop() != null) {
                                uccLadderPriceEditPO2.setStop(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getStop()).longValue()));
                            }
                            uccLadderPriceEditPO2.setBatchId(batchId);
                            uccLadderPriceEditPO2.setId(Long.valueOf(this.sequence.nextId()));
                            uccLadderPriceEditPOList.add(uccLadderPriceEditPO2);
                        }
                        this.uccLadderPriceEditMapper.insertBatch(uccLadderPriceEditPOList);
                    }
                }
                if (uccSkuEditDetailInfoBo.getOnShelveWay() != null || uccSkuEditDetailInfoBo.getPreUpTime() != null || uccSkuEditDetailInfoBo.getPreDownTime() != null) {
                    UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
                    uccSkuPutCirPo.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPutCirPo.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    uccSkuPutCirPo.setState(Integer.valueOf(1));
                    List uccSkuPutCirPoList = this.uccSkuPutCirMapper.querySkuPutCir(uccSkuPutCirPo);
                    UccSkuPutCirEditPO skuPutCirEditPO = new UccSkuPutCirEditPO();
                    skuPutCirEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    skuPutCirEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    skuPutCirEditPO.setState(Integer.valueOf(1));
                    UccSkuPutCirEditPO uccSkuPutCirEditPO = this.uccSkuPutCirEditMapper.getModelBy(skuPutCirEditPO);
                    if (CollectionUtils.isEmpty((Collection)uccSkuPutCirPoList) && uccSkuPutCirEditPO != null || CollectionUtils.isNotEmpty((Collection)uccSkuPutCirPoList) && uccSkuPutCirEditPO != null) {
                        if (uccSkuEditDetailInfoBo.getOnShelveWay() != null) {
                            if (uccSkuEditDetailInfoBo.getOnShelveWay() == 0) {
                                uccSkuPutCirEditPO.setUpType(Integer.valueOf(1));
                            } else {
                                uccSkuPutCirEditPO.setUpType(Integer.valueOf(2));
                            }
                        }
                        if (uccSkuEditDetailInfoBo.getPreUpTime() != null) {
                            uccSkuPutCirEditPO.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                        }
                        if (uccSkuEditDetailInfoBo.getPreUpTime() != null) {
                            uccSkuPutCirEditPO.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                        }
                        uccSkuPutCirEditPO.setId(Long.valueOf(this.sequence.nextId()));
                        uccSkuPutCirEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        uccSkuPutCirEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        uccSkuPutCirEditPO.setState(Integer.valueOf(1));
                        uccSkuPutCirEditPO.setCreateOperId(userId);
                        uccSkuPutCirEditPO.setCreateTime((Date)time);
                        uccSkuPutCirEditPO.setBatchId(batchId);
                        where = new UccSkuPutCirEditPO();
                        where.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        where.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        this.uccSkuPutCirEditMapper.updateBy(uccSkuPutCirEditPO, (UccSkuPutCirEditPO)where);
                    } else if (CollectionUtils.isNotEmpty((Collection)uccSkuPutCirPoList) && uccSkuPutCirEditPO == null) {
                        uccSkuPutCirPo = (UccSkuPutCirPo)uccSkuPutCirPoList.get(0);
                        UccSkuPutCirEditPO set = new UccSkuPutCirEditPO();
                        BeanUtils.copyProperties((Object)uccSkuPutCirPo, (Object)set);
                        if (uccSkuEditDetailInfoBo.getOnShelveWay() != null) {
                            if (uccSkuEditDetailInfoBo.getOnShelveWay() == 0) {
                                set.setUpType(Integer.valueOf(1));
                            } else {
                                set.setUpType(Integer.valueOf(2));
                            }
                        }
                        if (uccSkuEditDetailInfoBo.getPreUpTime() != null) {
                            set.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                        }
                        if (uccSkuEditDetailInfoBo.getPreUpTime() != null) {
                            set.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                        }
                        set.setId(Long.valueOf(this.sequence.nextId()));
                        set.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        set.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        set.setState(Integer.valueOf(1));
                        set.setCreateOperId(userId);
                        set.setCreateTime((Date)time);
                        set.setBatchId(batchId);
                        this.uccSkuPutCirEditMapper.insert(set);
                    } else {
                        UccSkuPutCirEditPO uccSkuPutCirEditPO2 = new UccSkuPutCirEditPO();
                        uccSkuPutCirEditPO2.setId(Long.valueOf(this.sequence.nextId()));
                        uccSkuPutCirEditPO2.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        uccSkuPutCirEditPO2.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        if (uccSkuEditDetailInfoBo.getOnShelveWay() != null) {
                            if (uccSkuEditDetailInfoBo.getOnShelveWay() == 0) {
                                uccSkuPutCirEditPO2.setUpType(Integer.valueOf(1));
                            } else {
                                uccSkuPutCirEditPO2.setUpType(Integer.valueOf(2));
                                uccSkuPutCirEditPO2.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                                if (uccSkuEditDetailInfoBo.getPreDownTime() != null) {
                                    uccSkuPutCirEditPO2.setPreDownTime(uccSkuEditDetailInfoBo.getPreDownTime());
                                    uccSkuPutCirEditPO2.setDownType(Integer.valueOf(2));
                                }
                            }
                        } else {
                            throw new BusinessException("8888", "\u65b0\u589e\u4e0a\u67b6\u5468\u671f\u65f6\u4e0a\u67b6\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        uccSkuPutCirEditPO2.setState(Integer.valueOf(1));
                        uccSkuPutCirEditPO2.setCreateOperId(userId);
                        uccSkuPutCirEditPO2.setCreateTime((Date)time);
                        uccSkuPutCirEditPO2.setBatchId(batchId);
                        this.uccSkuPutCirEditMapper.insert(uccSkuPutCirEditPO2);
                    }
                }
                if (uccSkuEditDetailInfoBo.getTotalNum() != null) {
                    this.updateStock(uccSkuEditDetailInfoBo, userName);
                }
                uccSkuEditDetailInfoBo.setOperType(Integer.valueOf(2));
            } else {
                UccSkuEditPO uccSkuEditPO2 = new UccSkuEditPO();
                BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo, (Object)uccSkuEditPO2);
                if (uccSkuEditDetailInfoBo.getSkuPrice() != null) {
                    uccSkuEditPO2.setSkuPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuPrice()).longValue()));
                }
                uccSkuEditPO2.setUpdateOperName(userName);
                uccSkuEditPO2.setUpdateOperId(userId);
                uccSkuEditPO2.setUpdateTime((Date)time);
                uccSkuEditPO2.setBatchId(batchId);
                this.uccSkuEditMapper.insert(uccSkuEditPO2);
                UccSkuDetailEditPO uccSkuDetailEditPO2 = new UccSkuDetailEditPO();
                BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo, (Object)uccSkuDetailEditPO2);
                uccSkuDetailEditPO2.setBatchId(batchId);
                this.uccSkuDetailEditMapper.insert(uccSkuDetailEditPO2);
                if (uccSkuEditDetailInfoBo.getSkuSpec() != null && !uccSkuEditDetailInfoBo.getSkuSpec().isEmpty()) {
                    for (SkuInfoSpecBo skuInfoSpecBo : uccSkuEditDetailInfoBo.getSkuSpec()) {
                        UccSkuSpecEditPO uccSkuSpecEditPO = new UccSkuSpecEditPO();
                        BeanUtils.copyProperties((Object)skuInfoSpecBo, (Object)uccSkuSpecEditPO);
                        uccSkuSpecEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        uccSkuSpecEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        uccSkuSpecEditPO.setUpdateOperId(userId);
                        uccSkuSpecEditPO.setUpdateTime((Date)time);
                        uccSkuSpecEditPO.setBatchId(batchId);
                        this.uccSkuSpecEditMapper.insert(uccSkuSpecEditPO);
                    }
                }
                if (uccSkuEditDetailInfoBo.getSkuImages() != null && !uccSkuEditDetailInfoBo.getSkuImages().isEmpty()) {
                    for (EstoreSkuInfoImageBo estoreSkuInfoImageBo : uccSkuEditDetailInfoBo.getSkuImages()) {
                        uccSkuPicEditPO = new UccSkuPicEditPO();
                        BeanUtils.copyProperties((Object)estoreSkuInfoImageBo, (Object)uccSkuPicEditPO);
                        uccSkuPicEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        uccSkuPicEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        uccSkuPicEditPO.setUpdateOperId(userId);
                        uccSkuPicEditPO.setUpdateTime((Date)time);
                        uccSkuPicEditPO.setBatchId(batchId);
                        this.uccSkuPicEditMapper.insert(uccSkuPicEditPO);
                    }
                } else {
                    throw new ZTBusinessException("\u7b2c\u4e00\u6b21\u4fee\u6539\u65f6\u5fc5\u987b\u4f20\u5165skuImages");
                }
                if (uccSkuEditDetailInfoBo.getSkuExpand() != null) {
                    UccSkuExpandEditPO skuExpandEditPO = new UccSkuExpandEditPO();
                    skuExpandEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    skuExpandEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    UccSkuExpandEditPO skuExpandEditPO1 = this.uccSkuExpandEditMapper.getModelBy(skuExpandEditPO);
                    if (skuExpandEditPO1 == null) {
                        uccSkuExpandEditPO = new UccSkuExpandEditPO();
                        BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuExpand(), (Object)uccSkuExpandEditPO);
                        uccSkuExpandEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        uccSkuExpandEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        uccSkuExpandEditPO.setBatchId(batchId);
                        this.uccSkuExpandEditMapper.insert(uccSkuExpandEditPO);
                    } else {
                        uccSkuExpandEditPO = new UccSkuExpandEditPO();
                        BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuExpand(), (Object)uccSkuExpandEditPO);
                        UccSkuExpandEditPO where = new UccSkuExpandEditPO();
                        where.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                        where.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                        this.uccSkuExpandEditMapper.updateBy(uccSkuExpandEditPO, where);
                    }
                }
                if (uccSkuEditDetailInfoBo.getSkuInfoPrice() != null) {
                    UccSkuPriceEditPO uccSkuPriceEditPO = new UccSkuPriceEditPO();
                    BeanUtils.copyProperties((Object)uccSkuEditDetailInfoBo.getSkuInfoPrice(), (Object)uccSkuPriceEditPO);
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMarketPrice() != null) {
                        uccSkuPriceEditPO.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMarketPrice()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getAgreementPrice() != null) {
                        uccSkuPriceEditPO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getAgreementPrice()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getSalePrice() != null) {
                        uccSkuPriceEditPO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getSalePrice()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice1() != null) {
                        uccSkuPriceEditPO.setMemberPrice1(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice1()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice2() != null) {
                        uccSkuPriceEditPO.setMemberPrice2(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice2()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice3() != null) {
                        uccSkuPriceEditPO.setMemberPrice3(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice3()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice4() != null) {
                        uccSkuPriceEditPO.setMemberPrice4(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice4()).longValue()));
                    }
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice5() != null) {
                        uccSkuPriceEditPO.setMemberPrice5(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccSkuEditDetailInfoBo.getSkuInfoPrice().getMemberPrice5()).longValue()));
                    }
                    UccSkuPricePo temp = new UccSkuPricePo();
                    temp.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    temp.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    UccSkuPricePo uccSkuPricePo = this.uccSkuPriceMapper.querySkuPrice(temp);
                    Long priceId = uccSkuPricePo.getSkuPriceId();
                    uccSkuPriceEditPO.setSkuPriceId(priceId);
                    uccSkuPriceEditPO.setUpdateOperId(userId);
                    uccSkuPriceEditPO.setUpdateTime((Date)time);
                    uccSkuPriceEditPO.setBatchId(batchId);
                    uccSkuPriceEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPriceEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuPriceEditMapper.insert(uccSkuPriceEditPO);
                    if (uccSkuEditDetailInfoBo.getSkuInfoPrice().getSwitchOn() == 1 && uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo() != null && !uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo().isEmpty()) {
                        ArrayList<UccLadderPriceEditPO> uccLadderPriceEditPOList = new ArrayList<UccLadderPriceEditPO>();
                        for (UccLadderPriceInfo uccLadderPriceInfo : uccSkuEditDetailInfoBo.getSkuInfoPrice().getLadderPriceInfo()) {
                            UccLadderPriceEditPO uccLadderPriceEditPO3 = new UccLadderPriceEditPO();
                            BeanUtils.copyProperties((Object)uccLadderPriceInfo, (Object)uccLadderPriceEditPO3);
                            if (uccLadderPriceInfo.getPrice() != null) {
                                uccLadderPriceEditPO3.setPrice(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getPrice()).longValue()));
                            }
                            if (uccLadderPriceInfo.getStart() != null) {
                                uccLadderPriceEditPO3.setStart(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getStart()).longValue()));
                            }
                            if (uccLadderPriceInfo.getStop() != null) {
                                uccLadderPriceEditPO3.setStop(Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)uccLadderPriceInfo.getStop()).longValue()));
                            }
                            uccLadderPriceEditPO3.setId(Long.valueOf(this.sequence.nextId()));
                            uccLadderPriceEditPO3.setSkuPriceId(priceId);
                            uccLadderPriceEditPO3.setBatchId(batchId);
                            uccLadderPriceEditPO3.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                            uccLadderPriceEditPO3.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                            uccLadderPriceEditPOList.add(uccLadderPriceEditPO3);
                        }
                        this.uccLadderPriceEditMapper.insertBatch(uccLadderPriceEditPOList);
                    }
                } else {
                    throw new ZTBusinessException("\u7b2c\u4e00\u6b21\u4fee\u6539\u65f6\u5fc5\u987b\u4f20\u5165skuInfoPrice");
                }
                if (uccSkuEditDetailInfoBo.getOnShelveWay() != null || uccSkuEditDetailInfoBo.getOnShelveTime() != null) {
                    UccSkuPutCirEditPO uccSkuPutCirEditPO = new UccSkuPutCirEditPO();
                    uccSkuPutCirEditPO.setBatchId(batchId);
                    uccSkuPutCirEditPO.setId(Long.valueOf(this.sequence.nextId()));
                    uccSkuPutCirEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPutCirEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    if (uccSkuEditDetailInfoBo.getOnShelveWay() != null) {
                        if (uccSkuEditDetailInfoBo.getOnShelveWay() == 0) {
                            uccSkuPutCirEditPO.setUpType(Integer.valueOf(1));
                        } else {
                            uccSkuPutCirEditPO.setUpType(Integer.valueOf(2));
                        }
                    }
                    if (uccSkuEditDetailInfoBo.getPreUpTime() != null) {
                        uccSkuPutCirEditPO.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                    }
                    if (uccSkuEditDetailInfoBo.getPreUpTime() != null) {
                        uccSkuPutCirEditPO.setPreUpTime(uccSkuEditDetailInfoBo.getPreUpTime());
                    }
                    uccSkuPutCirEditPO.setPreUpTime(uccSkuEditDetailInfoBo.getOnShelveTime());
                    uccSkuPutCirEditPO.setState(Integer.valueOf(1));
                    uccSkuPutCirEditPO.setCreateOperId(userId);
                    uccSkuPutCirEditPO.setCreateTime((Date)time);
                    this.uccSkuPutCirEditMapper.insert(uccSkuPutCirEditPO);
                }
                if (uccSkuEditDetailInfoBo.getTotalNum() != null) {
                    this.updateStock(uccSkuEditDetailInfoBo, userName);
                }
            }
        }
        if (uccSkuEditDetailInfoBo.getOperType() == 3) {
            UccSkuEditPO skuEditPO;
            UccSkuEditPO uccSkuEditPO = new UccSkuEditPO();
            uccSkuEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
            uccSkuEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
            UccSkuEditPO result = this.uccSkuEditMapper.getModelBy(uccSkuEditPO);
            if (result != null) {
                if (result.getOperType() == 1) {
                    skuEditPO = new UccSkuEditPO();
                    skuEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    skuEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuEditMapper.deleteBy(skuEditPO);
                    UccSkuDetailEditPO uccSkuDetailEditPO3 = new UccSkuDetailEditPO();
                    uccSkuDetailEditPO3.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuDetailEditPO3.setCommodityId(uccSkuEditDetailInfoBo.getCommodityId());
                    uccSkuDetailEditPO3.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuDetailEditMapper.deleteBy(uccSkuDetailEditPO3);
                    uccSkuPicEditPO = new UccSkuPicEditPO();
                    uccSkuPicEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPicEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuPicEditMapper.deleteBy(uccSkuPicEditPO);
                    UccSkuExpandEditPO uccSkuExpandEditPO = new UccSkuExpandEditPO();
                    uccSkuExpandEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuExpandEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuExpandEditMapper.deleteBy(uccSkuExpandEditPO);
                    UccSkuPriceEditPO uccSkuPriceEditPO = new UccSkuPriceEditPO();
                    uccSkuPriceEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPriceEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuPriceEditMapper.deleteBy(uccSkuPriceEditPO);
                    UccLadderPriceEditPO uccLadderPriceEditPO4 = new UccLadderPriceEditPO();
                    uccLadderPriceEditPO4.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccLadderPriceEditPO4.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccLadderPriceEditMapper.deleteBy(uccLadderPriceEditPO4);
                    UccSkuSpecEditPO uccSkuSpecEditPO = new UccSkuSpecEditPO();
                    uccSkuSpecEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuSpecEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuSpecEditMapper.deleteBy(uccSkuSpecEditPO);
                    UccSaleNumEditPO uccSaleNumEditPO = new UccSaleNumEditPO();
                    uccSaleNumEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSaleNumEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSaleNumEditMapper.deleteBy(uccSaleNumEditPO);
                    UccSkuPutCirEditPO uccSkuPutCirEditPO = new UccSkuPutCirEditPO();
                    uccSkuPutCirEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPutCirEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuPutCirEditMapper.deleteBy(uccSkuPutCirEditPO);
                }
                if (result.getOperType() == 2) {
                    UccSkuEditPO skuEditPO3 = new UccSkuEditPO();
                    skuEditPO3.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    skuEditPO3.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuEditMapper.deleteBy(skuEditPO3);
                    UccSkuEditPO skuEditPO4 = new UccSkuEditPO();
                    skuEditPO4.setBatchId(result.getBatchId());
                    skuEditPO4.setSkuId(result.getSkuId());
                    skuEditPO4.setSupplierShopId(result.getSupplierShopId());
                    skuEditPO4.setUpdateOperName(userName);
                    skuEditPO4.setUpdateOperId(userId);
                    skuEditPO4.setUpdateTime((Date)time);
                    skuEditPO4.setOperType(uccSkuEditDetailInfoBo.getOperType());
                    skuEditPO4.setSell(uccSkuEditDetailInfoBo.getSell());
                    this.uccSkuEditMapper.insert(skuEditPO4);
                    UccSkuDetailEditPO uccSkuDetailEditPO4 = new UccSkuDetailEditPO();
                    uccSkuDetailEditPO4.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuDetailEditPO4.setCommodityId(uccSkuEditDetailInfoBo.getCommodityId());
                    uccSkuDetailEditPO4.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuDetailEditMapper.deleteBy(uccSkuDetailEditPO4);
                    uccSkuPicEditPO2 = new UccSkuPicEditPO();
                    uccSkuPicEditPO2.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPicEditPO2.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuPicEditMapper.deleteBy(uccSkuPicEditPO2);
                    UccSkuExpandEditPO uccSkuExpandEditPO = new UccSkuExpandEditPO();
                    uccSkuExpandEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuExpandEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuExpandEditMapper.deleteBy(uccSkuExpandEditPO);
                    UccSkuPriceEditPO uccSkuPriceEditPO = new UccSkuPriceEditPO();
                    uccSkuPriceEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPriceEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuPriceEditMapper.deleteBy(uccSkuPriceEditPO);
                    uccLadderPriceEditPO = new UccLadderPriceEditPO();
                    uccLadderPriceEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccLadderPriceEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccLadderPriceEditMapper.deleteBy(uccLadderPriceEditPO);
                    UccSkuSpecEditPO uccSkuSpecEditPO = new UccSkuSpecEditPO();
                    uccSkuSpecEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuSpecEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuSpecEditMapper.deleteBy(uccSkuSpecEditPO);
                    UccSaleNumEditPO uccSaleNumEditPO = new UccSaleNumEditPO();
                    uccSaleNumEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSaleNumEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSaleNumEditMapper.deleteBy(uccSaleNumEditPO);
                    UccSkuPutCirEditPO uccSkuPutCirEditPO = new UccSkuPutCirEditPO();
                    uccSkuPutCirEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                    uccSkuPutCirEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                    this.uccSkuPutCirEditMapper.deleteBy(uccSkuPutCirEditPO);
                }
            } else {
                skuEditPO = new UccSkuEditPO();
                skuEditPO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
                skuEditPO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
                skuEditPO.setCommodityId(uccSkuEditDetailInfoBo.getCommodityId());
                skuEditPO.setUpdateOperName(userName);
                skuEditPO.setUpdateOperId(userId);
                skuEditPO.setUpdateTime((Date)time);
                skuEditPO.setOperType(uccSkuEditDetailInfoBo.getOperType());
                skuEditPO.setSell(uccSkuEditDetailInfoBo.getSell());
                skuEditPO.setBatchId(batchId);
                this.uccSkuEditMapper.insert(skuEditPO);
            }
        }
    }

    private void addStock(UccSkuEditDetailInfoBo uccSkuEditDetailInfoBo, String userName) {
        try {
            SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
            smcsdkOperateStockNumReqBO.setOperateType("10");
            smcsdkOperateStockNumReqBO.setOperateNo(userName);
            ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
            SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
            if (uccSkuEditDetailInfoBo.getTotalNum() != null) {
                smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)uccSkuEditDetailInfoBo.getTotalNum())));
            } else {
                smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(0L));
            }
            smcsdkStockNumInfoBO.setSkuId(String.valueOf(uccSkuEditDetailInfoBo.getSkuId()));
            smcsdkStockNumInfoBO.setSupplierId(uccSkuEditDetailInfoBo.getSupplierShopId().toString());
            smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
            smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
            smcsdkOperateStockNumReqBO.setObjectId(String.valueOf(uccSkuEditDetailInfoBo.getCommodityId()));
            smcsdkOperateStockNumReqBO.setObjectType("10");
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
            SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
            if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                throw new ZTBusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_ADD_FAIL.code() + smcsdkOperateStockNumRspBO.getRespDesc());
            }
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
        }
        catch (Exception e) {
            throw new ZTBusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_ADD_FAIL.code() + e.getMessage());
        }
    }

    private void updateStock(UccSkuEditDetailInfoBo uccSkuEditDetailInfoBo, String userName) {
        UccIteminstockEditAbilityReqBO uccIteminstockEditAbilityReqBO = new UccIteminstockEditAbilityReqBO();
        ArrayList<UccIteminstockEditBO> batchStock = new ArrayList<UccIteminstockEditBO>();
        UccIteminstockEditBO uccIteminstockEditBO = new UccIteminstockEditBO();
        uccIteminstockEditBO.setSkuId(uccSkuEditDetailInfoBo.getSkuId());
        uccIteminstockEditBO.setSupplierShopId(uccSkuEditDetailInfoBo.getSupplierShopId());
        BigDecimal oldTotalNum = this.queryStock(uccSkuEditDetailInfoBo);
        if (oldTotalNum == null || oldTotalNum.longValue() == 0L) {
            this.addStock(uccSkuEditDetailInfoBo, userName);
        } else {
            UccIteminstockEditAbilityRspBO uccIteminstockEditAbilityRspBO;
            if (uccSkuEditDetailInfoBo.getTotalNum().longValue() > oldTotalNum.longValue()) {
                uccIteminstockEditBO.setOperTupe(Integer.valueOf(1));
                uccIteminstockEditBO.setNum(Long.valueOf(uccSkuEditDetailInfoBo.getTotalNum().longValue() - oldTotalNum.longValue()));
            } else if (uccSkuEditDetailInfoBo.getTotalNum().longValue() < oldTotalNum.longValue()) {
                uccIteminstockEditBO.setOperTupe(Integer.valueOf(0));
                uccIteminstockEditBO.setNum(Long.valueOf(oldTotalNum.longValue() - uccSkuEditDetailInfoBo.getTotalNum().longValue()));
            } else {
                return;
            }
            batchStock.add(uccIteminstockEditBO);
            uccIteminstockEditAbilityReqBO.setBatchStock(batchStock);
            uccIteminstockEditAbilityReqBO.setUsername(userName);
            try {
                uccIteminstockEditAbilityRspBO = this.uccIteminstockEditAbilityService.dealUccIteminstockEdit(uccIteminstockEditAbilityReqBO);
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u5e93\u5b58\u4fee\u6539\u5931\u8d25\uff1a" + e.getMessage());
            }
            if ("0000".equals(uccIteminstockEditAbilityRspBO.getRespCode())) {
                log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u4fee\u6539\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)uccIteminstockEditAbilityRspBO));
            } else {
                throw new ZTBusinessException("\u5e93\u5b58\u4fee\u6539\u51fa\u9519\uff1a" + uccIteminstockEditAbilityRspBO.getRespDesc());
            }
        }
    }

    private BigDecimal queryStock(UccSkuEditDetailInfoBo uccSkuEditDetailInfoBo) {
        try {
            SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
            smcsdkQryStockNumReqBO.setSkuIds((List)Lists.newArrayList((Object[])new Long[]{uccSkuEditDetailInfoBo.getSkuId()}));
            SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
            log.info("\u7b80\u7248\u5e93\u5b58\uff1a" + JSONObject.toJSONString((Object)smcsdkQryStockNumRspBO));
            if ("0000".equals(smcsdkQryStockNumRspBO.getRespCode())) {
                Map getMap = smcsdkQryStockNumRspBO.getSkuStockNumMap();
                if (getMap != null) {
                    if (getMap.containsKey(uccSkuEditDetailInfoBo.getSkuId())) {
                        return MoneyUtils.haoToYuan((Long)((Long)getMap.get(uccSkuEditDetailInfoBo.getSkuId())));
                    }
                    return null;
                }
                return null;
            }
            log.error("\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
            throw new BusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_QRY_FAIL.code(), "\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
    }
}

