/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.tydic.commodity.base.bo.UmcStationWebBO;
import com.tydic.commodity.common.atom.api.UccQueryProcessStepAtomService;
import com.tydic.commodity.common.atom.bo.UccQueryProcessStepAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccQueryProcessStepAtomRspBO;
import com.tydic.osworkflow.engine.element.CustomAttribute;
import com.tydic.osworkflow.engine.element.ProcDefAndParsingInfo;
import com.tydic.osworkflow.engine.element.Step;
import com.tydic.osworkflow.engine.inside.OsworkflowXmlParseService;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccQueryProcessStepAtomServiceImpl
implements UccQueryProcessStepAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccQueryProcessStepAtomServiceImpl.class);
    @Autowired
    private OsworkflowXmlParseService osworkflowXmlParseService;
    @Value(value="${ARG_EDIT_PROCESS_DEF_ID}")
    private String slefEditProcess;

    @Override
    public UccQueryProcessStepAtomRspBO qeryStep(UccQueryProcessStepAtomReqBO reqBO) {
        UccQueryProcessStepAtomRspBO rspBO = new UccQueryProcessStepAtomRspBO();
        if (reqBO.getObjType() == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        String procDefId = "";
        ArrayList<String> stationIds = new ArrayList<String>();
        for (UmcStationWebBO each : reqBO.getUmcStationsListWebExt()) {
            stationIds.add(each.getStationId().toString());
        }
        if (reqBO.getObjType() == 1) {
            if (StringUtils.isEmpty((Object)this.slefEditProcess)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u672a\u914d\u7f6e\u7f16\u8f91\u5ba1\u6279");
                return rspBO;
            }
            procDefId = this.slefEditProcess;
        }
        ArrayList<String> step = new ArrayList<String>();
        ProcDefAndParsingInfo procDefAndParsingInfo = this.osworkflowXmlParseService.getProcDefAndParsingInfoByProcDefId(procDefId);
        if (procDefAndParsingInfo.getWorkflow() != null) {
            if (CollectionUtils.isEmpty((Collection)procDefAndParsingInfo.getWorkflow().getSteps())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
            for (Step each : procDefAndParsingInfo.getWorkflow().getSteps()) {
                if (CollectionUtils.isEmpty((Collection)each.getCustomAttributes())) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    return rspBO;
                }
                for (CustomAttribute customAttribute : each.getCustomAttributes()) {
                    if (!stationIds.contains(customAttribute.getAttributeName())) continue;
                    step.add(customAttribute.getAttributeName());
                }
            }
            rspBO.setStep(step);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

