/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.CommodityStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirLogAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirLogReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirLogRspBO;
import com.tydic.commodity.common.atom.api.UccSkuLogRecordAtomService;
import com.tydic.commodity.common.atom.api.UccSkuUpAtomService;
import com.tydic.commodity.common.atom.bo.UccSkuLogRecordReqBO;
import com.tydic.commodity.common.atom.bo.UccSkuLogRecordRspBO;
import com.tydic.commodity.common.atom.bo.UccSkuUpReqBO;
import com.tydic.commodity.common.atom.bo.UccSkuUpRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UccSkuUpAtomServiceImpl
implements UccSkuUpAtomService {
    @Autowired
    private UccSkuPutCirLogAtomService uccSkuPutCirLogAtomService;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private UccSkuLogRecordAtomService uccSkuLogRecordAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccSkuUpAtomServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    @Override
    public UccSkuUpRspBO dealSkuUp(UccSkuUpReqBO reqBO) {
        UccSkuUpRspBO rspBO = new UccSkuUpRspBO();
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(s);
            return rspBO;
        }
        Long nextId = 0L;
        try {
            nextId = this.uccBatchSequence.nextId();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException("\u751f\u6210\u6279\u6b21\u53f7\u5f02\u5e38");
        }
        try {
            UccSkuPutCirLogReqBO uccSkuPutCirLogReqBO = new UccSkuPutCirLogReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuPutCirLogReqBO);
            uccSkuPutCirLogReqBO.setBatchId(nextId);
            UccSkuPutCirLogRspBO uccSkuPutCirLogRspBO = this.uccSkuPutCirLogAtomService.addSkuPutCirLog(uccSkuPutCirLogReqBO);
            if ("8888".equals(uccSkuPutCirLogRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)uccSkuPutCirLogRspBO, (Object)((Object)rspBO));
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException("\u4e0a\u4e0b\u67b6\u5468\u671f\u65e5\u5fd7\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
        }
        UccSkuPutCirPo skuPutCirPo = new UccSkuPutCirPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)skuPutCirPo);
        skuPutCirPo.setState(Integer.valueOf(2));
        try {
            this.uccSkuPutCirMapper.modifyBySkuId(skuPutCirPo);
            Date preDownTime = null;
            if (reqBO.getPreDownTime() != null && !reqBO.getPreDownTime().equals("")) {
                String preDownTime1 = reqBO.getPreDownTime();
                preDownTime = DateUtils.strToDate((String)preDownTime1);
                skuPutCirPo.setPreDownTime(preDownTime);
                skuPutCirPo.setDownType(Integer.valueOf(2));
            } else {
                preDownTime = DateUtils.strToDate((String)"2035-12-31 10:12:35");
                skuPutCirPo.setPreDownTime(preDownTime);
            }
            if (reqBO.getPreUpTime() != null && !reqBO.getPreUpTime().equals("")) {
                Date preUpTime = null;
                String preUpTime1 = reqBO.getPreUpTime();
                preUpTime = DateUtils.strToDate((String)preUpTime1);
                skuPutCirPo.setPreUpTime(preUpTime);
            }
            skuPutCirPo.setState(Integer.valueOf(1));
            skuPutCirPo.setRealUpTime(new Date());
            skuPutCirPo.setId(Long.valueOf(this.uccBatchSequence.nextId()));
            this.uccSkuPutCirMapper.addSkuPutCir(skuPutCirPo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u4e0a\u4e0b\u67b6\u5468\u671f\u64cd\u4f5c\u5f02\u5e38");
        }
        try {
            UccSkuLogRecordReqBO uccSkuLogRecordReqBO = new UccSkuLogRecordReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuLogRecordReqBO);
            uccSkuLogRecordReqBO.setBatchId(nextId);
            UccSkuLogRecordRspBO uccSkuLogRecordRspBO = this.uccSkuLogRecordAtomService.dealSkuLogRecord(uccSkuLogRecordReqBO);
            if ("8888".equals(uccSkuLogRecordRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)((Object)uccSkuLogRecordRspBO), (Object)((Object)rspBO));
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException("\u5355\u54c1\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38");
        }
        UccSkuPo skuPo = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)skuPo);
        skuPo.setOnShelveTime(new Date());
        skuPo.setSkuStatus(Integer.valueOf(3));
        skuPo.setRemark("");
        try {
            int i = this.uccSkuMapper.modifySku(skuPo);
            if (i == 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u4fe1\u606f\u5931\u8d25,\u8bf7\u68c0\u67e5\u4fe1\u606f\u8f93\u5165\u662f\u5426\u6b63\u786e");
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(skuPo.getSkuId());
        List uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
        UccCommodityPo uccCommodityPo = this.uccCommodityMapper.qryCommdByCommdId(((UccSkuPo)uccSkuPos.get(0)).getCommodityId(), skuPo.getSupplierShopId());
        if (uccCommodityPo != null && !CommodityStatusEnum.UP_STATUS.getStatus().equals(uccCommodityPo.getCommodityStatus())) {
            UccCommodityPo uccCommodityPo1 = new UccCommodityPo();
            uccCommodityPo1.setCommodityId(uccCommodityPo.getCommodityId());
            uccCommodityPo1.setCommodityStatus(CommodityStatusEnum.UP_STATUS.getStatus());
            this.uccCommodityMapper.updateCommodity(uccCommodityPo1);
        }
        ArrayList<Long> skus = new ArrayList<Long>();
        skus.add(reqBO.getSkuId());
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        if (uccCommodityPo != null) {
            syncSceneCommodityToEsReqBO.setCommodityIds((List)Lists.newArrayList((Object[])new Long[]{uccCommodityPo.getCommodityId()}));
        }
        syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierShopId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public String judge(UccSkuUpReqBO reqBO) {
        String s = "";
        if (StringUtils.isEmpty((Object)reqBO)) {
            s = "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
            return s;
        }
        if (reqBO.getSkuId() == null) {
            s = "\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a";
            return s;
        }
        if (reqBO.getSupplierShopId() == null) {
            s = "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a";
            return s;
        }
        return s;
    }
}

