/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.common.ability.bo.UccOnLoadToRedisEMdmCatalogBO;
import com.tydic.commodity.common.busi.api.UccSupplyTypeRefreshRedisService;
import com.tydic.commodity.common.busi.bo.UccSupplyTypeRefreshRedisReqBo;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSupplyTypeMapper;
import com.tydic.commodity.po.UccSupplyTypePo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccSupplyTypeRefreshRedisServiceImpl
implements UccSupplyTypeRefreshRedisService {
    private static final Logger log = LoggerFactory.getLogger(UccSupplyTypeRefreshRedisServiceImpl.class);
    @Autowired
    private UccSupplyTypeMapper uccSupplyTypeMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;

    @Override
    public RspUccBo dealSupplyTypeRefreshRedis(UccSupplyTypeRefreshRedisReqBo reqBo) {
        Map<Long, List<UccSupplyTypePo>> supplyMap;
        Iterator<Map.Entry<Long, List<UccSupplyTypePo>>> iterator;
        List uccSupplyTypePos;
        RspUccBo rspUccBo = new RspUccBo();
        UccSupplyTypePo uccSupplyTypePo = new UccSupplyTypePo();
        if (reqBo.getSupplyId() != null) {
            uccSupplyTypePo.setSupplyId(reqBo.getSupplyId());
        }
        if (!CollectionUtils.isEmpty((Collection)(uccSupplyTypePos = this.uccSupplyTypeMapper.selectByPo(uccSupplyTypePo))) && (iterator = (supplyMap = uccSupplyTypePos.stream().collect(Collectors.groupingBy(a -> a.getSupplyId()))).entrySet().iterator()).hasNext()) {
            Map.Entry<Long, List<UccSupplyTypePo>> each = iterator.next();
            Map<String, String> typeAndContract = each.getValue().stream().filter(a -> a.getCommodityTypeId() != null && a.getExpand1() != null).collect(Collectors.toMap(a -> a.getCommodityTypeId().toString(), b -> b.getExpand1().toString(), (a, b) -> a));
            this.cacheClient.set("UCC_CONTRACT_SUPPLY_REDIS_KEY" + each.getKey(), typeAndContract);
        }
        return rspUccBo;
    }

    @Override
    public RspUccBo dealSupplyCatalogRefreshRedis(UccSupplyTypeRefreshRedisReqBo reqBo) {
        Map.Entry<Long, List<UccSupplyTypePo>> each;
        List commodityTypeIds;
        Map<Long, List<UccSupplyTypePo>> supplyMap;
        Iterator<Map.Entry<Long, List<UccSupplyTypePo>>> iterator;
        List uccSupplyTypePos;
        RspUccBo rspUccBo = new RspUccBo();
        UccSupplyTypePo uccSupplyTypePo = new UccSupplyTypePo();
        if (reqBo.getSupplyId() != null) {
            uccSupplyTypePo.setSupplyId(reqBo.getSupplyId());
        }
        if (!CollectionUtils.isEmpty((Collection)(uccSupplyTypePos = this.uccSupplyTypeMapper.selectByPo(uccSupplyTypePo))) && (iterator = (supplyMap = uccSupplyTypePos.stream().collect(Collectors.groupingBy(a -> a.getSupplyId()))).entrySet().iterator()).hasNext() && !CollectionUtils.isEmpty(commodityTypeIds = (each = iterator.next()).getValue().stream().filter(a -> a.getCommodityTypeId() != null).map(a -> a.getCommodityTypeId()).collect(Collectors.toList()))) {
            List uccOnLoadToRedisEMdmCatalogBOS = new ArrayList();
            List qryCatalogTreeByType = this.uccEMdmCatalogMapper.qryCatalogTreeByType(commodityTypeIds);
            if (!CollectionUtils.isEmpty((Collection)qryCatalogTreeByType)) {
                uccOnLoadToRedisEMdmCatalogBOS = JSONObject.parseArray((String)JSONObject.toJSONString((Object)qryCatalogTreeByType), UccOnLoadToRedisEMdmCatalogBO.class);
            }
            this.cacheClient.set(each.getKey() + "tree", uccOnLoadToRedisEMdmCatalogBOS);
        }
        return rspUccBo;
    }
}

