/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.api.UccBatchSaveGoodImagesAbilityService;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesBO;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesFailReason;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesReqBO;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccBatchSaveGoodImagesAbilityService"})
public class UccBatchSaveGoodImagesAbilityServiceImpl
implements UccBatchSaveGoodImagesAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchSaveGoodImagesAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    private static final String IMAGE_NAME_REGEX = "^[\\d]*_[12345]{1}.((jpg)|(png))$";

    @PostMapping(value={"dealBatchSaveGoodImages"})
    public UccBatchSaveGoodImagesRspBO dealBatchSaveGoodImages(@RequestBody UccBatchSaveGoodImagesReqBO reqBO) {
        this.validate(reqBO);
        UccBatchSaveGoodImagesRspBO rspBO = new UccBatchSaveGoodImagesRspBO();
        ArrayList<UccBatchSaveGoodImagesFailReason> failReasonList = new ArrayList<UccBatchSaveGoodImagesFailReason>();
        UccBatchSaveGoodImagesFailReason failReason = new UccBatchSaveGoodImagesFailReason();
        AtomicBoolean flag = new AtomicBoolean(false);
        HashMap<Long, Map> skuImagesMap = new HashMap<Long, Map>();
        HashMap skuCommodityPicTypeMap = new HashMap();
        HashSet<String> imageNameSet = new HashSet<String>();
        HashMap<String, Integer> imageCountMap = new HashMap<String, Integer>();
        for (UccBatchSaveGoodImagesBO imagesBO : reqBO.getSkuImagesList()) {
            String skuImageName = imagesBO.getSkuImageName();
            String skuImageAddress = imagesBO.getSkuImageAddress();
            if (!Pattern.matches(IMAGE_NAME_REGEX, skuImageName)) {
                flag.set(true);
                failReason.setFailReason(skuImageName + "\uff1a\u56fe\u7247\u547d\u540d\u4e0d\u7b26\u5408\u8981\u6c42(\u201c\u5355\u54c1\u7f16\u7801_xxx.\u56fe\u7247\u540e\u7f00\u201d\uff08xxx\u4e3a\u5e8f\u53f7\uff0c\u4ece1\u5f00\u59cb\uff09");
                failReasonList.add(failReason);
                break;
            }
            if (imageNameSet.contains(skuImageName)) {
                flag.set(true);
                failReason.setFailReason(skuImageName + "\uff1a\u56fe\u7247\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                failReasonList.add(failReason);
            }
            imageNameSet.add(skuImageName);
            String skuCode = skuImageName.substring(0, skuImageName.indexOf("_"));
            Integer commodityPicType = Integer.valueOf(skuImageName.substring(skuImageName.indexOf("_") + 1, skuImageName.indexOf(".")));
            List uccSkuPoList = this.uccSkuMapper.querySkuByCode((List)Lists.newArrayList((Object[])new String[]{skuCode}));
            if (ObjectUtils.isEmpty((Object)uccSkuPoList)) {
                throw new ZTBusinessException("\u5355\u54c1\u7f16\u7801\uff1a" + skuCode + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u547d\u540d\u56fe\u7247\u540d\u79f0");
            }
            Long skuId2 = ((UccSkuPo)uccSkuPoList.get(0)).getSkuId();
            if (imageCountMap.containsKey(skuCode)) {
                imageCountMap.put(skuCode, (Integer)imageCountMap.get(skuCode) + 1);
                if ((Integer)imageCountMap.get(skuCode) > 5) {
                    flag.set(true);
                    failReason.setFailReason("\u5355\u54c1\u56fe\u7247\u6570\u91cf\u8d85\u8fc7\u4e0a\u9650\uff0c\u6700\u591a\u4e0a\u4f205\u5f20");
                    failReasonList.add(failReason);
                }
            } else {
                imageCountMap.put(skuCode, 1);
            }
            if (!skuCommodityPicTypeMap.containsKey(skuId2)) {
                HashMap<Integer, ArrayList> map = new HashMap<Integer, ArrayList>();
                map.put(commodityPicType, Lists.newArrayList((Object[])new String[]{skuImageAddress}));
                skuCommodityPicTypeMap.put(skuId2, map);
            } else {
                Map commodityPicTypeMap = (Map)skuCommodityPicTypeMap.get(skuId2);
                if (commodityPicTypeMap.containsKey(commodityPicType)) {
                    ((List)commodityPicTypeMap.get(commodityPicType)).add(skuImageAddress);
                } else {
                    commodityPicTypeMap.put(commodityPicType, Lists.newArrayList((Object[])new String[]{skuImageAddress}));
                }
            }
            Integer searchPicType = commodityPicType == 1 ? 1 : 2;
            List uccSkuPicPos = null;
            if (!skuImagesMap.containsKey(skuId2)) {
                uccSkuPicPos = this.uccSkuPicMapper.qeurySkuPicBySkuId((List)Lists.newArrayList((Object[])new Long[]{skuId2}), searchPicType);
                if (ObjectUtils.isEmpty((Object)uccSkuPicPos)) {
                    flag.set(true);
                    failReason.setFailReason("\u5355\u54c1ID\uff1a" + skuId2 + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5355\u54c1\u56fe\u7247\u6570\u636e");
                    failReasonList.add(failReason);
                    break;
                }
                HashMap<Integer, ArrayList> tmpMap2 = new HashMap<Integer, ArrayList>();
                tmpMap2.put(commodityPicType, Lists.newArrayList((Iterable)uccSkuPicPos));
                skuImagesMap.put(skuId2, tmpMap2);
                continue;
            }
            Map imagesMap = (Map)skuImagesMap.get(skuId2);
            if (imagesMap.containsKey(commodityPicType)) continue;
            uccSkuPicPos = this.uccSkuPicMapper.qeurySkuPicBySkuId((List)Lists.newArrayList((Object[])new Long[]{skuId2}), searchPicType);
            if (ObjectUtils.isEmpty((Object)uccSkuPicPos)) {
                flag.set(true);
                failReason.setFailReason("\u5355\u54c1ID\uff1a" + skuId2 + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5355\u54c1\u56fe\u7247\u6570\u636e");
                failReasonList.add(failReason);
                break;
            }
            imagesMap.put(commodityPicType, Lists.newArrayList((Iterable)uccSkuPicPos));
        }
        if (flag.get()) {
            rspBO.setFailReasonList(failReasonList.stream().distinct().collect(Collectors.toList()));
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        skuImagesMap.forEach((skuId, tmpMap) -> {
            if (tmpMap.containsKey(1) && !ObjectUtils.isEmpty(tmpMap.get(1)) && ((List)tmpMap.get(1)).size() > 1) {
                flag.set(true);
                failReason.setFailReason("\u5355\u54c1\u56fe\u7247\u4e3b\u56fe\u4e0d\u552f\u4e00");
                failReasonList.add(failReason);
            }
            Map commodityPicTypeMap = (Map)skuCommodityPicTypeMap.get(skuId);
            if (skuCommodityPicTypeMap.containsKey(skuId)) {
                tmpMap.forEach((commodityPicType, uccSkuPicList) -> {
                    if (commodityPicTypeMap.containsKey(commodityPicType) && !ObjectUtils.isEmpty((Object)uccSkuPicList)) {
                        UccSkuPicPo skuPicPo = commodityPicType.equals(1) ? (UccSkuPicPo)uccSkuPicList.get(0) : (UccSkuPicPo)uccSkuPicList.get(commodityPicType - 2);
                        skuPicPo.setSkuPicUrl((String)((List)commodityPicTypeMap.get(commodityPicType)).get(0));
                        this.uccSkuPicMapper.updateSkuPic(skuPicPo);
                    }
                });
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFailReasonList(failReasonList.stream().distinct().collect(Collectors.toList()));
        return rspBO;
    }

    private void validate(UccBatchSaveGoodImagesReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuImagesList())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccBatchSaveGoodImagesBO bo : reqBO.getSkuImagesList()) {
            if (StringUtil.isEmpty((String)bo.getSkuImageName())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u7684[skuImageName]\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtil.isEmpty((String)bo.getSkuImageAddress())) continue;
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u7684[skuImageAddress]\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

