/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.common.ability.api.UccAssignCodeApplyMaterialAddAbilityService;
import com.tydic.commodity.common.ability.bo.UccAssignCodeApplyMaterialAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccAssignCodeApplyMaterialAddAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccAssignCodeApplyMaterialAddBusiService;
import com.tydic.commodity.common.busi.bo.UccAssignCodeApplyMaterialAddBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccAssignCodeApplyMaterialAddBusiRspBO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAssignCodeApplyMaterialAddAbilityService"})
public class UccAssignCodeApplyMaterialAddAbilityServiceImpl
implements UccAssignCodeApplyMaterialAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAssignCodeApplyMaterialAddAbilityServiceImpl.class);
    @Autowired
    private UccAssignCodeApplyMaterialAddBusiService uccAssignCodeApplyMaterialAddBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealAssignCodeApplyMaterialAdd"})
    public UccAssignCodeApplyMaterialAddAbilityRspBO dealAssignCodeApplyMaterialAdd(@RequestBody UccAssignCodeApplyMaterialAddAbilityReqBO reqBO) {
        this.validation(reqBO);
        UccAssignCodeApplyMaterialAddBusiReqBO busiReqBO = (UccAssignCodeApplyMaterialAddBusiReqBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UccAssignCodeApplyMaterialAddBusiReqBO.class));
        UccAssignCodeApplyMaterialAddBusiRspBO busiRspBO = this.uccAssignCodeApplyMaterialAddBusiService.dealAssignCodeApplyMaterialAdd(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new BaseBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        this.syncMQ(busiRspBO);
        UccAssignCodeApplyMaterialAddAbilityRspBO rspBO = (UccAssignCodeApplyMaterialAddAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), UccAssignCodeApplyMaterialAddAbilityRspBO.class);
        return rspBO;
    }

    private void syncMQ(UccAssignCodeApplyMaterialAddBusiRspBO busiRspBO) {
        List<UccSkuPo> uccSkuPoList = busiRspBO.getUccSkuPoList();
        if (!CollectionUtils.isEmpty(uccSkuPoList)) {
            for (UccSkuPo skuPo : uccSkuPoList) {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(Arrays.asList(skuPo.getCommodityId()));
                syncSceneCommodityToEsReqBO.setSupplierId(skuPo.getSupplierShopId());
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
                }
            }
        }
    }

    private void validation(UccAssignCodeApplyMaterialAddAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCatalogId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2[\u7269\u6599\u5206\u7c7bID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getMaterialName())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2[\u7269\u6599\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getMaterialCode())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2[\u7269\u6599\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getMeasureId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2[\u8ba1\u91cf\u5355\u4f4dID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getMeasure())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2[\u8ba1\u91cf\u5355\u4f4d]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

