/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccEMdmCatalogBo;
import com.tydic.commodity.common.busi.api.UccEMdmCatalogSyncBusiService;
import com.tydic.commodity.common.busi.bo.UccEMdmCatalogSyncBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccEMdmCatalogSyncBusiRspBO;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccEMdmCatalogSyncBusiServiceImpl
implements UccEMdmCatalogSyncBusiService {
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;

    @Override
    public UccEMdmCatalogSyncBusiRspBO syncEMdmCatalog(UccEMdmCatalogSyncBusiReqBO reqBO) {
        List uccEMdmCatalogMapperListByCodes = this.uccEMdmCatalogMapper.getListByCodes(reqBO.getCatalogs().stream().map(UccEMdmCatalogBo::getCatalogCode).collect(Collectors.toList()));
        Map<String, UccEMdmCatalogPO> uccEMdmCatalogPOMap = uccEMdmCatalogMapperListByCodes.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCatalogCode, o -> o, (old, cur) -> old));
        for (UccEMdmCatalogBo uccEMdmCatalogBo : reqBO.getCatalogs()) {
            this.valCatalog(uccEMdmCatalogBo);
            if (!uccEMdmCatalogPOMap.containsKey(uccEMdmCatalogBo.getCatalogCode())) {
                this.add(uccEMdmCatalogBo);
                continue;
            }
            this.update(uccEMdmCatalogBo, uccEMdmCatalogPOMap.get(uccEMdmCatalogBo.getCatalogCode()));
        }
        UccEMdmCatalogSyncBusiRspBO rspBO = new UccEMdmCatalogSyncBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void update(UccEMdmCatalogBo uccEMdmCatalogBo, UccEMdmCatalogPO existCatalogPo) {
        UccEMdmCatalogPO uccEMdmCatalogPO = new UccEMdmCatalogPO();
        uccEMdmCatalogPO.setSysId(uccEMdmCatalogBo.getSysId());
        uccEMdmCatalogPO.setCatalogId(existCatalogPo.getCatalogId());
        uccEMdmCatalogPO.setCatalogName(uccEMdmCatalogBo.getCatalogName());
        uccEMdmCatalogPO.setCatalogCode(uccEMdmCatalogBo.getCatalogCode());
        uccEMdmCatalogPO.setCatalogVer(uccEMdmCatalogBo.getCatalogVer());
        uccEMdmCatalogPO.setCatalogDesc(uccEMdmCatalogBo.getCatalogDesc());
        uccEMdmCatalogPO.setParentCatalogCode(uccEMdmCatalogBo.getParentCatalogCode());
        uccEMdmCatalogPO.setUuid(uccEMdmCatalogBo.getCatalogCode());
        uccEMdmCatalogPO.setFreezeFlag(uccEMdmCatalogBo.getFreezeFlag());
        uccEMdmCatalogPO.setUpdateLoginId(Long.valueOf(1L));
        uccEMdmCatalogPO.setUpdateTime(new Date());
        uccEMdmCatalogPO.setRemark(uccEMdmCatalogBo.getRemark());
        this.uccEMdmCatalogMapper.updateById(uccEMdmCatalogPO);
        if (!StringUtils.isBlank((CharSequence)uccEMdmCatalogBo.getParentCatalogCode()) && !uccEMdmCatalogBo.getParentCatalogCode().equals(existCatalogPo.getParentCatalogCode())) {
            UccEMdmCatalogPO uccEMdmCatalog = new UccEMdmCatalogPO();
            uccEMdmCatalog.setCatalogCode(uccEMdmCatalogBo.getParentCatalogCode());
            UccEMdmCatalogPO edmCatalog = this.uccEMdmCatalogMapper.getModelBy(uccEMdmCatalog);
            if (null != edmCatalog) {
                UccEMdmCatalogPO updateCurrent = new UccEMdmCatalogPO();
                updateCurrent.setCatalogId(uccEMdmCatalogPO.getCatalogId());
                updateCurrent.setParentCatalogId(edmCatalog.getCatalogId());
                updateCurrent.setCatalogLevel(Integer.valueOf(edmCatalog.getCatalogLevel() + 1));
                updateCurrent.setLastLevel(Integer.valueOf(0));
                this.uccEMdmCatalogMapper.updateById(updateCurrent);
                this.updateNotLast(edmCatalog.getCatalogId());
                UccEMdmCatalogPO eMdmCatalog = new UccEMdmCatalogPO();
                eMdmCatalog.setParentCatalogCode(uccEMdmCatalogBo.getCatalogCode());
                List eMdmCatalogMapperList = this.uccEMdmCatalogMapper.getList(eMdmCatalog);
                if (CollectionUtils.isNotEmpty((Collection)eMdmCatalogMapperList)) {
                    this.updateChildLevel(eMdmCatalogMapperList, edmCatalog.getCatalogLevel() + 1, uccEMdmCatalogPO.getCatalogId());
                }
            }
        }
    }

    private void add(UccEMdmCatalogBo uccEMdmCatalogBo) {
        UccEMdmCatalogPO uccEMdmCatalog;
        UccEMdmCatalogPO uccEMdmCatalogPO = new UccEMdmCatalogPO();
        uccEMdmCatalogPO.setSysId(uccEMdmCatalogBo.getSysId());
        uccEMdmCatalogPO.setCatalogId(Long.valueOf(Sequence.getInstance().nextId()));
        uccEMdmCatalogPO.setCatalogName(uccEMdmCatalogBo.getCatalogName());
        uccEMdmCatalogPO.setCatalogCode(uccEMdmCatalogBo.getCatalogCode());
        uccEMdmCatalogPO.setCatalogVer(uccEMdmCatalogBo.getCatalogVer());
        uccEMdmCatalogPO.setCatalogDesc(uccEMdmCatalogBo.getCatalogDesc());
        uccEMdmCatalogPO.setParentCatalogCode(uccEMdmCatalogBo.getParentCatalogCode());
        uccEMdmCatalogPO.setParentCatalogId(Long.valueOf(0L));
        uccEMdmCatalogPO.setUuid(uccEMdmCatalogBo.getCatalogCode());
        uccEMdmCatalogPO.setFreezeFlag(uccEMdmCatalogBo.getFreezeFlag());
        uccEMdmCatalogPO.setCreateLoginId(Long.valueOf(1L));
        uccEMdmCatalogPO.setCreateTime(new Date());
        uccEMdmCatalogPO.setRemark(uccEMdmCatalogBo.getRemark());
        uccEMdmCatalogPO.setLastLevel(Integer.valueOf(2));
        uccEMdmCatalogPO.setCatalogLevel(Integer.valueOf(1));
        int currentLevel = uccEMdmCatalogPO.getCatalogLevel();
        if (!StringUtils.isBlank((CharSequence)uccEMdmCatalogBo.getParentCatalogCode())) {
            uccEMdmCatalog = new UccEMdmCatalogPO();
            uccEMdmCatalog.setCatalogCode(uccEMdmCatalogBo.getParentCatalogCode());
            UccEMdmCatalogPO edmCatalog = this.uccEMdmCatalogMapper.getModelBy(uccEMdmCatalog);
            if (null != edmCatalog) {
                uccEMdmCatalogPO.setParentCatalogId(edmCatalog.getCatalogId());
                uccEMdmCatalogPO.setCatalogLevel(Integer.valueOf(edmCatalog.getCatalogLevel() + 1));
                currentLevel = edmCatalog.getCatalogLevel() + 1;
                this.updateNotLast(edmCatalog.getCatalogId());
            }
        }
        this.uccEMdmCatalogMapper.insert(uccEMdmCatalogPO);
        uccEMdmCatalog = new UccEMdmCatalogPO();
        uccEMdmCatalog.setParentCatalogCode(uccEMdmCatalogBo.getCatalogCode());
        List eMdmCatalogPOS = this.uccEMdmCatalogMapper.getList(uccEMdmCatalog);
        if (CollectionUtils.isNotEmpty((Collection)eMdmCatalogPOS)) {
            this.updateNotLast(uccEMdmCatalogPO.getCatalogId());
            this.updateChildLevel(eMdmCatalogPOS, currentLevel, uccEMdmCatalogPO.getCatalogId());
        }
    }

    private void updateNotLast(Long catalogId) {
        UccEMdmCatalogPO update = new UccEMdmCatalogPO();
        update.setCatalogId(catalogId);
        update.setLastLevel(Integer.valueOf(0));
        this.uccEMdmCatalogMapper.updateById(update);
    }

    private void updateChildLevel(List<UccEMdmCatalogPO> edmCatalogs, int currentLevel, Long parentId) {
        for (UccEMdmCatalogPO edmCatalog : edmCatalogs) {
            UccEMdmCatalogPO updateChild = new UccEMdmCatalogPO();
            updateChild.setCatalogId(edmCatalog.getCatalogId());
            updateChild.setCatalogLevel(Integer.valueOf(currentLevel + 1));
            updateChild.setParentCatalogId(parentId);
            this.uccEMdmCatalogMapper.updateById(updateChild);
            UccEMdmCatalogPO uccEMdmCatalogPO = new UccEMdmCatalogPO();
            uccEMdmCatalogPO.setParentCatalogId(edmCatalog.getCatalogId());
            List uccEMdmCatalogMapperList = this.uccEMdmCatalogMapper.getList(uccEMdmCatalogPO);
            if (!CollectionUtils.isNotEmpty((Collection)uccEMdmCatalogMapperList)) continue;
            this.updateChildLevel(uccEMdmCatalogMapperList, currentLevel + 1, edmCatalog.getCatalogId());
        }
    }

    private void valCatalog(UccEMdmCatalogBo uccEMdmCatalogBo) {
        if (null == uccEMdmCatalogBo.getParentCatalogCode()) {
            throw new BusinessException("0001", "\u7236\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)uccEMdmCatalogBo.getCatalogName())) {
            throw new BusinessException("0001", "\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)uccEMdmCatalogBo.getCatalogCode())) {
            throw new BusinessException("0001", "\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == uccEMdmCatalogBo.getFreezeFlag()) {
            throw new BusinessException("0001", "\u505c\u7528\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

