/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.cfc.ability.api.CfcGetUnionCodeAbilityService;
import com.tydic.cfc.ability.bo.CfcGetUnionCodeAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcGetUnionCodeAbilityRspBO;
import com.tydic.commodity.base.bo.UccBatchTaskDealProducerBO;
import com.tydic.commodity.base.bo.UccSkuBatchAddRecordBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.api.UccDealBatchAuditRecordAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuBatchAddRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccDealBatchAuditRecordAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuBatchAddRecordAbilityReqBO;
import com.tydic.commodity.common.atom.api.UccBatchDealOrderAddAtomService;
import com.tydic.commodity.common.atom.bo.UccBatchDealOrderAddAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccBatchDealOrderAddAtomRspBO;
import com.tydic.commodity.common.comb.api.UccBatchUpdateStatusCombService;
import com.tydic.commodity.common.comb.bo.UccBatchUpdateStatusCombReqBO;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.ComBatchDealTaskMapper;
import com.tydic.commodity.po.ComBatchDealRecordPO;
import com.tydic.commodity.po.ComBatchDealTaskPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UccBatchTaskDealConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UccBatchTaskDealConsumer.class);
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private UccDealBatchAuditRecordAbilityService uccDealBatchAuditRecordAbilityService;
    @Autowired
    private ComBatchDealTaskMapper comBatchDealTaskMapper;
    @Autowired
    private UccBatchDealOrderAddAtomService uccBatchDealOrderAddAtomService;
    @Autowired
    private UccBatchUpdateStatusCombService uccBatchUpdateStatusCombService;
    @Autowired
    private CfcGetUnionCodeAbilityService cfcGetUnionCodeAbilityService;
    @Autowired
    private UccSkuBatchAddRecordAbilityService uccSkuBatchAddRecordAbilityService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            log.info("\u5546\u54c1\u6279\u91cf\u63d0\u4ea4\u6d88\u8d39\u8005proxyMessage=" + JSON.toJSONString((Object)message));
            String content = message.getContent();
            log.info("\u5546\u54c1\u6279\u91cf\u63d0\u4ea4\u6d88\u8d39\u8005\u6536\u5230\uff0c\u6570\u636e\u5185\u5bb9\u5982\u4e0b" + content);
            UccBatchTaskDealProducerBO uccBatchTaskDealProducerBO = (UccBatchTaskDealProducerBO)JSON.parseObject((String)content, UccBatchTaskDealProducerBO.class);
            Integer dealType = uccBatchTaskDealProducerBO.getDealType();
            String batchNo = uccBatchTaskDealProducerBO.getBatchNo();
            ComBatchDealTaskPO comBatchDealTaskPO = new ComBatchDealTaskPO();
            comBatchDealTaskPO.setBatchNo(batchNo);
            ComBatchDealTaskPO comBatchDealTaskPO1 = this.comBatchDealTaskMapper.getModelBy(comBatchDealTaskPO);
            if (dealType.equals(UccConstants.BatchDealType.BATCH_AUDIT) || dealType.equals(UccConstants.BatchDealType.BEFOR_TASK) || dealType.equals(UccConstants.BatchDealType.TRANSFER_TASK)) {
                ComBatchDealRecordPO comBatchDealRrecordPO = new ComBatchDealRecordPO();
                comBatchDealRrecordPO.setBatchNo(batchNo);
                List comBatchDealRrecordPOs = this.comBatchDealRrecordMapper.getList(comBatchDealRrecordPO);
                if (!CollectionUtils.isEmpty((Collection)comBatchDealRrecordPOs)) {
                    comBatchDealRrecordPOs.forEach(comBatchDealRrecordPO1 -> {
                        UccDealBatchAuditRecordAbilityReqBO auditRecordAbilityReqBO = new UccDealBatchAuditRecordAbilityReqBO();
                        auditRecordAbilityReqBO.setOrderId(comBatchDealRrecordPO1.getObjId());
                        auditRecordAbilityReqBO.setTaskId(comBatchDealRrecordPO1.getTaskId());
                        auditRecordAbilityReqBO.setReqJson(comBatchDealTaskPO1.getReqJson());
                        auditRecordAbilityReqBO.setDealType(dealType);
                        this.uccDealBatchAuditRecordAbilityService.dealBatchAuditRecord(auditRecordAbilityReqBO);
                    });
                }
            } else {
                JSONObject json = this.convertDealTypeDefaltParam(dealType, comBatchDealTaskPO1.getSource());
                Integer busiType = json.getInteger("busiType");
                String processKey = json.getString("processKey");
                boolean needAudit = false;
                if (StringUtils.hasText((String)processKey)) {
                    needAudit = true;
                    this.createDealOrder(processKey, busiType, comBatchDealTaskPO1);
                } else if (dealType.equals(UccConstants.BatchDealType.COMM_EDIT_SUBMIT)) {
                    this.dealCommEdit(comBatchDealTaskPO1);
                }
                UccBatchUpdateStatusCombReqBO uccBatchUpdateStatusCombReqBO = new UccBatchUpdateStatusCombReqBO();
                uccBatchUpdateStatusCombReqBO.setBatchNo(batchNo);
                uccBatchUpdateStatusCombReqBO.setDealType(dealType);
                uccBatchUpdateStatusCombReqBO.setReqJson(comBatchDealTaskPO1.getReqJson());
                this.bulidParam(needAudit, busiType, uccBatchUpdateStatusCombReqBO);
                this.uccBatchUpdateStatusCombService.dealBatchUpdateStatus(uccBatchUpdateStatusCombReqBO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void dealCommEdit(ComBatchDealTaskPO comBatchDealTaskPO) {
        ComBatchDealRecordPO comBatchDealRecordPO = new ComBatchDealRecordPO();
        comBatchDealRecordPO.setOnShelveWay(UccConstants.BatchRecordOnShelveWay.AUTO_PUT_ON);
        comBatchDealRecordPO.setBatchNo(comBatchDealTaskPO.getBatchNo());
        List pos = this.comBatchDealRrecordMapper.getList(comBatchDealRecordPO);
        if (!CollectionUtils.isEmpty((Collection)pos)) {
            UccSkuBatchAddRecordAbilityReqBO uccSkuBatchAddRecordAbilityReqBO = (UccSkuBatchAddRecordAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)comBatchDealTaskPO.getReqJson()), UccSkuBatchAddRecordAbilityReqBO.class);
            uccSkuBatchAddRecordAbilityReqBO.setObjType(UccConstants.BatchObjType.COMMODITY);
            uccSkuBatchAddRecordAbilityReqBO.setDealType(UccConstants.BatchDealType.COMM_PUT_ON);
            ArrayList batchObjList = new ArrayList();
            pos.forEach(comBatchDealRecordPO1 -> {
                UccSkuBatchAddRecordBO bo = new UccSkuBatchAddRecordBO();
                bo.setSupplierShopId(comBatchDealRecordPO1.getSupplierShopId());
                bo.setObjId(comBatchDealRecordPO1.getObjId());
                batchObjList.add(bo);
            });
            uccSkuBatchAddRecordAbilityReqBO.setBatchObjList(batchObjList);
            this.uccSkuBatchAddRecordAbilityService.addSkuBatchDealRecord(uccSkuBatchAddRecordAbilityReqBO);
        }
    }

    private void createDealOrder(String processKey, Integer busiType, ComBatchDealTaskPO comBatchDealTaskPO) {
        UccBatchDealOrderAddAtomReqBO orderAddAtomReqBO = (UccBatchDealOrderAddAtomReqBO)((Object)JSON.parseObject((String)comBatchDealTaskPO.getReqJson(), UccBatchDealOrderAddAtomReqBO.class));
        orderAddAtomReqBO.setBatchNo(comBatchDealTaskPO.getBatchNo());
        orderAddAtomReqBO.setBusiType(busiType);
        orderAddAtomReqBO.setProcDefKey(processKey);
        CfcGetUnionCodeAbilityReqBO cfcGetUnionCodeAbilityReqBO = new CfcGetUnionCodeAbilityReqBO();
        cfcGetUnionCodeAbilityReqBO.setCenter("UMC");
        cfcGetUnionCodeAbilityReqBO.setNum(Integer.valueOf(1));
        cfcGetUnionCodeAbilityReqBO.setEncodedRuleCode("UMC_AUDIT_CODE");
        cfcGetUnionCodeAbilityReqBO.setOrgType("-1");
        CfcGetUnionCodeAbilityRspBO cfcGetUnionCodeAbilityRspBO = this.cfcGetUnionCodeAbilityService.getUnionCode(cfcGetUnionCodeAbilityReqBO);
        if (!"0000".equals(cfcGetUnionCodeAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u751f\u6210\u5ba1\u6279\u5355\u53f7\u9519\u8bef\uff01\u5f02\u5e38\u7f16\u7801\u3010" + cfcGetUnionCodeAbilityRspBO.getRespCode() + "\u3011," + cfcGetUnionCodeAbilityRspBO.getRespDesc());
        }
        orderAddAtomReqBO.setOrderCode((String)cfcGetUnionCodeAbilityRspBO.getSerialNoList().get(0));
        orderAddAtomReqBO.setOrderName(UccConstants.BatchDealOrderNameEnum.find((Integer)busiType).getValue() + orderAddAtomReqBO.getOrderCode());
        orderAddAtomReqBO.setOrderType(1);
        orderAddAtomReqBO.setSource(comBatchDealTaskPO.getSource());
        orderAddAtomReqBO.setTotalNum(comBatchDealTaskPO.getSuccessNum());
        UccBatchDealOrderAddAtomRspBO addAtomRspBO = this.uccBatchDealOrderAddAtomService.addBatchDealOrder(orderAddAtomReqBO);
        if (!"0000".equals(addAtomRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u751f\u6210\u5ba1\u6279\u5355\u9519\u8bef\uff01\u5f02\u5e38\u7f16\u7801\u3010" + addAtomRspBO.getRespCode() + "\u3011," + addAtomRspBO.getRespDesc());
        }
    }

    private void bulidParam(Boolean needAudit, Integer busiType, UccBatchUpdateStatusCombReqBO uccBatchUpdateStatusCombReqBO) {
        if (!needAudit.booleanValue()) {
            if (UccConstants.PassAuditBusiTypeCommStatusEnum.find((Integer)busiType) != null) {
                uccBatchUpdateStatusCombReqBO.setSpuStatus(UccConstants.PassAuditBusiTypeCommStatusEnum.find((Integer)busiType).getValue());
            }
            if (UccConstants.PassAuditBusiTypeSkuStatusEnum.find((Integer)busiType) != null) {
                uccBatchUpdateStatusCombReqBO.setSkuStatus(UccConstants.PassAuditBusiTypeSkuStatusEnum.find((Integer)busiType).getValue());
            }
            if (busiType.equals(UccConstants.AuditBusiType.COMM_EDIT_AUDIT)) {
                uccBatchUpdateStatusCombReqBO.setOnShelveWay(UccConstants.BatchRecordOnShelveWay.HHAN_PUT_ON);
            }
        } else {
            if (UccConstants.AuditAuditBusiTypeCommStatusEnum.find((Integer)busiType) != null) {
                uccBatchUpdateStatusCombReqBO.setSpuStatus(UccConstants.AuditAuditBusiTypeCommStatusEnum.find((Integer)busiType).getValue());
            }
            if (UccConstants.AuditAuditBusiTypeSkuStatusEnum.find((Integer)busiType) != null) {
                uccBatchUpdateStatusCombReqBO.setSkuStatus(UccConstants.AuditAuditBusiTypeSkuStatusEnum.find((Integer)busiType).getValue());
            }
        }
    }

    private JSONObject convertDealTypeDefaltParam(Integer dealType, Integer source) {
        JSONObject json = new JSONObject();
        int busiType = 0;
        String processKey = "";
        if (dealType.equals(UccConstants.BatchDealType.COMM_EDIT_SUBMIT)) {
            busiType = UccConstants.AuditBusiType.COMM_EDIT_AUDIT;
            if (UccConstants.Source.AGR.equals(source)) {
                processKey = "ARG_EDIT_PROCESS";
            } else if (UccConstants.Source.NOT_AGR.equals(source)) {
                processKey = "SELF_EDIT_PROCESS";
            }
        }
        if (dealType.equals(UccConstants.BatchDealType.COMM_EDIT_SUBMIT_NOT_DRAFT)) {
            busiType = UccConstants.AuditBusiType.COMM_EDIT_AUDIT;
            if (UccConstants.Source.AGR.equals(source)) {
                processKey = "ARG_EDIT_PROCESS";
            } else if (UccConstants.Source.NOT_AGR.equals(source)) {
                processKey = "SELF_EDIT_PROCESS";
            }
        }
        if (dealType.equals(UccConstants.BatchDealType.SKU_EDIT_SUBMIT_DRAFT)) {
            busiType = UccConstants.AuditBusiType.SKU_EDIT_AUDIT;
            if (UccConstants.Source.AGR.equals(source)) {
                processKey = "ARG_EDIT_PROCESS";
            } else if (UccConstants.Source.NOT_AGR.equals(source)) {
                processKey = "SELF_EDIT_PROCESS";
            }
        }
        if (dealType.equals(UccConstants.BatchDealType.SKU_EDIT_SUBMIT_NOT_DRAFT)) {
            busiType = UccConstants.AuditBusiType.SKU_EDIT_AUDIT;
            if (UccConstants.Source.AGR.equals(source)) {
                processKey = "ARG_EDIT_PROCESS";
            } else if (UccConstants.Source.NOT_AGR.equals(source)) {
                processKey = "SELF_EDIT_PROCESS";
            }
        }
        if (dealType.equals(UccConstants.BatchDealType.COMM_DELETE)) {
            busiType = UccConstants.AuditBusiType.COMM_BATCH_DELETE;
        }
        if (dealType.equals(UccConstants.BatchDealType.COMM_PUT_ON)) {
            busiType = UccConstants.AuditBusiType.COMM_PUT_ON_AUDIT;
            if (UccConstants.Source.AGR.equals(source)) {
                processKey = "ARG_ON_SHELF_PROCESS";
            } else if (UccConstants.Source.NOT_AGR.equals(source)) {
                processKey = "SELF_ON_SHELF_PROCESS";
            } else if (UccConstants.Source.ECOM.equals(source)) {
                processKey = "ESTORE_ON_SHELF_PROCESS";
            }
        }
        if (dealType.equals(UccConstants.BatchDealType.SKU_PUT_ON)) {
            busiType = UccConstants.AuditBusiType.SKU_PUT_ON_AUDIT;
            if (UccConstants.Source.AGR.equals(source)) {
                processKey = "ARG_ON_SHELF_PROCESS";
            } else if (UccConstants.Source.NOT_AGR.equals(source)) {
                processKey = "SELF_ON_SHELF_PROCESS";
            } else if (UccConstants.Source.ECOM.equals(source)) {
                processKey = "ESTORE_ON_SHELF_PROCESS";
            }
        }
        if (dealType.equals(UccConstants.BatchDealType.SKU_PUT_OFF)) {
            busiType = UccConstants.AuditBusiType.SKU_PUT_OFF_AUDIT;
            if (UccConstants.Source.AGR.equals(source)) {
                processKey = "ARG_OFF_SHELF_PROCESS";
            } else if (UccConstants.Source.NOT_AGR.equals(source)) {
                processKey = "SELF_OFF_SHELF_PROCESS";
            } else if (UccConstants.Source.ECOM.equals(source)) {
                processKey = "ESTORE_OFF_SHELF_PROCESS";
            }
        }
        if (dealType.equals(UccConstants.BatchDealType.SKU_RE_PUT_ON)) {
            busiType = UccConstants.AuditBusiType.SKU_RE_PUT_ON_AUDIT;
            if (UccConstants.Source.AGR.equals(source)) {
                processKey = "ARG_REINSTATE_PROCESS";
            } else if (UccConstants.Source.NOT_AGR.equals(source)) {
                processKey = "SELF_REINSTATE_PROCESS";
            } else if (UccConstants.Source.ECOM.equals(source)) {
                processKey = "ESTORE_REINSTATE_PROCESS";
            }
        }
        if (dealType.equals(UccConstants.BatchDealType.SKU_REJECT)) {
            busiType = UccConstants.AuditBusiType.SKU_REJECT_ADIT;
        }
        if (dealType.equals(UccConstants.BatchDealType.SKU_RE_TO_PUT_ON)) {
            busiType = UccConstants.AuditBusiType.SKU_RE_TO_PUT_ON_AUDIT;
        }
        if (dealType.equals(UccConstants.BatchDealType.SKU_DELETE)) {
            busiType = UccConstants.AuditBusiType.SKU_BATCH_DELETE;
        }
        json.put("busiType", (Object)Integer.toString(busiType));
        json.put("processKey", (Object)processKey);
        return json;
    }
}

