/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.busibase.comb.api.UccSkuListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccSkuListCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuListQryCombRspBO;
import com.tydic.commodity.common.ability.api.UccSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccQrySkuBatchDealRecordByPageBusiService;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ComBatchDealRecordPO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuListQryAbilityService"})
public class UccSkuListQryAbilityServiceImpl
implements UccSkuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuListQryAbilityServiceImpl.class);
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuListQryCombService uccSkuListQryCombService;
    @Autowired
    private UccQrySkuBatchDealRecordByPageBusiService uccQrySkuBatchDealRecordByPageBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;

    @PostMapping(value={"getSkuListQry"})
    public UccSkuListQryAbilityRspBO getSkuListQry(@RequestBody UccSkuListQryAbilityReqBO reqBO) {
        String json = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        UccSkuListQryCombRspBO searchCommodityManageCombRspBo = this.uccSkuListQryCombService.getSkuListQry((UccSkuListQryCombReqBO)JSON.parseObject((String)json, UccSkuListQryCombReqBO.class));
        if (UccConstants.IsBatchDealQry.YES.equals(reqBO.getIsBatchDealQry())) {
            UccSkuListQryAbilityRspBO rspBO = new UccSkuListQryAbilityRspBO();
            rspBO.setRespCode(searchCommodityManageCombRspBo.getRespCode());
            rspBO.setRespDesc(searchCommodityManageCombRspBo.getRespDesc());
            rspBO.setTotal(searchCommodityManageCombRspBo.getTotal());
            rspBO.setPageNo(searchCommodityManageCombRspBo.getPageNo());
            rspBO.setRecordsTotal(searchCommodityManageCombRspBo.getRecordsTotal());
            rspBO.setRows(JSONObject.parseArray((String)JSON.toJSONString((Object)searchCommodityManageCombRspBo.getRows()), UccSkuListQryBO.class));
            return rspBO;
        }
        if (UccConstants.IsQryNoPicSku.CODE.equals(reqBO.getIsQryNoPicSku()) || UccConstants.IsQryNoPicSku.NO_PIC.equals(reqBO.getIsQryNoPicSku())) {
            UccSkuListQryAbilityRspBO rspBO = new UccSkuListQryAbilityRspBO();
            rspBO.setRespCode(searchCommodityManageCombRspBo.getRespCode());
            rspBO.setRespDesc(searchCommodityManageCombRspBo.getRespDesc());
            rspBO.setTotal(searchCommodityManageCombRspBo.getTotal());
            rspBO.setPageNo(searchCommodityManageCombRspBo.getPageNo());
            rspBO.setRecordsTotal(searchCommodityManageCombRspBo.getRecordsTotal());
            rspBO.setRows(JSONObject.parseArray((String)JSON.toJSONString((Object)searchCommodityManageCombRspBo.getRows()), UccSkuListQryBO.class));
            return rspBO;
        }
        if (!CollectionUtils.isEmpty((Collection)searchCommodityManageCombRspBo.getRows())) {
            Map<String, String> skuStateNewMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.SKU_STATE_NEW.toString());
            for (UccSkuListCombQryBO skuManagementListQryBO : searchCommodityManageCombRspBo.getRows()) {
                skuManagementListQryBO.setSkuStatusDesc(skuStateNewMap.get(Convert.toStr((Object)skuManagementListQryBO.getSkuStatus())));
            }
            this.newResetStatus(searchCommodityManageCombRspBo.getRows());
        }
        String json1 = JSON.toJSONString((Object)searchCommodityManageCombRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        return (UccSkuListQryAbilityRspBO)JSON.parseObject((String)json1, UccSkuListQryAbilityRspBO.class);
    }

    private void newResetStatus(List<UccSkuListCombQryBO> rows) {
        List skus = rows.stream().map(UccSkuListCombQryBO::getSkuId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skus)) {
            return;
        }
        ComBatchDealRecordPO comBatchDealRecordPO = new ComBatchDealRecordPO();
        comBatchDealRecordPO.setObjIdList(skus);
        List comBatchDealRecordPOList = this.comBatchDealRrecordMapper.getListByObjIds(comBatchDealRecordPO);
        if (!CollectionUtils.isEmpty((Collection)comBatchDealRecordPOList)) {
            Map objIdMap = comBatchDealRecordPOList.stream().collect(Collectors.toConcurrentMap(ComBatchDealRecordPO::getObjId, ComBatchDealRecordPO::getDealType));
            for (UccSkuListCombQryBO row : rows) {
                Integer dealType = (Integer)objIdMap.get(row.getSkuId());
                if (null == dealType) continue;
                if (SkuStatusConstants.SKU_STATUS_REJECT.equals(row.getSkuStatus()) && UccConstants.BatchDealType.SKU_REJECT.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_REJECT_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (SkuStatusConstants.SKU_STATUS_WAIT_SHELF.equals(row.getSkuStatus()) && UccConstants.BatchDealType.SKU_RE_TO_PUT_ON.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_WAIT_SHELF_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if ((SkuStatusConstants.SKU_STATUS_WAIT_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_ON_SHELF_EDIT_REJECT.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_PUT_ON_AUDIT_REJECT.equals(row.getSkuStatus())) && UccConstants.BatchDealType.SKU_PUT_ON.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_WAIT_SHELF_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if ((SkuStatusConstants.SKU_STATUS_DOWN_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_ECCOM_DOWN_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_FORCE_DOWN_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_WARING_DOWN_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_RE_PUT_ON_AUDIT_REJECT.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_SHELF_EDIT_REJECT.equals(row.getSkuStatus())) && UccConstants.BatchDealType.SKU_RE_PUT_ON.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_RE_ON_SHELF_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if ((SkuStatusConstants.SKU_STATUS_ON_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_PUT_OFF_AUDIT_REJECT.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_SHELF_EDIT_REJECT.equals(row.getSkuStatus())) && UccConstants.BatchDealType.SKU_PUT_OFF.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_ON_SHELF_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if ((SkuStatusConstants.SKU_STATUS_ON_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_ON_SHELF_EDIT_REJECT.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_PUT_OFF_AUDIT_REJECT.equals(row.getSkuStatus())) && UccConstants.BatchDealType.SKU_FROCE_PUT_OFF.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_ON_SHELF_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (SkuStatusConstants.SKU_STATUS_DRAFT.equals(row.getSkuStatus()) && UccConstants.BatchDealType.SKU_DELETE.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_DELETE_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (SkuStatusConstants.SKU_STATUS_DRAFT.equals(row.getSkuStatus()) && UccConstants.BatchDealType.COMM_EDIT_SUBMIT.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_EDIT_SUBMIT_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (SkuStatusConstants.SKU_STATUS_WAIT_SHELF.equals(row.getSkuStatus()) && UccConstants.BatchDealType.COMM_EDIT_SUBMIT_NOT_DRAFT_TO_PUT_ON.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_EDIT_SUBMIT_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (SkuStatusConstants.SKU_STATUS_ON_SHELF.equals(row.getSkuStatus()) && UccConstants.BatchDealType.COMM_EDIT_SUBMIT_NOT_DRAFT_ON_SHELF.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_EDIT_SUBMIT_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (SkuStatusConstants.SKU_STATUS_DOWN_SHELF.equals(row.getSkuStatus()) && UccConstants.BatchDealType.COMM_EDIT_SUBMIT_NOT_DRAFT_DOWN_SHELF.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_EDIT_SUBMIT_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (SkuStatusConstants.SKU_STATUS_WARING_DOWN_SHELF.equals(row.getSkuStatus()) && UccConstants.BatchDealType.COMM_EDIT_SUBMIT_NOT_DRAFT_DOWN_SHELF.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_EDIT_SUBMIT_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (!SkuStatusConstants.SKU_STATUS_FORCE_DOWN_SHELF.equals(row.getSkuStatus()) || !UccConstants.BatchDealType.COMM_EDIT_SUBMIT_NOT_DRAFT_TO_PUT_ON.equals(dealType)) continue;
                row.setSkuStatus(SkuStatusConstants.SKU_EDIT_SUBMIT_ING);
                row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
            }
        }
    }
}

