/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.atom.api.UccBatchDealOrderAddAtomService;
import com.tydic.commodity.common.atom.bo.UccBatchDealOrderAddAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccBatchDealOrderAddAtomRspBO;
import com.tydic.commodity.dao.ComBatchDealObjMapper;
import com.tydic.commodity.dao.ComBatchDealOrderMapper;
import com.tydic.commodity.po.ComBatchDealObjPO;
import com.tydic.commodity.po.ComBatchDealOrderPO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspInfoBO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccBatchDealOrderAddAtomServiceImpl
implements UccBatchDealOrderAddAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchDealOrderAddAtomServiceImpl.class);
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Autowired
    private ComBatchDealObjMapper comBatchDealObjMapper;

    @Override
    public UccBatchDealOrderAddAtomRspBO addBatchDealOrder(UccBatchDealOrderAddAtomReqBO atomReqBO) {
        Long orderId = Sequence.getInstance().nextId();
        String approveInstId = this.startProjectByMq(atomReqBO, orderId);
        this.insertBatchDealOrder(atomReqBO, orderId, approveInstId);
        ComBatchDealObjPO combatchdealobjpo = new ComBatchDealObjPO();
        combatchdealobjpo.setBatchNo(atomReqBO.getBatchNo());
        combatchdealobjpo.setOrderId(orderId);
        this.comBatchDealObjMapper.insertCopyBatchRecord(combatchdealobjpo);
        UccBatchDealOrderAddAtomRspBO rspBO = new UccBatchDealOrderAddAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return rspBO;
    }

    private void insertBatchDealOrder(UccBatchDealOrderAddAtomReqBO atomReqBO, Long orderId, String approveInstId) {
        ComBatchDealOrderPO comBatchDealOrderPO = new ComBatchDealOrderPO();
        comBatchDealOrderPO.setBatchNo(atomReqBO.getBatchNo());
        comBatchDealOrderPO.setOrderId(orderId);
        comBatchDealOrderPO.setOrderType(atomReqBO.getOrderType());
        comBatchDealOrderPO.setOrderCode(atomReqBO.getOrderCode());
        comBatchDealOrderPO.setOrderName(atomReqBO.getOrderName());
        comBatchDealOrderPO.setTotalNum(atomReqBO.getTotalNum());
        comBatchDealOrderPO.setOrderStatus(UccConstants.BatchDealOrderObjStatus.TO_AUDIT);
        comBatchDealOrderPO.setCurrentStatus(UccConstants.BatchDealOrderCurrentStatus.PROCESSING);
        comBatchDealOrderPO.setCreateTime(new Date());
        comBatchDealOrderPO.setCreateUserId(atomReqBO.getUserId());
        comBatchDealOrderPO.setCreateUserName(atomReqBO.getName());
        comBatchDealOrderPO.setBusiType(atomReqBO.getBusiType());
        comBatchDealOrderPO.setProcInstId(approveInstId);
        comBatchDealOrderPO.setSource(atomReqBO.getSource());
        this.comBatchDealOrderMapper.insert(comBatchDealOrderPO);
    }

    private String startProjectByMq(UccBatchDealOrderAddAtomReqBO atomReqBO, Long objId) {
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO;
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = new EacStartProjectAbilityReqBO();
        eacStartProjectAbilityReqBO.setSysCode("DYC");
        eacStartProjectAbilityReqBO.setProcDefKey(atomReqBO.getProcDefKey());
        ArrayList<String> businessIdList = new ArrayList<String>();
        businessIdList.add(objId.toString());
        eacStartProjectAbilityReqBO.setBusinessIdList(businessIdList);
        String busiType = atomReqBO.getBusiType().toString();
        if (busiType.equals(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccOnShelfProcessOrder.code());
        } else if (busiType.equals(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccOffShelfProcessOrder.code());
        } else if (busiType.equals(ApprovalTypeEnum.uccReinstateProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccReinstateProcessOrder.code());
        } else if (busiType.equals(ApprovalTypeEnum.uccEditProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccEditProcessOrder.code());
        } else if (busiType.equals(ApprovalTypeEnum.comm_edit_audit_to_shelf_uccEditProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.comm_edit_audit_to_shelf_uccEditProcessOrder.code());
        } else if (busiType.equals(ApprovalTypeEnum.comm_edit_audit_on_shelf_uccEditProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.comm_edit_audit_on_shelf_uccEditProcessOrder.code());
        } else if (busiType.equals(ApprovalTypeEnum.comm_edit_audit_down_shelf_uccEditProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.comm_edit_audit_down_shelf_uccEditProcessOrder.code());
        } else if (busiType.equals(ApprovalTypeEnum.sku_edit_audit_to_shelf_uccEditProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.sku_edit_audit_to_shelf_uccEditProcessOrder.code());
        } else if (busiType.equals(ApprovalTypeEnum.sku_edit_audit_on_shelf_uccEditProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.sku_edit_audit_on_shelf_uccEditProcessOrder.code());
        } else if (busiType.equals(ApprovalTypeEnum.sku_edit_audit_down_shelf_uccEditProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.sku_edit_audit_down_shelf_uccEditProcessOrder.code());
        } else if (busiType.equals(ApprovalTypeEnum.uccOnShelfProcessOrderTime.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccOnShelfProcessOrderTime.code());
        }
        eacStartProjectAbilityReqBO.setOrgId(atomReqBO.getOrgId().toString());
        eacStartProjectAbilityReqBO.setOrgName(atomReqBO.getOrgName());
        eacStartProjectAbilityReqBO.setUserId(atomReqBO.getUserId().toString());
        eacStartProjectAbilityReqBO.setUserName(atomReqBO.getName());
        try {
            log.info("\u521b\u5efa\u5ba1\u6279\u5355\u5165\u53c2eacStartProjectAbilityReqBO :" + JSON.toJSON((Object)eacStartProjectAbilityReqBO));
            eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
            log.info("\u521b\u5efa\u5ba1\u6279\u5355\u51fa\u53c2eacStartProjectAbilityRspBO:" + JSON.toJSON((Object)eacStartProjectAbilityRspBO));
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
        return ((EacStartProjectAbilityRspInfoBO)eacStartProjectAbilityRspBO.getData().get(0)).getApproveInstId();
    }
}

