/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.busi.api.UccQuoteCommodityDealBusiService;
import com.tydic.commodity.common.busi.bo.UccQuoteCommodityDealBusiServiceReqBO;
import com.tydic.commodity.common.busi.bo.UccQuoteCommodityDealBusiServiceRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccQuoteCommodityDealBusiServiceImpl
implements UccQuoteCommodityDealBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccQuoteCommodityDealBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;

    @Override
    public UccQuoteCommodityDealBusiServiceRspBO dealQuoteCommodityDeal(UccQuoteCommodityDealBusiServiceReqBO reqBO) {
        UccQuoteCommodityDealBusiServiceRspBO rspBO = new UccQuoteCommodityDealBusiServiceRspBO();
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuIdList(reqBO.getSkuIdList());
        uccSkuPo.setAgrType(UccConstants.AgrType.FRAMEWORK);
        uccSkuPo.setSkuStatus(SkuStatusConstants.SKU_STATUS_DOWN_SHELF);
        uccSkuPo.setBatchNo(reqBO.getBatchNo());
        List quoteSkuList = this.uccSkuMapper.getDownShelfQuoteSku(uccSkuPo);
        if (CollectionUtils.isNotEmpty((Collection)quoteSkuList)) {
            List<Long> quoteSkuIdList = quoteSkuList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            this.uccSkuMapper.updateQuoteStatus(quoteSkuIdList, SkuStatusConstants.SKU_STATUS_DOWN_SHELF);
            rspBO.setQuoteSkuIdList(quoteSkuIdList);
            List quoteCommodityIds = quoteSkuList.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
            this.uccCommodityMapper.updateQuoteCommodityStatus(quoteCommodityIds);
            List uccCommodityPos = this.uccCommodityMapper.batchQryCommd(quoteCommodityIds, null);
            this.updateEs(quoteSkuList, uccCommodityPos);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateEs(List<UccSkuPo> quoteSkuList, List<UccCommodityPo> uccCommodityPos) {
        Map uccCommodityPoMap = uccCommodityPos.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, Function.identity()));
        ConcurrentHashMap maps = new ConcurrentHashMap();
        for (UccSkuPo uccSkuPo : quoteSkuList) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("sku_status", SkuStatusConstants.SKU_STATUS_DOWN_SHELF);
            map.put("commodity_status", ((UccCommodityPo)uccCommodityPoMap.get(uccSkuPo.getCommodityId())).getCommodityStatus());
            maps.put(uccSkuPo.getSkuId(), map);
        }
        log.info("\u66f4\u65b0es\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(maps));
        this.elasticsearchUtil.updateBatchData(this.esConfig.getIndexName(), maps);
    }
}

