/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.comb.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchDealTaskReqJsonBO;
import com.tydic.commodity.base.bo.UccSyncAgrBO;
import com.tydic.commodity.base.bo.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.common.busi.api.UccBatchUpdateStatusBusiService;
import com.tydic.commodity.common.busi.api.UccQuoteCommodityDealBusiService;
import com.tydic.commodity.common.busi.bo.UccBatchUpdateStatusBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccBatchUpdateStatusBusiRspBO;
import com.tydic.commodity.common.busi.bo.UccQuoteCommodityDealBusiServiceReqBO;
import com.tydic.commodity.common.comb.api.UccBatchUpdateStatusCombService;
import com.tydic.commodity.common.comb.bo.UccBatchUpdateStatusCombReqBO;
import com.tydic.commodity.common.comb.bo.UccBatchUpdateStatusCombRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.ComBatchDealObjMapper;
import com.tydic.commodity.dao.ComBatchDealOrderMapper;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.ComBatchDealTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.po.ComBatchDealObjPO;
import com.tydic.commodity.po.ComBatchDealOrderPO;
import com.tydic.commodity.po.ComBatchDealTaskPO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccBatchUpdateStatusCombServiceImpl
implements UccBatchUpdateStatusCombService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchUpdateStatusCombServiceImpl.class);
    @Autowired
    private UccBatchUpdateStatusBusiService uccBatchUpdateStatusBusiService;
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private ComBatchDealObjMapper comBatchDealObjMapper;
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private ComBatchDealTaskMapper comBatchDealTaskMapper;
    @Autowired
    private UccQuoteCommodityDealBusiService uccQuoteCommodityDealBusiService;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private EsConfig esConfig;
    @Value(value="${ucc.batch.record.sync.es.qry.size:1000}")
    private int SIZE;
    @Value(value="${ucc.batch.record.sync.es.qry.increment:500}")
    private int INCREMENT;
    @Value(value="${ucc.batch.record.deal.quote.enable:true}")
    private Boolean dealQuoteEnable;
    public static final Integer PASS = 0;

    @Override
    public UccBatchUpdateStatusCombRspBO dealBatchUpdateStatus(UccBatchUpdateStatusCombReqBO reqBO) {
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO;
        this.val(reqBO);
        if (UccConstants.BatchDealType.COMM_DELETE.equals(reqBO.getDealType()) || UccConstants.BatchDealType.SKU_DELETE.equals(reqBO.getDealType())) {
            this.deleteAgrRel(reqBO);
        }
        UccBatchUpdateStatusBusiReqBO uccBatchUpdateStatusBusiReqBO = new UccBatchUpdateStatusBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccBatchUpdateStatusBusiReqBO);
        UccBatchDealTaskReqJsonBO uccBatchDealTaskReqJsonBO = (UccBatchDealTaskReqJsonBO)JSON.parseObject((String)reqBO.getReqJson(), UccBatchDealTaskReqJsonBO.class);
        uccBatchUpdateStatusBusiReqBO.setUserId(uccBatchDealTaskReqJsonBO.getUserId());
        uccBatchUpdateStatusBusiReqBO.setName(uccBatchDealTaskReqJsonBO.getName());
        uccBatchUpdateStatusBusiReqBO.setUccBatchDealTaskReqJsonBO(uccBatchDealTaskReqJsonBO);
        uccBatchUpdateStatusBusiReqBO.setNeedAudit(reqBO.getNeedAudit());
        UccBatchUpdateStatusBusiRspBO uccBatchUpdateStatusBusiRspBO = this.uccBatchUpdateStatusBusiService.dealBatchUpdateStatus(uccBatchUpdateStatusBusiReqBO);
        if (!"0000".equals(uccBatchUpdateStatusBusiRspBO.getRespCode())) {
            throw new BusinessException(uccBatchUpdateStatusBusiRspBO.getRespCode(), uccBatchUpdateStatusBusiRspBO.getRespDesc());
        }
        if (this.dealQuoteEnable.booleanValue() && reqBO.getQuoteCommodityDealFlag().booleanValue() && PASS.equals(uccBatchDealTaskReqJsonBO.getAuditResult())) {
            UccQuoteCommodityDealBusiServiceReqBO uccQuoteCommodityDealBusiServiceReqBO = new UccQuoteCommodityDealBusiServiceReqBO();
            uccQuoteCommodityDealBusiServiceReqBO.setBatchNo(reqBO.getBatchNo());
            this.uccQuoteCommodityDealBusiService.dealQuoteCommodityDeal(uccQuoteCommodityDealBusiServiceReqBO);
        }
        if (UccConstants.BatchDealType.COMM_DELETE.equals(reqBO.getDealType()) || UccConstants.BatchDealType.SKU_DELETE.equals(reqBO.getDealType())) {
            if (!CollectionUtils.isEmpty(uccBatchUpdateStatusBusiRspBO.getDelObjIdList())) {
                syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                ArrayList<Long> delObjIdList = new ArrayList<Long>();
                for (String delObjId : uccBatchUpdateStatusBusiRspBO.getDelObjIdList()) {
                    delObjIdList.add(Convert.toLong((Object)delObjId));
                }
                syncSceneCommodityToEsReqBO.setSkuIds(delObjIdList);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            if (!CollectionUtils.isEmpty(uccBatchUpdateStatusBusiRspBO.getDelCommodityIdList())) {
                this.elasticsearchUtil.deleteBatchData(this.esConfig.getIndexName(), uccBatchUpdateStatusBusiRspBO.getDelCommodityIdList().stream().map(s -> "cache" + s).collect(Collectors.toList()));
            }
            if (!CollectionUtils.isEmpty(uccBatchUpdateStatusBusiRspBO.getDelObjIdList()) || !CollectionUtils.isEmpty(uccBatchUpdateStatusBusiRspBO.getDelCommodityIdList())) {
                this.comBatchDealRrecordMapper.deleteByBatchNo(reqBO.getBatchNo(), reqBO.getOnShelveWay());
            }
        } else {
            this.updateIndex(reqBO, uccBatchUpdateStatusBusiRspBO, uccBatchDealTaskReqJsonBO);
        }
        if (!CollectionUtils.isEmpty(uccBatchUpdateStatusBusiRspBO.getDeleteSkuIds())) {
            syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(uccBatchUpdateStatusBusiRspBO.getDeleteSkuIds());
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        UccBatchUpdateStatusCombRspBO rspBO = new UccBatchUpdateStatusCombRspBO();
        BeanUtils.copyProperties((Object)((Object)uccBatchUpdateStatusBusiRspBO), (Object)((Object)rspBO));
        return rspBO;
    }

    private void deleteAgrRel(UccBatchUpdateStatusCombReqBO reqBO) {
        block6: {
            block7: {
                ComBatchDealTaskPO comBatchDealTaskPO = new ComBatchDealTaskPO();
                comBatchDealTaskPO.setBatchNo(reqBO.getBatchNo());
                ComBatchDealTaskPO po = this.comBatchDealTaskMapper.getModelBy(comBatchDealTaskPO);
                if (!ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION.equals(po.getSource())) break block6;
                if (!UccConstants.BatchDealType.SKU_DELETE.equals(reqBO.getDealType())) break block7;
                Page page = new Page(1, 1);
                List objIdList = this.comBatchDealRrecordMapper.getObjIdByBatchNo(page, reqBO.getBatchNo());
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSkuId((Long)objIdList.get(0));
                UccSkuPo po1 = this.uccSkuMapper.getModelBy(uccSkuPo);
                if (po1 == null || !UccConstants.MinimalismFlag.YES.equals(po1.getMinimalismFlag())) break block6;
                Page page1 = new Page(1, this.SIZE);
                List objIdList1 = this.comBatchDealRrecordMapper.getSyncAgrInfoBySkuId(page1, reqBO.getBatchNo());
                if (!CollectionUtils.isEmpty((Collection)objIdList)) {
                    this.deleteAgrRel1(objIdList1);
                    if (page.getTotalPages() > 1) {
                        for (int pageNo = 2; pageNo <= page.getTotalPages(); ++pageNo) {
                            Page pageAgain = new Page(pageNo, this.SIZE);
                            objIdList1 = this.comBatchDealRrecordMapper.getSyncAgrInfoBySkuId(pageAgain, reqBO.getBatchNo());
                            this.deleteAgrRel1(objIdList1);
                        }
                    }
                }
                break block6;
            }
            Page page = new Page(1, this.SIZE);
            List objIdList = this.comBatchDealRrecordMapper.getSyncAgrInfoByCommodityId(page, reqBO.getBatchNo());
            if (!CollectionUtils.isEmpty((Collection)objIdList)) {
                this.deleteAgrRel1(objIdList);
                if (page.getTotalPages() > 1) {
                    for (int pageNo = 2; pageNo <= page.getTotalPages(); ++pageNo) {
                        Page pageAgain = new Page(pageNo, this.SIZE);
                        objIdList = this.comBatchDealRrecordMapper.getSyncAgrInfoByCommodityId(pageAgain, reqBO.getBatchNo());
                        this.deleteAgrRel1(objIdList);
                    }
                }
            }
        }
    }

    private void deleteAgrRel1(List<UccSyncAgrBO> objIdList) {
        if (!CollectionUtils.isEmpty(objIdList)) {
            Map<String, List<UccSyncAgrBO>> map = objIdList.stream().collect(Collectors.groupingBy(UccSyncAgrBO::getAgreementId));
            for (String key : map.keySet()) {
                List agreementSkuIds = map.get(key).stream().map(UccSyncAgrBO::getAgreementDetailsId).collect(Collectors.toList());
                try {
                    UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
                    notifyMessageBO.setAgreementId(key);
                    notifyMessageBO.setAgreementSkuIds(agreementSkuIds);
                    notifyMessageBO.setAgreementSkuStatus("20");
                    notifyMessageBO.setMemIdIn(Long.valueOf(1L));
                    log.info("\u534f\u8bae\u5546\u54c1\u5220\u9664\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
                    this.zoneGoodsAuditMQ.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TOPIC"), PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
                }
                catch (Exception var16) {
                    log.error("\u534f\u8bae\u5546\u54c1\u5220\u9664\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
                    throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
                }
            }
        }
    }

    private void val(UccBatchUpdateStatusCombReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (!reqBO.getRevokeFlag().booleanValue() && null == reqBO.getSkuStatus() && null == reqBO.getSpuStatus()) {
            throw new BusinessException("0001", "\u5546\u54c1\u3001\u5355\u54c1\u72b6\u6001\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBatchNo())) {
            throw new BusinessException("0001", "\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updateIndex(UccBatchUpdateStatusCombReqBO reqBO, UccBatchUpdateStatusBusiRspBO uccBatchUpdateStatusBusiRspBO, UccBatchDealTaskReqJsonBO uccBatchDealTaskReqJsonBO) {
        Integer objTypeByBatchNo = this.comBatchDealRrecordMapper.getObjTypeByBatchNo(reqBO.getBatchNo());
        Page page = new Page(1, this.SIZE);
        List objIdList = this.comBatchDealRrecordMapper.getObjIdByBatchNo(page, reqBO.getBatchNo());
        if (!CollectionUtils.isEmpty((Collection)objIdList) && (UccConstants.BatchObjType.SKU.equals(objTypeByBatchNo) || UccConstants.BatchObjType.COMMODITY.equals(objTypeByBatchNo))) {
            this.dealObjData(objIdList, objTypeByBatchNo, uccBatchUpdateStatusBusiRspBO, uccBatchDealTaskReqJsonBO, reqBO.getDealType(), reqBO.getAsyncFlag());
            if (page.getTotalPages() > 1) {
                for (int pageNo = 2; pageNo <= page.getTotalPages(); ++pageNo) {
                    Page pageAgain = new Page(pageNo, this.SIZE);
                    objIdList = this.comBatchDealRrecordMapper.getObjIdByBatchNo(pageAgain, reqBO.getBatchNo());
                    this.dealObjData(objIdList, objTypeByBatchNo, uccBatchUpdateStatusBusiRspBO, uccBatchDealTaskReqJsonBO, reqBO.getDealType(), reqBO.getAsyncFlag());
                }
            }
            if (!(SkuStatusConstants.SKU_STATUS_EDIT_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_PUT_ON_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_PUT_OFF_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_ON_SHELF_EDIT_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_SHELF_EDIT_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_DOWN_SHELF_EDIT_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_RE_PUT_ON_AUDITING.equals(reqBO.getSkuStatus()))) {
                this.comBatchDealRrecordMapper.deleteByBatchNo(reqBO.getBatchNo(), reqBO.getOnShelveWay());
            }
            ComBatchDealOrderPO set = new ComBatchDealOrderPO();
            if (null == reqBO.getSpuStatus()) {
                set.setCurrentStatus(reqBO.getSkuStatus());
            } else {
                set.setCurrentStatus(reqBO.getSpuStatus());
            }
            ComBatchDealOrderPO where = new ComBatchDealOrderPO();
            where.setBatchNo(reqBO.getBatchNo());
            this.comBatchDealOrderMapper.updateBy(set, where);
        }
    }

    private void dealObjData(List<Long> objIdList, Integer objType, UccBatchUpdateStatusBusiRspBO uccBatchUpdateStatusBusiRspBO, UccBatchDealTaskReqJsonBO uccBatchDealTaskReqJsonBO, Integer dealType, boolean asyncFlag) {
        List uccSkuPoList = this.uccSkuMapper.getSkuStatusByObjIds(objIdList, objType);
        if (!CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setState(Integer.valueOf(1));
            uccSkuPutCirPo.setSkuIdList(uccSkuPoList.stream().map(UccSkuPo::getSkuId).distinct().collect(Collectors.toList()));
            List uccSkuPutCirPos = this.uccSkuPutCirMapper.querySkuPutCir(uccSkuPutCirPo);
            List uccCommodityPoList = this.uccCommodityMapper.getCommodityStatusByCommodityIds(uccSkuPoList.stream().map(UccSkuPo::getCommodityId).distinct().collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty((Collection)uccCommodityPoList)) {
                objIdList.addAll(uccCommodityPoList.stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList()));
                List comBatchDealObjPOList = this.comBatchDealObjMapper.getListByObjIds(objIdList);
                ConcurrentMap<Long, UccCommodityPo> commodityMap = uccCommodityPoList.stream().collect(Collectors.toConcurrentMap(UccCommodityPo::getCommodityId, Function.identity()));
                ConcurrentMap<Long, UccSkuPo> skuStatusMap = uccSkuPoList.stream().collect(Collectors.toConcurrentMap(UccSkuPo::getSkuId, o -> o));
                Map<Long, UccSkuPutCirPo> skuPutCirPoMap = uccSkuPutCirPos.stream().collect(Collectors.toMap(UccSkuPutCirPo::getSkuId, Function.identity(), (o1, o2) -> o2));
                ArrayList<UccSkuPo> otherUccSkuPoList = new ArrayList<UccSkuPo>();
                if (UccConstants.BatchObjType.SKU.equals(objType)) {
                    otherUccSkuPoList.addAll(this.uccSkuMapper.getSkuStatusByObjIds(new ArrayList(commodityMap.keySet()), UccConstants.BatchObjType.COMMODITY));
                    otherUccSkuPoList.removeIf(uccSkuPo -> skuStatusMap.containsKey(uccSkuPo.getSkuId()));
                }
                int times = uccSkuPoList.size() % this.INCREMENT == 0 ? uccSkuPoList.size() / this.INCREMENT : uccSkuPoList.size() / this.INCREMENT + 1;
                int startIndex = 0;
                int endIndex = this.INCREMENT;
                for (int i = 1; i <= times; ++i) {
                    List<UccSkuPo> subList = uccSkuPoList.subList(startIndex, i == times ? uccSkuPoList.size() : endIndex);
                    this.syncEs(objType, subList, comBatchDealObjPOList, commodityMap, skuStatusMap, uccBatchUpdateStatusBusiRspBO, uccBatchDealTaskReqJsonBO, dealType, otherUccSkuPoList, asyncFlag, skuPutCirPoMap);
                    startIndex += this.INCREMENT;
                    endIndex += this.INCREMENT;
                }
            }
        }
    }

    private void syncEs(Integer objType, List<UccSkuPo> uccSkuPoList, List<ComBatchDealObjPO> comBatchDealObjPOList, ConcurrentMap<Long, UccCommodityPo> commodityMap, ConcurrentMap<Long, UccSkuPo> skuStatusMap, UccBatchUpdateStatusBusiRspBO uccBatchUpdateStatusBusiRspBO, UccBatchDealTaskReqJsonBO uccBatchDealTaskReqJsonBO, Integer dealType, List<UccSkuPo> otherUccSkuPoList, boolean asyncFlag, Map<Long, UccSkuPutCirPo> skuPutCirPoMap) {
        if (UccConstants.BatchDealType.BATCH_AUDIT.equals(dealType) && null != uccBatchUpdateStatusBusiRspBO.getEditBatchId() && null != uccBatchDealTaskReqJsonBO.getAuditResult() && uccBatchDealTaskReqJsonBO.getAuditResult() == 0) {
            ConcurrentMap<Long, List<UccSkuPo>> supplierSkuMap = uccSkuPoList.stream().collect(Collectors.groupingByConcurrent(UccSkuPo::getSupplierShopId));
            supplierSkuMap.forEach((supplierId, uccSkuPos) -> {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                syncSceneCommodityToEsReqBO.setSupplierId(supplierId);
                if (asyncFlag) {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                } else {
                    this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                }
            });
        } else {
            HashMap<String, Number> map;
            ConcurrentHashMap maps = new ConcurrentHashMap();
            for (UccSkuPo uccSkuPo : uccSkuPoList) {
                map = new HashMap<String, Number>();
                map.put("sku_status", ((UccSkuPo)skuStatusMap.get(uccSkuPo.getSkuId())).getSkuStatus());
                map.put("agr_type", ((UccSkuPo)skuStatusMap.get(uccSkuPo.getSkuId())).getAgrType());
                if (null != ((UccSkuPo)skuStatusMap.get(uccSkuPo.getSkuId())).getOffShelveWay()) {
                    map.put("off_shelve_way", ((UccSkuPo)skuStatusMap.get(uccSkuPo.getSkuId())).getOffShelveWay());
                }
                if (null != uccSkuPo.getOnShelveTime()) {
                    map.put("up_time", uccSkuPo.getOnShelveTime().getTime());
                    map.put("on_shelve_time", uccSkuPo.getOnShelveTime().getTime());
                }
                map.put("commodity_status", ((UccCommodityPo)commodityMap.get(uccSkuPo.getCommodityId())).getCommodityStatus());
                if (null != ((UccCommodityPo)commodityMap.get(uccSkuPo.getCommodityId())).getSubmitTime()) {
                    map.put("submitTime", ((UccCommodityPo)commodityMap.get(uccSkuPo.getCommodityId())).getSubmitTime().getTime());
                }
                map.put("audit_no_list", (Number)JSON.parseArray((String)JSON.toJSONString(comBatchDealObjPOList)));
                if (null != skuPutCirPoMap.get(uccSkuPo.getSkuId()) && null != skuPutCirPoMap.get(uccSkuPo.getSkuId()).getRealDownTime()) {
                    map.put("down_time", skuPutCirPoMap.get(uccSkuPo.getSkuId()).getRealDownTime().getTime());
                }
                maps.put(uccSkuPo.getSkuId(), map);
            }
            if (!CollectionUtils.isEmpty(otherUccSkuPoList)) {
                for (UccSkuPo uccSkuPo : otherUccSkuPoList) {
                    map = new HashMap();
                    map.put("commodity_status", ((UccCommodityPo)commodityMap.get(uccSkuPo.getCommodityId())).getCommodityStatus());
                    maps.put(uccSkuPo.getSkuId(), map);
                }
            }
            log.info("\u66f4\u65b0es\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(maps));
            this.elasticsearchUtil.updateBatchData(this.esConfig.getIndexName(), maps);
        }
    }
}

