/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.AttrValueBO;
import com.tydic.commodity.base.bo.CommodityPropDefIdBo;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccCommodityQryGroupDefAbilityService;
import com.tydic.commodity.common.ability.bo.UccCommodityQryGroupDefAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCommodityQryGroupDefAbilityRspBO;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccParamsConfigDetailMapper;
import com.tydic.commodity.dao.UccParamsConfigMapper;
import com.tydic.commodity.dao.UccPropValueListMapper;
import com.tydic.commodity.po.UccCommdPropDefPo;
import com.tydic.commodity.po.UccParamsConfigDetailPO;
import com.tydic.commodity.po.UccParamsConfigPO;
import com.tydic.commodity.po.UccPropValueListPo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCommodityQryGroupDefAbilityService"})
public class UccCommodityQryGroupDefAbilityServiceImpl
implements UccCommodityQryGroupDefAbilityService {
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccPropValueListMapper uccPropValueListMapper;
    @Autowired
    private UccParamsConfigMapper uccParamsConfigMapper;
    @Autowired
    private UccParamsConfigDetailMapper uccParamsConfigDetailMapper;
    public static final Integer NOT_SHOW_ECOM_PROP = 0;

    @PostMapping(value={"qryGroupDefListPage"})
    public UccCommodityQryGroupDefAbilityRspBO qryGroupDefListPage(@RequestBody UccCommodityQryGroupDefAbilityReqBO reqBO) {
        this.val(reqBO);
        Integer ecomPropConfig = this.getConfig();
        UccCommodityQryGroupDefAbilityRspBO rspBO = new UccCommodityQryGroupDefAbilityRspBO();
        ArrayList<CommodityPropDefIdBo> commodityPropDefIdBos = new ArrayList<CommodityPropDefIdBo>();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List uccCommdPropDefPoList = this.uccCommodityPropDefMapper.queryGrpPropPage(reqBO.getCommodityPropGrpId(), reqBO.getTemporarySource(), reqBO.getPropName(), ecomPropConfig, page);
        ArrayList<Long> commodityPropDefIds = new ArrayList<Long>();
        if (uccCommdPropDefPoList != null && !uccCommdPropDefPoList.isEmpty()) {
            for (UccCommdPropDefPo each : uccCommdPropDefPoList) {
                String json2 = JSONObject.toJSONString((Object)each, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                CommodityPropDefIdBo commodityPropDefIdBo = (CommodityPropDefIdBo)JSON.parseObject((String)json2, CommodityPropDefIdBo.class);
                commodityPropDefIdBos.add(commodityPropDefIdBo);
                commodityPropDefIds.add(commodityPropDefIdBo.getCommodityPropDefId());
            }
        }
        if (!CollectionUtils.isEmpty(commodityPropDefIds)) {
            List uccPropValueListPos = this.uccPropValueListMapper.queryPropValueBatch(commodityPropDefIds, reqBO.getTemporarySource(), ecomPropConfig);
            ConcurrentMap<Long, List<UccPropValueListPo>> concurrentMap = uccPropValueListPos.stream().collect(Collectors.groupingByConcurrent(UccPropValueListPo::getCommodityPropDefId));
            commodityPropDefIdBos.forEach(po -> {
                ArrayList<AttrValueBO> attrValueBOS = new ArrayList<AttrValueBO>();
                List uccPropValueListPoList = (List)concurrentMap.get(po.getCommodityPropDefId());
                if (uccPropValueListPoList != null && !uccPropValueListPoList.isEmpty()) {
                    for (UccPropValueListPo each : uccPropValueListPoList) {
                        String json2 = JSONObject.toJSONString((Object)each, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                        AttrValueBO attrValueBO = (AttrValueBO)JSON.parseObject((String)json2, AttrValueBO.class);
                        attrValueBOS.add(attrValueBO);
                    }
                }
                po.setAttrValues(attrValueBOS);
            });
        }
        rspBO.setRows(commodityPropDefIdBos);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(UccCommodityQryGroupDefAbilityReqBO reqBO) {
        if (null == reqBO.getCommodityPropGrpId()) {
            throw new BusinessException("8888", "\u5165\u53c2\u5c5e\u6027\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Integer getConfig() {
        UccParamsConfigPO uccParamsConfigPO = new UccParamsConfigPO();
        uccParamsConfigPO.setParamsCode("ECOM_PROP_SETTING");
        uccParamsConfigPO = this.uccParamsConfigMapper.getModelBy(uccParamsConfigPO);
        if (null != uccParamsConfigPO) {
            UccParamsConfigDetailPO uccParamsConfigDetailPO = new UccParamsConfigDetailPO();
            uccParamsConfigDetailPO.setParamsId(uccParamsConfigPO.getParamsId());
            uccParamsConfigDetailPO = this.uccParamsConfigDetailMapper.getModelBy(uccParamsConfigDetailPO);
            return uccParamsConfigDetailPO.getEnable();
        }
        return NOT_SHOW_ECOM_PROP;
    }
}

