/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.CommodityStatusConstants;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.api.UccSkuImageBatchEditAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuImageBatchEditAbilityImageBo;
import com.tydic.commodity.common.ability.bo.UccSkuImageBatchEditAbilityServiceReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuImageBatchEditAbilityServiceRspBo;
import com.tydic.commodity.common.ability.bo.UccSkuImageBatchEditAbilityServiceRspImageBo;
import com.tydic.commodity.common.busi.api.UccSkuImageBatchEditBusiService;
import com.tydic.commodity.common.busi.bo.UccSkuImageBatchEditBusiReqBo;
import com.tydic.commodity.common.busi.bo.UccSkuImageBatchEditBusiRspBo;
import com.tydic.commodity.common.innserbo.UccBatchEditSkuImagesTmpBo;
import com.tydic.commodity.common.innserbo.UccBatchEditSkuImagesTmpImageBo;
import com.tydic.commodity.config.UccIdGenerator;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuImageBatchEditAbilityService"})
public class UccSkuImageBatchEditAbilityServiceImpl
implements UccSkuImageBatchEditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuImageBatchEditAbilityServiceImpl.class);
    @Autowired
    private UccIdGenerator uccIdGenerator;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuImageBatchEditBusiService uccSkuImageBatchEditBusiService;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;
    @Value(value="${ucc.imageNameRegex:^[\\d]*_[12345]{1}.((jpg)|(png)|(jpeg))$}")
    private String imageNameRegex;
    @Value(value="${ucc.imageMaxCount:5}")
    private int imageMaxCount;
    @Value(value="${ucc.validateCommodityApproving:true}")
    private boolean validateCommodityApproving;

    @PostMapping(value={"dealBatchEditGoodImages"})
    public UccSkuImageBatchEditAbilityServiceRspBo dealBatchEditGoodImages(@RequestBody UccSkuImageBatchEditAbilityServiceReqBo reqBO) {
        UccSkuImageBatchEditAbilityServiceRspBo rspBO = new UccSkuImageBatchEditAbilityServiceRspBo();
        this.validate(reqBO);
        List<UccBatchEditSkuImagesTmpBo> tmpBoList = this.convertToInnerBoAndValidate(reqBO);
        ArrayList<UccBatchEditSkuImagesTmpBo> validateSuccessList = new ArrayList<UccBatchEditSkuImagesTmpBo>();
        HashMap<String, List<String>> skuFailMap = new HashMap<String, List<String>>();
        this.validateInnerBo(tmpBoList, validateSuccessList, skuFailMap);
        if (ObjectUtil.isNotEmpty(validateSuccessList)) {
            List skuCodeList = validateSuccessList.stream().map(UccBatchEditSkuImagesTmpBo::getSkuCode).distinct().collect(Collectors.toList());
            List uccSkuPos = this.uccSkuMapper.querySkuByCode(skuCodeList);
            Map<String, UccSkuPo> skuPoMap = uccSkuPos.stream().collect(Collectors.toMap(UccSkuPo::getSkuCode, item -> item));
            Map<Object, Object> commodityIdVsApprovalStatusMap = new HashMap();
            if (ObjectUtil.isNotEmpty((Object)uccSkuPos) && this.validateCommodityApproving) {
                log.info("\u5546\u54c1\u56fe\u7247\u6279\u91cf\u7f16\u8f91\uff0c\u9700\u8981\u67e5\u8be2\u5546\u54c1\u72b6\u6001");
                List commodityIds = uccSkuPos.stream().map(UccSkuPo::getCommodityId).distinct().collect(Collectors.toList());
                List uccCommodityPoList = this.uccCommodityMapper.queryCommodityTypeByCommodityId(commodityIds, null);
                commodityIdVsApprovalStatusMap = uccCommodityPoList.stream().filter(o -> null != o.getCommodityStatus()).collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo::getCommodityStatus));
            }
            ArrayList<UccBatchEditSkuImagesTmpBo> realValidateSuccessList = new ArrayList<UccBatchEditSkuImagesTmpBo>();
            for (UccBatchEditSkuImagesTmpBo imagesTmpBo : validateSuccessList) {
                String skuCode = imagesTmpBo.getSkuCode();
                List<UccBatchEditSkuImagesTmpImageBo> imageBoList = imagesTmpBo.getImageBoList();
                if (skuPoMap.containsKey(skuCode)) {
                    UccSkuPo uccSkuPo = skuPoMap.get(skuCode);
                    imagesTmpBo.setSkuId(uccSkuPo.getSkuId());
                    imagesTmpBo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                    imagesTmpBo.setCommodityId(uccSkuPo.getCommodityId());
                    for (UccBatchEditSkuImagesTmpImageBo imageBo : imageBoList) {
                        imageBo.setSkuId(uccSkuPo.getSkuId());
                        imageBo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                    }
                    boolean checkApproving = true;
                    if (this.validateCommodityApproving) {
                        Integer commodityApproveStatus;
                        log.info("\u5546\u54c1\u56fe\u7247\u6279\u91cf\u7f16\u8f91\uff0c\u8fdb\u884c\u72b6\u6001\u6821\u9a8c");
                        if (ObjectUtil.isNotEmpty(commodityIdVsApprovalStatusMap) && ObjectUtil.isNotEmpty((Object)(commodityApproveStatus = (Integer)commodityIdVsApprovalStatusMap.get(imagesTmpBo.getCommodityId()))) && CommodityStatusConstants.COMMD_STATUS_EDIT_AUDITING.equals(commodityApproveStatus)) {
                            checkApproving = false;
                            this.checkAndCleanSkuCodeList(skuFailMap, skuCode);
                            for (UccBatchEditSkuImagesTmpImageBo imageBo : imageBoList) {
                                this.putSkuFailListToMap(skuFailMap, skuCode, "\u5355\u54c1\u7f16\u7801(" + imageBo.getInputImageName() + ")\u5546\u54c1\u6b63\u5728\u7f16\u8f91\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u6279\u91cf\u7ef4\u62a4\u56fe\u7247");
                            }
                        }
                    }
                    if (!checkApproving) continue;
                    realValidateSuccessList.add(imagesTmpBo);
                    continue;
                }
                this.checkAndCleanSkuCodeList(skuFailMap, skuCode);
                for (UccBatchEditSkuImagesTmpImageBo imageBo : imageBoList) {
                    this.putSkuFailListToMap(skuFailMap, skuCode, "\u56fe\u7247(" + imageBo.getInputImageName() + ")\u5bf9\u5e94\u5355\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
                }
            }
            for (UccBatchEditSkuImagesTmpBo imagesTmpBo : realValidateSuccessList) {
                UccSkuImageBatchEditBusiRspBo updateRspBo;
                if (!CollectionUtils.isEmpty(imagesTmpBo.getImageBoList()) && imagesTmpBo.getImageBoList().size() < 5) {
                    int supplementPicCount = this.imageMaxCount - imagesTmpBo.getImageBoList().size();
                    for (int i = 1; i <= supplementPicCount; ++i) {
                        UccBatchEditSkuImagesTmpImageBo uccBatchEditSkuImagesTmpImageBo = (UccBatchEditSkuImagesTmpImageBo)JUtil.js((Object)imagesTmpBo.getImageBoList().get(0), UccBatchEditSkuImagesTmpImageBo.class);
                        uccBatchEditSkuImagesTmpImageBo.setSkuPicId(this.uccIdGenerator.nextId());
                        uccBatchEditSkuImagesTmpImageBo.setSkuPicUrl(null);
                        uccBatchEditSkuImagesTmpImageBo.setInputImageName(null);
                        uccBatchEditSkuImagesTmpImageBo.setCommodityPicType(2);
                        uccBatchEditSkuImagesTmpImageBo.setPicOrder(imagesTmpBo.getImageBoList().get(this.imageMaxCount - supplementPicCount - 1).getPicOrder() + i);
                        imagesTmpBo.getImageBoList().add(uccBatchEditSkuImagesTmpImageBo);
                    }
                }
                if ("0000".equals((updateRspBo = this.uccSkuImageBatchEditBusiService.updateSkuImages(new UccSkuImageBatchEditBusiReqBo(imagesTmpBo))).getRespCode())) {
                    this.syncToEs(skuFailMap, imagesTmpBo);
                    continue;
                }
                this.checkAndCleanSkuCodeList(skuFailMap, imagesTmpBo.getSkuCode());
                for (UccBatchEditSkuImagesTmpImageBo imageBo : imagesTmpBo.getImageBoList()) {
                    this.putSkuFailListToMap(skuFailMap, imagesTmpBo.getSkuCode(), "\u5355\u54c1\u7f16\u7801(" + imageBo.getInputImageName() + ")\u66f4\u65b0\u5931\u8d25\uff1a" + updateRspBo.getRespDesc());
                }
            }
        }
        this.fileFailObject(rspBO, skuFailMap);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncToEs(Map<String, List<String>> skuFailMap, UccBatchEditSkuImagesTmpBo imagesTmpBo) {
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds((List)ListUtil.toList((Object[])new Long[]{imagesTmpBo.getSkuId()}));
        syncSceneCommodityToEsReqBO.setSupplierId(imagesTmpBo.getSupplierShopId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
            e.printStackTrace();
            this.checkAndCleanSkuCodeList(skuFailMap, imagesTmpBo.getSkuCode());
            for (UccBatchEditSkuImagesTmpImageBo imageBo : imagesTmpBo.getImageBoList()) {
                this.putSkuFailListToMap(skuFailMap, imagesTmpBo.getSkuCode(), "\u5355\u54c1\u7f16\u7801(" + imageBo.getInputImageName() + ")\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
            }
        }
    }

    private void checkAndCleanSkuCodeList(Map<String, List<String>> skuFailMap, String skuCode) {
        List<String> failList = skuFailMap.get(skuCode);
        if (ObjectUtil.isNotEmpty(failList)) {
            skuFailMap.put(skuCode, null);
        }
    }

    private void fileFailObject(UccSkuImageBatchEditAbilityServiceRspBo rspBO, Map<String, List<String>> skuFailMap) {
        if (ObjectUtil.isNotEmpty(skuFailMap)) {
            for (List<String> value : skuFailMap.values()) {
                for (String failStr : value) {
                    rspBO.getFailReasonList().add(new UccSkuImageBatchEditAbilityServiceRspImageBo(failStr));
                }
            }
        }
    }

    private void validateInnerBo(List<UccBatchEditSkuImagesTmpBo> tmpBoList, List<UccBatchEditSkuImagesTmpBo> validateSuccessList, Map<String, List<String>> skuFailMap) {
        for (UccBatchEditSkuImagesTmpBo tmpBo : tmpBoList) {
            boolean checkOk = this.checkImageBo(tmpBo, skuFailMap);
            if (!checkOk) continue;
            validateSuccessList.add(tmpBo);
        }
    }

    private boolean checkImageBo(UccBatchEditSkuImagesTmpBo tmpBo, Map<String, List<String>> skuFailMap) {
        List<UccBatchEditSkuImagesTmpImageBo> imageBoList = tmpBo.getImageBoList();
        String skuCode = tmpBo.getSkuCode();
        if (imageBoList.size() > this.imageMaxCount) {
            for (UccBatchEditSkuImagesTmpImageBo tmpImageBo : imageBoList) {
                this.putSkuFailListToMap(skuFailMap, skuCode, "\u5355\u54c1\u56fe\u7247[" + tmpImageBo.getInputImageName() + "]\u8d85\u8fc7\u6700\u5927\u9650\u5236[" + this.imageMaxCount + "]\u5f20\u4e86!");
            }
            return false;
        }
        boolean haveMainImage = false;
        for (UccBatchEditSkuImagesTmpImageBo tmpImageBo : imageBoList) {
            if (!UccConstants.CommodityPicType.MAIN.equals(tmpImageBo.getCommodityPicType())) continue;
            haveMainImage = true;
            break;
        }
        if (!haveMainImage) {
            for (UccBatchEditSkuImagesTmpImageBo tmpImageBo : imageBoList) {
                this.putSkuFailListToMap(skuFailMap, skuCode, "\u5355\u54c1\u56fe\u7247[" + tmpImageBo.getInputImageName() + "]\u4e0d\u5305\u542b\u4e3b\u56fe");
            }
            return false;
        }
        boolean haveOneMainImage = false;
        boolean haveOneMainImageReal = false;
        for (UccBatchEditSkuImagesTmpImageBo tmpImageBo : imageBoList) {
            if (!UccConstants.CommodityPicType.MAIN.equals(tmpImageBo.getCommodityPicType())) continue;
            if (haveOneMainImage) {
                haveOneMainImageReal = true;
                break;
            }
            haveOneMainImage = true;
        }
        if (haveOneMainImageReal) {
            for (UccBatchEditSkuImagesTmpImageBo tmpImageBo : imageBoList) {
                this.putSkuFailListToMap(skuFailMap, skuCode, "\u5355\u54c1\u56fe\u7247[" + tmpImageBo.getInputImageName() + "]\u5305\u542b\u591a\u5f20\u4e3b\u56fe");
            }
            return false;
        }
        return true;
    }

    void putSkuFailListToMap(Map<String, List<String>> skuFailMap, String skuCode, String failStr) {
        List<String> failList = skuFailMap.get(skuCode);
        if (ObjectUtil.isEmpty(failList)) {
            failList = new ArrayList<String>();
            skuFailMap.put(skuCode, failList);
        }
        failList.add(failStr);
    }

    private List<UccBatchEditSkuImagesTmpBo> convertToInnerBoAndValidate(UccSkuImageBatchEditAbilityServiceReqBo reqBO) {
        HashMap<String, UccBatchEditSkuImagesTmpBo> skuMap = new HashMap<String, UccBatchEditSkuImagesTmpBo>();
        Date now = new Date();
        List skuImagesList = reqBO.getSkuImagesList();
        for (UccSkuImageBatchEditAbilityImageBo imagesBO : skuImagesList) {
            String skuImageName = imagesBO.getSkuImageName();
            String skuCode = skuImageName.substring(0, skuImageName.indexOf("_"));
            Integer imageOrder = Integer.valueOf(skuImageName.substring(skuImageName.indexOf("_") + 1, skuImageName.indexOf(".")));
            UccBatchEditSkuImagesTmpBo tmpBo = (UccBatchEditSkuImagesTmpBo)skuMap.get(skuCode);
            if (tmpBo == null) {
                tmpBo = new UccBatchEditSkuImagesTmpBo();
                tmpBo.setSkuCode(skuCode);
                skuMap.put(skuCode, tmpBo);
            }
            List<UccBatchEditSkuImagesTmpImageBo> imageBoList = tmpBo.getImageBoList();
            UccBatchEditSkuImagesTmpImageBo imageBo = new UccBatchEditSkuImagesTmpImageBo();
            imageBo.setCreateTime(now);
            imageBo.setUpdateTime(now);
            if (UccConstants.CommodityPicType.MAIN.equals(imageOrder)) {
                imageBo.setRemark("\u4e3b\u56fe");
            } else {
                imageBo.setRemark("\u7ec6\u8282\u56fe");
            }
            imageBo.setPicOrder(imageOrder);
            if (UccConstants.CommodityPicType.MAIN.equals(imageOrder)) {
                imageBo.setCommodityPicType(UccConstants.CommodityPicType.MAIN);
            } else {
                imageBo.setCommodityPicType(UccConstants.CommodityPicType.DETAIL);
            }
            imageBo.setSkuPicId(this.uccIdGenerator.nextId());
            imageBo.setSkuPicUrl(imagesBO.getSkuImageAddress());
            imageBo.setInputImageName(skuImageName);
            imageBoList.add(imageBo);
        }
        return new ArrayList<UccBatchEditSkuImagesTmpBo>(skuMap.values());
    }

    private void validate(UccSkuImageBatchEditAbilityServiceReqBo reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuImagesList())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccSkuImageBatchEditAbilityImageBo bo : reqBO.getSkuImagesList()) {
            if (StringUtil.isEmpty((String)bo.getSkuImageName())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u7684[skuImageName]\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)bo.getSkuImageAddress())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u7684[skuImageAddress]\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Pattern p = Pattern.compile(this.imageNameRegex, 2);
            if (p.matcher(bo.getSkuImageName()).matches()) continue;
            throw new ZTBusinessException("\u5546\u54c1\u7f16\u7801(" + bo.getSkuImageName() + ")\u56fe\u7247\u547d\u540d\u4e0d\u7b26\u5408\u8981\u6c42\uff1a\u5355\u54c1\u7f16\u7801_xxx.\u56fe\u7247\u540e\u7f00");
        }
    }
}

