/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSkuWhiteListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuWhiteListQryAbilityServiceReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuWhiteListQryAbilityServiceRspBo;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuWhiteListQryAbilityService"})
public class UccSkuWhiteListQryAbilityServiceImpl
implements UccSkuWhiteListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuWhiteListQryAbilityServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    @PostMapping(value={"qrySkuWhite"})
    public UccSkuWhiteListQryAbilityServiceRspBo qrySkuWhite(@RequestBody UccSkuWhiteListQryAbilityServiceReqBo reqBo) {
        this.val(reqBo);
        String result = this.searchInfo(this.buildQry(reqBo));
        List<Long> whiteList = this.parseReturn(result);
        UccSkuWhiteListQryAbilityServiceRspBo rspBo = new UccSkuWhiteListQryAbilityServiceRspBo();
        rspBo.setWhiteOrgIdList(whiteList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<Long> parseReturn(String result) {
        JSONObject resultObj = JSON.parseObject((String)result);
        JSONObject hitsObj = resultObj.getJSONObject("hits");
        JSONArray hitsArray = hitsObj.getJSONArray("hits");
        JSONObject dataObj = hitsArray.getJSONObject(0);
        JSONObject source = dataObj.getJSONObject("_source");
        return source.getJSONArray("whitelist").stream().map(Convert::toLong).collect(Collectors.toList());
    }

    private String buildQry(UccSkuWhiteListQryAbilityServiceReqBo reqBo) {
        JSONObject qryObj = new JSONObject();
        JSONArray sourceArray = new JSONArray();
        sourceArray.add((Object)"whitelist");
        JSONObject query = new JSONObject();
        JSONObject bool = new JSONObject();
        JSONArray mustArray = new JSONArray();
        JSONObject match = new JSONObject();
        JSONObject must = new JSONObject();
        match.put("sku_id", (Object)reqBo.getSkuId());
        must.put("match", (Object)match);
        mustArray.add((Object)must);
        bool.put("must", (Object)mustArray);
        query.put("bool", (Object)bool);
        qryObj.put("_source", (Object)sourceArray);
        qryObj.put("query", (Object)query);
        return qryObj.toJSONString();
    }

    private void val(UccSkuWhiteListQryAbilityServiceReqBo reqBo) {
        if (null == reqBo.getSkuId()) {
            throw new BusinessException("0001", "\u5355\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }
}

