/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.api.UccCommodityMeasureSynBusiService;
import com.tydic.commodity.common.ability.bo.UccCommodityMeasureSynBusiReqBO;
import com.tydic.commodity.common.ability.bo.UccCommodityMeasureSynBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCommodityMeasureSynBusiService"})
public class UccCommodityMeasureSynBusiServiceImpl
implements UccCommodityMeasureSynBusiService {
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    private static final String DEFAULT_CREATE_ID = "sys";
    private static final String DEFAULT_UPDATE_ID = "admin";

    @PostMapping(value={"dealUccCommodityMeasureBusiSyn"})
    public UccCommodityMeasureSynBusiRspBO dealUccCommodityMeasureBusiSyn(@RequestBody UccCommodityMeasureSynBusiReqBO reqBO) {
        this.validate(reqBO);
        UccCommodityMeasureSynBusiRspBO rspBO = new UccCommodityMeasureSynBusiRspBO();
        List synBusiBOS = reqBO.getUccCommodityMeasureBOList();
        List measureBOList = synBusiBOS.stream().map(e -> (UccCommodityMeasurePo)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccCommodityMeasurePo.class)).collect(Collectors.toList());
        ArrayList<Object> codeList = new ArrayList<UccCommodityMeasurePo>();
        List<Object> differenceList = new ArrayList();
        List<Object> existsList = new ArrayList();
        int count = 0;
        for (UccCommodityMeasurePo uccCommodityMeasurePo : measureBOList) {
            codeList.add(uccCommodityMeasurePo);
            if (++count % 100 != 0 && count != measureBOList.size()) continue;
            existsList = this.uccCommodityMeasureMapper.qryMeasureCodeExists(codeList);
            if (!ObjectUtils.isEmpty(existsList)) {
                List finalExistsList = existsList;
                existsList = codeList.stream().filter(e -> {
                    List collect = finalExistsList.stream().filter(e2 -> e2.getCode().equals(e.getCode())).collect(Collectors.toList());
                    if (!ObjectUtils.isEmpty(collect)) {
                        return e.getCode().equals(((UccCommodityMeasurePo)collect.get(0)).getCode());
                    }
                    return false;
                }).collect(Collectors.toList());
                List existsCodeLists = existsList.stream().map(UccCommodityMeasurePo::getCode).collect(Collectors.toList());
                differenceList = codeList.stream().filter(e -> !existsCodeLists.contains(e.getCode())).collect(Collectors.toList());
                codeList = new ArrayList();
                if (!ObjectUtils.isEmpty(existsList) && existsList.size() > 0) {
                    this.updateCodeExists(existsList);
                }
                if (ObjectUtils.isEmpty(differenceList) || differenceList.size() <= 0) continue;
                this.insertDifferenceList(differenceList);
                continue;
            }
            this.insertDifferenceList(codeList);
            codeList = new ArrayList();
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateCodeExists(List<UccCommodityMeasurePo> existsList) {
        existsList.forEach(e -> {
            e.setUpdateLoginId(DEFAULT_UPDATE_ID);
            e.setUpdateTime(new Date());
            this.uccCommodityMeasureMapper.updateInfoByCode(e);
        });
    }

    private void insertDifferenceList(List<UccCommodityMeasurePo> differenceList) {
        differenceList.forEach(e -> {
            e.setMeasureId(Long.valueOf(Sequence.getInstance().nextId()));
            e.setMeasureType(Integer.valueOf(0));
            e.setIsDelete(Integer.valueOf(0));
            e.setSource(Integer.valueOf(1));
            e.setCreateLoginId(DEFAULT_CREATE_ID);
            e.setCreateTime(new Date());
            e.setUpdateLoginId(DEFAULT_UPDATE_ID);
            e.setUpdateTime(new Date());
        });
        this.uccCommodityMeasureMapper.batchInsertMeasure(differenceList);
    }

    private void validate(UccCommodityMeasureSynBusiReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getUccCommodityMeasureBOList())) {
            throw new ZTBusinessException("\u5165\u53c2\u5b57\u6bb5[uccCommodityMeasureBOList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

