/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccCommodityTypeSkuIdCountQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeSkuIdCountQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeSkuIdCountQryAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeSkuIdCountQryAbilityRspSkuDataBo;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.CommodityTypeCountQrySkuPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCommodityTypeSkuIdCountQryAbilityService"})
public class UccCommodityTypeSkuIdCountQryAbilityServiceImpl
implements UccCommodityTypeSkuIdCountQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityTypeSkuIdCountQryAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Value(value="${ucc.querySkuStatus:0,2,3,5}")
    private List<Integer> querySkuStatus;

    @PostMapping(value={"queryCommodityTypeAndSkuIdPageList"})
    public UccCommodityTypeSkuIdCountQryAbilityRspBo queryCommodityTypeAndSkuIdPageList(@RequestBody UccCommodityTypeSkuIdCountQryAbilityReqBo reqBo) {
        this.validateArg(reqBo);
        UccCommodityTypeSkuIdCountQryAbilityRspBo rspBo = new UccCommodityTypeSkuIdCountQryAbilityRspBo();
        List skuCommodityPoList = this.uccSkuMapper.qryCommodityIdBySkuId(reqBo.getSkuIdList());
        List commodityIdList = skuCommodityPoList.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List uccSkuPoList = this.uccSkuMapper.qrySkuIdAndCommodityTypeBySkuIdListPage(reqBo.getSkuIdList(), commodityIdList, this.querySkuStatus, page);
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        Map<Object, Object> skuTypeMap = new HashMap();
        Boolean needReturnSkuIdList = reqBo.getNeedReturnSkuIdList();
        if (needReturnSkuIdList.booleanValue()) {
            List uccSkuPos = this.uccSkuMapper.qrySkuIdAndCommodityTypeFilterApproveSpuList(reqBo.getSkuIdList(), commodityIdList, this.querySkuStatus);
            skuTypeMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getCommodityTypeId));
        }
        ArrayList<UccCommodityTypeSkuIdCountQryAbilityRspSkuDataBo> rowsList = new ArrayList<UccCommodityTypeSkuIdCountQryAbilityRspSkuDataBo>();
        rspBo.setRows(rowsList);
        for (CommodityTypeCountQrySkuPo uccSkuPo : uccSkuPoList) {
            UccCommodityTypeSkuIdCountQryAbilityRspSkuDataBo tmpBo = new UccCommodityTypeSkuIdCountQryAbilityRspSkuDataBo();
            BeanUtils.copyProperties((Object)uccSkuPo, (Object)tmpBo);
            rowsList.add(tmpBo);
            if (!needReturnSkuIdList.booleanValue() || skuTypeMap.get(tmpBo.getCommodityTypeId()) == null) continue;
            tmpBo.setSkuIdList(((List)skuTypeMap.get(tmpBo.getCommodityTypeId())).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
        }
        rspBo.setDatasCount(Integer.valueOf(reqBo.getSkuIdList().size()));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateArg(UccCommodityTypeSkuIdCountQryAbilityReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getSkuIdList())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

