/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.comb.api.UccCodegenerationCombService;
import com.tydic.commodity.busibase.comb.bo.UccCodegenerationCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccCodegenerationCombRspBO;
import com.tydic.commodity.common.ability.api.UccCreateSkuPoolAbilityService;
import com.tydic.commodity.common.ability.bo.UccCreateSkuPoolAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccCreateSkuPoolAbilityRspBo;
import com.tydic.commodity.common.busi.api.UccCreateSkuPoolBusiService;
import com.tydic.commodity.utils.ValidatorUtil;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCreateSkuPoolAbilityService"})
public class UccCreateSkuPoolAbilityServiceImpl
implements UccCreateSkuPoolAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCreateSkuPoolAbilityServiceImpl.class);
    @Autowired
    private UccCreateSkuPoolBusiService uccCreateSkuPoolBusiService;
    @Autowired
    private UccCodegenerationCombService uccCodegenerationCombService;

    @PostMapping(value={"dealSkuPool"})
    public UccCreateSkuPoolAbilityRspBo dealSkuPool(@RequestBody UccCreateSkuPoolAbilityReqBo reqBo) {
        UccCreateSkuPoolAbilityRspBo rspBo = new UccCreateSkuPoolAbilityRspBo();
        try {
            ValidatorUtil.validator((Object)reqBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(e.getMessage());
            return rspBo;
        }
        try {
            if (StringUtils.isBlank((CharSequence)reqBo.getPoolCode())) {
                this.setPoolCode(reqBo);
            }
            rspBo = this.uccCreateSkuPoolBusiService.dealSkuPool(reqBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u521b\u5efa\u5546\u54c1\u6c60\u5931\u8d25\uff01");
        }
        return rspBo;
    }

    private void setPoolCode(UccCreateSkuPoolAbilityReqBo reqBo) {
        UccCodegenerationCombReqBO uccCodegenerationCombReqBO = new UccCodegenerationCombReqBO();
        uccCodegenerationCombReqBO.setCodeType("06");
        uccCodegenerationCombReqBO.setCount(Integer.valueOf(1));
        UccCodegenerationCombRspBO uccCodegenerationCombRspBO = this.uccCodegenerationCombService.dealUccCodegeneration(uccCodegenerationCombReqBO);
        if (!"0000".equals(uccCodegenerationCombRspBO.getRespCode())) {
            throw new BusinessException("8888", uccCodegenerationCombRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)uccCodegenerationCombRspBO.getCodeList())) {
            throw new BusinessException("8888", "\u751f\u6210\u5546\u54c1\u6c60\u7f16\u7801\u5931\u8d25\uff01");
        }
        reqBo.setPoolCode((String)uccCodegenerationCombRspBO.getCodeList().get(0));
    }
}

