/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.UccEstoreSkuListQryBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.comb.api.UccConfigurationparametersDetailCombService;
import com.tydic.commodity.busibase.comb.api.UccSkuListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccSkuListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuListQryCombRspBO;
import com.tydic.commodity.common.ability.api.UccEcommerceSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccEcommerceSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEcommerceSkuListQryAbilityRspBO;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.UccCommodityTypeAddCoefficientMapper;
import com.tydic.commodity.dao.UccParamsConfigDetailMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuBatchDealRecordMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ComBatchDealRecordPO;
import com.tydic.commodity.po.UccCommodityTypeAddCoefficientPO;
import com.tydic.commodity.po.UccParamsConfigDetailPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccEcommerceSkuListQryAbilityService"})
public class UccEcommerceSkuListQryAbilityServiceImpl
implements UccEcommerceSkuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccEcommerceSkuListQryAbilityServiceImpl.class);
    @Autowired
    private UccSkuListQryCombService uccSkuListQryCombService;
    @Autowired
    private UccCommodityTypeAddCoefficientMapper uccCommodityTypeAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccConfigurationparametersDetailCombService uccConfigurationparametersDetailAbilityService;
    @Autowired
    private UccBaseDictionaryAtomService uccBaseDictionaryAtomService;
    @Autowired
    private UccSkuBatchDealRecordMapper uccSkuBatchDealRecordMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private UccParamsConfigDetailMapper uccParamsConfigDetailMapper;

    @PostMapping(value={"getEstoreSkuListQry"})
    public UccEcommerceSkuListQryAbilityRspBO getEstoreSkuListQry(@RequestBody UccEcommerceSkuListQryAbilityReqBO reqBO) {
        UccEcommerceSkuListQryAbilityRspBO rspBO = new UccEcommerceSkuListQryAbilityRspBO();
        reqBO.setSkuSource(ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT);
        UccSkuListQryCombReqBO skuManagementListQryAbilityReqBO = new UccSkuListQryCombReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)skuManagementListQryAbilityReqBO);
        if (ObjectUtil.isNotEmpty((Object)reqBO.getSkuStatus()) && ((Integer)reqBO.getSkuStatus().get(0)).equals(3)) {
            skuManagementListQryAbilityReqBO.setOrderByColumn(Integer.valueOf(2));
        }
        UccSkuListQryCombRspBO managementListQryAbilityRspBO = this.uccSkuListQryCombService.getSkuListQry(skuManagementListQryAbilityReqBO);
        if (UccConstants.IsBatchDealQry.YES.equals(reqBO.getIsBatchDealQry())) {
            rspBO.setRespCode(managementListQryAbilityRspBO.getRespCode());
            rspBO.setRespDesc(managementListQryAbilityRspBO.getRespDesc());
            rspBO.setTotal(managementListQryAbilityRspBO.getTotal());
            rspBO.setPageNo(managementListQryAbilityRspBO.getPageNo());
            rspBO.setRecordsTotal(managementListQryAbilityRspBO.getRecordsTotal());
            rspBO.setRows(JSONObject.parseArray((String)JSON.toJSONString((Object)managementListQryAbilityRspBO.getRows()), UccEstoreSkuListQryBO.class));
            return rspBO;
        }
        if (!"0000".equals(managementListQryAbilityRspBO.getRespCode())) {
            rspBO = (UccEcommerceSkuListQryAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)managementListQryAbilityRspBO), UccEcommerceSkuListQryAbilityRspBO.class);
            rspBO.setRows(JSONObject.parseArray((String)JSON.toJSONString((Object)rspBO.getRows()), UccEstoreSkuListQryBO.class));
            return rspBO;
        }
        rspBO = (UccEcommerceSkuListQryAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)managementListQryAbilityRspBO), UccEcommerceSkuListQryAbilityRspBO.class);
        rspBO.setRows(JSONObject.parseArray((String)JSON.toJSONString((Object)rspBO.getRows()), UccEstoreSkuListQryBO.class));
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            List<Long> skus = rspBO.getRows().stream().map(UccEstoreSkuListQryBO::getSkuId).collect(Collectors.toList());
            List uccSkuAddCoefficientPOList = this.uccSkuAddCoefficientMapper.selectBySkuIds(skus);
            Map<Object, Object> skuCoefficient = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)uccSkuAddCoefficientPOList)) {
                skuCoefficient = uccSkuAddCoefficientPOList.stream().collect(Collectors.toMap(UccSkuAddCoefficientPO::getSkuId, UccSkuAddCoefficientPO::getAddCoefficient));
            }
            HashSet commodityTypeIds = new HashSet();
            rspBO.getRows().forEach(a -> {
                if (a.getCommodityTypeId() != null) {
                    commodityTypeIds.add(a.getCommodityTypeId());
                }
            });
            HashMap typeCoefficient = new HashMap();
            if (!commodityTypeIds.isEmpty()) {
                UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO = new UccCommodityTypeAddCoefficientPO();
                uccCommodityTypeAddCoefficientPO.setCommodityTypeIds(new ArrayList(commodityTypeIds));
                uccCommodityTypeAddCoefficientPO.setDelFlag("0");
                uccCommodityTypeAddCoefficientPO.setDealStatus(Integer.valueOf(2));
                List uccCommodityTypeAddCoefficientPOS = this.uccCommodityTypeAddCoefficientMapper.getList(uccCommodityTypeAddCoefficientPO);
                if (!CollectionUtils.isEmpty((Collection)uccCommodityTypeAddCoefficientPOS)) {
                    uccCommodityTypeAddCoefficientPOS.forEach(a -> typeCoefficient.put("" + a.getCommodityTypeId() + a.getSupplierId(), a.getAddCoefficient()));
                }
            }
            BigDecimal defaultCoefficient = null;
            UccParamsConfigDetailPO uccParamsConfigDetailPO = this.packagingParamsConfigDetail();
            if (ObjectUtil.isNotEmpty((Object)uccParamsConfigDetailPO)) {
                defaultCoefficient = new BigDecimal(uccParamsConfigDetailPO.getRule());
            }
            for (UccEstoreSkuListQryBO each : rspBO.getRows()) {
                if (skuCoefficient.containsKey(each.getSkuId())) {
                    each.setMarkupRate((BigDecimal)skuCoefficient.get(each.getSkuId()));
                    continue;
                }
                if (typeCoefficient.containsKey("" + each.getCommodityTypeId() + each.getSupplierShopId())) {
                    each.setMarkupRate((BigDecimal)typeCoefficient.get("" + each.getCommodityTypeId() + each.getSupplierShopId()));
                    continue;
                }
                if (defaultCoefficient == null) continue;
                each.setMarkupRate(defaultCoefficient);
            }
            for (UccEstoreSkuListQryBO row : rspBO.getRows()) {
                if (!ObjectUtil.isNotEmpty((Object)row.getMatStatus())) continue;
                Integer matStatus = row.getMatStatus();
                if (matStatus.equals(3)) {
                    row.setMaterialCode("\u5df2\u63d0\u4ea4\u8d4b\u7801\u7533\u8bf7");
                    continue;
                }
                if (!matStatus.equals(4)) continue;
                row.setMaterialCode("\u8d4b\u7801\u4e2d");
            }
            this.transApprovalStatus(rspBO.getRows());
            this.newResetStatus(rspBO.getRows(), skus);
        }
        return rspBO;
    }

    private void newResetStatus(List<UccEstoreSkuListQryBO> rows, List<Long> skus) {
        ComBatchDealRecordPO comBatchDealRecordPO = new ComBatchDealRecordPO();
        comBatchDealRecordPO.setObjIdList(skus);
        List comBatchDealRecordPOList = this.comBatchDealRrecordMapper.getListByObjIds(comBatchDealRecordPO);
        if (!CollectionUtils.isEmpty((Collection)comBatchDealRecordPOList)) {
            Map objIdMap = comBatchDealRecordPOList.stream().collect(Collectors.toConcurrentMap(ComBatchDealRecordPO::getObjId, ComBatchDealRecordPO::getDealType));
            for (UccEstoreSkuListQryBO row : rows) {
                Integer dealType = (Integer)objIdMap.get(row.getSkuId());
                if (null == dealType) continue;
                if (SkuStatusConstants.SKU_STATUS_WAIT_SHELF.equals(row.getSkuStatus()) && UccConstants.BatchDealType.SKU_REJECT.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_REJECT_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (SkuStatusConstants.SKU_STATUS_REJECT.equals(row.getSkuStatus()) && UccConstants.BatchDealType.SKU_RE_TO_PUT_ON.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_WAIT_SHELF_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if ((SkuStatusConstants.SKU_STATUS_WAIT_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_ON_SHELF_EDIT_REJECT.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_PUT_ON_AUDIT_REJECT.equals(row.getSkuStatus())) && UccConstants.BatchDealType.SKU_PUT_ON.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_WAIT_SHELF_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if ((SkuStatusConstants.SKU_STATUS_DOWN_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_ECCOM_DOWN_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_FORCE_DOWN_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_WARING_DOWN_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_RE_PUT_ON_AUDIT_REJECT.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_SHELF_EDIT_REJECT.equals(row.getSkuStatus())) && UccConstants.BatchDealType.SKU_RE_PUT_ON.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_RE_ON_SHELF_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if ((SkuStatusConstants.SKU_STATUS_ON_SHELF.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_PUT_OFF_AUDIT_REJECT.equals(row.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_SHELF_EDIT_REJECT.equals(row.getSkuStatus())) && UccConstants.BatchDealType.SKU_PUT_OFF.equals(dealType)) {
                    row.setSkuStatus(SkuStatusConstants.SKU_STATUS_ON_SHELF_ING);
                    row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
                }
                if (!SkuStatusConstants.SKU_STATUS_ON_SHELF.equals(row.getSkuStatus()) && !SkuStatusConstants.SKU_STATUS_ON_SHELF_EDIT_REJECT.equals(row.getSkuStatus()) && !SkuStatusConstants.SKU_STATUS_PUT_OFF_AUDIT_REJECT.equals(row.getSkuStatus()) || !UccConstants.BatchDealType.SKU_FROCE_PUT_OFF.equals(dealType)) continue;
                row.setSkuStatus(SkuStatusConstants.SKU_STATUS_ON_SHELF_ING);
                row.setSkuStatusDesc("\u6570\u636e\u5904\u7406\u4e2d");
            }
        }
    }

    private void transApprovalStatus(List<UccEstoreSkuListQryBO> rows) {
        Map skuStatus = this.uccBaseDictionaryAtomService.queryBypCodeBackMap("SKU_STATE_NEW");
        for (UccEstoreSkuListQryBO row : rows) {
            if (row.getSkuStatus() == null || !skuStatus.containsKey(row.getSkuStatus().toString())) continue;
            row.setSkuStatusDesc((String)skuStatus.get(row.getSkuStatus().toString()));
        }
    }

    private UccParamsConfigDetailPO packagingParamsConfigDetail() {
        UccParamsConfigDetailPO uccParamsConfigDetailPO = new UccParamsConfigDetailPO();
        ArrayList<String> codeList = new ArrayList<String>(3);
        codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT");
        codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_ALLOW_MARKET");
        codeList.add("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_STATE");
        List listByCode = this.uccParamsConfigDetailMapper.getListByCode(codeList);
        if (!CollectionUtils.isEmpty((Collection)listByCode)) {
            Map<String, UccParamsConfigDetailPO> paramsConfigDetailMap = listByCode.stream().collect(Collectors.toMap(UccParamsConfigDetailPO::getCode, po -> po, (k1, k2) -> k2));
            uccParamsConfigDetailPO = paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT");
            uccParamsConfigDetailPO.setDealStatus(Integer.valueOf(paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_STATE").getRule()));
            uccParamsConfigDetailPO.setAllowMarketPrice(Integer.valueOf(paramsConfigDetailMap.get("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_ALLOW_MARKET").getRule()));
        }
        return uccParamsConfigDetailPO;
    }
}

