/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.common.busi.api.UccEditSkuCommodityTypeBusiService;
import com.tydic.commodity.common.busi.bo.UccEditSkuCommodityTypeBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccEditSkuCommodityTypeBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccEditSkuCommodityTypeBusiServiceImpl
implements UccEditSkuCommodityTypeBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @Override
    public UccEditSkuCommodityTypeBusiRspBO editSkuCommodityType(UccEditSkuCommodityTypeBusiReqBO reqBO) {
        this.val(reqBO);
        List uccSkuPos = this.uccSkuMapper.qryCommodityIdBySkuId(reqBO.getSkuIdList());
        if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            this.uccSkuMapper.updateSkuCommodityTypeId(reqBO.getSkuIdList(), reqBO.getCommodityTypeId(), reqBO.getOperDate(), reqBO.getOperId(), reqBO.getOperName());
            this.uccCommodityMapper.updateSpuCommodityTypeId(uccSkuPos.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList()), reqBO.getCommodityTypeId(), reqBO.getOperDate(), reqBO.getOperId(), reqBO.getOperName());
            ConcurrentMap<Long, List<UccSkuPo>> supplierIdMap = uccSkuPos.stream().collect(Collectors.groupingByConcurrent(UccSkuPo::getSupplierShopId));
            supplierIdMap.forEach((supplierId, skuPos) -> {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(skuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                syncSceneCommodityToEsReqBO.setSupplierId(supplierId);
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            });
        }
        UccEditSkuCommodityTypeBusiRspBO rspBO = new UccEditSkuCommodityTypeBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(UccEditSkuCommodityTypeBusiReqBO reqBO) {
        if (null == reqBO.getCommodityTypeId()) {
            throw new BaseBusinessException("0001", "\u5546\u54c1\u7c7b\u578bID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperDate()) {
            throw new BaseBusinessException("0001", "\u64cd\u4f5c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getSkuIdList())) {
            throw new BaseBusinessException("0001", "\u5355\u54c1ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

