/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.common.ability.api.UccAssignCodeApplyChangeStatusAbilityService;
import com.tydic.commodity.common.ability.bo.UccAssignCodeApplyChangeStatusAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccAssignCodeApplyChangeStatusAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccAssignCodeApplyChangeStatusBusiService;
import com.tydic.commodity.common.busi.bo.UccAssignCodeApplyChangeStatusBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccAssignCodeApplyChangeStatusBusiRspBO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAssignCodeApplyChangeStatusAbilityService"})
public class UccAssignCodeApplyChangeStatusAbilityServiceImpl
implements UccAssignCodeApplyChangeStatusAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAssignCodeApplyChangeStatusAbilityServiceImpl.class);
    @Autowired
    private UccAssignCodeApplyChangeStatusBusiService uccAssignCodeApplyChangeStatusBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"dealAssignCodeApplyChangeStatus"})
    public UccAssignCodeApplyChangeStatusAbilityRspBO dealAssignCodeApplyChangeStatus(@RequestBody UccAssignCodeApplyChangeStatusAbilityReqBO reqBO) {
        this.validation(reqBO);
        UccAssignCodeApplyChangeStatusBusiReqBO busiReqBO = (UccAssignCodeApplyChangeStatusBusiReqBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UccAssignCodeApplyChangeStatusBusiReqBO.class));
        UccAssignCodeApplyChangeStatusBusiRspBO busiRspBO = this.uccAssignCodeApplyChangeStatusBusiService.dealAssignCodeApplyChangeStatus(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new BaseBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        this.syncMQ(busiRspBO);
        UccAssignCodeApplyChangeStatusAbilityRspBO rspBO = (UccAssignCodeApplyChangeStatusAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), UccAssignCodeApplyChangeStatusAbilityRspBO.class);
        return rspBO;
    }

    private void syncMQ(UccAssignCodeApplyChangeStatusBusiRspBO busiRspBO) {
        List<UccSkuPo> skuPoList = busiRspBO.getUccSkuPoList();
        Map shopIdSkuIdMap = skuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId, Collectors.mapping(UccSkuPo::getSkuId, Collectors.toList())));
        if (MapUtil.isNotEmpty(shopIdSkuIdMap)) {
            shopIdSkuIdMap.forEach((k, v) -> {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(v);
                syncSceneCommodityToEsReqBO.setSupplierId(k);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u6839\u636e\u5355\u54c1ID\u540c\u6b65ES\u6570\u636e MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25" + e.getMessage());
                }
            });
        }
    }

    private void validation(UccAssignCodeApplyChangeStatusAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getApplyList())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2[\u8d4b\u7801\u7533\u8bf7\u5355\u5217\u8868]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getApplyList().forEach(uccAssignCodeApplyChangeStatusBO -> {
            if (ObjectUtil.isEmpty((Object)uccAssignCodeApplyChangeStatusBO.getApplyId())) {
                throw new BaseBusinessException("0001", "\u5165\u53c2[\u8d4b\u7801\u7533\u8bf7Id]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)uccAssignCodeApplyChangeStatusBO.getApplyStatus())) {
                throw new BaseBusinessException("0001", "\u5165\u53c2[\u8d4b\u7801\u7533\u8bf7\u5355\u72b6\u6001]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }
}

