/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.convert.Convert;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccComTypeCoefficientAddBusiService;
import com.tydic.commodity.common.busi.bo.UccComTypeCoefficientAddBusiServiceReqBo;
import com.tydic.commodity.common.busi.bo.UccComTypeCoefficientAddBusiServiceRspBo;
import com.tydic.commodity.dao.UccCommodityTypeAddCoefficientLogMapper;
import com.tydic.commodity.dao.UccCommodityTypeAddCoefficientMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.po.UccCommodityTypeAddCoefficientLogPO;
import com.tydic.commodity.po.UccCommodityTypeAddCoefficientPO;
import com.tydic.commodity.po.UccVendorPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccComTypeCoefficientAddBusiServiceImpl
implements UccComTypeCoefficientAddBusiService {
    @Autowired
    private UccCommodityTypeAddCoefficientMapper uccCommodityTypeAddCoefficientMapper;
    @Autowired
    private UccCommodityTypeAddCoefficientLogMapper uccCommodityTypeAddCoefficientLogMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;

    @Override
    public UccComTypeCoefficientAddBusiServiceRspBo comTypeCoeAdd(UccComTypeCoefficientAddBusiServiceReqBo reqBo) {
        this.check(reqBo);
        this.deleteCoef(reqBo);
        this.addOrUpdateCoef(reqBo);
        UccComTypeCoefficientAddBusiServiceRspBo rspBo = new UccComTypeCoefficientAddBusiServiceRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void addOrUpdateCoef(UccComTypeCoefficientAddBusiServiceReqBo reqBo) {
        UccCommodityTypeAddCoefficientPO qryPo = new UccCommodityTypeAddCoefficientPO();
        qryPo.setSupplierIds(reqBo.getSupplierIds());
        qryPo.setCommodityTypeIds(reqBo.getCommodityTypeIds());
        qryPo.setDelFlag("0");
        List uccCommodityTypeAddCoefficientPOS = this.uccCommodityTypeAddCoefficientMapper.getList(qryPo);
        if (CollectionUtils.isEmpty((Collection)uccCommodityTypeAddCoefficientPOS)) {
            this.dealAdd(reqBo, reqBo.getSupplierIds(), reqBo.getCommodityTypeIds());
        } else {
            ArrayList<UccCommodityTypeAddCoefficientPO> pos = new ArrayList<UccCommodityTypeAddCoefficientPO>();
            for (Long supplierId : reqBo.getSupplierIds()) {
                for (Long commodityTypeId : reqBo.getCommodityTypeIds()) {
                    UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO = new UccCommodityTypeAddCoefficientPO();
                    uccCommodityTypeAddCoefficientPO.setSupplierId(supplierId);
                    uccCommodityTypeAddCoefficientPO.setCommodityTypeId(commodityTypeId);
                    pos.add(uccCommodityTypeAddCoefficientPO);
                }
            }
            Map<String, UccCommodityTypeAddCoefficientPO> existMap = uccCommodityTypeAddCoefficientPOS.stream().collect(Collectors.toMap(exist -> Convert.toStr((Object)exist.getSupplierId()) + Convert.toStr((Object)exist.getCommodityTypeId()), Function.identity()));
            List<UccCommodityTypeAddCoefficientPO> updates = pos.stream().filter(req -> existMap.containsKey(Convert.toStr((Object)req.getSupplierId()) + Convert.toStr((Object)req.getCommodityTypeId()))).collect(Collectors.toList());
            List<UccCommodityTypeAddCoefficientPO> adds = pos.stream().filter(req -> !existMap.containsKey(Convert.toStr((Object)req.getSupplierId()) + Convert.toStr((Object)req.getCommodityTypeId()))).collect(Collectors.toList());
            this.update(reqBo, existMap, updates);
            this.add(reqBo, adds);
        }
    }

    private void add(UccComTypeCoefficientAddBusiServiceReqBo reqBo, List<UccCommodityTypeAddCoefficientPO> adds) {
        if (CollectionUtils.isEmpty(adds)) {
            ArrayList<UccCommodityTypeAddCoefficientPO> uccCommodityTypeAddCoefficientPOS = new ArrayList<UccCommodityTypeAddCoefficientPO>();
            ArrayList<UccCommodityTypeAddCoefficientLogPO> uccCommodityTypeAddCoefficientLogPOS = new ArrayList<UccCommodityTypeAddCoefficientLogPO>();
            Map<Long, UccVendorPo> uccVendorPoMap = this.getVendorMap(reqBo.getSupplierIds());
            for (UccCommodityTypeAddCoefficientPO add : adds) {
                add.setId(Long.valueOf(Sequence.getInstance().nextId()));
                UccVendorPo uccVendorPo = uccVendorPoMap.get(add.getSupplierId());
                if (null != uccVendorPo) {
                    add.setSupplierName(uccVendorPo.getVendorName());
                }
                add.setAddCoefficient(reqBo.getAddCoefficient());
                add.setAllowMarketPrice(reqBo.getAllowMarketPrice());
                add.setCreateTime(new Date());
                add.setUpdateTime(new Date());
                add.setDealStatus(UccConstants.UccAddCoefficientDealState.DEALING);
                add.setDelFlag("0");
                uccCommodityTypeAddCoefficientPOS.add(add);
                UccCommodityTypeAddCoefficientLogPO uccCommodityTypeAddCoefficientLogPO = new UccCommodityTypeAddCoefficientLogPO();
                uccCommodityTypeAddCoefficientLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccCommodityTypeAddCoefficientLogPO.setCommodityTypeAddCoefficientId(add.getId());
                uccCommodityTypeAddCoefficientLogPO.setSupplierId(add.getSupplierId());
                uccCommodityTypeAddCoefficientLogPO.setSupplierName(add.getSupplierName());
                uccCommodityTypeAddCoefficientLogPO.setCommodityTypeId(add.getCommodityTypeId());
                uccCommodityTypeAddCoefficientLogPO.setAddCoefficient(reqBo.getAddCoefficient());
                uccCommodityTypeAddCoefficientLogPO.setAllowMarketPrice(reqBo.getAllowMarketPrice());
                uccCommodityTypeAddCoefficientLogPO.setChangeType(UccConstants.CommodityTypeAddCoefChangeType.UPDATE);
                uccCommodityTypeAddCoefficientLogPO.setEffTime(new Date());
                uccCommodityTypeAddCoefficientLogPO.setCreateTime(new Date());
                uccCommodityTypeAddCoefficientLogPO.setUpdateOperId(Convert.toStr((Object)reqBo.getUserId()));
                uccCommodityTypeAddCoefficientLogPO.setUpdateOperName(reqBo.getName());
                uccCommodityTypeAddCoefficientLogPO.setAccountNumber(reqBo.getUsername());
                uccCommodityTypeAddCoefficientLogPOS.add(uccCommodityTypeAddCoefficientLogPO);
            }
            if (!CollectionUtils.isEmpty(uccCommodityTypeAddCoefficientPOS)) {
                this.uccCommodityTypeAddCoefficientMapper.insertBatch(uccCommodityTypeAddCoefficientPOS);
            }
            if (!CollectionUtils.isEmpty(uccCommodityTypeAddCoefficientLogPOS)) {
                this.uccCommodityTypeAddCoefficientLogMapper.insertBatch(uccCommodityTypeAddCoefficientLogPOS);
            }
        }
    }

    private void update(UccComTypeCoefficientAddBusiServiceReqBo reqBo, Map<String, UccCommodityTypeAddCoefficientPO> existMap, List<UccCommodityTypeAddCoefficientPO> updates) {
        if (CollectionUtils.isEmpty(updates)) {
            ArrayList<UccCommodityTypeAddCoefficientLogPO> uccCommodityTypeAddCoefficientLogPOS = new ArrayList<UccCommodityTypeAddCoefficientLogPO>();
            for (UccCommodityTypeAddCoefficientPO update : updates) {
                UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO = existMap.get(Convert.toStr((Object)update.getSupplierId()) + Convert.toStr((Object)update.getCommodityTypeId()));
                UccCommodityTypeAddCoefficientPO updatePo = new UccCommodityTypeAddCoefficientPO();
                updatePo.setId(uccCommodityTypeAddCoefficientPO.getId());
                updatePo.setAllowMarketPrice(reqBo.getAllowMarketPrice());
                updatePo.setAddCoefficient(reqBo.getAddCoefficient());
                updatePo.setUpdateTime(new Date());
                this.uccCommodityTypeAddCoefficientMapper.updateById(updatePo);
                UccCommodityTypeAddCoefficientLogPO uccCommodityTypeAddCoefficientLogPO = new UccCommodityTypeAddCoefficientLogPO();
                uccCommodityTypeAddCoefficientLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccCommodityTypeAddCoefficientLogPO.setCommodityTypeAddCoefficientId(uccCommodityTypeAddCoefficientPO.getId());
                uccCommodityTypeAddCoefficientLogPO.setSupplierId(uccCommodityTypeAddCoefficientPO.getSupplierId());
                uccCommodityTypeAddCoefficientLogPO.setSupplierName(uccCommodityTypeAddCoefficientPO.getSupplierName());
                uccCommodityTypeAddCoefficientLogPO.setCommodityTypeId(uccCommodityTypeAddCoefficientPO.getCommodityTypeId());
                uccCommodityTypeAddCoefficientLogPO.setAddCoefficient(reqBo.getAddCoefficient());
                uccCommodityTypeAddCoefficientLogPO.setAllowMarketPrice(reqBo.getAllowMarketPrice());
                uccCommodityTypeAddCoefficientLogPO.setChangeType(UccConstants.CommodityTypeAddCoefChangeType.UPDATE);
                uccCommodityTypeAddCoefficientLogPO.setEffTime(new Date());
                uccCommodityTypeAddCoefficientLogPO.setCreateTime(new Date());
                uccCommodityTypeAddCoefficientLogPO.setUpdateOperId(Convert.toStr((Object)reqBo.getUserId()));
                uccCommodityTypeAddCoefficientLogPO.setUpdateOperName(reqBo.getName());
                uccCommodityTypeAddCoefficientLogPO.setAccountNumber(reqBo.getUsername());
                uccCommodityTypeAddCoefficientLogPOS.add(uccCommodityTypeAddCoefficientLogPO);
            }
            if (!CollectionUtils.isEmpty(uccCommodityTypeAddCoefficientLogPOS)) {
                this.uccCommodityTypeAddCoefficientLogMapper.insertBatch(uccCommodityTypeAddCoefficientLogPOS);
            }
        }
    }

    private void dealAdd(UccComTypeCoefficientAddBusiServiceReqBo reqBo, List<Long> supplierIds, List<Long> commodityTypeIds) {
        Map<Long, UccVendorPo> uccVendorPoMap = this.getVendorMap(supplierIds);
        ArrayList<UccCommodityTypeAddCoefficientPO> uccCommodityTypeAddCoefficientPOS = new ArrayList<UccCommodityTypeAddCoefficientPO>();
        ArrayList<UccCommodityTypeAddCoefficientLogPO> uccCommodityTypeAddCoefficientLogPOS = new ArrayList<UccCommodityTypeAddCoefficientLogPO>();
        for (Long supplierId : reqBo.getSupplierIds()) {
            for (Long commodityTypeId : commodityTypeIds) {
                UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO = new UccCommodityTypeAddCoefficientPO();
                uccCommodityTypeAddCoefficientPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccCommodityTypeAddCoefficientPO.setSupplierId(supplierId);
                UccVendorPo uccVendorPo = uccVendorPoMap.get(supplierId);
                if (null != uccVendorPo) {
                    uccCommodityTypeAddCoefficientPO.setSupplierName(uccVendorPo.getVendorName());
                }
                uccCommodityTypeAddCoefficientPO.setCommodityTypeId(commodityTypeId);
                uccCommodityTypeAddCoefficientPO.setAddCoefficient(reqBo.getAddCoefficient());
                uccCommodityTypeAddCoefficientPO.setAllowMarketPrice(reqBo.getAllowMarketPrice());
                uccCommodityTypeAddCoefficientPO.setCreateTime(new Date());
                uccCommodityTypeAddCoefficientPO.setUpdateTime(new Date());
                uccCommodityTypeAddCoefficientPO.setDealStatus(UccConstants.UccAddCoefficientDealState.DEALING);
                uccCommodityTypeAddCoefficientPO.setDelFlag("0");
                uccCommodityTypeAddCoefficientPOS.add(uccCommodityTypeAddCoefficientPO);
                UccCommodityTypeAddCoefficientLogPO uccCommodityTypeAddCoefficientLogPO = new UccCommodityTypeAddCoefficientLogPO();
                uccCommodityTypeAddCoefficientLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccCommodityTypeAddCoefficientLogPO.setCommodityTypeAddCoefficientId(uccCommodityTypeAddCoefficientPO.getId());
                uccCommodityTypeAddCoefficientLogPO.setSupplierId(uccCommodityTypeAddCoefficientPO.getSupplierId());
                uccCommodityTypeAddCoefficientLogPO.setSupplierName(uccCommodityTypeAddCoefficientPO.getSupplierName());
                uccCommodityTypeAddCoefficientLogPO.setCommodityTypeId(uccCommodityTypeAddCoefficientPO.getCommodityTypeId());
                uccCommodityTypeAddCoefficientLogPO.setAddCoefficient(reqBo.getAddCoefficient());
                uccCommodityTypeAddCoefficientLogPO.setAllowMarketPrice(reqBo.getAllowMarketPrice());
                uccCommodityTypeAddCoefficientLogPO.setChangeType(UccConstants.CommodityTypeAddCoefChangeType.ADD);
                uccCommodityTypeAddCoefficientLogPO.setEffTime(new Date());
                uccCommodityTypeAddCoefficientLogPO.setCreateTime(new Date());
                uccCommodityTypeAddCoefficientLogPO.setUpdateOperId(Convert.toStr((Object)reqBo.getUserId()));
                uccCommodityTypeAddCoefficientLogPO.setUpdateOperName(reqBo.getName());
                uccCommodityTypeAddCoefficientLogPO.setAccountNumber(reqBo.getUsername());
                uccCommodityTypeAddCoefficientLogPOS.add(uccCommodityTypeAddCoefficientLogPO);
            }
        }
        if (!CollectionUtils.isEmpty(uccCommodityTypeAddCoefficientPOS)) {
            this.uccCommodityTypeAddCoefficientMapper.insertBatch(uccCommodityTypeAddCoefficientPOS);
        }
        if (!CollectionUtils.isEmpty(uccCommodityTypeAddCoefficientLogPOS)) {
            this.uccCommodityTypeAddCoefficientLogMapper.insertBatch(uccCommodityTypeAddCoefficientLogPOS);
        }
    }

    private Map<Long, UccVendorPo> getVendorMap(List<Long> supplierIds) {
        Map<Long, UccVendorPo> uccVendorPoMap = null;
        List vendorList = this.uccVendorMapper.getVendorList(supplierIds);
        uccVendorPoMap = CollectionUtils.isEmpty((Collection)vendorList) ? vendorList.stream().collect(Collectors.toMap(UccVendorPo::getVendorId, o -> o)) : new HashMap<Long, UccVendorPo>(0);
        return uccVendorPoMap;
    }

    private void deleteCoef(UccComTypeCoefficientAddBusiServiceReqBo reqBo) {
        if (!CollectionUtils.isEmpty(reqBo.getDeleteIds())) {
            UccCommodityTypeAddCoefficientPO deleteIdPo = new UccCommodityTypeAddCoefficientPO();
            deleteIdPo.setIds(reqBo.getDeleteIds());
            this.uccCommodityTypeAddCoefficientMapper.deleteBy(deleteIdPo);
            UccCommodityTypeAddCoefficientLogPO logDeletePo = new UccCommodityTypeAddCoefficientLogPO();
            logDeletePo.setCommodityTypeAddCoefficientIds(reqBo.getDeleteIds());
            this.uccCommodityTypeAddCoefficientLogMapper.deleteBy(logDeletePo);
        }
    }

    private void check(UccComTypeCoefficientAddBusiServiceReqBo reqBo) {
        UccCommodityTypeAddCoefficientPO deleteQryPo = new UccCommodityTypeAddCoefficientPO();
        deleteQryPo.setIds(reqBo.getDeleteIds());
        deleteQryPo.setDealStatus(UccConstants.UccAddCoefficientDealState.DEALING);
        List uccCommodityTypeAddCoefficientPOS = this.uccCommodityTypeAddCoefficientMapper.getList(deleteQryPo);
        if (!CollectionUtils.isEmpty((Collection)uccCommodityTypeAddCoefficientPOS)) {
            throw new BusinessException("8888", "\u5546\u54c1\u7c7b\u578b\u52a0\u4ef7\u7cfb\u6570\u8fd8\u672a\u4fee\u6539\u5b8c\u6210\uff0c\u4e0d\u80fd\u91cd\u590d\u4fee\u6539\u3002");
        }
        UccCommodityTypeAddCoefficientPO qryPo = new UccCommodityTypeAddCoefficientPO();
        qryPo.setSupplierIds(reqBo.getSupplierIds());
        qryPo.setCommodityTypeIds(reqBo.getCommodityTypeIds());
        qryPo.setDealStatus(UccConstants.UccAddCoefficientDealState.DEALING);
        qryPo.setDelFlag("0");
        List uccCommodityTypeAddCoefficientMapperList = this.uccCommodityTypeAddCoefficientMapper.getList(qryPo);
        if (!CollectionUtils.isEmpty((Collection)uccCommodityTypeAddCoefficientMapperList)) {
            throw new BusinessException("8888", "\u5546\u54c1\u7c7b\u578b\u52a0\u4ef7\u7cfb\u6570\u8fd8\u672a\u4fee\u6539\u5b8c\u6210\uff0c\u4e0d\u80fd\u91cd\u590d\u4fee\u6539\u3002");
        }
    }
}

