/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.UccBatchDealTaskReqJsonBO;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccBatchUpdateStatusBusiService;
import com.tydic.commodity.common.busi.bo.UccBatchUpdateStatusBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccBatchUpdateStatusBusiRspBO;
import com.tydic.commodity.common.comb.api.UccBatchUpdateStatusCombService;
import com.tydic.commodity.common.comb.bo.UccBatchUpdateStatusCombReqBO;
import com.tydic.commodity.common.comb.bo.UccBatchUpdateStatusCombRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.ComBatchDealObjMapper;
import com.tydic.commodity.dao.ComBatchDealOrderMapper;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ComBatchDealObjPO;
import com.tydic.commodity.po.ComBatchDealOrderPO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccBatchUpdateStatusCombServiceImpl
implements UccBatchUpdateStatusCombService {
    @Autowired
    private UccBatchUpdateStatusBusiService uccBatchUpdateStatusBusiService;
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private ComBatchDealObjMapper comBatchDealObjMapper;
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;
    @Value(value="${ucc.batch.record.sync.es.qry.size:1000}")
    private int SIZE;

    @Override
    public UccBatchUpdateStatusCombRspBO dealBatchUpdateStatus(UccBatchUpdateStatusCombReqBO reqBO) {
        this.val(reqBO);
        UccBatchUpdateStatusBusiReqBO uccBatchUpdateStatusBusiReqBO = new UccBatchUpdateStatusBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccBatchUpdateStatusBusiReqBO);
        UccBatchDealTaskReqJsonBO uccBatchDealTaskReqJsonBO = (UccBatchDealTaskReqJsonBO)JSON.parseObject((String)reqBO.getReqJson(), UccBatchDealTaskReqJsonBO.class);
        uccBatchUpdateStatusBusiReqBO.setUserId(uccBatchDealTaskReqJsonBO.getUserId());
        uccBatchUpdateStatusBusiReqBO.setName(uccBatchDealTaskReqJsonBO.getName());
        UccBatchUpdateStatusBusiRspBO uccBatchUpdateStatusBusiRspBO = this.uccBatchUpdateStatusBusiService.dealBatchUpdateStatus(uccBatchUpdateStatusBusiReqBO);
        if (!"0000".equals(uccBatchUpdateStatusBusiRspBO.getRespCode())) {
            throw new BusinessException(uccBatchUpdateStatusBusiRspBO.getRespCode(), uccBatchUpdateStatusBusiRspBO.getRespDesc());
        }
        this.updateIndex(reqBO);
        UccBatchUpdateStatusCombRspBO rspBO = new UccBatchUpdateStatusCombRspBO();
        BeanUtils.copyProperties((Object)((Object)uccBatchUpdateStatusBusiRspBO), (Object)((Object)rspBO));
        return rspBO;
    }

    private void val(UccBatchUpdateStatusCombReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getSkuStatus() && null == reqBO.getSpuStatus()) {
            throw new BusinessException("0001", "\u5546\u54c1\u3001\u5355\u54c1\u72b6\u6001\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBatchNo())) {
            throw new BusinessException("0001", "\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updateIndex(UccBatchUpdateStatusCombReqBO reqBO) {
        Integer objTypeByBatchNo = this.comBatchDealRrecordMapper.getObjTypeByBatchNo(reqBO.getBatchNo());
        Page page = new Page(1, this.SIZE);
        List objIdList = this.comBatchDealRrecordMapper.getObjIdByBatchNo(page, reqBO.getBatchNo());
        if (!CollectionUtils.isEmpty((Collection)objIdList) && (UccConstants.BatchObjType.SKU.equals(objTypeByBatchNo) || UccConstants.BatchObjType.COMMODITY.equals(objTypeByBatchNo))) {
            this.dealObjData(objIdList, objTypeByBatchNo, reqBO);
            if (page.getTotalPages() > 1) {
                for (int pageNo = 2; pageNo <= page.getTotalPages(); ++pageNo) {
                    Page pageAgain = new Page(pageNo, this.SIZE);
                    objIdList = this.comBatchDealRrecordMapper.getObjIdByBatchNo(pageAgain, reqBO.getBatchNo());
                    this.dealObjData(objIdList, objTypeByBatchNo, reqBO);
                }
            }
            if (!(SkuStatusConstants.SKU_STATUS_EDIT_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_PUT_OFF_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_ON_SHELF_EDIT_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_WAIT_SHELF_EDIT_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_SHELF_EDIT_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_DOWN_SHELF_EDIT_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_RE_PUT_ON_AUDITING.equals(reqBO.getSkuStatus()))) {
                this.comBatchDealRrecordMapper.deleteByBatchNo(reqBO.getBatchNo(), reqBO.getOnShelveWay());
            }
            ComBatchDealOrderPO set = new ComBatchDealOrderPO();
            if (null == reqBO.getSpuStatus()) {
                set.setCurrentStatus(reqBO.getSkuStatus());
            } else {
                set.setCurrentStatus(reqBO.getSpuStatus());
            }
            ComBatchDealOrderPO where = new ComBatchDealOrderPO();
            where.setBatchNo(reqBO.getBatchNo());
            this.comBatchDealOrderMapper.updateBy(set, where);
        }
    }

    private void dealObjData(List<Long> objIdList, Integer objType, UccBatchUpdateStatusCombReqBO reqBO) {
        List uccSkuPoList = this.uccSkuMapper.getSkuStatusByObjIds(objIdList, objType);
        if (!CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            if (UccConstants.BatchDealType.COMM_DELETE.equals(reqBO.getDealType()) || UccConstants.BatchDealType.SKU_DELETE.equals(reqBO.getDealType())) {
                this.elasticsearchUtil.deleteBatchData(this.esConfig.getIndexName(), uccSkuPoList.stream().map(uccSkuPo -> uccSkuPo.getSkuId().toString()).collect(Collectors.toList()));
                return;
            }
            List uccCommodityPoList = this.uccCommodityMapper.getCommodityStatusByCommodityIds(uccSkuPoList.stream().map(UccSkuPo::getCommodityId).distinct().collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty((Collection)uccCommodityPoList)) {
                List comBatchDealObjPOList = this.comBatchDealObjMapper.getListByObjIds(objIdList);
                ConcurrentMap<Object, Object> objOrderMap = new ConcurrentHashMap();
                if (!CollectionUtils.isEmpty((Collection)comBatchDealObjPOList)) {
                    objOrderMap = comBatchDealObjPOList.stream().collect(Collectors.groupingByConcurrent(ComBatchDealObjPO::getObjId));
                }
                ConcurrentMap<Long, Integer> commodityStatusMap = uccCommodityPoList.stream().collect(Collectors.toConcurrentMap(UccCommodityPo::getCommodityId, UccCommodityPo::getCommodityStatus));
                ConcurrentMap<Long, UccSkuPo> skuStatusMap = uccSkuPoList.stream().collect(Collectors.toConcurrentMap(UccSkuPo::getSkuId, o -> o));
                ConcurrentHashMap maps = new ConcurrentHashMap();
                for (UccSkuPo uccSkuPo2 : uccSkuPoList) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("sku_status", ((UccSkuPo)skuStatusMap.get(uccSkuPo2.getSkuId())).getSkuStatus());
                    map.put("commodity_status", (Integer)commodityStatusMap.get(uccSkuPo2.getCommodityId()));
                    if (UccConstants.BatchObjType.SKU.equals(objType)) {
                        map.put("audit_no_list", (Integer)objOrderMap.get(uccSkuPo2.getSkuId()));
                    } else {
                        map.put("audit_no_list", (Integer)objOrderMap.get(uccSkuPo2.getCommodityId()));
                    }
                    maps.put(uccSkuPo2.getSkuId(), map);
                }
                this.elasticsearchUtil.updateBatchData(this.esConfig.getIndexName(), maps);
            }
        }
    }
}

