/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccCommodityTypeAddCoefficientDeleteBusiService;
import com.tydic.commodity.common.busi.bo.UccCommodityTypeAddCoefficientDeleteBusiReqBo;
import com.tydic.commodity.common.busi.bo.UccCommodityTypeAddCoefficientDeleteBusiRspBo;
import com.tydic.commodity.common.busi.bo.UccCommodityTypeCoefficientModifyMqBusiReqBo;
import com.tydic.commodity.common.busi.bo.UccCommodityTypeCoefficientMqBo;
import com.tydic.commodity.dao.UccCommodityTypeAddCoefficientLogMapper;
import com.tydic.commodity.dao.UccCommodityTypeAddCoefficientMapper;
import com.tydic.commodity.po.UccCommodityTypeAddCoefficientLogPO;
import com.tydic.commodity.po.UccCommodityTypeAddCoefficientPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCommodityTypeAddCoefficientDeleteBusiServiceImpl
implements UccCommodityTypeAddCoefficientDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityTypeAddCoefficientDeleteBusiServiceImpl.class);
    @Value(value="${UCC_COMMODITY_TYPE_COEFFICIENT_TOPIC}")
    private String uccCommodityTypeCoefficientTopic;
    @Value(value="${UCC_COMMODITY_TYPE_COEFFICIENT_TAG}")
    private String uccCommodityTypeCoefficientTag;
    @Resource(name="uccCommodityTypeCoefficientDealProvider")
    private ProxyMessageProducer uccCommodityTypeCoefficientDealProvider;
    @Autowired
    private UccCommodityTypeAddCoefficientMapper uccCommodityTypeAddCoefficientMapper;
    @Autowired
    private UccCommodityTypeAddCoefficientLogMapper uccCommodityTypeAddCoefficientLogMapper;

    @Override
    public UccCommodityTypeAddCoefficientDeleteBusiRspBo batchDeleteComTypeAddCoe(UccCommodityTypeAddCoefficientDeleteBusiReqBo reqBo) {
        this.check(reqBo);
        UccCommodityTypeAddCoefficientPO queryPoListByIds = new UccCommodityTypeAddCoefficientPO();
        queryPoListByIds.setIds(reqBo.getCommodityTypeAddCoefficientIds());
        List uccCommodityTypeAddCoefficientPOList = this.uccCommodityTypeAddCoefficientMapper.getList(queryPoListByIds);
        UccCommodityTypeAddCoefficientPO deleteIdPo = new UccCommodityTypeAddCoefficientPO();
        deleteIdPo.setIds(reqBo.getCommodityTypeAddCoefficientIds());
        this.uccCommodityTypeAddCoefficientMapper.deleteBy(deleteIdPo);
        this.addCommodityTypeAddCoefficientLog(reqBo, uccCommodityTypeAddCoefficientPOList);
        this.sendCommodityTypeCoefficientMq(3, uccCommodityTypeAddCoefficientPOList);
        UccCommodityTypeAddCoefficientDeleteBusiRspBo rspBo = new UccCommodityTypeAddCoefficientDeleteBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void check(UccCommodityTypeAddCoefficientDeleteBusiReqBo reqBo) {
        UccCommodityTypeAddCoefficientPO deleteQryPo = new UccCommodityTypeAddCoefficientPO();
        deleteQryPo.setIds(reqBo.getCommodityTypeAddCoefficientIds());
        deleteQryPo.setDealStatus(UccConstants.UccAddCoefficientDealState.DEALING);
        List uccCommodityTypeAddCoefficientPOS = this.uccCommodityTypeAddCoefficientMapper.getList(deleteQryPo);
        if (!CollectionUtils.isEmpty((Collection)uccCommodityTypeAddCoefficientPOS)) {
            throw new BusinessException("8888", "\u5546\u54c1\u7c7b\u578b\u52a0\u4ef7\u7cfb\u6570\u8fd8\u672a\u4fee\u6539\u5b8c\u6210\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
        }
    }

    private void addCommodityTypeAddCoefficientLog(UccCommodityTypeAddCoefficientDeleteBusiReqBo reqBo, List<UccCommodityTypeAddCoefficientPO> uccCommodityTypeAddCoefficientPOList) {
        ArrayList<UccCommodityTypeAddCoefficientLogPO> uccCommodityTypeAddCoefficientLogPOList = new ArrayList<UccCommodityTypeAddCoefficientLogPO>(10);
        for (UccCommodityTypeAddCoefficientPO uccCommodityTypeAddCoefficientPO : uccCommodityTypeAddCoefficientPOList) {
            UccCommodityTypeAddCoefficientLogPO uccCommodityTypeAddCoefficientLogPO = new UccCommodityTypeAddCoefficientLogPO();
            uccCommodityTypeAddCoefficientLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uccCommodityTypeAddCoefficientLogPO.setCommodityTypeAddCoefficientId(uccCommodityTypeAddCoefficientPO.getId());
            uccCommodityTypeAddCoefficientLogPO.setSupplierId(uccCommodityTypeAddCoefficientPO.getSupplierId());
            uccCommodityTypeAddCoefficientLogPO.setSupplierName(uccCommodityTypeAddCoefficientPO.getSupplierName());
            uccCommodityTypeAddCoefficientLogPO.setCommodityTypeId(uccCommodityTypeAddCoefficientPO.getCommodityTypeId());
            uccCommodityTypeAddCoefficientLogPO.setAddCoefficient(uccCommodityTypeAddCoefficientPO.getAddCoefficient());
            uccCommodityTypeAddCoefficientLogPO.setAllowMarketPrice(uccCommodityTypeAddCoefficientPO.getAllowMarketPrice());
            uccCommodityTypeAddCoefficientLogPO.setChangeType(UccConstants.CommodityTypeAddCoefChangeType.DELETE);
            uccCommodityTypeAddCoefficientLogPO.setEffTime(new Date());
            uccCommodityTypeAddCoefficientLogPO.setCreateTime(new Date());
            uccCommodityTypeAddCoefficientLogPO.setUpdateOperId(Convert.toStr((Object)reqBo.getUserId()));
            uccCommodityTypeAddCoefficientLogPO.setUpdateOperName(reqBo.getName());
            uccCommodityTypeAddCoefficientLogPO.setAccountNumber(reqBo.getUsername());
            uccCommodityTypeAddCoefficientLogPOList.add(uccCommodityTypeAddCoefficientLogPO);
        }
        this.uccCommodityTypeAddCoefficientLogMapper.insertBatch(uccCommodityTypeAddCoefficientLogPOList);
    }

    private void sendCommodityTypeCoefficientMq(Integer operationType, List<UccCommodityTypeAddCoefficientPO> uccCommodityTypeAddCoefficientPOList) {
        try {
            List uccCommodityTypeCoefficientMqBoList = JSON.parseArray((String)JSON.toJSONString(uccCommodityTypeAddCoefficientPOList), UccCommodityTypeCoefficientMqBo.class);
            UccCommodityTypeCoefficientModifyMqBusiReqBo mqMessageContent = new UccCommodityTypeCoefficientModifyMqBusiReqBo();
            mqMessageContent.setOperationType(operationType);
            mqMessageContent.setUccCommodityTypeCoefficientBoList(uccCommodityTypeCoefficientMqBoList);
            this.uccCommodityTypeCoefficientDealProvider.send(new ProxyMessage(this.uccCommodityTypeCoefficientTopic, this.uccCommodityTypeCoefficientTag, JSON.toJSONString((Object)mqMessageContent)));
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u5546\u54c1\u7c7b\u578b\u52a0\u4ef7\u4fee\u6539\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

