/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.common.ability.api.MaterialMatchCheckAbilityService;
import com.tydic.commodity.common.ability.bo.MaterialMatchCheckAbilityReqBO;
import com.tydic.commodity.common.ability.bo.MaterialMatchCheckAbilityRspBO;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.MaterialMatchCheckAbilityService"})
public class MaterialMatchCheckAbilityServiceImpl
implements MaterialMatchCheckAbilityService {
    private static final Logger log = LoggerFactory.getLogger(MaterialMatchCheckAbilityServiceImpl.class);
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;

    @PostMapping(value={"checkMaterialIsMatch"})
    public MaterialMatchCheckAbilityRspBO checkMaterialIsMatch(@RequestBody MaterialMatchCheckAbilityReqBO reqBo) {
        MaterialMatchCheckAbilityRspBO rspBO = new MaterialMatchCheckAbilityRspBO();
        this.validateParam(reqBo);
        if (reqBo.getIsBatch().booleanValue()) {
            if (!CollectionUtils.isEmpty((Collection)reqBo.getMaterialBOList())) {
                for (UccEMdmMaterialBO materialBO : reqBo.getMaterialBOList()) {
                    UccEMdmMaterialPO materialPO;
                    List uccEMdmMaterialPOS = null;
                    if (StringUtils.isNotBlank((CharSequence)materialBO.getMaterialCode()) && materialBO.getMaterialId() == null && CollectionUtils.isEmpty((Collection)(uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.selectListByMaterialCode(materialBO.getMaterialCode(), null)))) {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc(materialBO.getMaterialName() + "\u7269\u6599\u4e0d\u5339\u914d");
                        return rspBO;
                    }
                    if (materialBO.getMaterialId() == null || (materialPO = this.uccEMdmMaterialMapper.selectByPrimaryKey(materialBO.getMaterialId())) != null) continue;
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc(materialBO.getMaterialName() + "\u7269\u6599\u4e0d\u5339\u914d");
                    return rspBO;
                }
            }
        } else if (reqBo.getMaterialBO() != null) {
            UccEMdmMaterialPO materialPO;
            List uccEMdmMaterialPOS;
            UccEMdmMaterialBO materialBO = reqBo.getMaterialBO();
            if (StringUtils.isNotBlank((CharSequence)materialBO.getMaterialCode()) && materialBO.getMaterialId() == null && CollectionUtils.isEmpty((Collection)(uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.selectListByMaterialCode(materialBO.getMaterialCode(), null)))) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(materialBO.getMaterialName() + "\u7269\u6599\u4e0d\u5339\u914d");
                return rspBO;
            }
            if (materialBO.getMaterialId() != null && (materialPO = this.uccEMdmMaterialMapper.selectByPrimaryKey(materialBO.getMaterialId())) == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(materialBO.getMaterialName() + "\u7269\u6599\u4e0d\u5339\u914d");
                return rspBO;
            }
        }
        rspBO.setIsMatch(Boolean.valueOf(true));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParam(MaterialMatchCheckAbilityReqBO reqBo) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getIsBatch().booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)reqBo.getMaterialBOList())) {
                throw new ZTBusinessException("\u7269\u6599ID\u6216\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
            for (UccEMdmMaterialBO bo : reqBo.getMaterialBOList()) {
                if (bo.getMaterialId() != null || bo.getMaterialCode() != null) continue;
                throw new ZTBusinessException("\u7269\u6599ID\u6216\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        } else {
            if (reqBo.getMaterialBO() == null) {
                throw new ZTBusinessException("\u7269\u6599ID\u6216\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
            if (reqBo.getMaterialBO().getMaterialId() == null && reqBo.getMaterialBO().getMaterialCode() == null) {
                throw new ZTBusinessException("\u7269\u6599ID\u6216\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }
}

