/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.convert.Convert;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.busi.api.UccBatchUpdateStatusBusiService;
import com.tydic.commodity.common.busi.bo.UccBatchUpdateStatusBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccBatchUpdateStatusBusiRspBO;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.UccCommodityEditMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPackageEditMapper;
import com.tydic.commodity.dao.UccCommodityPackageMapper;
import com.tydic.commodity.dao.UccCommodityPicEditMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccCommodityServiceEditMapper;
import com.tydic.commodity.dao.UccCommodityServiceMapper;
import com.tydic.commodity.dao.UccLadderPriceEditMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuEditMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicEditMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceEditMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuSpecEditMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.UccSpuSpecEditMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.dao.XextSkuChangeFailMapper;
import com.tydic.commodity.po.ComBatchDealRecordPO;
import com.tydic.commodity.po.XextSkuChangePo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccBatchUpdateStatusBusiServiceImpl
implements UccBatchUpdateStatusBusiService {
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private XextSkuChangeFailMapper xextSkuChangeFailMapper;
    @Autowired
    private UccCommodityEditMapper uccCommodityEditMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCommodityPicEditMapper uccCommodityPicEditMapper;
    @Autowired
    private UccCommodityPackageMapper uccCommodityPackageMapper;
    @Autowired
    private UccCommodityPackageEditMapper uccCommodityPackageEditMapper;
    @Autowired
    private UccCommodityServiceMapper uccCommodityServiceMapper;
    @Autowired
    private UccCommodityServiceEditMapper uccCommodityServiceEditMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuEditMapper uccSkuEditMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPicEditMapper uccSkuPicEditMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuPriceEditMapper uccSkuPriceEditMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSkuSpecEditMapper uccSkuSpecEditMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccSpuSpecEditMapper uccSpuSpecEditMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccLadderPriceEditMapper uccLadderPriceEditMapper;

    @Override
    public UccBatchUpdateStatusBusiRspBO dealBatchUpdateStatus(UccBatchUpdateStatusBusiReqBO reqBO) {
        UccBatchUpdateStatusBusiRspBO rspBO = new UccBatchUpdateStatusBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Integer objType = this.comBatchDealRrecordMapper.getObjTypeByBatchNo(reqBO.getBatchNo());
        if (null == objType) {
            throw new BaseBusinessException("8888", "\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!UccConstants.BatchObjType.SKU.equals(objType) && !UccConstants.BatchObjType.COMMODITY.equals(objType)) {
            return rspBO;
        }
        ComBatchDealRecordPO combatchdealrrecordpo = new ComBatchDealRecordPO();
        combatchdealrrecordpo.setBatchNo(reqBO.getBatchNo());
        combatchdealrrecordpo.setBatchId(Long.valueOf(Sequence.getInstance().nextId()));
        combatchdealrrecordpo.setOnShelveWay(reqBO.getOnShelveWay());
        combatchdealrrecordpo.setSkuStatus(reqBO.getSkuStatus());
        combatchdealrrecordpo.setCommodityStatus(reqBO.getSpuStatus());
        combatchdealrrecordpo.setUpdateUserId(Convert.toStr((Object)reqBO.getUserId()));
        combatchdealrrecordpo.setUpdateUserName(reqBO.getName());
        combatchdealrrecordpo.setUpdateTime(new Date());
        combatchdealrrecordpo.setObjType(objType);
        this.comBatchDealRrecordMapper.insertBatchSkuLog(combatchdealrrecordpo);
        if (UccConstants.BatchDealType.SKU_DELETE.equals(reqBO.getDealType())) {
            List uccSkuPoList = this.comBatchDealRrecordMapper.getSkuIdByBatchNo(reqBO.getBatchNo());
            if (!CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
                rspBO.setDelObjIdList(uccSkuPoList.stream().map(comBatchDealRecordPO -> comBatchDealRecordPO.getObjId().toString()).collect(Collectors.toList()));
            }
            this.comBatchDealRrecordMapper.insertBatchCommodityLogByRecord(combatchdealrrecordpo);
            this.comBatchDealRrecordMapper.batchDeleteCommodityBySku(reqBO.getBatchNo());
            this.comBatchDealRrecordMapper.batchDeleteSku(reqBO.getBatchNo());
            return rspBO;
        }
        if (UccConstants.BatchDealType.COMM_DELETE.equals(reqBO.getDealType())) {
            List uccSkuPoList = this.comBatchDealRrecordMapper.getCommodityIdByBatchNo(reqBO.getBatchNo());
            if (!CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
                rspBO.setDelObjIdList(uccSkuPoList.stream().map(comBatchDealRecordPO -> comBatchDealRecordPO.getObjId().toString()).collect(Collectors.toList()));
            }
            this.comBatchDealRrecordMapper.insertBatchCommodityLogByRecord(combatchdealrrecordpo);
            this.comBatchDealRrecordMapper.batchDeleteSkuByCommodity(reqBO.getBatchNo());
            this.comBatchDealRrecordMapper.batchDeleteCommodity(reqBO.getBatchNo());
            return rspBO;
        }
        this.comBatchDealRrecordMapper.updateSkuStatusByRecord(combatchdealrrecordpo);
        if (null == reqBO.getSpuStatus()) {
            if (!(SkuStatusConstants.SKU_STATUS_PUT_ON_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_PUT_OFF_AUDITING.equals(reqBO.getSkuStatus()) || SkuStatusConstants.SKU_STATUS_RE_PUT_ON_AUDITING.equals(reqBO.getSkuStatus()))) {
                this.comBatchDealRrecordMapper.insertBatchCommodityLogBySkuRecord(combatchdealrrecordpo);
                this.comBatchDealRrecordMapper.updateCommodityStatusBySkuStatus(combatchdealrrecordpo);
            }
        } else {
            this.comBatchDealRrecordMapper.insertBatchCommodityLogByRecord(combatchdealrrecordpo);
            this.comBatchDealRrecordMapper.updateCommodityStatusByRecord(combatchdealrrecordpo);
        }
        if (UccConstants.BatchDealType.SKU_REJECT.equals(reqBO.getDealType())) {
            XextSkuChangePo xextSkuChangePo = new XextSkuChangePo();
            xextSkuChangePo.setBatchNo(reqBO.getBatchNo());
            xextSkuChangePo.setCreateTime(new Date());
            xextSkuChangePo.setRemark(reqBO.getReqJson());
            this.xextSkuChangeFailMapper.insertBatchByHistory(xextSkuChangePo);
        }
        if (UccConstants.BatchDealType.SKU_RE_TO_PUT_ON.equals(reqBO.getDealType())) {
            this.xextSkuChangeFailMapper.batchDeleteFail(reqBO.getBatchNo());
        }
        if ((UccConstants.BatchDealType.COMM_EDIT_SUBMIT_NOT_DRAFT.equals(reqBO.getDealType()) || UccConstants.BatchDealType.SKU_EDIT_SUBMIT_NOT_DRAFT.equals(reqBO.getDealType())) && null != reqBO.getUccBatchDealTaskReqJsonBO() && null != reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId()) {
            this.uccCommodityMapper.deleteCommodityByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccCommodityEditMapper.insertMainByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccCommodityPicMapper.deleteByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccCommodityPicEditMapper.insertMainByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccCommodityPackageMapper.deleteByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccCommodityPackageEditMapper.insertMainByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccCommodityServiceMapper.deleteByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccCommodityServiceEditMapper.insertMainByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccSkuMapper.deleteByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccSkuEditMapper.insertMainByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccSkuPicMapper.deleteByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccSkuPicEditMapper.insertMainByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccSkuPriceMapper.deleteByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccSkuPriceEditMapper.insertMainByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccSkuSpecMapper.deleteByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccSkuSpecEditMapper.insertMainByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccSpuSpecMapper.deleteByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccSpuSpecEditMapper.insertMainByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccLadderPriceMapper.deleteByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
            this.uccLadderPriceEditMapper.insertMainByEdit(reqBO.getUccBatchDealTaskReqJsonBO().getEditBatchId());
        }
        return rspBO;
    }
}

